/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.config.internal.registry;

import org.mule.runtime.config.internal.resolvers.ConfigurationDependencyResolver;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.internal.lifecycle.LifecycleInterceptor;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

import org.springframework.context.ApplicationContext;

public class BaseSpringRegistry extends AbstractSpringRegistry {

  // lifecycle phase from the application context
  protected AtomicBoolean springContextInitialised = new AtomicBoolean(false);

  public BaseSpringRegistry(ApplicationContext applicationContext,
                            MuleContext muleContext,
                            LifecycleInterceptor lifecycleInterceptor) {
    super(applicationContext, muleContext, lifecycleInterceptor);
  }

  @Override
  public ConfigurationDependencyResolver getConfigurationDependencyResolver() {
    return null;
  }

  @Override
  protected <T> Map<String, T> lookupEntriesForLifecycleIncludingAncestors(Class<T> type) {
    return internalLookupByTypeWithoutAncestorsAndObjectProviders(type, false, false, getApplicationContext());
  }
}
