/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.registry;

import io.qameta.allure.Description;
import javax.inject.Inject;
import javax.inject.Named;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.queue.QueueManager;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.privileged.registry.LegacyRegistryUtils;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class QueueManagerInjectTestCase
extends AbstractMuleContextTestCase {
    @Test
    @Description(value="Tests that injecting either new or old api is correct")
    public void injectQueueManager() throws Exception {
        QueueManager mockNewQM = (QueueManager)Mockito.mock(QueueManager.class);
        org.mule.runtime.core.api.util.queue.QueueManager mockOldQM = (org.mule.runtime.core.api.util.queue.QueueManager)Mockito.mock(org.mule.runtime.core.api.util.queue.QueueManager.class);
        org.mule.sdk.api.queue.QueueManager mockNewSdkQM = (org.mule.sdk.api.queue.QueueManager)Mockito.mock(org.mule.sdk.api.queue.QueueManager.class);
        LegacyRegistryUtils.registerObject((MuleContext)muleContext, (String)"_muleApiQueueManager", (Object)mockNewQM);
        LegacyRegistryUtils.registerObject((MuleContext)muleContext, (String)"_muleQueueManager", (Object)mockOldQM);
        LegacyRegistryUtils.registerObject((MuleContext)muleContext, (String)"_muleSdkApiQueueManager", (Object)mockNewSdkQM);
        QueueManagerConsumer consumer = new QueueManagerConsumer();
        muleContext.getInjector().inject((Object)consumer);
        MatcherAssert.assertThat((Object)consumer.getNewApiQueueManager(), (Matcher)Matchers.is((Object)mockNewQM));
        MatcherAssert.assertThat((Object)consumer.getNewSdkApiQueueManager(), (Matcher)Matchers.is((Object)mockNewSdkQM));
        MatcherAssert.assertThat((Object)consumer.getOldCoreApiQueueManager(), (Matcher)Matchers.is((Object)mockOldQM));
    }

    public static class QueueManagerConsumer {
        private QueueManager newApiQueueManager;
        private org.mule.runtime.core.api.util.queue.QueueManager oldCoreApiQueueManager;
        private org.mule.sdk.api.queue.QueueManager newSdkApiQueueManager;

        public QueueManager getNewApiQueueManager() {
            return this.newApiQueueManager;
        }

        public org.mule.runtime.core.api.util.queue.QueueManager getOldCoreApiQueueManager() {
            return this.oldCoreApiQueueManager;
        }

        public org.mule.sdk.api.queue.QueueManager getNewSdkApiQueueManager() {
            return this.newSdkApiQueueManager;
        }

        @Inject
        @Named(value="_muleApiQueueManager")
        public void setNewQueueManager(QueueManager queueManager) {
            this.newApiQueueManager = queueManager;
        }

        @Inject
        @Named(value="_muleQueueManager")
        public void setOldQueueManager(org.mule.runtime.core.api.util.queue.QueueManager queueManager) {
            this.oldCoreApiQueueManager = queueManager;
        }

        @Inject
        @Named(value="_muleSdkApiQueueManager")
        public void setNewSdkQueueManager(org.mule.sdk.api.queue.QueueManager queueManager) {
            this.newSdkApiQueueManager = queueManager;
        }
    }
}

