/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.resolvers;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsIterableWithSize;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.graph.api.ArtifactAstDependencyGraph;
import org.mule.runtime.ast.graph.api.ArtifactAstDependencyGraphFactory;
import org.mule.runtime.config.internal.resolvers.ConfigurationDependencyResolver;
import org.mule.tck.junit4.AbstractMuleTestCase;

@Issue(value="MULE-19984")
@Feature(value="Lifecycle and Dependency Injection")
@Story(value="Lifecycle Phase")
@ExtendWith(value={MockitoExtension.class})
class ConfigurationDependencyResolverTestCase
extends AbstractMuleTestCase {
    private static final String COMPONENT_ID = "component";
    @Mock
    private ArtifactAst ast;
    @Mock
    private ArtifactAstDependencyGraph graph;

    ConfigurationDependencyResolverTestCase() {
    }

    @BeforeEach
    public void setUp() throws Exception {
        ComponentAst component = (ComponentAst)Mockito.mock(ComponentAst.class);
        Mockito.when((Object)component.getComponentId()).thenReturn(Optional.of(COMPONENT_ID));
        Mockito.when((Object)this.ast.recursiveStream()).thenReturn(Stream.of(component));
    }

    @Test
    @Description(value="A set of two components will be returned when there are two required components")
    void getRequiredComponentsWithIdTestCase() {
        try (MockedStatic graphFactoryStatic = Mockito.mockStatic(ArtifactAstDependencyGraphFactory.class);){
            graphFactoryStatic.when(() -> ArtifactAstDependencyGraphFactory.generateFor((ArtifactAst)this.ast)).thenReturn((Object)this.graph);
            Set<ComponentAst> components = Set.of(this.createComponentWithId("A"), this.createComponentWithId("B"));
            Mockito.when((Object)this.graph.getRequiredComponents(COMPONENT_ID)).thenReturn(components);
            ConfigurationDependencyResolver configurationDependencyResolver = new ConfigurationDependencyResolver(this.ast);
            Collection result = configurationDependencyResolver.getDirectComponentDependencies(COMPONENT_ID);
            MatcherAssert.assertThat((Object)result, (Matcher)IsIterableWithSize.iterableWithSize((int)2));
        }
    }

    @Test
    @Description(value="A set of three components will be returned when there are 5 required components, only 3 have id")
    void getRequiredComponentsWithoutIdTestCase() {
        try (MockedStatic graphFactoryStatic = Mockito.mockStatic(ArtifactAstDependencyGraphFactory.class);){
            graphFactoryStatic.when(() -> ArtifactAstDependencyGraphFactory.generateFor((ArtifactAst)this.ast)).thenReturn((Object)this.graph);
            Set<ComponentAst> components = Set.of(this.createComponentWithId("A"), this.createComponentWithId("B"), this.createComponentWithId("C"), this.createComponentWithoutId("D"), this.createComponentWithoutId("E"));
            Mockito.when((Object)this.graph.getRequiredComponents(COMPONENT_ID)).thenReturn(components);
            ConfigurationDependencyResolver configurationDependencyResolver = new ConfigurationDependencyResolver(this.ast);
            Collection result = configurationDependencyResolver.getDirectComponentDependencies(COMPONENT_ID);
            MatcherAssert.assertThat((Object)result, (Matcher)IsIterableWithSize.iterableWithSize((int)3));
        }
    }

    private ComponentAst createComponentWithId(String componentName) {
        ComponentAst component = (ComponentAst)Mockito.mock(ComponentAst.class);
        Mockito.when((Object)component.getComponentId()).thenReturn(Optional.of(componentName));
        return component;
    }

    private ComponentAst createComponentWithoutId(String componentName) {
        ComponentAst component = (ComponentAst)Mockito.mock(ComponentAst.class);
        return component;
    }
}

