/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.config.internal.dsl.processor;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mule.runtime.ast.api.ComponentAst;

import java.util.*;
import java.util.stream.Stream;

import static org.hamcrest.CoreMatchers.is;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.mule.runtime.config.internal.dsl.processor.ObjectTypeVisitor.*;

@ExtendWith(MockitoExtension.class)
class ObjectTypeVisitorOnTypeTestCase {

  private ObjectTypeVisitor visitor;
  @Mock
  private ComponentAst componentModel;

  @BeforeEach
  public void setup() {
    visitor = new ObjectTypeVisitor(componentModel);
  }

  @ParameterizedTest
  @MethodSource("data")
  void onType(String testName, Class<?> type, Class<?> expectedType) {
    visitor.onType(type);

    assertThat(testName, visitor.getType(), is(expectedType));
  }

  static Stream<Arguments> data() {
    return Stream.of(
                     args(List.class, DEFAULT_COLLECTION_TYPE),
                     args(Collection.class, DEFAULT_COLLECTION_TYPE),
                     args(ArrayList.class, DEFAULT_COLLECTION_TYPE),
                     args(Set.class, DEFAULT_SET_CLASS),
                     args(HashSet.class, HashSet.class),
                     args(TreeSet.class, TreeSet.class),
                     args(Map.class, DEFAULT_MAP_TYPE),
                     args(TreeMap.class, TreeMap.class),
                     args(Object.class, Object.class));
  }

  private static Arguments args(Class<?> type, Class<?> expected) {
    return Arguments.of(type.getSimpleName(), type, expected);
  }
}
