/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.bean;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.serialization.ObjectSerializer;
import org.mule.runtime.api.serialization.SerializationProtocol;
import org.mule.runtime.config.internal.bean.DefaultObjectSerializerDelegate;
import org.mule.runtime.core.api.MuleContext;
import org.mule.tck.junit4.AbstractMuleTestCase;

@Feature(value="Serialization")
@Story(value="Default object serializer")
public class ObjectSerializerDelegateTestCase
extends AbstractMuleTestCase {
    @Test
    void delegatesProperly() {
        ObjectSerializer objectSerializer = (ObjectSerializer)Mockito.mock(ObjectSerializer.class);
        SerializationProtocol internalProtocol = (SerializationProtocol)Mockito.mock(SerializationProtocol.class);
        Mockito.when((Object)objectSerializer.getInternalProtocol()).thenReturn((Object)internalProtocol);
        SerializationProtocol externalProtocol = (SerializationProtocol)Mockito.mock(SerializationProtocol.class);
        Mockito.when((Object)objectSerializer.getExternalProtocol()).thenReturn((Object)externalProtocol);
        MuleContext muleContext = (MuleContext)Mockito.mock(MuleContext.class);
        Mockito.when((Object)muleContext.getObjectSerializer()).thenReturn((Object)objectSerializer);
        DefaultObjectSerializerDelegate objectSerializerDelegate = new DefaultObjectSerializerDelegate();
        objectSerializerDelegate.setMuleContext(muleContext);
        MatcherAssert.assertThat((Object)objectSerializerDelegate.getInternalProtocol(), (Matcher)Matchers.sameInstance((Object)internalProtocol));
        MatcherAssert.assertThat((Object)objectSerializerDelegate.getExternalProtocol(), (Matcher)Matchers.sameInstance((Object)externalProtocol));
    }
}

