/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.context.service;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.service.Service;
import org.mule.runtime.config.internal.context.service.InjectParamsFromContextServiceProxy;
import org.mule.runtime.config.utils.Utils;
import org.mule.runtime.container.internal.MetadataInvocationHandler;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.registry.IllegalDependencyInjectionException;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@ExtendWith(value={MockitoExtension.class})
class InjectParamsFromContextServiceProxyTestCase
extends AbstractMuleTestCase {
    @Mock
    private Registry registry;
    @Mock
    private MuleContext muleContext;

    InjectParamsFromContextServiceProxyTestCase() {
    }

    @BeforeEach
    public void setUp() {
        Utils.augmentedParam = null;
    }

    @Test
    void notAugmentedInvocation() {
        Utils.BasicService service = new Utils.BasicService();
        Utils.BaseService serviceProxy = (Utils.BaseService)InjectParamsFromContextServiceProxy.createInjectProviderParamsServiceProxy((Service)service, (Registry)this.registry);
        serviceProxy.augmented();
        MatcherAssert.assertThat((Object)Utils.augmentedParam, (Matcher)Matchers.is((Object)true));
    }

    @Test
    void augmentedInvocation() {
        Mockito.when((Object)this.registry.lookupAllByType(MuleContext.class)).thenReturn(Collections.singleton(this.muleContext));
        Utils.AugmentedMethodService service = new Utils.AugmentedMethodService();
        Utils.BaseService serviceProxy = (Utils.BaseService)InjectParamsFromContextServiceProxy.createInjectProviderParamsServiceProxy((Service)service, (Registry)this.registry);
        serviceProxy.augmented();
        MatcherAssert.assertThat((Object)Utils.augmentedParam, (Matcher)Matchers.sameInstance((Object)this.muleContext));
    }

    @Test
    void augmentedSubclassInvocation() {
        Mockito.when((Object)this.registry.lookupAllByType(MuleContext.class)).thenReturn(Collections.singleton(this.muleContext));
        Utils.AugmentedSubclassMethodService service = new Utils.AugmentedSubclassMethodService();
        Utils.BaseService serviceProxy = (Utils.BaseService)InjectParamsFromContextServiceProxy.createInjectProviderParamsServiceProxy((Service)service, (Registry)this.registry);
        serviceProxy.augmented();
        MatcherAssert.assertThat((Object)Utils.augmentedParam, (Matcher)Matchers.sameInstance((Object)this.muleContext));
    }

    @Test
    void augmentedSubclassOverridesInvocation() {
        Mockito.when((Object)this.registry.lookupAllByType(MuleContext.class)).thenReturn(Collections.singleton(this.muleContext));
        Utils.AugmentedSubclassOverridesMethodService service = new Utils.AugmentedSubclassOverridesMethodService();
        Utils.BaseService serviceProxy = (Utils.BaseService)InjectParamsFromContextServiceProxy.createInjectProviderParamsServiceProxy((Service)service, (Registry)this.registry);
        serviceProxy.augmented();
        MatcherAssert.assertThat((Object)Utils.augmentedParam, (Matcher)Matchers.is((Object)true));
    }

    @Test
    void namedAugmentedInvocation() {
        Mockito.when((Object)this.registry.lookupByName("_muleContext")).thenReturn(Optional.of(this.muleContext));
        Utils.NamedAugmentedMethodService service = new Utils.NamedAugmentedMethodService();
        Utils.BaseService serviceProxy = (Utils.BaseService)InjectParamsFromContextServiceProxy.createInjectProviderParamsServiceProxy((Service)service, (Registry)this.registry);
        serviceProxy.augmented();
        MatcherAssert.assertThat((Object)Utils.augmentedParam, (Matcher)Matchers.sameInstance((Object)this.muleContext));
    }

    @Test
    void invalidNamedAugmentedInvocation() {
        Utils.InvalidNamedAugmentedMethodService service = new Utils.InvalidNamedAugmentedMethodService();
        Utils.BaseService serviceProxy = (Utils.BaseService)InjectParamsFromContextServiceProxy.createInjectProviderParamsServiceProxy((Service)service, (Registry)this.registry);
        IllegalDependencyInjectionException thrown = (IllegalDependencyInjectionException)Assert.assertThrows(IllegalDependencyInjectionException.class, () -> serviceProxy.augmented());
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.is((Object)String.format("No object found in the registry for parameter '%s' of method '%s' in service '%s'", "param", "augmented", "InvalidNamedAugmentedMethodService")));
    }

    @Test
    void hiddenAugmentedInvocation() {
        Utils.HiddenAugmentedMethodService service = new Utils.HiddenAugmentedMethodService();
        Utils.BaseService serviceProxy = (Utils.BaseService)InjectParamsFromContextServiceProxy.createInjectProviderParamsServiceProxy((Service)service, (Registry)this.registry);
        serviceProxy.augmented();
        MatcherAssert.assertThat((Object)Utils.augmentedParam, (Matcher)Matchers.is((Object)true));
    }

    @Test
    void overloadedAugmentedInvocation() {
        Mockito.when((Object)this.registry.lookupAllByType(Integer.TYPE)).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.registry.lookupAllByType(MuleContext.class)).thenReturn(Collections.singleton(this.muleContext));
        Utils.OverloadedAugmentedMethodService service = new Utils.OverloadedAugmentedMethodService();
        Utils.BaseOverloadedService serviceProxy = (Utils.BaseOverloadedService)InjectParamsFromContextServiceProxy.createInjectProviderParamsServiceProxy((Service)service, (Registry)this.registry);
        serviceProxy.augmented();
        MatcherAssert.assertThat((Object)Utils.augmentedParam, (Matcher)Matchers.is((Object)true));
    }

    @Test
    void overloadedAugmentedInvocation2() {
        Mockito.when((Object)this.registry.lookupAllByType(MuleContext.class)).thenReturn(Collections.singleton(this.muleContext));
        Utils.OverloadedAugmentedMethodService service = new Utils.OverloadedAugmentedMethodService();
        Utils.BaseOverloadedService serviceProxy = (Utils.BaseOverloadedService)InjectParamsFromContextServiceProxy.createInjectProviderParamsServiceProxy((Service)service, (Registry)this.registry);
        serviceProxy.augmented(1);
        MatcherAssert.assertThat((Object)Utils.augmentedParam, (Matcher)Matchers.sameInstance((Object)this.muleContext));
    }

    @Test
    void overloadedAugmentedInvocation3() {
        Utils.OverloadedAugmentedMethodService2 service = new Utils.OverloadedAugmentedMethodService2();
        Utils.BaseOverloadedService2 serviceProxy = (Utils.BaseOverloadedService2)InjectParamsFromContextServiceProxy.createInjectProviderParamsServiceProxy((Service)service, (Registry)this.registry);
        serviceProxy.augmented(this.muleContext, 1);
        MatcherAssert.assertThat((Object)Utils.augmentedParam, (Matcher)Matchers.sameInstance((Object)this.muleContext));
    }

    @Test
    void ambiguousAugmentedInvocation() {
        Mockito.when((Object)this.registry.lookupAllByType(MuleContext.class)).thenReturn(Collections.singleton(this.muleContext));
        Utils.AmbiguousAugmentedMethodService service = new Utils.AmbiguousAugmentedMethodService();
        Utils.BaseService serviceProxy = (Utils.BaseService)InjectParamsFromContextServiceProxy.createInjectProviderParamsServiceProxy((Service)service, (Registry)this.registry);
        IllegalDependencyInjectionException thrown = (IllegalDependencyInjectionException)Assert.assertThrows(IllegalDependencyInjectionException.class, () -> serviceProxy.augmented());
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.is((Object)String.format("More than one invocation candidate for method '%s' in service '%s'", "augmented", "AmbiguousAugmentedMethodService")));
        MatcherAssert.assertThat((Object)Utils.augmentedParam, (Matcher)Matchers.nullValue());
    }

    @Test
    void invalidAugmentedInvocation() {
        Utils.InvalidAugmentedMethodService service = new Utils.InvalidAugmentedMethodService();
        Utils.BaseService serviceProxy = (Utils.BaseService)InjectParamsFromContextServiceProxy.createInjectProviderParamsServiceProxy((Service)service, (Registry)this.registry);
        serviceProxy.augmented();
        MatcherAssert.assertThat((Object)Utils.augmentedParam, (Matcher)Matchers.is((Object)true));
    }

    @Test
    void throughProxyAugmentedInvocation() {
        Mockito.when((Object)this.registry.lookupAllByType(MuleContext.class)).thenReturn(Collections.singleton(this.muleContext));
        final Utils.AugmentedMethodService service = new Utils.AugmentedMethodService();
        MetadataInvocationHandler<Utils.BaseService> noOpHandler = new MetadataInvocationHandler<Utils.BaseService>((Utils.BaseService)service){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return method.invoke((Object)service, args);
            }
        };
        Utils.BaseService innerProxy = (Utils.BaseService)Proxy.newProxyInstance(service.getClass().getClassLoader(), new Class[]{Utils.BaseService.class}, (InvocationHandler)noOpHandler);
        Utils.BaseService serviceProxy = (Utils.BaseService)InjectParamsFromContextServiceProxy.createInjectProviderParamsServiceProxy((Service)innerProxy, (Registry)this.registry);
        serviceProxy.augmented();
        MatcherAssert.assertThat((Object)Utils.augmentedParam, (Matcher)Matchers.sameInstance((Object)this.muleContext));
    }
}

