/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.context.service;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.config.internal.context.service.InjectParamsFromContextServiceMethodInvoker;
import org.mule.runtime.config.utils.UtilsJavax;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.registry.IllegalDependencyInjectionException;
import org.mule.tck.junit4.AbstractMuleTestCase;

@ExtendWith(value={MockitoExtension.class})
class InjectParamsFromContextServiceMethodInvokerJavaxTestCase
extends AbstractMuleTestCase {
    @Mock
    private Registry registry;
    @Mock
    private MuleContext muleContext;
    private InjectParamsFromContextServiceMethodInvoker injectParamsFromContextServiceMethodInvoker;
    private Method method;

    InjectParamsFromContextServiceMethodInvokerJavaxTestCase() {
    }

    @BeforeEach
    public void setUp() throws NoSuchMethodException {
        this.injectParamsFromContextServiceMethodInvoker = new InjectParamsFromContextServiceMethodInvoker(this.registry);
        this.method = UtilsJavax.BaseService.class.getMethod("augmented", new Class[0]);
        UtilsJavax.augmentedParam = null;
    }

    @Test
    void notAugmentedInvocation() throws Throwable {
        UtilsJavax.BasicService service = new UtilsJavax.BasicService();
        this.injectParamsFromContextServiceMethodInvoker.invoke((Object)service, this.method, null);
        MatcherAssert.assertThat((Object)UtilsJavax.augmentedParam, (Matcher)Matchers.is((Object)true));
    }

    @Test
    void augmentedInvocation() throws Throwable {
        Mockito.when((Object)this.registry.lookupAllByType(MuleContext.class)).thenReturn(Collections.singleton(this.muleContext));
        UtilsJavax.AugmentedMethodService service = new UtilsJavax.AugmentedMethodService();
        this.injectParamsFromContextServiceMethodInvoker.invoke((Object)service, this.method, null);
        MatcherAssert.assertThat((Object)UtilsJavax.augmentedParam, (Matcher)Matchers.sameInstance((Object)this.muleContext));
    }

    @Test
    void augmentedSubclassInvocation() throws Throwable {
        Mockito.when((Object)this.registry.lookupAllByType(MuleContext.class)).thenReturn(Collections.singleton(this.muleContext));
        UtilsJavax.AugmentedSubclassMethodService service = new UtilsJavax.AugmentedSubclassMethodService();
        this.injectParamsFromContextServiceMethodInvoker.invoke((Object)service, this.method, null);
        MatcherAssert.assertThat((Object)UtilsJavax.augmentedParam, (Matcher)Matchers.sameInstance((Object)this.muleContext));
    }

    @Test
    void augmentedSubclassOverridesInvocation() throws Throwable {
        Mockito.when((Object)this.registry.lookupAllByType(MuleContext.class)).thenReturn(Collections.singleton(this.muleContext));
        UtilsJavax.AugmentedSubclassOverridesMethodService service = new UtilsJavax.AugmentedSubclassOverridesMethodService();
        this.injectParamsFromContextServiceMethodInvoker.invoke((Object)service, this.method, null);
        MatcherAssert.assertThat((Object)UtilsJavax.augmentedParam, (Matcher)Matchers.is((Object)true));
    }

    @Test
    void namedAugmentedInvocation() throws Throwable {
        Mockito.when((Object)this.registry.lookupByName("_muleContext")).thenReturn(Optional.of(this.muleContext));
        UtilsJavax.NamedAugmentedMethodService service = new UtilsJavax.NamedAugmentedMethodService();
        this.injectParamsFromContextServiceMethodInvoker.invoke((Object)service, this.method, null);
        MatcherAssert.assertThat((Object)UtilsJavax.augmentedParam, (Matcher)Matchers.sameInstance((Object)this.muleContext));
    }

    @Test
    void invalidNamedAugmentedInvocation() throws Throwable {
        UtilsJavax.InvalidNamedAugmentedMethodService service = new UtilsJavax.InvalidNamedAugmentedMethodService();
        IllegalDependencyInjectionException thrown = (IllegalDependencyInjectionException)Assert.assertThrows(IllegalDependencyInjectionException.class, () -> this.injectParamsFromContextServiceMethodInvoker.invoke((Object)service, this.method, null));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.is((Object)String.format("No object found in the registry for parameter '%s' of method '%s' in service '%s'", "param", this.method.getName(), service.toString())));
    }

    @Test
    void hiddenAugmentedInvocation() throws Throwable {
        UtilsJavax.HiddenAugmentedMethodService service = new UtilsJavax.HiddenAugmentedMethodService();
        this.injectParamsFromContextServiceMethodInvoker.invoke((Object)service, this.method, null);
        MatcherAssert.assertThat((Object)UtilsJavax.augmentedParam, (Matcher)Matchers.is((Object)true));
    }

    @Test
    void overloadedAugmentedInvocation() throws Throwable {
        Mockito.when((Object)this.registry.lookupAllByType(Integer.TYPE)).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.registry.lookupAllByType(MuleContext.class)).thenReturn(Collections.singleton(this.muleContext));
        UtilsJavax.OverloadedAugmentedMethodService service = new UtilsJavax.OverloadedAugmentedMethodService();
        this.injectParamsFromContextServiceMethodInvoker.invoke((Object)service, this.method, null);
        MatcherAssert.assertThat((Object)UtilsJavax.augmentedParam, (Matcher)Matchers.is((Object)true));
    }

    @Test
    void overloadedAugmentedInvocation2() throws Throwable {
        Mockito.when((Object)this.registry.lookupAllByType(MuleContext.class)).thenReturn(Collections.singleton(this.muleContext));
        UtilsJavax.OverloadedAugmentedMethodService service = new UtilsJavax.OverloadedAugmentedMethodService();
        List<Method> methods = Arrays.asList(UtilsJavax.OverloadedAugmentedMethodService.class.getMethods());
        Optional<Method> method = methods.stream().filter(m -> m.getName().equals("augmented") && m.getParameterCount() == 1 && !m.getParameters()[0].getName().contains("context")).findFirst();
        this.injectParamsFromContextServiceMethodInvoker.invoke((Object)service, method.get(), new Object[]{1});
        MatcherAssert.assertThat((Object)UtilsJavax.augmentedParam, (Matcher)Matchers.sameInstance((Object)this.muleContext));
    }

    @Test
    void ambiguousAugmentedInvocation() throws Throwable {
        Mockito.when((Object)this.registry.lookupAllByType(MuleContext.class)).thenReturn(Collections.singleton(this.muleContext));
        UtilsJavax.AmbiguousAugmentedMethodService service = new UtilsJavax.AmbiguousAugmentedMethodService();
        IllegalDependencyInjectionException thrown = (IllegalDependencyInjectionException)Assert.assertThrows(IllegalDependencyInjectionException.class, () -> this.injectParamsFromContextServiceMethodInvoker.invoke((Object)service, this.method, null));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.is((Object)String.format("More than one invocation candidate for method '%s' in service '%s'", this.method.getName(), service.toString())));
        MatcherAssert.assertThat((Object)UtilsJavax.augmentedParam, (Matcher)Matchers.nullValue());
    }

    @Test
    void invalidAugmentedInvocation() throws Throwable {
        UtilsJavax.InvalidAugmentedMethodService service = new UtilsJavax.InvalidAugmentedMethodService();
        this.injectParamsFromContextServiceMethodInvoker.invoke((Object)service, this.method, null);
        MatcherAssert.assertThat((Object)UtilsJavax.augmentedParam, (Matcher)Matchers.is((Object)true));
    }
}

