/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.context.service;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.service.Service;
import org.mule.runtime.config.internal.context.service.InjectParamsFromContextServiceProxy;
import org.mule.runtime.config.utils.UtilsJavax;
import org.mule.runtime.container.internal.MetadataInvocationHandler;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.registry.IllegalDependencyInjectionException;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@ExtendWith(value={MockitoExtension.class})
class InjectParamsFromContextServiceProxyJavaxTestCase
extends AbstractMuleTestCase {
    @Mock
    private Registry registry;
    @Mock
    private MuleContext muleContext;

    InjectParamsFromContextServiceProxyJavaxTestCase() {
    }

    @BeforeEach
    public void setUp() {
        UtilsJavax.augmentedParam = null;
    }

    @Test
    void notAugmentedInvocation() {
        UtilsJavax.BasicService service = new UtilsJavax.BasicService();
        UtilsJavax.BaseService serviceProxy = (UtilsJavax.BaseService)InjectParamsFromContextServiceProxy.createInjectProviderParamsServiceProxy((Service)service, (Registry)this.registry);
        serviceProxy.augmented();
        MatcherAssert.assertThat((Object)UtilsJavax.augmentedParam, (Matcher)Matchers.is((Object)true));
    }

    @Test
    void augmentedInvocation() {
        Mockito.when((Object)this.registry.lookupAllByType(MuleContext.class)).thenReturn(Collections.singleton(this.muleContext));
        UtilsJavax.AugmentedMethodService service = new UtilsJavax.AugmentedMethodService();
        UtilsJavax.BaseService serviceProxy = (UtilsJavax.BaseService)InjectParamsFromContextServiceProxy.createInjectProviderParamsServiceProxy((Service)service, (Registry)this.registry);
        serviceProxy.augmented();
        MatcherAssert.assertThat((Object)UtilsJavax.augmentedParam, (Matcher)Matchers.sameInstance((Object)this.muleContext));
    }

    @Test
    void augmentedSubclassInvocation() {
        Mockito.when((Object)this.registry.lookupAllByType(MuleContext.class)).thenReturn(Collections.singleton(this.muleContext));
        UtilsJavax.AugmentedSubclassMethodService service = new UtilsJavax.AugmentedSubclassMethodService();
        UtilsJavax.BaseService serviceProxy = (UtilsJavax.BaseService)InjectParamsFromContextServiceProxy.createInjectProviderParamsServiceProxy((Service)service, (Registry)this.registry);
        serviceProxy.augmented();
        MatcherAssert.assertThat((Object)UtilsJavax.augmentedParam, (Matcher)Matchers.sameInstance((Object)this.muleContext));
    }

    @Test
    void augmentedSubclassOverridesInvocation() {
        Mockito.when((Object)this.registry.lookupAllByType(MuleContext.class)).thenReturn(Collections.singleton(this.muleContext));
        UtilsJavax.AugmentedSubclassOverridesMethodService service = new UtilsJavax.AugmentedSubclassOverridesMethodService();
        UtilsJavax.BaseService serviceProxy = (UtilsJavax.BaseService)InjectParamsFromContextServiceProxy.createInjectProviderParamsServiceProxy((Service)service, (Registry)this.registry);
        serviceProxy.augmented();
        MatcherAssert.assertThat((Object)UtilsJavax.augmentedParam, (Matcher)Matchers.is((Object)true));
    }

    @Test
    void namedAugmentedInvocation() {
        Mockito.when((Object)this.registry.lookupByName("_muleContext")).thenReturn(Optional.of(this.muleContext));
        UtilsJavax.NamedAugmentedMethodService service = new UtilsJavax.NamedAugmentedMethodService();
        UtilsJavax.BaseService serviceProxy = (UtilsJavax.BaseService)InjectParamsFromContextServiceProxy.createInjectProviderParamsServiceProxy((Service)service, (Registry)this.registry);
        serviceProxy.augmented();
        MatcherAssert.assertThat((Object)UtilsJavax.augmentedParam, (Matcher)Matchers.sameInstance((Object)this.muleContext));
    }

    @Test
    void invalidNamedAugmentedInvocation() {
        UtilsJavax.InvalidNamedAugmentedMethodService service = new UtilsJavax.InvalidNamedAugmentedMethodService();
        UtilsJavax.BaseService serviceProxy = (UtilsJavax.BaseService)InjectParamsFromContextServiceProxy.createInjectProviderParamsServiceProxy((Service)service, (Registry)this.registry);
        IllegalDependencyInjectionException thrown = (IllegalDependencyInjectionException)Assert.assertThrows(IllegalDependencyInjectionException.class, () -> serviceProxy.augmented());
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.is((Object)String.format("No object found in the registry for parameter '%s' of method '%s' in service '%s'", "param", "augmented", "InvalidNamedAugmentedMethodService")));
    }

    @Test
    void hiddenAugmentedInvocation() {
        UtilsJavax.HiddenAugmentedMethodService service = new UtilsJavax.HiddenAugmentedMethodService();
        UtilsJavax.BaseService serviceProxy = (UtilsJavax.BaseService)InjectParamsFromContextServiceProxy.createInjectProviderParamsServiceProxy((Service)service, (Registry)this.registry);
        serviceProxy.augmented();
        MatcherAssert.assertThat((Object)UtilsJavax.augmentedParam, (Matcher)Matchers.is((Object)true));
    }

    @Test
    void overloadedAugmentedInvocation() {
        Mockito.when((Object)this.registry.lookupAllByType(Integer.TYPE)).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.registry.lookupAllByType(MuleContext.class)).thenReturn(Collections.singleton(this.muleContext));
        UtilsJavax.OverloadedAugmentedMethodService service = new UtilsJavax.OverloadedAugmentedMethodService();
        UtilsJavax.BaseOverloadedService serviceProxy = (UtilsJavax.BaseOverloadedService)InjectParamsFromContextServiceProxy.createInjectProviderParamsServiceProxy((Service)service, (Registry)this.registry);
        serviceProxy.augmented();
        MatcherAssert.assertThat((Object)UtilsJavax.augmentedParam, (Matcher)Matchers.is((Object)true));
    }

    @Test
    void overloadedAugmentedInvocation2() {
        Mockito.when((Object)this.registry.lookupAllByType(MuleContext.class)).thenReturn(Collections.singleton(this.muleContext));
        UtilsJavax.OverloadedAugmentedMethodService service = new UtilsJavax.OverloadedAugmentedMethodService();
        UtilsJavax.BaseOverloadedService serviceProxy = (UtilsJavax.BaseOverloadedService)InjectParamsFromContextServiceProxy.createInjectProviderParamsServiceProxy((Service)service, (Registry)this.registry);
        serviceProxy.augmented(1);
        MatcherAssert.assertThat((Object)UtilsJavax.augmentedParam, (Matcher)Matchers.sameInstance((Object)this.muleContext));
    }

    @Test
    void overloadedAugmentedInvocation3() {
        UtilsJavax.OverloadedAugmentedMethodService2 service = new UtilsJavax.OverloadedAugmentedMethodService2();
        UtilsJavax.BaseOverloadedService2 serviceProxy = (UtilsJavax.BaseOverloadedService2)InjectParamsFromContextServiceProxy.createInjectProviderParamsServiceProxy((Service)service, (Registry)this.registry);
        serviceProxy.augmented(this.muleContext, 1);
        MatcherAssert.assertThat((Object)UtilsJavax.augmentedParam, (Matcher)Matchers.sameInstance((Object)this.muleContext));
    }

    @Test
    void ambiguousAugmentedInvocation() {
        Mockito.when((Object)this.registry.lookupAllByType(MuleContext.class)).thenReturn(Collections.singleton(this.muleContext));
        UtilsJavax.AmbiguousAugmentedMethodService service = new UtilsJavax.AmbiguousAugmentedMethodService();
        UtilsJavax.BaseService serviceProxy = (UtilsJavax.BaseService)InjectParamsFromContextServiceProxy.createInjectProviderParamsServiceProxy((Service)service, (Registry)this.registry);
        IllegalDependencyInjectionException thrown = (IllegalDependencyInjectionException)Assert.assertThrows(IllegalDependencyInjectionException.class, () -> serviceProxy.augmented());
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.is((Object)String.format("More than one invocation candidate for method '%s' in service '%s'", "augmented", "AmbiguousAugmentedMethodService")));
        MatcherAssert.assertThat((Object)UtilsJavax.augmentedParam, (Matcher)Matchers.nullValue());
    }

    @Test
    void invalidAugmentedInvocation() {
        UtilsJavax.InvalidAugmentedMethodService service = new UtilsJavax.InvalidAugmentedMethodService();
        UtilsJavax.BaseService serviceProxy = (UtilsJavax.BaseService)InjectParamsFromContextServiceProxy.createInjectProviderParamsServiceProxy((Service)service, (Registry)this.registry);
        serviceProxy.augmented();
        MatcherAssert.assertThat((Object)UtilsJavax.augmentedParam, (Matcher)Matchers.is((Object)true));
    }

    @Test
    void throughProxyAugmentedInvocation() {
        Mockito.when((Object)this.registry.lookupAllByType(MuleContext.class)).thenReturn(Collections.singleton(this.muleContext));
        final UtilsJavax.AugmentedMethodService service = new UtilsJavax.AugmentedMethodService();
        MetadataInvocationHandler<UtilsJavax.BaseService> noOpHandler = new MetadataInvocationHandler<UtilsJavax.BaseService>((UtilsJavax.BaseService)service){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return method.invoke((Object)service, args);
            }
        };
        UtilsJavax.BaseService innerProxy = (UtilsJavax.BaseService)Proxy.newProxyInstance(service.getClass().getClassLoader(), new Class[]{UtilsJavax.BaseService.class}, (InvocationHandler)noOpHandler);
        UtilsJavax.BaseService serviceProxy = (UtilsJavax.BaseService)InjectParamsFromContextServiceProxy.createInjectProviderParamsServiceProxy((Service)innerProxy, (Registry)this.registry);
        serviceProxy.augmented();
        MatcherAssert.assertThat((Object)UtilsJavax.augmentedParam, (Matcher)Matchers.sameInstance((Object)this.muleContext));
    }
}

