/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.processor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.config.internal.dsl.processor.ObjectTypeVisitor;

@ExtendWith(value={MockitoExtension.class})
class ObjectTypeVisitorOnTypeTestCase {
    private ObjectTypeVisitor visitor;
    @Mock
    private ComponentAst componentModel;

    ObjectTypeVisitorOnTypeTestCase() {
    }

    @BeforeEach
    public void setup() {
        this.visitor = new ObjectTypeVisitor(this.componentModel);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    void onType(String testName, Class<?> type, Class<?> expectedType) {
        this.visitor.onType(type);
        MatcherAssert.assertThat((String)testName, (Object)this.visitor.getType(), (Matcher)CoreMatchers.is(expectedType));
    }

    static Stream<Arguments> data() {
        return Stream.of(ObjectTypeVisitorOnTypeTestCase.args(List.class, ObjectTypeVisitor.DEFAULT_COLLECTION_TYPE), ObjectTypeVisitorOnTypeTestCase.args(Collection.class, ObjectTypeVisitor.DEFAULT_COLLECTION_TYPE), ObjectTypeVisitorOnTypeTestCase.args(ArrayList.class, ObjectTypeVisitor.DEFAULT_COLLECTION_TYPE), ObjectTypeVisitorOnTypeTestCase.args(Set.class, ObjectTypeVisitor.DEFAULT_SET_CLASS), ObjectTypeVisitorOnTypeTestCase.args(HashSet.class, HashSet.class), ObjectTypeVisitorOnTypeTestCase.args(TreeSet.class, TreeSet.class), ObjectTypeVisitorOnTypeTestCase.args(Map.class, ObjectTypeVisitor.DEFAULT_MAP_TYPE), ObjectTypeVisitorOnTypeTestCase.args(TreeMap.class, TreeMap.class), ObjectTypeVisitorOnTypeTestCase.args(Object.class, Object.class));
    }

    private static Arguments args(Class<?> type, Class<?> expected) {
        return Arguments.of((Object[])new Object[]{type.getSimpleName(), type, expected});
    }
}

