/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.dsl.model;

import java.util.Optional;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsNot;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.serialization.ArtifactAstDeserializer;
import org.mule.runtime.ast.api.serialization.ArtifactAstSerializerProvider;
import org.mule.runtime.config.dsl.model.AbstractDslModelTestCase;
import org.mule.runtime.core.api.extension.provider.MuleExtensionModelProvider;

public class ComponentLocationTestCase
extends AbstractDslModelTestCase {
    private static final String CONFIG_NAME = "myConfig";
    private Set<ExtensionModel> extensions;

    @Before
    public void setUp() {
        this.extensions = Set.of(MuleExtensionModelProvider.getExtensionModel(), this.mockExtension);
    }

    @Test
    public void validateConnectionLocation() throws Exception {
        ArtifactAstDeserializer defaultArtifactAstDeserializer = new ArtifactAstSerializerProvider().getDeserializer();
        ArtifactAst applicationModel = defaultArtifactAstDeserializer.deserialize(((Object)((Object)this)).getClass().getResourceAsStream("/asts/ComponentLocationTestCase.ast"), name -> this.extensions.stream().filter(x -> x.getName().equals(name)).findFirst().orElse(null));
        ComponentAst config = (ComponentAst)applicationModel.topLevelComponentsStream().findFirst().get();
        MatcherAssert.assertThat((Object)config.getModel(ConfigurationModel.class), (Matcher)Is.is((Matcher)IsNot.not(Optional.empty())));
        MatcherAssert.assertThat((Object)config.getLocation().getLocation(), (Matcher)IsEqual.equalTo((Object)CONFIG_NAME));
        ComponentAst connection = (ComponentAst)config.directChildrenStream().findFirst().get();
        MatcherAssert.assertThat((Object)connection.getModel(ConnectionProviderModel.class), (Matcher)Is.is((Matcher)IsNot.not(Optional.empty())));
        MatcherAssert.assertThat((Object)connection.getLocation().getLocation(), (Matcher)IsEqual.equalTo((Object)"myConfig/connection"));
    }
}

