/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.dsl.model;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.internal.creation.MockSettingsImpl;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.metadata.resolving.AttributesTypeResolver;
import org.mule.runtime.api.metadata.resolving.InputTypeResolver;
import org.mule.runtime.api.metadata.resolving.OutputTypeResolver;
import org.mule.runtime.api.metadata.resolving.PartialTypeKeysResolver;
import org.mule.runtime.api.metadata.resolving.QueryEntityResolver;
import org.mule.runtime.api.metadata.resolving.TypeKeysResolver;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.serialization.ArtifactAstDeserializer;
import org.mule.runtime.ast.api.serialization.ArtifactAstSerializerProvider;
import org.mule.runtime.config.dsl.model.AbstractMetadataCacheIdGeneratorTestCase;
import org.mule.runtime.extension.api.metadata.MetadataResolverFactory;
import org.mule.runtime.extension.api.property.MetadataKeyIdModelProperty;
import org.mule.runtime.extension.api.property.MetadataKeyPartModelProperty;
import org.mule.runtime.extension.api.property.RequiredForMetadataModelProperty;
import org.mule.runtime.metadata.api.cache.MetadataCacheId;
import org.mule.runtime.metadata.internal.NullMetadataResolverFactory;
import org.mule.runtime.module.extension.internal.loader.java.property.MetadataResolverFactoryModelProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Feature(value="SDK Tooling Support")
@Story(value="Metadata Cache")
public class ModelBasedMetadataCacheKeyGeneratorTestCase
extends AbstractMetadataCacheIdGeneratorTestCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelBasedMetadataCacheKeyGeneratorTestCase.class);
    private static final String MY_FLOW = "myFlow";
    private static final String MY_CONFIG = "myConfig";
    private static final String METADATA_KEY_PART_1 = "partOne";
    private static final String METADATA_KEY_PART_2 = "partTwo";
    private static final String METADATA_KEY_PART_3 = "partThree";
    private static final String METADATA_KEY_GROUP = "Key Group";
    private static final String CATEGORY_NAME = "category";
    private static final String OPERATION_LOCATION = "myFlow/processors/0";
    private static final String ANOTHER_OPERATION_LOCATION = "myFlow/processors/1";

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.mockSimpleMetadataKeyId(this.operation);
        this.mockSimpleMetadataKeyId(this.anotherOperation);
    }

    @Test
    public void idempotentHashCalculation() throws Exception {
        ArtifactAst applicationModel = this.loadAst("idempotentHashCalculation_1.ast");
        HashMap hashByLocation = new HashMap();
        applicationModel.topLevelComponentsStream().forEach(component -> {
            try {
                hashByLocation.put(component.getLocation().getLocation(), this.getIdForComponentMetadata(applicationModel, component.getLocation().getLocation()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        LOGGER.debug(((Object)hashByLocation).toString());
        ArtifactAst reload = this.loadAst("idempotentHashCalculation_2.ast");
        reload.topLevelComponentsStream().forEach(component -> {
            try {
                String location = component.getLocation().getLocation();
                MetadataCacheId previousHash = (MetadataCacheId)hashByLocation.get(location);
                MatcherAssert.assertThat((Object)previousHash, (Matcher)Matchers.is((Object)this.getIdForComponentMetadata(reload, component.getLocation().getLocation())));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Test
    public void configurationParameterModifiesHash() throws Exception {
        MetadataCacheId cacheId = this.getIdForComponentMetadata(this.loadAst("configurationParameterModifiesGlobalHash_1.ast"), OPERATION_LOCATION);
        LOGGER.debug(cacheId.toString());
        MetadataCacheId otherKeyParts = this.getIdForComponentMetadata(this.loadAst("configurationParameterModifiesGlobalHash_2.ast"), OPERATION_LOCATION);
        LOGGER.debug(otherKeyParts.toString());
        MatcherAssert.assertThat((Object)cacheId, (Matcher)Matchers.not((Object)otherKeyParts));
    }

    @Test
    public void configurationParameterModifiesGlobalHash() throws Exception {
        MetadataCacheId cacheId = this.getIdForGlobalMetadata(this.loadAst("configurationParameterModifiesGlobalHash_1.ast"), OPERATION_LOCATION);
        LOGGER.debug(cacheId.toString());
        MetadataCacheId otherKeyParts = this.getIdForGlobalMetadata(this.loadAst("configurationParameterModifiesGlobalHash_2.ast"), OPERATION_LOCATION);
        LOGGER.debug(otherKeyParts.toString());
        MatcherAssert.assertThat((Object)cacheId, (Matcher)Matchers.not((Object)otherKeyParts));
    }

    @Test
    public void operationParameterDoesNotModifyHash() throws Exception {
        MetadataCacheId keyParts = this.getIdForComponentMetadata(this.loadAst("operationParameterDoesNotModifyHash_1.ast"), OPERATION_LOCATION);
        LOGGER.debug(keyParts.toString());
        MetadataCacheId otherKeyParts = this.getIdForComponentMetadata(this.loadAst("operationParameterDoesNotModifyHash_2.ast"), OPERATION_LOCATION);
        LOGGER.debug(otherKeyParts.toString());
        MatcherAssert.assertThat((Object)keyParts, (Matcher)Matchers.is((Object)otherKeyParts));
    }

    @Test
    public void operationParameterDoesNotModifyGlobal() throws Exception {
        MetadataCacheId keyParts = this.getIdForGlobalMetadata(this.loadAst("operationParameterDoesNotModifyGlobal_1.ast"), OPERATION_LOCATION);
        LOGGER.debug(keyParts.toString());
        MetadataCacheId otherKeyParts = this.getIdForGlobalMetadata(this.loadAst("operationParameterDoesNotModifyGlobal_2.ast"), OPERATION_LOCATION);
        LOGGER.debug(otherKeyParts.toString());
        MatcherAssert.assertThat((Object)keyParts, (Matcher)Matchers.is((Object)otherKeyParts));
    }

    @Test
    public void metadataKeyModifiesHash() throws Exception {
        MetadataCacheId keyParts = this.getIdForComponentMetadata(this.loadAst("metadataKeyModifiesHash_1.ast"), OPERATION_LOCATION);
        LOGGER.debug(keyParts.toString());
        MetadataCacheId otherKeyParts = this.getIdForComponentMetadata(this.loadAst("metadataKeyModifiesHash_2.ast"), OPERATION_LOCATION);
        LOGGER.debug(otherKeyParts.toString());
        MetadataCacheId finalKeyParts = this.getIdForComponentMetadata(this.loadAst("metadataKeyModifiesHash_3.ast"), OPERATION_LOCATION);
        LOGGER.debug(finalKeyParts.toString());
        MatcherAssert.assertThat((Object)otherKeyParts, (Matcher)Matchers.not((Object)keyParts));
        MatcherAssert.assertThat((Object)finalKeyParts, (Matcher)Matchers.not((Object)keyParts));
        MatcherAssert.assertThat((Object)finalKeyParts, (Matcher)Matchers.not((Object)otherKeyParts));
    }

    @Test
    public void metadataCategoryModifiesGlobalHash() throws Exception {
        MetadataCacheId id = this.getIdForGlobalMetadata(this.loadAst("metadataCategoryModifiesGlobalHash_1.ast"), OPERATION_LOCATION);
        LOGGER.debug(id.toString());
        Mockito.when((Object)this.operation.getModelProperty(MetadataKeyIdModelProperty.class)).thenReturn(Optional.of(new MetadataKeyIdModelProperty(this.TYPE_LOADER.load(String.class), METADATA_KEY_PART_1, "OTHER_CATEGORY")));
        MetadataCacheId otherId = this.getIdForGlobalMetadata(this.loadAst("metadataCategoryModifiesGlobalHash_2.ast"), OPERATION_LOCATION);
        LOGGER.debug(id.toString());
        MatcherAssert.assertThat((Object)id, (Matcher)Matchers.not((Object)otherId));
    }

    @Test
    public void configurationParametersAsRequireForMetadataModifiesHash() throws Exception {
        this.mockRequiredForMetadataModelProperty((EnrichableModel)this.configuration, null);
        this.mockRequiredForMetadataModelProperty((EnrichableModel)this.connectionProvider, null);
        MetadataCacheId keyParts = this.getIdForComponentMetadata(this.loadAst("configurationParametersAsRequireForMetadataModifiesHash_2.ast"), OPERATION_LOCATION);
        LOGGER.debug(keyParts.toString());
        this.mockRequiredForMetadataModelProperty((EnrichableModel)this.configuration, Arrays.asList(this.behaviourParameter.getName()));
        this.mockRequiredForMetadataModelProperty((EnrichableModel)this.connectionProvider, null);
        MetadataCacheId otherKeyParts = this.getIdForComponentMetadata(this.loadAst("configurationParametersAsRequireForMetadataModifiesHash_2.ast"), OPERATION_LOCATION);
        LOGGER.debug(otherKeyParts.toString());
        MatcherAssert.assertThat((Object)keyParts, (Matcher)Matchers.not((Object)otherKeyParts));
    }

    @Test
    @Issue(value="MULE-18601")
    public void configurationNestedParamsCountedTwiceForHash() throws Exception {
        ArtifactAst app = this.loadAst("configurationNestedParamsCountedTwiceForHash_1.ast");
        MetadataCacheId keyParts = this.getIdForComponentMetadata(app, OPERATION_LOCATION);
        LOGGER.debug(keyParts.toString());
        MatcherAssert.assertThat((Object)keyParts.getParts(), (Matcher)IsCollectionWithSize.hasSize((int)3));
        MatcherAssert.assertThat((Object)((MetadataCacheId)keyParts.getParts().get(0)).getParts(), (Matcher)IsCollectionWithSize.hasSize((int)2));
        MatcherAssert.assertThat((Object)((MetadataCacheId)((MetadataCacheId)keyParts.getParts().get(0)).getParts().get(0)).getParts(), (Matcher)IsCollectionWithSize.hasSize((int)0));
        MetadataCacheId configurationPart = (MetadataCacheId)((MetadataCacheId)keyParts.getParts().get(0)).getParts().get(1);
        MatcherAssert.assertThat((Object)((String)configurationPart.getSourceElementName().get()), (Matcher)Matchers.is((Object)"configuration"));
        MatcherAssert.assertThat((Object)configurationPart.getParts(), (Matcher)IsCollectionWithSize.hasSize((int)2));
        MatcherAssert.assertThat((Object)((MetadataCacheId)configurationPart.getParts().get(0)).getParts(), (Matcher)IsCollectionWithSize.hasSize((int)2));
        MatcherAssert.assertThat((Object)((MetadataCacheId)((MetadataCacheId)configurationPart.getParts().get(0)).getParts().get(0)).getParts(), (Matcher)IsCollectionWithSize.hasSize((int)0));
        MatcherAssert.assertThat((Object)((MetadataCacheId)((MetadataCacheId)configurationPart.getParts().get(0)).getParts().get(0)).getParts(), (Matcher)IsCollectionWithSize.hasSize((int)0));
        MatcherAssert.assertThat((Object)((MetadataCacheId)configurationPart.getParts().get(1)).getParts(), (Matcher)IsCollectionWithSize.hasSize((int)0));
        MatcherAssert.assertThat((Object)((MetadataCacheId)keyParts.getParts().get(1)).getParts(), (Matcher)IsCollectionWithSize.hasSize((int)0));
        MatcherAssert.assertThat((Object)((MetadataCacheId)keyParts.getParts().get(2)).getParts(), (Matcher)IsCollectionWithSize.hasSize((int)0));
    }

    @Test
    public void connectionParametersAsRequireForMetadataModifiesHash() throws Exception {
        this.mockRequiredForMetadataModelProperty((EnrichableModel)this.configuration, null);
        this.mockRequiredForMetadataModelProperty((EnrichableModel)this.connectionProvider, null);
        ArtifactAst app = this.loadAst("connectionParametersAsRequireForMetadataModifiesHash_1.ast");
        MetadataCacheId keyParts = this.getIdForComponentMetadata(app, OPERATION_LOCATION);
        LOGGER.debug(keyParts.toString());
        this.mockRequiredForMetadataModelProperty((EnrichableModel)this.configuration, null);
        this.mockRequiredForMetadataModelProperty((EnrichableModel)this.connectionProvider, Arrays.asList(this.behaviourParameter.getName()));
        ArtifactAst modifiedApp = this.loadAst("connectionParametersAsRequireForMetadataModifiesHash_2.ast");
        MetadataCacheId otherKeyParts = this.getIdForComponentMetadata(modifiedApp, OPERATION_LOCATION);
        LOGGER.debug(otherKeyParts.toString());
        MatcherAssert.assertThat((Object)keyParts, (Matcher)Matchers.not((Object)otherKeyParts));
    }

    @Test
    public void differencesInRequiredParametersForMetadataYieldsDifferentHashes() throws Exception {
        this.mockRequiredForMetadataModelProperty((EnrichableModel)this.configuration, null);
        this.mockRequiredForMetadataModelProperty((EnrichableModel)this.connectionProvider, Arrays.asList(this.contentParameter.getName()));
        ArtifactAst app = this.loadAst("differencesInRequiredParametersForMetadataYieldsDifferentHashes_1.ast");
        MetadataCacheId keyParts = this.getIdForComponentMetadata(app, OPERATION_LOCATION);
        LOGGER.debug(keyParts.toString());
        this.mockRequiredForMetadataModelProperty((EnrichableModel)this.configuration, null);
        this.mockRequiredForMetadataModelProperty((EnrichableModel)this.connectionProvider, Arrays.asList(this.behaviourParameter.getName()));
        ArtifactAst modifiedApp = this.loadAst("differencesInRequiredParametersForMetadataYieldsDifferentHashes_2.ast");
        MetadataCacheId otherKeyParts = this.getIdForComponentMetadata(modifiedApp, OPERATION_LOCATION);
        LOGGER.debug(otherKeyParts.toString());
        MatcherAssert.assertThat((Object)keyParts, (Matcher)Matchers.not((Object)otherKeyParts));
    }

    @Test
    public void metadataKeyCacheIdForConfigModelShouldIncludeConnectionParameters() throws Exception {
        ArtifactAst app = this.loadAst("metadataKeyCacheIdForConfigModelShouldIncludeConnectionParameters_1.ast");
        MetadataCacheId keyParts = this.getIdForMetadataKeys(app, MY_CONFIG);
        LOGGER.debug(keyParts.toString());
        ArtifactAst modifiedApp = this.loadAst("metadataKeyCacheIdForConfigModelShouldIncludeConnectionParameters_2.ast");
        MetadataCacheId otherKeyParts = this.getIdForMetadataKeys(modifiedApp, MY_CONFIG);
        LOGGER.debug(otherKeyParts.toString());
        MatcherAssert.assertThat((Object)otherKeyParts, (Matcher)Matchers.not((Matcher)Matchers.is((Object)keyParts)));
    }

    @Test
    public void metadataKeyDoesNotModifyKeyHash() throws Exception {
        ArtifactAst app = this.loadAst("metadataKeyDoesNotModifyKeyHash_1.ast");
        MetadataCacheId keyParts = this.getIdForMetadataKeys(app, OPERATION_LOCATION);
        LOGGER.debug(keyParts.toString());
        ArtifactAst modifiedApp = this.loadAst("metadataKeyDoesNotModifyKeyHash_2.ast");
        MetadataCacheId otherKeyParts = this.getIdForMetadataKeys(modifiedApp, OPERATION_LOCATION);
        LOGGER.debug(otherKeyParts.toString());
        ArtifactAst modifiedApp2 = this.loadAst("metadataKeyDoesNotModifyKeyHash_3.ast");
        MetadataCacheId finalKeyParts = this.getIdForMetadataKeys(modifiedApp2, OPERATION_LOCATION);
        LOGGER.debug(finalKeyParts.toString());
        MatcherAssert.assertThat((Object)otherKeyParts, (Matcher)Matchers.is((Object)keyParts));
        MatcherAssert.assertThat((Object)finalKeyParts, (Matcher)Matchers.is((Object)keyParts));
        MatcherAssert.assertThat((Object)finalKeyParts, (Matcher)Matchers.is((Object)otherKeyParts));
    }

    @Test
    public void multiLevelMetadataKeyModifiesHash() throws Exception {
        this.mockMultiLevelMetadataKeyId(this.operation);
        ArtifactAst app = this.loadAst("multiLevelMetadataKeyModifiesHash_1.ast");
        MetadataCacheId twoLevelParts = this.getIdForComponentMetadata(app, OPERATION_LOCATION);
        LOGGER.debug(twoLevelParts.toString());
        ArtifactAst modifiedApp = this.loadAst("multiLevelMetadataKeyModifiesHash_2.ast");
        MetadataCacheId otherKeyParts = this.getIdForComponentMetadata(modifiedApp, OPERATION_LOCATION);
        LOGGER.debug(otherKeyParts.toString());
        MatcherAssert.assertThat((Object)otherKeyParts, (Matcher)Matchers.not((Object)twoLevelParts));
    }

    @Test
    public void multiLevelPartValueModifiesHash() throws Exception {
        this.mockMultiLevelMetadataKeyId(this.operation);
        ArtifactAst app = this.loadAst("multiLevelPartValueModifiesHash_1.ast");
        MetadataCacheId original = this.getIdForComponentMetadata(app, OPERATION_LOCATION);
        LOGGER.debug(original.toString());
        ArtifactAst modifiedApp = this.loadAst("multiLevelPartValueModifiesHash_2.ast");
        MetadataCacheId newHash = this.getIdForComponentMetadata(modifiedApp, OPERATION_LOCATION);
        LOGGER.debug(newHash.toString());
        LOGGER.debug(newHash.toString());
        MatcherAssert.assertThat((Object)original, (Matcher)Matchers.not((Object)newHash));
    }

    @Test
    public void multiLevelPartValueDoesNotModifyHashForKeys() throws Exception {
        this.mockMultiLevelMetadataKeyId(this.operation);
        ArtifactAst app = this.loadAst("multiLevelPartValueDoesNotModifyHashForKeys_1.ast");
        MetadataCacheId original = this.getIdForMetadataKeys(app, OPERATION_LOCATION);
        LOGGER.debug(original.toString());
        ArtifactAst modifiedApp = this.loadAst("multiLevelPartValueDoesNotModifyHashForKeys_2.ast");
        MetadataCacheId newHash = this.getIdForMetadataKeys(modifiedApp, OPERATION_LOCATION);
        LOGGER.debug(newHash.toString());
        MatcherAssert.assertThat((Object)original, (Matcher)Matchers.is((Object)newHash));
    }

    @Test
    public void multiLevelPartValueDoesNotModifyGlobalId() throws Exception {
        this.mockMultiLevelMetadataKeyId(this.operation);
        ArtifactAst app = this.loadAst("multiLevelPartValueDoesNotModifyGlobalId_1.ast");
        MetadataCacheId original = this.getIdForGlobalMetadata(app, OPERATION_LOCATION);
        LOGGER.debug(original.toString());
        ArtifactAst modifiedApp = this.loadAst("multiLevelPartValueDoesNotModifyGlobalId_2.ast");
        MetadataCacheId newHash = this.getIdForGlobalMetadata(modifiedApp, OPERATION_LOCATION);
        LOGGER.debug(newHash.toString());
        MatcherAssert.assertThat((Object)original, (Matcher)Matchers.is((Object)newHash));
    }

    @Test
    public void metadataKeyHashIdStructure() throws Exception {
        this.mockMultiLevelMetadataKeyId(this.operation);
        this.setPartialFetchingMock(this.operation);
        this.mockTypeResolversInformationModelProperty((EnrichableModel)this.operation, CATEGORY_NAME, "outputResolver", "attributesResolver", Collections.emptyMap(), "keysResolver", true);
        ArtifactAst app = this.loadAst("metadataKeyHashIdStructure_1.ast");
        MetadataCacheId original = this.getIdForMetadataKeys(app, OPERATION_LOCATION);
        LOGGER.debug(original.toString());
        MatcherAssert.assertThat((Object)original.getParts(), (Matcher)IsCollectionWithSize.hasSize((int)6));
        MatcherAssert.assertThat((Object)((String)((MetadataCacheId)original.getParts().get(2)).getSourceElementName().get()), (Matcher)Matchers.startsWith((String)"category:"));
        MatcherAssert.assertThat((Object)((String)((MetadataCacheId)original.getParts().get(3)).getSourceElementName().get()), (Matcher)Matchers.startsWith((String)"resolver:"));
        MatcherAssert.assertThat((Object)((String)((MetadataCacheId)original.getParts().get(4)).getSourceElementName().get()), (Matcher)Matchers.equalTo((Object)"metadataKey"));
        MatcherAssert.assertThat((Object)((String)((MetadataCacheId)original.getParts().get(5)).getSourceElementName().get()), (Matcher)Matchers.equalTo((Object)"metadataKeyValues"));
    }

    @Test
    public void partialFetchingMultiLevelPartValueModifiesHashForKeys() throws Exception {
        this.mockMultiLevelMetadataKeyId(this.operation);
        this.setPartialFetchingMock(this.operation);
        this.mockTypeResolversInformationModelProperty((EnrichableModel)this.operation, CATEGORY_NAME, "outputResolver", "attributesResolver", Collections.emptyMap(), "keysResolver", true);
        ArtifactAst app = this.loadAst("partialFetchingMultiLevelPartValueModifiesHashForKeys_1.ast");
        MetadataCacheId original = this.getIdForMetadataKeys(app, OPERATION_LOCATION);
        LOGGER.debug(original.toString());
        ArtifactAst modiifiedApp = this.loadAst("partialFetchingMultiLevelPartValueModifiesHashForKeys_2.ast");
        MetadataCacheId newHash = this.getIdForMetadataKeys(modiifiedApp, OPERATION_LOCATION);
        LOGGER.debug(newHash.toString());
        MatcherAssert.assertThat((Object)original, (Matcher)Matchers.not((Object)newHash));
    }

    @Test
    public void sameSimpleMetadataKeyWithSameResolverOnDifferentOperationsGeneratesSameHashForKeys() throws Exception {
        this.mockTypeResolversInformationModelProperty((EnrichableModel)this.operation, CATEGORY_NAME, "outputResolver", "attributesResolver", Collections.emptyMap(), "keysResolver");
        this.mockTypeResolversInformationModelProperty((EnrichableModel)this.anotherOperation, CATEGORY_NAME, "outputResolver", "attributesResolver", Collections.emptyMap(), "keysResolver");
        ArtifactAst app = this.loadAst("sameSimpleMetadataKeyWithSameResolverOnDifferentOperationsGeneratesSameHashForKeys_1.ast");
        MetadataCacheId operationKeysParts = this.getIdForMetadataKeys(app, OPERATION_LOCATION);
        LOGGER.debug(operationKeysParts.toString());
        ArtifactAst modifiedApp = this.loadAst("sameSimpleMetadataKeyWithSameResolverOnDifferentOperationsGeneratesSameHashForKeys_2.ast");
        MetadataCacheId anotherOperationKeysParts = this.getIdForMetadataKeys(modifiedApp, ANOTHER_OPERATION_LOCATION);
        LOGGER.debug(anotherOperationKeysParts.toString());
        MatcherAssert.assertThat((Object)anotherOperationKeysParts, (Matcher)Matchers.is((Object)operationKeysParts));
    }

    @Test
    public void multilevelPartsWithSameValuesOnDifferentOperationsGeneratesSameHashForKeys() throws Exception {
        this.mockMultiLevelMetadataKeyId(this.operation);
        this.mockMultiLevelMetadataKeyId(this.anotherOperation);
        this.mockTypeResolversInformationModelProperty((EnrichableModel)this.operation, CATEGORY_NAME, "outputResolver", "attributesResolver", Collections.emptyMap(), "keysResolver");
        this.mockTypeResolversInformationModelProperty((EnrichableModel)this.anotherOperation, CATEGORY_NAME, "outputResolver", "attributesResolver", Collections.emptyMap(), "keysResolver");
        ArtifactAst app = this.loadAst("multilevelPartsWithSameValuesOnDifferentOperationsGeneratesSameHashForKeys_1.ast");
        MetadataCacheId operationHash = this.getIdForMetadataKeys(app, OPERATION_LOCATION);
        MetadataCacheId anotherOperationHash = this.getIdForMetadataKeys(app, ANOTHER_OPERATION_LOCATION);
        LOGGER.debug(operationHash.toString());
        LOGGER.debug(anotherOperationHash.toString());
        MatcherAssert.assertThat((Object)operationHash, (Matcher)Matchers.is((Object)anotherOperationHash));
    }

    @Test
    public void multilevelPartsWithDifferentValuesOnDifferentOperationsGeneratesSameHashForKeys() throws Exception {
        this.mockMultiLevelMetadataKeyId(this.operation);
        this.mockMultiLevelMetadataKeyId(this.anotherOperation);
        this.mockTypeResolversInformationModelProperty((EnrichableModel)this.operation, CATEGORY_NAME, "outputResolver", "attributesResolver", Collections.emptyMap(), "keysResolver");
        this.mockTypeResolversInformationModelProperty((EnrichableModel)this.anotherOperation, CATEGORY_NAME, "outputResolver", "attributesResolver", Collections.emptyMap(), "keysResolver");
        ArtifactAst app = this.loadAst("multilevelPartsWithDifferentValuesOnDifferentOperationsGeneratesSameHashForKeys_1.ast");
        MetadataCacheId operationHash = this.getIdForMetadataKeys(app, OPERATION_LOCATION);
        MetadataCacheId anotherOperationHash = this.getIdForMetadataKeys(app, ANOTHER_OPERATION_LOCATION);
        LOGGER.debug(operationHash.toString());
        LOGGER.debug(anotherOperationHash.toString());
        MatcherAssert.assertThat((Object)operationHash, (Matcher)Matchers.is((Object)anotherOperationHash));
    }

    @Test
    public void partialFetchingWithSameValuesOnDifferentOperationsGeneratesSameHashForKeys() throws Exception {
        this.mockMultiLevelMetadataKeyId(this.operation);
        this.mockMultiLevelMetadataKeyId(this.anotherOperation);
        this.setPartialFetchingMock(this.operation);
        this.setPartialFetchingMock(this.anotherOperation);
        this.mockTypeResolversInformationModelProperty((EnrichableModel)this.operation, CATEGORY_NAME, "outputResolver", "attributesResolver", Collections.emptyMap(), "keysResolver");
        this.mockTypeResolversInformationModelProperty((EnrichableModel)this.anotherOperation, CATEGORY_NAME, "outputResolver", "attributesResolver", Collections.emptyMap(), "keysResolver");
        ArtifactAst app = this.loadAst("partialFetchingWithSameValuesOnDifferentOperationsGeneratesSameHashForKeys_1.ast");
        MetadataCacheId operationHash = this.getIdForMetadataKeys(app, OPERATION_LOCATION);
        MetadataCacheId anotherOperationHash = this.getIdForMetadataKeys(app, ANOTHER_OPERATION_LOCATION);
        LOGGER.debug(operationHash.toString());
        LOGGER.debug(anotherOperationHash.toString());
        MatcherAssert.assertThat((Object)operationHash, (Matcher)Matchers.is((Object)anotherOperationHash));
    }

    @Test
    public void partialFetchingWithDifferentValuesOnDifferentOperationsGeneratesSameHashForKeys() throws Exception {
        this.mockMultiLevelMetadataKeyId(this.operation);
        this.mockMultiLevelMetadataKeyId(this.anotherOperation);
        this.setPartialFetchingMock(this.operation);
        this.setPartialFetchingMock(this.anotherOperation);
        ArtifactAst app = this.loadAst("partialFetchingWithDifferentValuesOnDifferentOperationsGeneratesSameHashForKeys_1.ast");
        MetadataCacheId operationHash = this.getIdForMetadataKeys(app, OPERATION_LOCATION);
        MetadataCacheId anotherOperationHash = this.getIdForMetadataKeys(app, ANOTHER_OPERATION_LOCATION);
        LOGGER.debug(operationHash.toString());
        LOGGER.debug(anotherOperationHash.toString());
        MatcherAssert.assertThat((Object)operationHash, (Matcher)Matchers.is((Matcher)Matchers.not((Object)anotherOperationHash)));
    }

    private void mockRequiredForMetadataModelProperty(EnrichableModel model, List<String> parameterNames) {
        if (parameterNames == null) {
            Mockito.when((Object)model.getModelProperty(RequiredForMetadataModelProperty.class)).thenReturn(Optional.of(new RequiredForMetadataModelProperty(Collections.emptyList())));
        } else {
            RequiredForMetadataModelProperty requiredForMetadataModelProperty = new RequiredForMetadataModelProperty(parameterNames);
            Mockito.when((Object)model.getModelProperty(RequiredForMetadataModelProperty.class)).thenReturn(Optional.of(requiredForMetadataModelProperty));
        }
    }

    private void setPartialFetchingMock(OperationModel operation) {
        Mockito.when((Object)operation.getModelProperty(MetadataResolverFactoryModelProperty.class)).thenReturn(Optional.of(new MetadataResolverFactoryModelProperty(() -> new MetadataResolverFactory(){

            public TypeKeysResolver getKeyResolver() {
                return (TypeKeysResolver)Mockito.mock(PartialTypeKeysResolver.class);
            }

            public <T> InputTypeResolver<T> getInputResolver(String parameterName) {
                return (InputTypeResolver)Mockito.mock(InputTypeResolver.class);
            }

            public Collection<InputTypeResolver> getInputResolvers() {
                return Collections.emptyList();
            }

            public <T> OutputTypeResolver<T> getOutputResolver() {
                return (OutputTypeResolver)Mockito.mock(OutputTypeResolver.class);
            }

            public <T> AttributesTypeResolver<T> getOutputAttributesResolver() {
                return (AttributesTypeResolver)Mockito.mock(AttributesTypeResolver.class);
            }

            public QueryEntityResolver getQueryEntityResolver() {
                return (QueryEntityResolver)Mockito.mock(QueryEntityResolver.class);
            }
        })));
    }

    private void mockSimpleMetadataKeyId(OperationModel model) {
        ParameterModel metadataKeyId = this.mockKeyPart(METADATA_KEY_PART_1, 1);
        ArrayList<ParameterModel> parameterModels = new ArrayList<ParameterModel>(model.getAllParameterModels());
        parameterModels.add(metadataKeyId);
        Mockito.when((Object)((ParameterGroupModel)model.getParameterGroupModels().get(0)).getParameterModels()).thenReturn(parameterModels);
        Mockito.when((Object)((ParameterGroupModel)model.getParameterGroupModels().get(0)).getParameter(ArgumentMatchers.anyString())).then(invocation -> {
            String paramName;
            switch (paramName = (String)invocation.getArgument(0)) {
                case "myCamelCaseName": {
                    return Optional.of(this.contentParameter);
                }
                case "listName": {
                    return Optional.of(this.listParameter);
                }
                case "otherName": {
                    return Optional.of(this.behaviourParameter);
                }
                case "partOne": {
                    return Optional.of(metadataKeyId);
                }
            }
            return Optional.empty();
        });
        Mockito.when((Object)model.getModelProperty(MetadataKeyIdModelProperty.class)).thenReturn(Optional.of(new MetadataKeyIdModelProperty(this.TYPE_LOADER.load(String.class), METADATA_KEY_PART_1, CATEGORY_NAME)));
        Mockito.when((Object)model.getModelProperty(MetadataResolverFactoryModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)model.getAllParameterModels()).thenReturn(parameterModels);
    }

    private void mockMultiLevelMetadataKeyId(OperationModel operationModel) {
        ParameterModel partOne = this.mockKeyPart(METADATA_KEY_PART_1, 1);
        ParameterModel partTwo = this.mockKeyPart(METADATA_KEY_PART_2, 2);
        ParameterModel partThree = this.mockKeyPart(METADATA_KEY_PART_3, 3);
        List<ParameterModel> partParameterModels = Arrays.asList(partOne, partTwo, partThree);
        ParameterGroupModel metadataKeyIdGroup = (ParameterGroupModel)Mockito.mock(ParameterGroupModel.class, (MockSettings)new MockSettingsImpl().lenient().defaultAnswer(Mockito.RETURNS_DEFAULTS));
        Mockito.when((Object)metadataKeyIdGroup.getName()).thenReturn((Object)METADATA_KEY_GROUP);
        Mockito.when((Object)metadataKeyIdGroup.isShowInDsl()).thenReturn((Object)false);
        Mockito.when((Object)metadataKeyIdGroup.getParameterModels()).thenReturn(partParameterModels);
        Mockito.when((Object)metadataKeyIdGroup.getParameter(ArgumentMatchers.anyString())).then(invocation -> {
            String paramName;
            switch (paramName = (String)invocation.getArgument(0)) {
                case "partOne": {
                    return Optional.of(partOne);
                }
                case "partTwo": {
                    return Optional.of(partTwo);
                }
                case "partThree": {
                    return Optional.of(partThree);
                }
            }
            return Optional.empty();
        });
        ObjectTypeBuilder groupType = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType();
        groupType.addField().key(METADATA_KEY_PART_1).value(this.TYPE_LOADER.load(String.class));
        groupType.addField().key(METADATA_KEY_PART_2).value(this.TYPE_LOADER.load(String.class));
        groupType.addField().key(METADATA_KEY_PART_3).value(this.TYPE_LOADER.load(String.class));
        Mockito.when((Object)operationModel.getModelProperty(MetadataKeyIdModelProperty.class)).thenReturn(Optional.of(new MetadataKeyIdModelProperty((MetadataType)groupType.build(), METADATA_KEY_GROUP, CATEGORY_NAME)));
        Mockito.when((Object)operationModel.getModelProperty(MetadataResolverFactoryModelProperty.class)).thenReturn(Optional.of(new MetadataResolverFactoryModelProperty(NullMetadataResolverFactory::new)));
        Mockito.when((Object)operationModel.getParameterGroupModels()).thenReturn(Arrays.asList(this.parameterGroupModel, metadataKeyIdGroup));
        ArrayList parameterModels = new ArrayList(operationModel.getAllParameterModels());
        ArrayList allParams = new ArrayList();
        allParams.addAll(this.componentParameterModels);
        allParams.addAll(parameterModels);
        allParams.addAll(partParameterModels);
        Mockito.when((Object)operationModel.getAllParameterModels()).thenReturn(Collections.unmodifiableList(allParams));
    }

    private ParameterModel mockKeyPart(String name, int order) {
        ParameterModel metadataKeyId = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)metadataKeyId.getName()).thenReturn((Object)name);
        Mockito.when((Object)metadataKeyId.getExpressionSupport()).thenReturn((Object)ExpressionSupport.NOT_SUPPORTED);
        Mockito.when((Object)metadataKeyId.getModelProperty((Class)ArgumentMatchers.any())).then(invocation -> {
            if (invocation.getArguments()[0].equals(MetadataKeyPartModelProperty.class)) {
                return Optional.of(new MetadataKeyPartModelProperty(order));
            }
            return Optional.empty();
        });
        Mockito.when((Object)metadataKeyId.getDslConfiguration()).thenReturn((Object)ParameterDslConfiguration.getDefaultInstance());
        Mockito.when((Object)metadataKeyId.getLayoutModel()).thenReturn(Optional.empty());
        Mockito.when((Object)metadataKeyId.getRole()).thenReturn((Object)ParameterRole.BEHAVIOUR);
        Mockito.when((Object)metadataKeyId.getType()).thenReturn((Object)this.TYPE_LOADER.load(String.class));
        return metadataKeyId;
    }

    private ArtifactAst loadAst(String astFileName) throws IOException {
        ArtifactAstDeserializer defaultArtifactAstDeserializer = new ArtifactAstSerializerProvider().getDeserializer();
        ArtifactAst deserializedArtifactAst = defaultArtifactAstDeserializer.deserialize(((Object)((Object)this)).getClass().getResourceAsStream("/asts/" + astFileName), name -> this.extensions.stream().filter(x -> x.getName().equals(name)).findFirst().orElse(null));
        return deserializedArtifactAst;
    }
}

