/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.dsl.model.internal.config;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.config.internal.model.dsl.ClassLoaderResourceProvider;
import org.mule.runtime.properties.api.ConfigurationProperty;
import org.mule.runtime.properties.api.DefaultConfigurationPropertiesProvider;
import org.mule.runtime.properties.api.ResourceProvider;
import org.mule.runtime.properties.internal.ConfigurationPropertiesException;
import org.mule.tck.junit4.AbstractMuleTestCase;

@Feature(value="Configuration properties")
@Story(value="Component configuration properties with YAML story")
public class YamlConfigurationPropertiesComponentTestCase
extends AbstractMuleTestCase {
    private ResourceProvider externalResourceProvider;
    private DefaultConfigurationPropertiesProvider configurationComponent;

    @BeforeEach
    public void setUp() {
        this.externalResourceProvider = new ClassLoaderResourceProvider(Thread.currentThread().getContextClassLoader());
    }

    @Description(value="Validates the values obtained for the different types in the properties")
    @Test
    void validConfig() throws InitialisationException {
        this.configurationComponent = new DefaultConfigurationPropertiesProvider("properties.yaml", this.externalResourceProvider);
        this.configurationComponent.initialise();
        MatcherAssert.assertThat((Object)((ConfigurationProperty)this.configurationComponent.provide("number").get()).getValue(), (Matcher)Is.is((Object)"34843"));
        MatcherAssert.assertThat((Object)((ConfigurationProperty)this.configurationComponent.provide("float").get()).getValue(), (Matcher)Is.is((Object)"2392.00"));
        MatcherAssert.assertThat((Object)((ConfigurationProperty)this.configurationComponent.provide("date").get()).getValue(), (Matcher)Is.is((Object)"2001-01-23"));
        MatcherAssert.assertThat((Object)((ConfigurationProperty)this.configurationComponent.provide("lines").get()).getValue(), (Matcher)Is.is((Object)"458 Walkman Dr.\nSuite #292\n"));
        MatcherAssert.assertThat((Object)((ConfigurationProperty)this.configurationComponent.provide("list").get()).getValue(), (Matcher)Is.is((Object)"one,two,three"));
        MatcherAssert.assertThat((Object)((ConfigurationProperty)this.configurationComponent.provide("complex.prop0").get()).getValue(), (Matcher)Is.is((Object)"value0"));
        MatcherAssert.assertThat((Object)((ConfigurationProperty)this.configurationComponent.provide("complex.complex2.prop1").get()).getValue(), (Matcher)Is.is((Object)"value1"));
        MatcherAssert.assertThat((Object)((ConfigurationProperty)this.configurationComponent.provide("complex.complex2.prop2").get()).getValue(), (Matcher)Is.is((Object)"value2"));
    }

    @Description(value="Validates that a list of complex objects is not valid")
    @Test
    void complexListOfObjectsNotSuported() throws InitialisationException {
        this.configurationComponent = new DefaultConfigurationPropertiesProvider("complex-list-object.yaml", this.externalResourceProvider);
        ConfigurationPropertiesException thrown = (ConfigurationPropertiesException)Assertions.assertThrows(ConfigurationPropertiesException.class, () -> this.configurationComponent.initialise());
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Is.is((Object)"Configuration properties does not support type a list of complex types. Complex type keys are: complex"));
    }

    @Description(value="Validates that a only string types are supported")
    @Test
    void unsupportedType() throws InitialisationException {
        this.configurationComponent = new DefaultConfigurationPropertiesProvider("unsupported-type.yaml", this.externalResourceProvider);
        ConfigurationPropertiesException thrown = (ConfigurationPropertiesException)Assertions.assertThrows(ConfigurationPropertiesException.class, () -> this.configurationComponent.initialise());
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Is.is((Object)"YAML configuration properties only supports string values, make sure to wrap the value with \" so you force the value to be an string. Offending property is integer with value 1235"));
    }

    @Description(value="Validates encoding")
    @Test
    void validConfigEncoding() throws InitialisationException {
        this.configurationComponent = new DefaultConfigurationPropertiesProvider("properties-utf16.yaml", "UTF-16", this.externalResourceProvider);
        this.configurationComponent.initialise();
        MatcherAssert.assertThat((Object)((ConfigurationProperty)this.configurationComponent.provide("number").get()).getValue(), (Matcher)Is.is((Object)"34843"));
    }

    @Description(value="YAML config files need spaces after key definition")
    @Test
    void spacesRequired() throws InitialisationException {
        this.configurationComponent = new DefaultConfigurationPropertiesProvider("spaces.yaml", this.externalResourceProvider);
        ConfigurationPropertiesException thrown = (ConfigurationPropertiesException)Assertions.assertThrows(ConfigurationPropertiesException.class, () -> this.configurationComponent.initialise());
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Is.is((Object)"YAML configuration properties must have space after ':' character. Offending line is: prop1:\"v1\" prop2:\"v2\""));
    }

    @Description(value="YAML config files need to have correct number of quotes")
    @Test
    void quotesRequired() throws InitialisationException {
        this.configurationComponent = new DefaultConfigurationPropertiesProvider("quotes.yaml", this.externalResourceProvider);
        ConfigurationPropertiesException thrown = (ConfigurationPropertiesException)Assertions.assertThrows(ConfigurationPropertiesException.class, () -> this.configurationComponent.initialise());
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Is.is((Object)"Error while parsing YAML configuration file. Check that all quotes are correctly closed."));
    }
}

