/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.model;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.app.declaration.api.ElementDeclaration;
import org.mule.runtime.config.api.dsl.CoreDslConstants;
import org.mule.runtime.config.api.dsl.model.ComponentBuildingDefinitionRegistry;
import org.mule.runtime.config.api.dsl.model.ConfigurationParameters;
import org.mule.runtime.config.api.dsl.model.DslElementModel;
import org.mule.runtime.config.api.dsl.model.DslElementModelFactory;
import org.mule.runtime.config.api.dsl.model.ResourceProvider;
import org.mule.runtime.config.api.dsl.model.properties.ConfigurationPropertiesProvider;
import org.mule.runtime.config.api.dsl.model.properties.ConfigurationPropertiesProviderFactory;
import org.mule.runtime.config.api.dsl.model.properties.ConfigurationProperty;
import org.mule.runtime.config.api.dsl.processor.ArtifactConfig;
import org.mule.runtime.config.internal.dsl.model.ComponentLocationVisitor;
import org.mule.runtime.config.internal.dsl.model.ComponentModelReader;
import org.mule.runtime.config.internal.dsl.model.DefaultConfigurationParameters;
import org.mule.runtime.config.internal.dsl.model.ExtensionModelHelper;
import org.mule.runtime.config.internal.dsl.model.config.CompositeConfigurationPropertiesProvider;
import org.mule.runtime.config.internal.dsl.model.config.ConfigurationPropertiesResolver;
import org.mule.runtime.config.internal.dsl.model.config.DefaultConfigurationPropertiesResolver;
import org.mule.runtime.config.internal.dsl.model.config.DefaultConfigurationProperty;
import org.mule.runtime.config.internal.dsl.model.config.EnvironmentPropertiesConfigurationProvider;
import org.mule.runtime.config.internal.dsl.model.config.FileConfigurationPropertiesProvider;
import org.mule.runtime.config.internal.dsl.model.config.GlobalPropertyConfigurationPropertiesProvider;
import org.mule.runtime.config.internal.dsl.model.config.MapConfigurationPropertiesProvider;
import org.mule.runtime.config.internal.dsl.model.config.PropertiesResolverConfigurationProperties;
import org.mule.runtime.config.internal.dsl.model.config.RuntimeConfigurationException;
import org.mule.runtime.config.internal.dsl.model.extension.xml.MacroExpansionModulesModel;
import org.mule.runtime.config.internal.dsl.processor.ObjectTypeVisitor;
import org.mule.runtime.config.internal.dsl.spring.ComponentModelHelper;
import org.mule.runtime.config.internal.model.ComponentModel;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.extension.MuleExtensionModelProvider;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.runtime.dsl.api.component.TypeDefinitionVisitor;
import org.mule.runtime.dsl.api.component.config.ComponentConfiguration;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.mule.runtime.dsl.api.xml.parser.ConfigFile;
import org.mule.runtime.dsl.api.xml.parser.ConfigLine;
import org.mule.runtime.dsl.api.xml.parser.SimpleConfigAttribute;
import org.mule.runtime.extension.api.util.NameUtils;
import org.mule.runtime.internal.util.NameValidationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationModel.class);
    public static final String POLICY_ROOT_ELEMENT = "policy";
    public static final String ERROR_MAPPING = "error-mapping";
    public static final String ON_ERROR = "on-error";
    public static final String MAX_REDELIVERY_ATTEMPTS_ROLLBACK_ES_ATTRIBUTE = "maxRedeliveryAttempts";
    public static final String WHEN_CHOICE_ES_ATTRIBUTE = "when";
    public static final String TYPE_ES_ATTRIBUTE = "type";
    public static final String EXCEPTION_STRATEGY_REFERENCE_ELEMENT = "exception-strategy";
    public static final String PROPERTY_ELEMENT = "property";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String REFERENCE_ATTRIBUTE = "ref";
    public static final String VALUE_ATTRIBUTE = "value";
    public static final String TRANSFORMER_REFERENCE_ELEMENT = "transformer";
    public static final String ANNOTATION_ELEMENT = "annotations";
    public static final String DATA_WEAVE = "weave";
    public static final String CUSTOM_TRANSFORMER = "custom-transformer";
    public static final String DESCRIPTION_ELEMENT = "description";
    public static final String PROPERTIES_ELEMENT = "properties";
    private static final String MODULE_OPERATION_CHAIN_ELEMENT = "module-operation-chain";
    public static final String REDELIVERY_POLICY_ELEMENT = "redelivery-policy";
    public static final String TEST_NAMESPACE = "test";
    public static final String DOC_NAMESPACE = "doc";
    public static final String SPRING_SECURITY_NAMESPACE = "ss";
    public static final String MULE_SECURITY_NAMESPACE = "mule-ss";
    public static final String MULE_XML_NAMESPACE = "mulexml";
    public static final String PGP_NAMESPACE = "pgp";
    public static final String XSL_NAMESPACE = "xsl";
    public static final String TRANSPORT_NAMESPACE = "transports";
    public static final String JMS_NAMESPACE = "jms";
    public static final String VM_NAMESPACE = "vm";
    public static final String HTTP_TRANSPORT_NAMESPACE = "http-transport";
    public static final String BATCH_NAMESPACE = "batch";
    public static final String PARSER_TEST_NAMESPACE = "parsers-test";
    public static final String GLOBAL_PROPERTY = "global-property";
    public static final String SECURITY_MANAGER = "security-manager";
    public static final String OBJECT_ELEMENT = "object";
    public static final ComponentIdentifier EXCEPTION_STRATEGY_REFERENCE_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("exception-strategy").build();
    public static final ComponentIdentifier ERROR_MAPPING_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("error-mapping").build();
    public static final ComponentIdentifier ON_ERROR_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("on-error").build();
    public static final ComponentIdentifier MULE_PROPERTY_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("property").build();
    public static final ComponentIdentifier MULE_PROPERTIES_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("properties").build();
    public static final ComponentIdentifier ANNOTATIONS_ELEMENT_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("annotations").build();
    public static final ComponentIdentifier TRANSFORMER_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("transformer").build();
    public static final ComponentIdentifier CUSTOM_TRANSFORMER_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("custom-transformer").build();
    public static final ComponentIdentifier DOC_DESCRIPTION_IDENTIFIER = ComponentIdentifier.builder().namespace("doc").name("description").build();
    public static final ComponentIdentifier DESCRIPTION_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("description").build();
    public static final ComponentIdentifier OBJECT_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("object").build();
    public static final ComponentIdentifier REDELIVERY_POLICY_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("redelivery-policy").build();
    public static final ComponentIdentifier GLOBAL_PROPERTY_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("global-property").build();
    public static final ComponentIdentifier SECURITY_MANAGER_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("security-manager").build();
    public static final ComponentIdentifier MODULE_OPERATION_CHAIN = ComponentIdentifier.builder().namespace("mule").name("module-operation-chain").build();
    public static final String MUNIT_PREFIX = "munit";
    public static final ComponentIdentifier MUNIT_TEST_IDENTIFIER = ComponentIdentifier.builder().namespace("munit").name("test").build();
    public static final ComponentIdentifier MUNIT_BEFORE_TEST_IDENTIFIER = ComponentIdentifier.builder().namespace("munit").name("before-test").build();
    public static final ComponentIdentifier MUNIT_BEFORE_SUITE_IDENTIFIER = ComponentIdentifier.builder().namespace("munit").name("before-suite").build();
    public static final ComponentIdentifier MUNIT_AFTER_TEST_IDENTIFIER = ComponentIdentifier.builder().namespace("munit").name("after-test").build();
    public static final ComponentIdentifier MUNIT_AFTER_SUITE_IDENTIFIER = ComponentIdentifier.builder().namespace("munit").name("after-suite").build();
    public static final String HTTP_POLICY = "http-policy";
    public static final ComponentIdentifier HTTP_PROXY_SOURCE_POLICY_IDENTIFIER = ComponentIdentifier.builder().namespace("http-policy").name("source").build();
    public static final ComponentIdentifier HTTP_PROXY_OPERATION_IDENTIFIER = ComponentIdentifier.builder().namespace("http-policy").name("operation").build();
    public static final ComponentIdentifier HTTP_PROXY_POLICY_IDENTIFIER = ComponentIdentifier.builder().namespace("http-policy").name("proxy").build();
    public static final String CLASS_ATTRIBUTE = "class";
    private static ImmutableSet<ComponentIdentifier> ignoredNameValidationComponentList = ImmutableSet.builder().add((Object)ComponentIdentifier.builder().namespace("mule").name("flow-ref").build()).add((Object)ComponentIdentifier.builder().namespace("mule").name("alias").build()).add((Object)ComponentIdentifier.builder().namespace("mule").name("password-encryption-strategy").build()).add((Object)ComponentIdentifier.builder().namespace("mule").name("custom-security-provider").build()).add((Object)ComponentIdentifier.builder().namespace("mule").name("custom-encryption-strategy").build()).add((Object)ComponentIdentifier.builder().namespace("mule").name("secret-key-encryption-strategy").build()).add((Object)ComponentIdentifier.builder().namespace("mule").name("import").build()).add((Object)ComponentIdentifier.builder().namespace("mule").name("string-to-byte-array-transformer").build()).add((Object)ComponentIdentifier.builder().namespace("mule").name("append-string-transformer").build()).add((Object)ComponentIdentifier.builder().namespace("mule").name("security-manager").build()).add((Object)ComponentIdentifier.builder().namespace("test").name("queue").build()).add((Object)ComponentIdentifier.builder().namespace("test").name("invocation-counter").build()).add((Object)ComponentIdentifier.builder().namespace("ss").name("user").build()).add((Object)ComponentIdentifier.builder().namespace("mule-ss").name("delegate-security-provider").build()).add((Object)ComponentIdentifier.builder().namespace("mule-ss").name("security-manager").build()).add((Object)ComponentIdentifier.builder().namespace("mulexml").name("xslt-transformer").build()).add((Object)ComponentIdentifier.builder().namespace("mulexml").name("alias").build()).add((Object)ComponentIdentifier.builder().namespace("pgp").name("security-provider").build()).add((Object)ComponentIdentifier.builder().namespace("pgp").name("keybased-encryption-strategy").build()).add((Object)ComponentIdentifier.builder().namespace("xsl").name("param").build()).add((Object)ComponentIdentifier.builder().namespace("xsl").name("attribute").build()).add((Object)ComponentIdentifier.builder().namespace("xsl").name("element").build()).add((Object)ComponentIdentifier.builder().namespace("transports").name("inbound-endpoint").build()).add((Object)ComponentIdentifier.builder().namespace("transports").name("outbound-endpoint").build()).add((Object)ComponentIdentifier.builder().namespace("jms").name("inbound-endpoint").build()).add((Object)ComponentIdentifier.builder().namespace("vm").name("inbound-endpoint").build()).add((Object)ComponentIdentifier.builder().namespace("http-transport").name("inbound-endpoint").build()).add((Object)ComponentIdentifier.builder().namespace("http-transport").name("set-cookie").build()).add((Object)ComponentIdentifier.builder().namespace("http-transport").name("header").build()).add((Object)ComponentIdentifier.builder().namespace("http-transport").name("http-response-to-object-transformer").build()).add((Object)ComponentIdentifier.builder().namespace("http-transport").name("http-response-to-string-transformer").build()).add((Object)ComponentIdentifier.builder().namespace("http-transport").name("message-to-http-response-transformer").build()).add((Object)ComponentIdentifier.builder().namespace("http-transport").name("object-to-http-request-transformer").build()).add((Object)ComponentIdentifier.builder().namespace("batch").name("step").build()).add((Object)ComponentIdentifier.builder().namespace("batch").name("execute").build()).add((Object)ComponentIdentifier.builder().namespace("parsers-test").name("child").build()).add((Object)ComponentIdentifier.builder().namespace("parsers-test").name("kid").build()).add((Object)ComponentIdentifier.builder().namespace("weave").name("reader-property").build()).build();
    private final Optional<ComponentBuildingDefinitionRegistry> componentBuildingDefinitionRegistry;
    private List<ComponentModel> muleComponentModels = new LinkedList<ComponentModel>();
    private PropertiesResolverConfigurationProperties configurationProperties;
    private ResourceProvider externalResourceProvider;
    private Map<String, ComponentModel> namedComponentModels = new HashMap<String, ComponentModel>();
    private Map<String, ComponentModel> namedTopLevelComponentModels = new HashMap<String, ComponentModel>();

    public ApplicationModel(ArtifactConfig artifactConfig, ArtifactDeclaration artifactDeclaration, ResourceProvider externalResourceProvider) throws Exception {
        this(artifactConfig, artifactDeclaration, Collections.emptySet(), Collections.emptyMap(), Optional.empty(), Optional.of(new ComponentBuildingDefinitionRegistry()), true, externalResourceProvider);
    }

    public ApplicationModel(ArtifactConfig artifactConfig, ArtifactDeclaration artifactDeclaration, Set<ExtensionModel> extensionModels, Map<String, String> deploymentProperties, Optional<ConfigurationProperties> parentConfigurationProperties, Optional<ComponentBuildingDefinitionRegistry> componentBuildingDefinitionRegistry, boolean runtimeMode, ResourceProvider externalResourceProvider) throws Exception {
        this.componentBuildingDefinitionRegistry = componentBuildingDefinitionRegistry;
        this.externalResourceProvider = externalResourceProvider;
        this.createConfigurationAttributeResolver(artifactConfig, parentConfigurationProperties, deploymentProperties);
        this.convertConfigFileToComponentModel(artifactConfig);
        this.convertArtifactDeclarationToComponentModel(extensionModels, artifactDeclaration);
        this.resolveRegistrationNames();
        this.createEffectiveModel();
        this.indexComponentModels();
        this.validateModel(componentBuildingDefinitionRegistry);
        ExtensionModelHelper extensionModelHelper = new ExtensionModelHelper(extensionModels);
        if (runtimeMode) {
            this.expandModules(extensionModels);
            this.indexComponentModels();
        }
        this.resolveComponentTypes();
        this.resolveTypedComponentIdentifier(extensionModelHelper);
        this.executeOnEveryMuleComponentTree(componentModel -> new ComponentLocationVisitor().accept((ComponentModel)componentModel));
    }

    private void indexComponentModels() {
        this.executeOnEveryComponentTree(componentModel -> {
            if (componentModel.getNameAttribute() != null) {
                this.namedComponentModels.put(componentModel.getNameAttribute(), (ComponentModel)componentModel);
            }
        });
        this.executeOnEveryRootElement(componentModel -> {
            if (componentModel.getNameAttribute() != null) {
                this.namedTopLevelComponentModels.put(componentModel.getNameAttribute(), (ComponentModel)componentModel);
            }
        });
    }

    private void resolveTypedComponentIdentifier(ExtensionModelHelper extensionModelHelper) {
        this.executeOnEveryComponentTree(componentModel -> {
            Optional<TypedComponentIdentifier> typedComponentIdentifier = Optional.of(TypedComponentIdentifier.builder().identifier(componentModel.getIdentifier()).type(ComponentModelHelper.resolveComponentType(componentModel, extensionModelHelper)).build());
            componentModel.setComponentType(typedComponentIdentifier.map(typedIdentifier -> typedIdentifier.getType()).orElse(TypedComponentIdentifier.ComponentType.UNKNOWN));
        });
    }

    private void createConfigurationAttributeResolver(ArtifactConfig artifactConfig, final Optional<ConfigurationProperties> parentConfigurationProperties, Map<String, String> deploymentProperties) {
        DefaultConfigurationPropertiesResolver systemPropertiesResolver;
        MapConfigurationPropertiesProvider deploymentPropertiesConfigurationProperties = null;
        if (!deploymentProperties.isEmpty()) {
            deploymentPropertiesConfigurationProperties = new MapConfigurationPropertiesProvider(deploymentProperties, "Deployment properties");
        }
        EnvironmentPropertiesConfigurationProvider environmentPropertiesConfigurationProvider = new EnvironmentPropertiesConfigurationProvider();
        ConfigurationPropertiesProvider globalPropertiesConfigurationAttributeProvider = this.createProviderFromGlobalProperties(artifactConfig);
        DefaultConfigurationPropertiesResolver environmentPropertiesConfigurationPropertiesResolver = new DefaultConfigurationPropertiesResolver(Optional.empty(), environmentPropertiesConfigurationProvider);
        DefaultConfigurationPropertiesResolver parentLocalResolver = deploymentPropertiesConfigurationProperties != null ? new DefaultConfigurationPropertiesResolver(Optional.of(environmentPropertiesConfigurationPropertiesResolver), deploymentPropertiesConfigurationProperties) : environmentPropertiesConfigurationPropertiesResolver;
        DefaultConfigurationPropertiesResolver localResolver = new DefaultConfigurationPropertiesResolver(Optional.of(new DefaultConfigurationPropertiesResolver(Optional.of(parentLocalResolver), globalPropertiesConfigurationAttributeProvider)), environmentPropertiesConfigurationProvider);
        localResolver.setRootResolver(parentLocalResolver);
        List<ConfigurationPropertiesProvider> configConfigurationPropertiesProviders = this.getConfigurationPropertiesProvidersFromComponents(artifactConfig, localResolver);
        FileConfigurationPropertiesProvider externalPropertiesConfigurationProvider = new FileConfigurationPropertiesProvider(this.externalResourceProvider, "External files");
        Optional<ConfigurationPropertiesResolver> parentConfigurationPropertiesResolver = Optional.of(localResolver);
        if (parentConfigurationProperties.isPresent()) {
            parentConfigurationPropertiesResolver = Optional.of(new DefaultConfigurationPropertiesResolver(Optional.empty(), new ConfigurationPropertiesProvider(){

                @Override
                public Optional<ConfigurationProperty> getConfigurationProperty(String configurationAttributeKey) {
                    return ((ConfigurationProperties)parentConfigurationProperties.get()).resolveProperty(configurationAttributeKey).map(value -> new DefaultConfigurationProperty(parentConfigurationProperties, configurationAttributeKey, value));
                }

                @Override
                public String getDescription() {
                    return "Domain properties";
                }
            }));
        }
        Optional<Object> configurationAttributesProvider = Optional.empty();
        if (!configConfigurationPropertiesProviders.isEmpty()) {
            configurationAttributesProvider = Optional.of(new CompositeConfigurationPropertiesProvider(configConfigurationPropertiesProviders));
            parentConfigurationPropertiesResolver = Optional.of(new DefaultConfigurationPropertiesResolver(deploymentPropertiesConfigurationProperties != null ? Optional.of(new DefaultConfigurationPropertiesResolver(parentConfigurationPropertiesResolver, deploymentPropertiesConfigurationProperties)) : parentConfigurationPropertiesResolver, (ConfigurationPropertiesProvider)configurationAttributesProvider.get()));
        } else if (deploymentPropertiesConfigurationProperties != null) {
            parentConfigurationPropertiesResolver = Optional.of(new DefaultConfigurationPropertiesResolver(parentConfigurationPropertiesResolver, deploymentPropertiesConfigurationProperties));
        }
        DefaultConfigurationPropertiesResolver globalPropertiesConfigurationPropertiesResolver = new DefaultConfigurationPropertiesResolver(parentConfigurationPropertiesResolver, globalPropertiesConfigurationAttributeProvider);
        if (configurationAttributesProvider.isPresent()) {
            DefaultConfigurationPropertiesResolver configurationPropertiesResolver = new DefaultConfigurationPropertiesResolver(Optional.of(globalPropertiesConfigurationPropertiesResolver), (ConfigurationPropertiesProvider)configurationAttributesProvider.get());
            systemPropertiesResolver = new DefaultConfigurationPropertiesResolver(Optional.of(configurationPropertiesResolver), environmentPropertiesConfigurationProvider);
        } else {
            systemPropertiesResolver = new DefaultConfigurationPropertiesResolver(Optional.of(globalPropertiesConfigurationPropertiesResolver), environmentPropertiesConfigurationProvider);
        }
        DefaultConfigurationPropertiesResolver externalPropertiesResolver = new DefaultConfigurationPropertiesResolver(deploymentPropertiesConfigurationProperties != null ? Optional.of(new DefaultConfigurationPropertiesResolver(Optional.of(systemPropertiesResolver), deploymentPropertiesConfigurationProperties)) : Optional.of(systemPropertiesResolver), externalPropertiesConfigurationProvider);
        if (deploymentPropertiesConfigurationProperties == null) {
            externalPropertiesResolver.setAsRootResolver();
            this.configurationProperties = new PropertiesResolverConfigurationProperties(externalPropertiesResolver);
        } else {
            DefaultConfigurationPropertiesResolver deploymentPropertiesResolver = new DefaultConfigurationPropertiesResolver(Optional.of(externalPropertiesResolver), deploymentPropertiesConfigurationProperties);
            deploymentPropertiesResolver.setAsRootResolver();
            this.configurationProperties = new PropertiesResolverConfigurationProperties(deploymentPropertiesResolver);
        }
        try {
            LifecycleUtils.initialiseIfNeeded((Object)this.configurationProperties.getConfigurationPropertiesResolver());
        }
        catch (InitialisationException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private List<ConfigurationPropertiesProvider> getConfigurationPropertiesProvidersFromComponents(ArtifactConfig artifactConfig, ConfigurationPropertiesResolver localResolver) {
        HashMap providerFactoriesMap = new HashMap();
        ServiceLoader<ConfigurationPropertiesProviderFactory> providerFactories = ServiceLoader.load(ConfigurationPropertiesProviderFactory.class);
        providerFactories.forEach(service -> {
            ComponentIdentifier componentIdentifier = service.getSupportedComponentIdentifier();
            if (providerFactoriesMap.containsKey(componentIdentifier)) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Multiple configuration providers for component: " + componentIdentifier)));
            }
            providerFactoriesMap.put(componentIdentifier, service);
        });
        ArrayList<ConfigurationPropertiesProvider> configConfigurationPropertiesProviders = new ArrayList<ConfigurationPropertiesProvider>();
        artifactConfig.getConfigFiles().stream().forEach(configFile -> configFile.getConfigLines().stream().forEach(configLine -> {
            for (ConfigLine componentConfigLine : configLine.getChildren()) {
                ComponentIdentifier componentIdentifier;
                if (componentConfigLine.getNamespace() == null || !providerFactoriesMap.containsKey(componentIdentifier = ComponentIdentifier.builder().namespace(componentConfigLine.getNamespace()).name(componentConfigLine.getIdentifier()).build())) continue;
                DefaultConfigurationParameters.Builder configurationParametersBuilder = DefaultConfigurationParameters.builder();
                ConfigurationParameters configurationParameters = this.resolveConfigurationParameters(configurationParametersBuilder, componentConfigLine, localResolver);
                ConfigurationPropertiesProvider provider = ((ConfigurationPropertiesProviderFactory)providerFactoriesMap.get(componentIdentifier)).createProvider(configurationParameters, this.externalResourceProvider);
                if (provider instanceof Component) {
                    Component providerComponent = (Component)provider;
                    TypedComponentIdentifier typedComponentIdentifier = TypedComponentIdentifier.builder().type(TypedComponentIdentifier.ComponentType.UNKNOWN).identifier(componentIdentifier).build();
                    DefaultComponentLocation.DefaultLocationPart locationPart = new DefaultComponentLocation.DefaultLocationPart(componentIdentifier.getName(), Optional.of(typedComponentIdentifier), Optional.of(configFile.getFilename()), Optional.of(configLine.getLineNumber()), Optional.of(configLine.getStartColumn()));
                    providerComponent.setAnnotations((Map)ImmutableMap.builder().put((Object)AbstractComponent.LOCATION_KEY, (Object)new DefaultComponentLocation(Optional.of(componentIdentifier.getName()), Collections.singletonList(locationPart))).build());
                }
                configConfigurationPropertiesProviders.add(provider);
            }
        }));
        return configConfigurationPropertiesProviders;
    }

    public void close() {
        LifecycleUtils.disposeIfNeeded((Object)this.configurationProperties.getConfigurationPropertiesResolver(), (Logger)LOGGER);
    }

    private ConfigurationParameters resolveConfigurationParameters(DefaultConfigurationParameters.Builder configurationParametersBuilder, ConfigLine componentConfigLine, ConfigurationPropertiesResolver localResolver) {
        componentConfigLine.getConfigAttributes().forEach((key, value) -> configurationParametersBuilder.withSimpleParameter((String)key, localResolver.resolveValue(value.getValue())));
        for (ConfigLine childConfigLine : componentConfigLine.getChildren()) {
            DefaultConfigurationParameters.Builder childParametersBuilder = DefaultConfigurationParameters.builder();
            configurationParametersBuilder.withComplexParameter(ComponentIdentifier.builder().name(childConfigLine.getIdentifier()).namespace(childConfigLine.getNamespace()).build(), this.resolveConfigurationParameters(childParametersBuilder, childConfigLine, localResolver));
        }
        return configurationParametersBuilder.build();
    }

    public void resolveComponentTypes() {
        this.componentBuildingDefinitionRegistry.ifPresent(buildingDefinitionRegistry -> this.executeOnEveryComponentTree(componentModel -> {
            Optional<ComponentBuildingDefinition<?>> buildingDefinition = buildingDefinitionRegistry.getBuildingDefinition(componentModel.getIdentifier());
            buildingDefinition.map(definition -> {
                ObjectTypeVisitor typeDefinitionVisitor = new ObjectTypeVisitor((ComponentModel)componentModel);
                definition.getTypeDefinition().visit((TypeDefinitionVisitor)typeDefinitionVisitor);
                componentModel.setType(typeDefinitionVisitor.getType());
                return definition;
            }).orElseGet(() -> {
                String classParameter = componentModel.getParameters().get(CLASS_ATTRIBUTE);
                if (classParameter != null) {
                    try {
                        componentModel.setType(ClassUtils.loadClass((String)classParameter, (ClassLoader)Thread.currentThread().getContextClassLoader()));
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeConfigurationException(I18nMessageFactory.createStaticMessage((String)e.getMessage()), e);
                    }
                }
                return null;
            });
        }));
    }

    private void createEffectiveModel() {
        this.processSourcesRedeliveryPolicy();
    }

    private void processSourcesRedeliveryPolicy() {
        this.executeOnEveryFlow(flowComponentModel -> {
            if (!flowComponentModel.getInnerComponents().isEmpty()) {
                ComponentModel possibleSourceComponent = flowComponentModel.getInnerComponents().get(0);
                possibleSourceComponent.getInnerComponents().stream().filter(childComponent -> childComponent.getIdentifier().equals(REDELIVERY_POLICY_IDENTIFIER)).findAny().ifPresent(redeliveryPolicyComponentModel -> {
                    possibleSourceComponent.getInnerComponents().remove(redeliveryPolicyComponentModel);
                    flowComponentModel.getInnerComponents().add(1, (ComponentModel)redeliveryPolicyComponentModel);
                });
            }
        });
    }

    private void convertArtifactDeclarationToComponentModel(Set<ExtensionModel> extensionModels, ArtifactDeclaration artifactDeclaration) {
        if (artifactDeclaration != null && !extensionModels.isEmpty()) {
            ExtensionModel muleModel = MuleExtensionModelProvider.getExtensionModel();
            if (!extensionModels.contains(muleModel)) {
                extensionModels = new HashSet<ExtensionModel>(extensionModels);
                extensionModels.add(muleModel);
            }
            DslElementModelFactory elementFactory = DslElementModelFactory.getDefault(DslResolvingContext.getDefault(extensionModels));
            ComponentModel rootComponent = new ComponentModel.Builder().setIdentifier(ComponentIdentifier.builder().namespace("mule").name("mule").build()).build();
            AtomicBoolean atLeastOneComponentAdded = new AtomicBoolean(false);
            artifactDeclaration.getGlobalElements().stream().map(e -> elementFactory.create((ElementDeclaration)e)).filter(Optional::isPresent).map(e -> ((DslElementModel)e.get()).getConfiguration()).forEach(config -> config.ifPresent(c -> {
                atLeastOneComponentAdded.set(true);
                ComponentModel componentModel = this.convertComponentConfiguration((ComponentConfiguration)c, true);
                componentModel.setParent(rootComponent);
                rootComponent.getInnerComponents().add(componentModel);
            }));
            if (atLeastOneComponentAdded.get()) {
                this.muleComponentModels.add(rootComponent);
            }
        }
    }

    private ComponentModel convertComponentConfiguration(ComponentConfiguration componentConfiguration, boolean isRoot) {
        ComponentModel.Builder builder = new ComponentModel.Builder().setIdentifier(componentConfiguration.getIdentifier());
        if (isRoot) {
            builder.markAsRootComponent();
        }
        for (Map.Entry parameter : componentConfiguration.getParameters().entrySet()) {
            builder.addParameter((String)parameter.getKey(), (String)parameter.getValue(), false);
        }
        for (ComponentConfiguration childComponentConfiguration : componentConfiguration.getNestedComponents()) {
            builder.addChildComponentModel(this.convertComponentConfiguration(childComponentConfiguration, false));
        }
        componentConfiguration.getValue().ifPresent(builder::setTextContent);
        ComponentModel componentModel = builder.build();
        for (ComponentModel childComponent : componentModel.getInnerComponents()) {
            childComponent.setParent(componentModel);
        }
        return componentModel;
    }

    private ConfigurationPropertiesProvider createProviderFromGlobalProperties(ArtifactConfig artifactConfig) {
        HashMap<String, ConfigurationProperty> globalProperties = new HashMap<String, ConfigurationProperty>();
        artifactConfig.getConfigFiles().stream().forEach(configFile -> ((ConfigLine)configFile.getConfigLines().get(0)).getChildren().stream().forEach(configLine -> {
            if (GLOBAL_PROPERTY.equals(configLine.getIdentifier())) {
                String key = ((SimpleConfigAttribute)configLine.getConfigAttributes().get(NAME_ATTRIBUTE)).getValue();
                String rawValue = ((SimpleConfigAttribute)configLine.getConfigAttributes().get(VALUE_ATTRIBUTE)).getValue();
                globalProperties.put(key, new DefaultConfigurationProperty(String.format("global-property - file: %s - lineNumber %s", configFile.getFilename(), configLine.getLineNumber()), key, rawValue));
            }
        }));
        return new GlobalPropertyConfigurationPropertiesProvider(globalProperties);
    }

    public Optional<ComponentModel> findComponentDefinitionModel(ComponentIdentifier componentIdentifier) {
        if (this.muleComponentModels.isEmpty()) {
            return Optional.empty();
        }
        return this.muleComponentModels.get(0).getInnerComponents().stream().filter(ComponentModel::isRoot).filter(componentModel -> componentModel.getIdentifier().equals(componentIdentifier)).findFirst();
    }

    private void convertConfigFileToComponentModel(ArtifactConfig artifactConfig) {
        List<ConfigFile> configFiles = artifactConfig.getConfigFiles();
        ComponentModelReader componentModelReader = new ComponentModelReader(this.configurationProperties.getConfigurationPropertiesResolver());
        configFiles.stream().forEach(configFile -> {
            ComponentModel componentModel = componentModelReader.extractComponentDefinitionModel((ConfigLine)configFile.getConfigLines().get(0), configFile.getFilename());
            if (this.muleComponentModels.isEmpty()) {
                this.muleComponentModels.add(componentModel);
            } else {
                ComponentModel rootComponentModel = this.muleComponentModels.get(0);
                this.muleComponentModels.set(0, new ComponentModel.Builder(rootComponentModel).merge(componentModel).build());
            }
        });
    }

    private void validateModel(Optional<ComponentBuildingDefinitionRegistry> componentBuildingDefinitionRegistry) throws ConfigurationException {
        if (this.muleComponentModels.isEmpty() || !this.isMuleConfigurationFile()) {
            return;
        }
        this.validateSingletonsAreNotRepeated();
        this.validateNameIsNotRepeated();
        this.validateNameHasValidCharacters();
        this.validateFlowRefPointsToExistingFlow();
        this.validateErrorMappings();
        this.validateExceptionStrategyWhenAttributeIsOnlyPresentInsideChoice();
        this.validateErrorHandlerStructure();
        this.validateParameterAndChildForSameAttributeAreNotDefinedTogether();
        if (componentBuildingDefinitionRegistry.isPresent()) {
            this.validateNamedTopLevelElementsHaveName(componentBuildingDefinitionRegistry.get());
        }
        this.validateSingleElementsExistence();
    }

    private void validateFlowRefPointsToExistingFlow() {
        this.executeOnEveryMuleComponentTree(componentModel -> {
            String nameAttribute;
            if (componentModel.getIdentifier().equals(CoreDslConstants.FLOW_REF_IDENTIFIER) && (nameAttribute = componentModel.getNameAttribute()) != null && !nameAttribute.startsWith("#[")) {
                Optional<ComponentModel> referencedFlow = this.findTopLevelNamedComponent(nameAttribute);
                referencedFlow.orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"flow-ref at %s:%s is pointing to %s which does not exist", (Object[])new Object[]{componentModel.getConfigFileName().orElse("unknown"), componentModel.getLineNumber().orElse(-1), nameAttribute})));
            }
        });
    }

    private void validateParameterAndChildForSameAttributeAreNotDefinedTogether() {
        this.executeOnEveryMuleComponentTree(componentModel -> {
            for (String parameterName : componentModel.getParameters().keySet()) {
                if (componentModel.isParameterValueProvidedBySchema(parameterName)) continue;
                String mapChildName = NameUtils.hyphenize((String)NameUtils.pluralize((String)parameterName));
                String listOrPojoChildName = NameUtils.hyphenize((String)parameterName);
                Optional<ComponentModel> childOptional = this.findRelatedChildForParameter(componentModel.getInnerComponents(), mapChildName, listOrPojoChildName);
                if (!childOptional.isPresent()) continue;
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Component %s has a child element %s which is used for the same purpose of the configuration parameter %s. Only one must be used.", componentModel.getIdentifier(), childOptional.get().getIdentifier(), parameterName)));
            }
        });
    }

    private Optional<ComponentModel> findRelatedChildForParameter(List<ComponentModel> chilrenComponents, String ... possibleNames) {
        HashSet<String> possibleNamesSet = new HashSet<String>(Arrays.asList(possibleNames));
        for (ComponentModel childrenComponent : chilrenComponents) {
            if (!possibleNamesSet.contains(childrenComponent.getIdentifier().getName())) continue;
            return Optional.of(childrenComponent);
        }
        return Optional.empty();
    }

    private void validateSingletonsAreNotRepeated() {
        HashMap existingObjectsWithName = new HashMap();
        this.executeOnEveryRootElementWithBuildingDefinition((componentModel, componentBuildingDefinition) -> {
            if (componentBuildingDefinition.getRegistrationName() != null) {
                String nameAttributeValue = componentModel.getNameAttribute();
                if (existingObjectsWithName.containsKey(nameAttributeValue)) {
                    ComponentModel otherComponentModel = (ComponentModel)existingObjectsWithName.get(nameAttributeValue);
                    if (componentModel.getConfigFileName().isPresent() && componentModel.getLineNumber().isPresent() && otherComponentModel.getConfigFileName().isPresent() && otherComponentModel.getLineNumber().isPresent()) {
                        throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"The configuration element [%s] can only appear once, but was present in both [%s:%d] and [%s:%d]", (Object[])new Object[]{componentModel.getIdentifier(), otherComponentModel.getConfigFileName().get(), otherComponentModel.getLineNumber().get(), componentModel.getConfigFileName().get(), componentModel.getLineNumber().get()}));
                    }
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"The configuration element [%s] can only appear once, but was present multiple times", (Object[])new Object[]{componentModel.getIdentifier()}));
                }
                existingObjectsWithName.put(nameAttributeValue, componentModel);
                componentModel.setParameter(NAME_ATTRIBUTE, componentBuildingDefinition.getRegistrationName());
            }
        });
    }

    private void validateNameIsNotRepeated() {
        HashMap existingObjectsWithName = new HashMap();
        this.executeOnEveryRootElement(componentModel -> {
            String nameAttributeValue = componentModel.getNameAttribute();
            if (nameAttributeValue != null && !ignoredNameValidationComponentList.contains((Object)componentModel.getIdentifier())) {
                if (existingObjectsWithName.containsKey(nameAttributeValue)) {
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Two configuration elements have been defined with the same global name. Global name [%s] must be unique. Clashing components are %s and %s", (Object[])new Object[]{nameAttributeValue, ((ComponentModel)existingObjectsWithName.get(nameAttributeValue)).getIdentifier(), componentModel.getIdentifier()}));
                }
                existingObjectsWithName.put(nameAttributeValue, componentModel);
            }
        });
    }

    private void validateNameHasValidCharacters() {
        this.executeOnEveryRootElement(componentModel -> {
            String nameAttributeValue = componentModel.getNameAttribute();
            if (nameAttributeValue != null) {
                try {
                    NameValidationUtil.verifyStringDoesNotContainsReservedCharacters((String)nameAttributeValue);
                }
                catch (IllegalArgumentException e) {
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Invalid global element name '%s' in %s:%s. Problem is: %s", nameAttributeValue, componentModel.getConfigFileName().orElse("unknown"), componentModel.getLineNumber().orElse(-1), e.getMessage())));
                }
            }
        });
    }

    private boolean isMuleConfigurationFile() {
        ComponentIdentifier rootIdentifier = this.muleComponentModels.get(0).getIdentifier();
        return rootIdentifier.equals(CoreDslConstants.MULE_IDENTIFIER) || rootIdentifier.equals(CoreDslConstants.MULE_DOMAIN_IDENTIFIER) || rootIdentifier.equals(CoreDslConstants.MULE_EE_DOMAIN_IDENTIFIER);
    }

    private void validateErrorMappings() {
        this.executeOnEveryComponentTree(componentModel -> {
            List errorMappings = componentModel.getInnerComponents().stream().filter(c -> c.getIdentifier().equals(ERROR_MAPPING_IDENTIFIER)).collect(Collectors.toList());
            if (!errorMappings.isEmpty()) {
                List anyMappings = errorMappings.stream().filter(this::isErrorMappingWithSourceAny).collect(Collectors.toList());
                if (anyMappings.size() > 1) {
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Only one mapping for 'ANY' or an empty source type is allowed."));
                }
                if (anyMappings.size() == 1 && !this.isErrorMappingWithSourceAny((ComponentModel)errorMappings.get(errorMappings.size() - 1))) {
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Only the last error mapping can have 'ANY' or an empty source type."));
                }
                List sources = errorMappings.stream().map(model -> model.getParameters().get("sourceType")).collect(Collectors.toList());
                List distinctSources = sources.stream().distinct().collect(Collectors.toList());
                if (sources.size() != distinctSources.size()) {
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Repeated source types are not allowed. Offending types are '%s'.", Joiner.on((String)"', '").join((Iterable)CollectionUtils.disjunction(sources, distinctSources)))));
                }
            }
        });
    }

    private boolean isErrorMappingWithSourceAny(ComponentModel model) {
        String sourceType = model.getParameters().get("sourceType");
        return sourceType == null || sourceType.equals("ANY");
    }

    private void validateErrorHandlerStructure() {
        this.executeOnEveryMuleComponentTree(component -> {
            if (component.getIdentifier().equals(CoreDslConstants.ERROR_HANDLER_IDENTIFIER)) {
                this.validateRefOrOnErrorsExclusiveness((ComponentModel)component);
                this.validateOnErrorsHaveTypeOrWhenAttribute((ComponentModel)component);
                this.validateNoMoreThanOneOnErrorPropagateWithRedelivery((ComponentModel)component);
            }
        });
    }

    private void validateRefOrOnErrorsExclusiveness(ComponentModel component) {
        if (component.getParameters().get(REFERENCE_ATTRIBUTE) != null && !component.getInnerComponents().isEmpty()) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"A reference error-handler cannot have on-errors."));
        }
    }

    private void validateNoMoreThanOneOnErrorPropagateWithRedelivery(ComponentModel component) {
        if (component.getInnerComponents().stream().filter(exceptionStrategyComponent -> exceptionStrategyComponent.getParameters().get(MAX_REDELIVERY_ATTEMPTS_ROLLBACK_ES_ATTRIBUTE) != null).count() > 1L) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Only one on-error-propagate within a error-handler can handle message redelivery. Remove one of the maxRedeliveryAttempts attributes"));
        }
    }

    private void validateOnErrorsHaveTypeOrWhenAttribute(ComponentModel component) {
        List<ComponentModel> innerComponents = component.getInnerComponents();
        for (int i = 0; i < innerComponents.size() - 1; ++i) {
            ComponentModel componentModel = this.getOnErrorComponentModel(innerComponents.get(i));
            Map<String, String> parameters = componentModel.getParameters();
            if (parameters.get(WHEN_CHOICE_ES_ATTRIBUTE) != null || parameters.get(TYPE_ES_ATTRIBUTE) != null) continue;
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Every handler (except for the last one) within an 'error-handler' must specify a 'when' or 'type' attribute."));
        }
    }

    private ComponentModel getOnErrorComponentModel(ComponentModel onErrorModel) {
        if (ON_ERROR_IDENTIFIER.equals(onErrorModel.getIdentifier())) {
            String sharedOnErrorName = onErrorModel.getParameters().get(REFERENCE_ATTRIBUTE);
            return this.findTopLevelNamedComponent(sharedOnErrorName).orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Could not find on-error reference named '%s'", sharedOnErrorName))));
        }
        return onErrorModel;
    }

    private void validateExceptionStrategyWhenAttributeIsOnlyPresentInsideChoice() {
        this.executeOnEveryMuleComponentTree(component -> {
            if (component.getIdentifier().getName().endsWith(EXCEPTION_STRATEGY_REFERENCE_ELEMENT) && component.getParameters().get(WHEN_CHOICE_ES_ATTRIBUTE) != null && !component.getParent().getIdentifier().getName().equals("error-handler") && !component.getParent().getIdentifier().getName().equals("mule")) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Only handlers within an error-handler can have when attribute specified"));
            }
        });
    }

    private void validateNamedTopLevelElementsHaveName(ComponentBuildingDefinitionRegistry componentBuildingDefinitionRegistry) throws ConfigurationException {
        try {
            List<ComponentModel> topLevelComponents = this.muleComponentModels.get(0).getInnerComponents();
            topLevelComponents.stream().forEach(topLevelComponent -> {
                ComponentIdentifier identifier = topLevelComponent.getIdentifier();
                componentBuildingDefinitionRegistry.getBuildingDefinition(identifier).filter(ComponentBuildingDefinition::isNamed).ifPresent(buildingDefinition -> {
                    if (StringUtils.isBlank((CharSequence)topLevelComponent.getNameAttribute())) {
                        throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Global element %s:%s does not provide a name attribute.", identifier.getNamespace(), identifier.getName())));
                    }
                });
            });
        }
        catch (Exception e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    public void executeOnEveryComponentTree(Consumer<ComponentModel> task) {
        for (ComponentModel componentModel : this.muleComponentModels) {
            this.executeOnComponentTree(componentModel, task);
        }
    }

    public void executeOnEveryMuleComponentTree(Consumer<ComponentModel> task) {
        for (ComponentModel componentModel : this.muleComponentModels) {
            this.executeOnComponentTree(componentModel, task);
        }
    }

    public void executeOnlyOnMuleRoot(Consumer<ComponentModel> task) {
        for (ComponentModel componentModel : this.muleComponentModels) {
            task.accept(componentModel);
        }
    }

    public void executeOnEveryRootElement(Consumer<ComponentModel> task) {
        for (ComponentModel muleComponentModel : this.muleComponentModels) {
            for (ComponentModel componentModel : muleComponentModel.getInnerComponents()) {
                task.accept(componentModel);
            }
        }
    }

    public void executeOnEveryFlow(Consumer<ComponentModel> task) {
        this.executeOnEveryRootElement(componentModel -> {
            if (CoreDslConstants.FLOW_IDENTIFIER.equals(componentModel.getIdentifier())) {
                task.accept((ComponentModel)componentModel);
            }
        });
    }

    private void executeOnComponentTree(ComponentModel component, Consumer<ComponentModel> task) throws MuleRuntimeException {
        task.accept(component);
        component.getInnerComponents().forEach(innerComponent -> this.executeOnComponentTree((ComponentModel)innerComponent, task));
    }

    private void validateSingleElementsExistence() {
        this.validateSingleElementExistence(MUNIT_AFTER_SUITE_IDENTIFIER);
        this.validateSingleElementExistence(MUNIT_AFTER_SUITE_IDENTIFIER);
        this.validateSingleElementExistence(MUNIT_BEFORE_TEST_IDENTIFIER);
        this.validateSingleElementExistence(MUNIT_AFTER_TEST_IDENTIFIER);
    }

    private void validateSingleElementExistence(ComponentIdentifier componentIdentifier) {
        HashMap existingComponentsPerFile = new HashMap();
        this.executeOnEveryMuleComponentTree(componentModel -> componentModel.getConfigFileName().ifPresent(configFileName -> {
            ComponentIdentifier identifier = componentModel.getIdentifier();
            if (componentIdentifier.getNamespace().equals(identifier.getNamespace()) && componentIdentifier.getName().equals(identifier.getName())) {
                if (existingComponentsPerFile.containsKey(configFileName) && ((Map)existingComponentsPerFile.get(configFileName)).containsKey(identifier)) {
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Two configuration elements %s have been defined. Element [%s] must be unique. Clashing components are %s and %s", (Object[])new Object[]{identifier.getNamespace() + ":" + identifier.getName(), identifier.getNamespace() + ":" + identifier.getName(), componentModel.getNameAttribute(), ((ComponentModel)((Map)existingComponentsPerFile.get(configFileName)).get(identifier)).getNameAttribute()}));
                }
                HashMap<ComponentIdentifier, ComponentModel> existingComponentWithName = new HashMap<ComponentIdentifier, ComponentModel>();
                existingComponentWithName.put(identifier, (ComponentModel)componentModel);
                existingComponentsPerFile.put(configFileName, existingComponentWithName);
            }
        }));
    }

    public ComponentModel getRootComponentModel() {
        return this.muleComponentModels.get(0);
    }

    public Optional<ComponentModel> findTopLevelNamedComponent(String name) {
        return Optional.ofNullable(this.namedTopLevelComponentModels.getOrDefault(name, null));
    }

    public Optional<ComponentModel> findNamedElement(String name) {
        Optional<ComponentModel> topLevelNamedComponent = this.findTopLevelNamedComponent(name);
        if (topLevelNamedComponent.isPresent()) {
            return topLevelNamedComponent;
        }
        return Optional.ofNullable(this.namedComponentModels.getOrDefault(name, null));
    }

    private void expandModules(Set<ExtensionModel> extensionModels) {
        new MacroExpansionModulesModel(this, extensionModels).expand();
    }

    public ConfigurationProperties getConfigurationProperties() {
        return this.configurationProperties;
    }

    private void resolveRegistrationNames() {
        this.executeOnEveryRootElementWithBuildingDefinition((componentModel, componentBuildingDefinition) -> {
            if (componentBuildingDefinition.getRegistrationName() != null) {
                componentModel.setParameter(NAME_ATTRIBUTE, componentBuildingDefinition.getRegistrationName());
            }
        });
    }

    private void executeOnEveryRootElementWithBuildingDefinition(BiConsumer<ComponentModel, ComponentBuildingDefinition> action) {
        if (this.componentBuildingDefinitionRegistry.isPresent()) {
            ComponentBuildingDefinitionRegistry definitionRegistry = this.componentBuildingDefinitionRegistry.get();
            this.executeOnEveryRootElement(componentModel -> {
                Optional<ComponentBuildingDefinition<?>> buildingDefinition = definitionRegistry.getBuildingDefinition(componentModel.getIdentifier());
                buildingDefinition.ifPresent(componentBuildingDefinition -> action.accept((ComponentModel)componentModel, (ComponentBuildingDefinition)componentBuildingDefinition));
            });
        }
    }
}

