/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config;

import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.StringContains;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.config.internal.ModuleDelegatingEntityResolver;
import org.mule.runtime.core.api.util.xmlsecurity.XMLSecureFactories;
import org.mule.runtime.dsl.api.xml.parser.XmlConfigurationDocumentLoader;
import org.mule.runtime.dsl.api.xml.parser.XmlGathererErrorHandler;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlConfigurationDocumentLoaderTestCase
extends AbstractMuleTestCase {
    private static final int LINE_NUMBER_ERROR = 6;
    private static final int COLUMN_NUMBER_ERROR = 12;

    @Test
    public void testWellformedXml() {
        Document document = this.getDocument("mule-config.xml");
        MatcherAssert.assertThat((Object)document, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)document.getDocumentElement().getNodeName(), (Matcher)Matchers.is((Object)"mule"));
        MatcherAssert.assertThat((Object)document.getDocumentElement().getChildNodes().getLength(), (Matcher)Matchers.is((Object)3));
        MatcherAssert.assertThat((Object)document.getDocumentElement().getChildNodes().item(1).getNodeName(), (Matcher)Matchers.is((Object)"flow"));
        MatcherAssert.assertThat((Object)document.getDocumentElement().getChildNodes().item(1).getAttributes().getNamedItem("name").getNodeValue(), (Matcher)Matchers.is((Object)"service"));
    }

    @Test
    public void testMalformedXmlWithWrongMuleSchemaLocationAndNoExtensionsRaisesException() {
        try {
            this.getDocument("mule-wrong-mule-schema-location.xml");
            Assert.fail((String)"Should not have reached this point as the document is malformed and an exception should have been thrown using the default constructor");
        }
        catch (MuleRuntimeException e) {
            MatcherAssert.assertThat((Object)this.getStackTrace((Exception)((Object)e)), (Matcher)StringContains.containsString((String)"Cannot find the declaration of element 'mule'"));
        }
    }

    @Test
    public void testMalformedXmlWithWrongSchemaLocationAndNoExtensionsRaisesException() {
        try {
            this.getDocument("mule-wrong-schema-location.xml");
            Assert.fail((String)"Should not have reached this point as the document is malformed and an exception should have been thrown using the default constructor");
        }
        catch (MuleRuntimeException e) {
            MatcherAssert.assertThat((Object)this.getStackTrace((Exception)((Object)e)), (Matcher)Matchers.anyOf((Matcher)StringContains.containsString((String)"Invalid content was found starting with element 'ext:whatever'"), (Matcher)StringContains.containsString((String)"Error loading: mule-wrong-schema-location.xml, Can't resolve http://www.mulesoft.org/schema/mule/core/current/ext.xsd")));
        }
    }

    @Test
    public void testMalformedXmlDefaultConstructor() throws XPathExpressionException {
        try {
            this.getDocument("mule-config-malformed.xml");
            Assert.fail((String)"Should not have reached this point as the document is malformed and an exception should have been thrown using the default constructor");
        }
        catch (MuleRuntimeException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)StringContains.containsString((String)"lineNumber: 6; columnNumber: 12"));
        }
    }

    @Test
    public void testMalformedXmlCustomGatherer() throws XPathExpressionException {
        XmlGathererErrorHandlerTest xmlGathererErrorHandlerTest = new XmlGathererErrorHandlerTest();
        XmlConfigurationDocumentLoader xmlConfigurationDocumentLoader = XmlConfigurationDocumentLoader.schemaValidatingDocumentLoader(() -> xmlGathererErrorHandlerTest);
        Document document = this.getDocument("mule-config-malformed.xml", xmlConfigurationDocumentLoader);
        MatcherAssert.assertThat((Object)document, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)document.getDocumentElement().getNodeName(), (Matcher)Matchers.is((Object)"mule"));
        MatcherAssert.assertThat((Object)document.getDocumentElement().getChildNodes().getLength(), (Matcher)Matchers.is((Object)3));
        Node flow = document.getDocumentElement().getChildNodes().item(1);
        MatcherAssert.assertThat((Object)flow.getNodeName(), (Matcher)Matchers.is((Object)"flow"));
        MatcherAssert.assertThat((Object)flow.getAttributes().getNamedItem("name").getNodeValue(), (Matcher)Matchers.is((Object)"missing-inner-element"));
        MatcherAssert.assertThat((Object)xmlGathererErrorHandlerTest.errors.size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((SAXParseException)xmlGathererErrorHandlerTest.errors.get(0)).getColumnNumber(), (Matcher)Matchers.is((Object)12));
        MatcherAssert.assertThat((Object)((SAXParseException)xmlGathererErrorHandlerTest.errors.get(0)).getLineNumber(), (Matcher)Matchers.is((Object)6));
    }

    private String getStackTrace(Exception e) {
        StringWriter errors = new StringWriter();
        e.printStackTrace(new PrintWriter(errors));
        return errors.toString();
    }

    private Document getDocument(String filename) {
        XmlConfigurationDocumentLoader xmlConfigurationDocumentLoader = XmlConfigurationDocumentLoader.schemaValidatingDocumentLoader();
        return this.getDocument(filename, xmlConfigurationDocumentLoader);
    }

    private Document getDocument(String filename, XmlConfigurationDocumentLoader xmlConfigurationDocumentLoader) {
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(filename);
        return xmlConfigurationDocumentLoader.loadDocument(() -> XMLSecureFactories.createDefault().getSAXParserFactory(), filename, inputStream, (EntityResolver)new ModuleDelegatingEntityResolver(Collections.emptySet()));
    }

    private class XmlGathererErrorHandlerTest
    implements XmlGathererErrorHandler {
        private final List<SAXParseException> errors = new ArrayList<SAXParseException>();

        private XmlGathererErrorHandlerTest() {
        }

        public void warning(SAXParseException exception) throws SAXException {
            throw new UnsupportedOperationException("Current tests only work with ERRORs (found a warning)");
        }

        public void error(SAXParseException exception) throws SAXException {
            this.errors.add(exception);
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            throw new UnsupportedOperationException("Current tests only work with ERRORs (found a fatal)");
        }

        public List<SAXParseException> getErrors() {
            return Collections.emptyList();
        }
    }
}

