/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.dsl.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.junit.Before;
import org.mockito.Answers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.type.TypeCatalog;
import org.mule.runtime.api.util.ExtensionModelTestUtils;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.dsl.xml.TypeDsl;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.property.RequiredForMetadataModelProperty;
import org.mule.runtime.extension.api.property.TypeResolversInformationModelProperty;
import org.mule.tck.junit4.AbstractMuleTestCase;

public abstract class AbstractDslModelTestCase
extends AbstractMuleTestCase {
    protected static final String NAMESPACE = "mockns";
    protected static final String NAMESPACE_URI = "http://www.mulesoft.org/schema/mule/mockns";
    protected static final String SCHEMA_LOCATION = "http://www.mulesoft.org/schema/mule/mockns/current/mule-mockns.xsd";
    protected static final String CONTENT_NAME = "myCamelCaseName";
    protected static final String BEHAVIOUR_NAME = "otherName";
    protected static final String LIST_NAME = "listName";
    protected static final String EXTENSION_NAME = "extension";
    protected static final String OPERATION_NAME = "mockOperation";
    protected static final String SOURCE_NAME = "source";
    protected static final String CONFIGURATION_NAME = "configuration";
    protected static final String CONNECTION_PROVIDER_NAME = "connection";
    protected static final BaseTypeBuilder TYPE_BUILDER = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA);
    protected static final String BEHAVIOUR_VALUE = "additional";
    protected static final String CONTENT_VALUE = "#[{field: value}]";
    protected static final String ITEM_VALUE = "itemValue";
    protected static final String ITEM_NAME = "list-name-item";
    protected static final String ANOTHER_OPERATION_NAME = "anotherMockOperation";
    protected static final String ANOTHER_CONTENT_NAME = "anotherMyCamelCaseName";
    @Mock(lenient=true)
    protected ExtensionModel mockExtension;
    @Mock(lenient=true)
    protected ConfigurationModel configuration;
    @Mock(lenient=true)
    protected OperationModel operation;
    @Mock(lenient=true)
    protected OperationModel anotherOperation;
    @Mock(lenient=true)
    protected ConnectionProviderModel connectionProvider;
    @Mock(lenient=true)
    protected ParameterModel contentParameter;
    @Mock(lenient=true)
    protected ParameterModel anotherContentParameter;
    @Mock(lenient=true)
    protected ParameterModel nameParameter;
    @Mock(lenient=true)
    protected ParameterModel behaviourParameter;
    @Mock(lenient=true)
    protected ParameterModel listParameter;
    @Mock(lenient=true)
    protected ParameterGroupModel parameterGroupModel;
    @Mock(lenient=true)
    protected ParameterGroupModel anotherParameterGroupModel;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS, lenient=true)
    protected SourceModel source;
    @Mock(lenient=true)
    protected DslResolvingContext dslContext;
    @Mock(lenient=true)
    protected TypeCatalog typeCatalog;
    protected ObjectType complexType;
    protected ClassTypeLoader TYPE_LOADER = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
    protected List<ParameterModel> defaultGroupParameterModels;
    protected List<ParameterModel> anotherDefaultGroupParameterModels;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)((Object)this));
        this.initializeExtensionMock(this.mockExtension);
        Mockito.when((Object)this.nameParameter.getName()).thenReturn((Object)"name");
        Mockito.when((Object)this.nameParameter.getExpressionSupport()).thenReturn((Object)ExpressionSupport.NOT_SUPPORTED);
        Mockito.when((Object)this.nameParameter.getModelProperty((Class)ArgumentMatchers.any())).thenReturn(Optional.empty());
        Mockito.when((Object)this.nameParameter.getDslConfiguration()).thenReturn((Object)ParameterDslConfiguration.getDefaultInstance());
        Mockito.when((Object)this.nameParameter.getLayoutModel()).thenReturn(Optional.empty());
        Mockito.when((Object)this.nameParameter.getRole()).thenReturn((Object)ParameterRole.BEHAVIOUR);
        Mockito.when((Object)this.nameParameter.getType()).thenReturn((Object)this.TYPE_LOADER.load(String.class));
        Mockito.when((Object)this.nameParameter.isComponentId()).thenReturn((Object)true);
        Mockito.when((Object)this.behaviourParameter.getName()).thenReturn((Object)BEHAVIOUR_NAME);
        Mockito.when((Object)this.behaviourParameter.getExpressionSupport()).thenReturn((Object)ExpressionSupport.NOT_SUPPORTED);
        Mockito.when((Object)this.behaviourParameter.getModelProperty((Class)ArgumentMatchers.any())).thenReturn(Optional.empty());
        Mockito.when((Object)this.behaviourParameter.getDslConfiguration()).thenReturn((Object)ParameterDslConfiguration.getDefaultInstance());
        Mockito.when((Object)this.behaviourParameter.getLayoutModel()).thenReturn(Optional.empty());
        Mockito.when((Object)this.behaviourParameter.getRole()).thenReturn((Object)ParameterRole.BEHAVIOUR);
        Mockito.when((Object)this.behaviourParameter.getType()).thenReturn((Object)this.TYPE_LOADER.load(String.class));
        Mockito.when((Object)this.listParameter.getName()).thenReturn((Object)LIST_NAME);
        Mockito.when((Object)this.listParameter.getExpressionSupport()).thenReturn((Object)ExpressionSupport.NOT_SUPPORTED);
        Mockito.when((Object)this.listParameter.getModelProperty((Class)ArgumentMatchers.any())).thenReturn(Optional.empty());
        Mockito.when((Object)this.listParameter.getDslConfiguration()).thenReturn((Object)ParameterDslConfiguration.getDefaultInstance());
        Mockito.when((Object)this.listParameter.getLayoutModel()).thenReturn(Optional.empty());
        Mockito.when((Object)this.listParameter.getRole()).thenReturn((Object)ParameterRole.BEHAVIOUR);
        Mockito.when((Object)this.listParameter.getType()).thenReturn((Object)TYPE_BUILDER.arrayType().of(this.TYPE_LOADER.load(String.class)).build());
        Mockito.when((Object)this.contentParameter.getName()).thenReturn((Object)CONTENT_NAME);
        Mockito.when((Object)this.contentParameter.getExpressionSupport()).thenReturn((Object)ExpressionSupport.SUPPORTED);
        Mockito.when((Object)this.contentParameter.getModelProperty((Class)ArgumentMatchers.any())).thenReturn(Optional.empty());
        Mockito.when((Object)this.contentParameter.getDslConfiguration()).thenReturn((Object)ParameterDslConfiguration.getDefaultInstance());
        Mockito.when((Object)this.contentParameter.getLayoutModel()).thenReturn(Optional.empty());
        Mockito.when((Object)this.contentParameter.getRole()).thenReturn((Object)ParameterRole.CONTENT);
        Mockito.when((Object)this.anotherContentParameter.getName()).thenReturn((Object)ANOTHER_CONTENT_NAME);
        Mockito.when((Object)this.anotherContentParameter.getExpressionSupport()).thenReturn((Object)ExpressionSupport.SUPPORTED);
        Mockito.when((Object)this.anotherContentParameter.getModelProperty((Class)ArgumentMatchers.any())).thenReturn(Optional.empty());
        Mockito.when((Object)this.anotherContentParameter.getDslConfiguration()).thenReturn((Object)ParameterDslConfiguration.getDefaultInstance());
        Mockito.when((Object)this.anotherContentParameter.getLayoutModel()).thenReturn(Optional.empty());
        Mockito.when((Object)this.anotherContentParameter.getRole()).thenReturn((Object)ParameterRole.CONTENT);
        ObjectTypeBuilder type = TYPE_BUILDER.objectType();
        type.addField().key("field").value(this.TYPE_LOADER.load(String.class)).build();
        Mockito.when((Object)this.contentParameter.getType()).thenReturn((Object)type.build());
        Mockito.when((Object)this.anotherContentParameter.getType()).thenReturn((Object)type.build());
        this.defaultGroupParameterModels = Arrays.asList(this.nameParameter, this.contentParameter, this.behaviourParameter, this.listParameter);
        Mockito.when((Object)this.parameterGroupModel.getName()).thenReturn((Object)"General");
        Mockito.when((Object)this.parameterGroupModel.isShowInDsl()).thenReturn((Object)false);
        Mockito.when((Object)this.parameterGroupModel.getParameterModels()).thenReturn(this.defaultGroupParameterModels);
        Mockito.when((Object)this.parameterGroupModel.getParameter(ArgumentMatchers.anyString())).then(invocation -> {
            String paramName;
            switch (paramName = (String)invocation.getArgument(0)) {
                case "myCamelCaseName": {
                    return Optional.of(this.contentParameter);
                }
                case "listName": {
                    return Optional.of(this.listParameter);
                }
                case "otherName": {
                    return Optional.of(this.behaviourParameter);
                }
            }
            return Optional.empty();
        });
        this.anotherDefaultGroupParameterModels = Arrays.asList(this.anotherContentParameter, this.listParameter);
        Mockito.when((Object)this.anotherParameterGroupModel.getName()).thenReturn((Object)"General");
        Mockito.when((Object)this.anotherParameterGroupModel.isShowInDsl()).thenReturn((Object)false);
        Mockito.when((Object)this.anotherParameterGroupModel.getParameterModels()).thenReturn(this.anotherDefaultGroupParameterModels);
        Mockito.when((Object)this.anotherParameterGroupModel.getParameter(ArgumentMatchers.anyString())).then(invocation -> {
            String paramName;
            switch (paramName = (String)invocation.getArgument(0)) {
                case "anotherMyCamelCaseName": {
                    return Optional.of(this.anotherContentParameter);
                }
                case "listName": {
                    return Optional.of(this.listParameter);
                }
            }
            return Optional.empty();
        });
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add(BEHAVIOUR_NAME);
        RequiredForMetadataModelProperty requiredForMetadataModelProperty = new RequiredForMetadataModelProperty(parameters);
        Mockito.when((Object)this.connectionProvider.getName()).thenReturn((Object)CONNECTION_PROVIDER_NAME);
        Mockito.when((Object)this.connectionProvider.getParameterGroupModels()).thenReturn(Arrays.asList(this.parameterGroupModel));
        Mockito.when((Object)this.configuration.getName()).thenReturn((Object)CONFIGURATION_NAME);
        Mockito.when((Object)this.configuration.getParameterGroupModels()).thenReturn(Arrays.asList(this.parameterGroupModel));
        Mockito.when((Object)this.configuration.getOperationModels()).thenReturn(Arrays.asList(this.operation));
        Mockito.when((Object)this.configuration.getSourceModels()).thenReturn(Arrays.asList(this.source));
        Mockito.when((Object)this.configuration.getConnectionProviders()).thenReturn(Arrays.asList(this.connectionProvider));
        Mockito.when((Object)this.configuration.getModelProperty(RequiredForMetadataModelProperty.class)).thenReturn(Optional.of(requiredForMetadataModelProperty));
        Mockito.when((Object)this.connectionProvider.getModelProperty(RequiredForMetadataModelProperty.class)).thenReturn(Optional.of(requiredForMetadataModelProperty));
        Mockito.when((Object)this.source.getName()).thenReturn((Object)SOURCE_NAME);
        Mockito.when((Object)this.source.getParameterGroupModels()).thenReturn(Arrays.asList(this.parameterGroupModel));
        Mockito.when((Object)this.source.getSuccessCallback()).thenReturn(Optional.empty());
        Mockito.when((Object)this.source.getErrorCallback()).thenReturn(Optional.empty());
        Mockito.when((Object)this.operation.getName()).thenReturn((Object)OPERATION_NAME);
        Mockito.when((Object)this.operation.getParameterGroupModels()).thenReturn(Arrays.asList(this.parameterGroupModel));
        Mockito.when((Object)this.anotherOperation.getName()).thenReturn((Object)ANOTHER_OPERATION_NAME);
        Mockito.when((Object)this.anotherOperation.getParameterGroupModels()).thenReturn(Arrays.asList(this.anotherParameterGroupModel));
        ExtensionModelTestUtils.visitableMock((ComponentModel[])new ComponentModel[]{this.operation, this.source, this.anotherOperation});
        HashMap<String, String> parameterResolversNames = new HashMap<String, String>();
        parameterResolversNames.put(LIST_NAME, LIST_NAME);
        parameterResolversNames.put(CONTENT_NAME, CONTENT_NAME);
        this.mockTypeResolversInformationModelProperty((EnrichableModel)this.operation, "category", "outputResolverName", "attributesResolverName", parameterResolversNames);
        this.mockTypeResolversInformationModelProperty((EnrichableModel)this.source, "category", "outputResolverName", "attributesResolverName", parameterResolversNames);
        HashMap<String, String> anotherParameterResolversNames = new HashMap<String, String>();
        anotherParameterResolversNames.put(LIST_NAME, LIST_NAME);
        anotherParameterResolversNames.put(ANOTHER_CONTENT_NAME, ANOTHER_CONTENT_NAME);
        this.mockTypeResolversInformationModelProperty((EnrichableModel)this.anotherOperation, "category", "outputResolverName", "attributesResolverName", anotherParameterResolversNames);
        Mockito.when((Object)this.typeCatalog.getSubTypes((ObjectType)ArgumentMatchers.any())).thenReturn(Collections.emptySet());
        Mockito.when((Object)this.typeCatalog.getSuperTypes((ObjectType)ArgumentMatchers.any())).thenReturn(Collections.emptySet());
        Mockito.when((Object)this.typeCatalog.getAllBaseTypes()).thenReturn(Collections.emptySet());
        Mockito.when((Object)this.typeCatalog.getAllSubTypes()).thenReturn(Collections.emptySet());
        Mockito.when((Object)this.typeCatalog.getTypes()).thenReturn(Collections.emptySet());
        this.complexType = (ObjectType)this.TYPE_LOADER.load(ComplexTypePojo.class);
        Mockito.when((Object)this.typeCatalog.getType((String)ArgumentMatchers.any())).thenReturn(Optional.of(this.complexType));
        Mockito.when((Object)this.typeCatalog.containsBaseType((ObjectType)ArgumentMatchers.any())).thenReturn((Object)false);
        Mockito.when((Object)this.dslContext.getExtension((String)ArgumentMatchers.any())).thenReturn(Optional.of(this.mockExtension));
        Mockito.when((Object)this.dslContext.getExtensions()).thenReturn(Collections.singleton(this.mockExtension));
        Mockito.when((Object)this.dslContext.getTypeCatalog()).thenReturn((Object)this.typeCatalog);
        Stream.of(this.configuration, this.operation, this.connectionProvider, this.source).forEach(model -> Mockito.when((Object)model.getAllParameterModels()).thenReturn(this.defaultGroupParameterModels));
        Mockito.when((Object)this.anotherOperation.getAllParameterModels()).thenReturn(this.anotherDefaultGroupParameterModels);
    }

    protected void initializeExtensionMock(ExtensionModel extension) {
        Mockito.when((Object)extension.getName()).thenReturn((Object)EXTENSION_NAME);
        Mockito.when((Object)extension.getXmlDslModel()).thenReturn((Object)XmlDslModel.builder().setXsdFileName("mule-mockns.xsd").setPrefix(NAMESPACE).setNamespace(NAMESPACE_URI).setSchemaLocation(SCHEMA_LOCATION).setSchemaVersion("4.0").build());
        Mockito.when((Object)extension.getSubTypes()).thenReturn(Collections.emptySet());
        Mockito.when((Object)extension.getImportedTypes()).thenReturn(Collections.emptySet());
        Mockito.when((Object)extension.getXmlDslModel()).thenReturn((Object)XmlDslModel.builder().setXsdFileName("").setPrefix(NAMESPACE).setNamespace(NAMESPACE_URI).setSchemaLocation(SCHEMA_LOCATION).setSchemaVersion("").build());
        Mockito.when((Object)extension.getConfigurationModels()).thenReturn(Arrays.asList(this.configuration));
        Mockito.when((Object)extension.getConfigurationModel(ArgumentMatchers.anyString())).thenReturn(Optional.of(this.configuration));
        Mockito.when((Object)extension.getOperationModels()).thenReturn(Arrays.asList(this.operation, this.anotherOperation));
        Mockito.when((Object)extension.getOperationModel(ArgumentMatchers.anyString())).then(invocation -> {
            String operationName;
            switch (operationName = (String)invocation.getArgument(0)) {
                case "mockOperation": {
                    return Optional.of(this.operation);
                }
                case "anotherMockOperation": {
                    return Optional.of(this.anotherOperation);
                }
            }
            return Optional.empty();
        });
        Mockito.when((Object)extension.getSourceModels()).thenReturn(Arrays.asList(this.source));
        Mockito.when((Object)extension.getSourceModel(ArgumentMatchers.anyString())).thenReturn(Optional.of(this.source));
        Mockito.when((Object)extension.getConnectionProviders()).thenReturn(Arrays.asList(this.connectionProvider));
        Mockito.when((Object)extension.getConnectionProviderModel(ArgumentMatchers.anyString())).thenReturn(Optional.of(this.connectionProvider));
    }

    protected void removeTypeResolversInformationModelPropertyfromMock(EnrichableModel model) {
        Mockito.when((Object)model.getModelProperty(TypeResolversInformationModelProperty.class)).thenReturn(Optional.empty());
    }

    protected void mockTypeResolversInformationModelPropertyWithOutputType(EnrichableModel model, String category, String outputResolverName) {
        this.mockTypeResolversInformationModelProperty(model, category, outputResolverName, null, null, null);
    }

    protected void mockTypeResolversInformationModelPropertyWithAttributeType(EnrichableModel model, String category, String attributesResolverName) {
        this.mockTypeResolversInformationModelProperty(model, category, null, attributesResolverName, null, null);
    }

    protected void mockTypeResolversInformationModelPropertyWithInputTypes(EnrichableModel model, String category, Map<String, String> parameterResolversNames) {
        this.mockTypeResolversInformationModelProperty(model, category, null, null, parameterResolversNames, null);
    }

    protected void mockTypeResolversInformationModelProperty(EnrichableModel model, String category, String outputResolverName, String attributesResolverName, Map<String, String> parameterResolversNames) {
        this.mockTypeResolversInformationModelProperty(model, category, outputResolverName, attributesResolverName, parameterResolversNames, null);
    }

    protected void mockTypeResolversInformationModelProperty(EnrichableModel model, String category, String outputResolverName, String attributesResolverName, Map<String, String> parameterResolversNames, String keysResolverName) {
        Mockito.when((Object)model.getModelProperty(TypeResolversInformationModelProperty.class)).thenReturn(Optional.of(new TypeResolversInformationModelProperty(category, parameterResolversNames, outputResolverName, attributesResolverName, keysResolverName, false, false)));
    }

    @TypeDsl(allowTopLevelDefinition=true)
    @Alias(value="complexType")
    public static class ComplexTypePojo {
        @Parameter
        private String otherName;
        @Parameter
        @Content
        private String myCamelCaseName;
        @Parameter
        private List<Integer> numbers;

        public List<Integer> getNumbers() {
            return this.numbers;
        }

        public String getOtherName() {
            return this.otherName;
        }

        public void setOtherName(String otherName) {
            this.otherName = otherName;
        }

        public String getMyCamelCaseName() {
            return this.myCamelCaseName;
        }

        public void setMyCamelCaseName(String myCamelCaseName) {
            this.myCamelCaseName = myCamelCaseName;
        }
    }
}

