/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.dsl.model;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsNull;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.app.declaration.api.ConnectionElementDeclaration;
import org.mule.runtime.app.declaration.api.GlobalElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterGroupElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterValue;
import org.mule.runtime.app.declaration.api.fluent.ConfigurationElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ConnectionElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ElementDeclarer;
import org.mule.runtime.config.api.dsl.processor.ArtifactConfig;
import org.mule.runtime.config.dsl.model.AbstractDslModelTestCase;
import org.mule.runtime.config.internal.model.ApplicationModel;
import org.mule.runtime.config.internal.model.ComponentModel;
import org.mule.runtime.core.api.extension.MuleExtensionModelProvider;

public class ComponentLocationTestCase
extends AbstractDslModelTestCase {
    private static final String CONFIG_NAME = "myConfig";
    private ElementDeclarer declarer;
    private Set<ExtensionModel> extensions;

    @Before
    public void setUp() {
        this.declarer = ElementDeclarer.forExtension((String)"extension");
        this.extensions = ImmutableSet.builder().add((Object)MuleExtensionModelProvider.getExtensionModel()).add((Object)this.mockExtension).build();
    }

    @Test
    public void validateConnectionLocation() throws Exception {
        ApplicationModel applicationModel = this.loadApplicationModel(this.buildAppDeclaration());
        ComponentModel root = applicationModel.getRootComponentModel();
        MatcherAssert.assertThat((Object)root.getComponentLocation(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        ComponentModel config = (ComponentModel)root.getInnerComponents().get(0);
        MatcherAssert.assertThat((Object)config.getModel(ConfigurationModel.class), (Matcher)Is.is((Matcher)IsNot.not(Optional.empty())));
        MatcherAssert.assertThat((Object)config.getComponentLocation().getLocation(), (Matcher)IsEqual.equalTo((Object)CONFIG_NAME));
        ComponentModel connection = (ComponentModel)config.getInnerComponents().get(0);
        MatcherAssert.assertThat((Object)connection.getModel(ConnectionProviderModel.class), (Matcher)Is.is((Matcher)IsNot.not(Optional.empty())));
        MatcherAssert.assertThat((Object)connection.getComponentLocation().getLocation(), (Matcher)IsEqual.equalTo((Object)"myConfig/connection"));
    }

    protected ApplicationModel loadApplicationModel(ArtifactDeclaration declaration) throws Exception {
        return new ApplicationModel(new ArtifactConfig.Builder().build(), declaration, this.extensions, Collections.emptyMap(), Optional.empty(), Optional.empty(), uri -> ((Object)((Object)this)).getClass().getResourceAsStream(uri), this.getFeatureFlaggingService());
    }

    private ArtifactDeclaration buildAppDeclaration() {
        return (ArtifactDeclaration)ElementDeclarer.newArtifact().withGlobalElement((GlobalElementDeclaration)((ConfigurationElementDeclarer)this.declarer.newConfiguration("configuration").withRefName(CONFIG_NAME).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("myCamelCaseName", "#[{field: value}]").withParameter("otherName", "additional").withParameter("listName", (ParameterValue)ElementDeclarer.newListValue().withValue("itemValue").build()).getDeclaration())).withConnection((ConnectionElementDeclaration)((ConnectionElementDeclarer)this.declarer.newConnection("connection").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("myCamelCaseName", "#[{field: value}]").withParameter("otherName", "additional").withParameter("listName", (ParameterValue)ElementDeclarer.newListValue().withValue("itemValue").build()).getDeclaration())).getDeclaration()).getDeclaration()).getDeclaration();
    }
}

