/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.dsl.spring;

import java.lang.reflect.InvocationTargetException;
import java.net.URLClassLoader;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.runtime.config.internal.dsl.spring.ObjectFactoryClassRepository;
import org.mule.runtime.core.internal.util.CompositeClassLoader;
import org.mule.runtime.dsl.api.component.AbstractComponentFactory;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.runtime.dsl.api.component.ObjectFactory;
import org.springframework.beans.factory.SmartFactoryBean;

@RunWith(value=MockitoJUnitRunner.class)
public class ObjectFactoryClassRepositoryTestCase {
    @Test
    public void cacheEnableForCGLib() throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        ComponentBuildingDefinition componentBuildingDefinition = (ComponentBuildingDefinition)Mockito.mock(ComponentBuildingDefinition.class);
        Class<ObjectFactory> objectFactoryClass = this.getObjectFactoryClass(componentBuildingDefinition, FakeObjectConnectionProviderObjectFactory.class);
        ObjectFactory objectFactory = objectFactoryClass.newInstance();
        Assert.assertThat((Object)((SmartFactoryBean)objectFactory).isSingleton(), (Matcher)Is.is((Object)true));
        Class<?> firstProxyGenerated = objectFactory.getClass();
        objectFactoryClass = this.getObjectFactoryClass(componentBuildingDefinition, FakeObjectConnectionProviderObjectFactory.class);
        objectFactory = objectFactoryClass.newInstance();
        Assert.assertThat((Object)((SmartFactoryBean)objectFactory).isSingleton(), (Matcher)Is.is((Object)true));
        Assert.assertThat(firstProxyGenerated, (Matcher)CoreMatchers.sameInstance(objectFactory.getClass()));
    }

    @Test
    public void compositeClassLoadersAreCorrectlyCached() throws Exception {
        ComponentBuildingDefinition componentBuildingDefinition = (ComponentBuildingDefinition)Mockito.mock(ComponentBuildingDefinition.class);
        URLClassLoader classLoader1 = new URLClassLoader(((URLClassLoader)this.getClass().getClassLoader()).getURLs(), this.getClass().getClassLoader().getParent());
        URLClassLoader classLoader2 = new URLClassLoader(((URLClassLoader)this.getClass().getClassLoader()).getURLs(), this.getClass().getClassLoader().getParent());
        Class<?> factoryClass1 = classLoader1.loadClass(FakeObjectConnectionProviderObjectFactory.class.getName());
        Class<?> factoryClass2 = classLoader2.loadClass(FakeObjectConnectionProviderObjectFactory.class.getName());
        Class<?> otherFactoryClass1 = classLoader1.loadClass(OtherFakeObjectConnectionProviderObjectFactory.class.getName());
        Class<?> otherFactoryClass2 = classLoader2.loadClass(OtherFakeObjectConnectionProviderObjectFactory.class.getName());
        Class<ObjectFactory> enhancedFactoryClass1 = this.getObjectFactoryClass(componentBuildingDefinition, factoryClass1);
        Class<ObjectFactory> enhancedFactoryClass2 = this.getObjectFactoryClass(componentBuildingDefinition, factoryClass2);
        Class<ObjectFactory> enhancedOtherFactoryClass1 = this.getObjectFactoryClass(componentBuildingDefinition, otherFactoryClass1);
        Class<ObjectFactory> enhancedOtherFactoryClass2 = this.getObjectFactoryClass(componentBuildingDefinition, otherFactoryClass2);
        Assert.assertThat((Object)enhancedFactoryClass1.getClassLoader(), (Matcher)IsInstanceOf.instanceOf(CompositeClassLoader.class));
        Assert.assertThat((Object)enhancedFactoryClass2.getClassLoader(), (Matcher)IsInstanceOf.instanceOf(CompositeClassLoader.class));
        Assert.assertThat((Object)enhancedOtherFactoryClass1.getClassLoader(), (Matcher)IsInstanceOf.instanceOf(CompositeClassLoader.class));
        Assert.assertThat((Object)enhancedOtherFactoryClass2.getClassLoader(), (Matcher)IsInstanceOf.instanceOf(CompositeClassLoader.class));
        Assert.assertThat((Object)enhancedFactoryClass1.getClassLoader(), (Matcher)Is.is((Matcher)CoreMatchers.sameInstance((Object)enhancedOtherFactoryClass1.getClassLoader())));
        Assert.assertThat((Object)enhancedFactoryClass2.getClassLoader(), (Matcher)Is.is((Matcher)CoreMatchers.sameInstance((Object)enhancedOtherFactoryClass2.getClassLoader())));
        Assert.assertThat((Object)enhancedFactoryClass1.getClassLoader(), (Matcher)Is.is((Matcher)IsNot.not((Matcher)CoreMatchers.sameInstance((Object)enhancedFactoryClass2.getClassLoader()))));
        Assert.assertThat((Object)enhancedOtherFactoryClass1.getClassLoader(), (Matcher)Is.is((Matcher)IsNot.not((Matcher)CoreMatchers.sameInstance((Object)enhancedOtherFactoryClass2.getClassLoader()))));
    }

    public Class<ObjectFactory> getObjectFactoryClass(ComponentBuildingDefinition componentBuildingDefinition, Class factoryType) {
        ObjectFactoryClassRepository objectFactoryClassRepository = new ObjectFactoryClassRepository();
        return objectFactoryClassRepository.getObjectFactoryClass(componentBuildingDefinition, factoryType, FakeObject.class, () -> false, Optional.empty());
    }

    public static class FakeObject {
    }

    public static class OtherFakeObjectConnectionProviderObjectFactory
    extends AbstractComponentFactory {
        public Object doGetObject() throws Exception {
            return new FakeObject();
        }
    }

    public static class FakeObjectConnectionProviderObjectFactory
    extends AbstractComponentFactory {
        public Object doGetObject() throws Exception {
            return new FakeObject();
        }
    }
}

