/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Spliterator;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.config.internal.model.ComponentModel;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class ComponentAstSpliteratorTestCase
extends AbstractMuleTestCase {
    @Test
    public void singleLevel() {
        ComponentModel.Builder rootBuilder = this.baseComponentBuilder("root");
        ComponentModel child1 = this.baseComponentBuilder("1").build();
        rootBuilder.addChildComponentModel(child1);
        ComponentModel child2 = this.baseComponentBuilder("2").build();
        rootBuilder.addChildComponentModel(child2);
        ComponentModel root = rootBuilder.build();
        ArrayList visitedComponents = new ArrayList();
        ((ComponentAst)root).recursiveStream().forEach(c -> visitedComponents.add(c));
        Assert.assertThat(visitedComponents, (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.sameInstance((Object)root), Matchers.sameInstance((Object)child1), Matchers.sameInstance((Object)child2)}));
    }

    @Test
    public void twoLevels() {
        ComponentModel.Builder rootBuilder = this.baseComponentBuilder("root");
        ComponentModel.Builder child1Builder = this.baseComponentBuilder("1");
        ComponentModel child11 = this.baseComponentBuilder("11").build();
        child1Builder.addChildComponentModel(child11);
        ComponentModel child12 = this.baseComponentBuilder("12").build();
        child1Builder.addChildComponentModel(child12);
        ComponentModel child1 = child1Builder.build();
        rootBuilder.addChildComponentModel(child1);
        ComponentModel.Builder child2Builder = this.baseComponentBuilder("2");
        ComponentModel child21 = this.baseComponentBuilder("21").build();
        child2Builder.addChildComponentModel(child21);
        ComponentModel child22 = this.baseComponentBuilder("22").build();
        child2Builder.addChildComponentModel(child22);
        ComponentModel child2 = child2Builder.build();
        rootBuilder.addChildComponentModel(child2);
        ComponentModel root = rootBuilder.build();
        ArrayList visitedComponents = new ArrayList();
        ((ComponentAst)root).recursiveStream().forEach(c -> visitedComponents.add(c));
        Assert.assertThat(visitedComponents, (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.sameInstance((Object)root), Matchers.sameInstance((Object)child1), Matchers.sameInstance((Object)child11), Matchers.sameInstance((Object)child12), Matchers.sameInstance((Object)child2), Matchers.sameInstance((Object)child21), Matchers.sameInstance((Object)child22)}));
        Spliterator rootSpliterator = ((ComponentAst)root).recursiveSpliterator();
        Assert.assertThat((Object)rootSpliterator.getExactSizeIfKnown(), (Matcher)Matchers.is((Object)7L));
    }

    @Test
    public void twoLevelsDirectOnly() {
        ComponentModel.Builder rootBuilder = this.baseComponentBuilder("root");
        ComponentModel.Builder child1Builder = this.baseComponentBuilder("1");
        ComponentModel child11 = this.baseComponentBuilder("11").build();
        child1Builder.addChildComponentModel(child11);
        ComponentModel child12 = this.baseComponentBuilder("12").build();
        child1Builder.addChildComponentModel(child12);
        ComponentModel child1 = child1Builder.build();
        rootBuilder.addChildComponentModel(child1);
        ComponentModel.Builder child2Builder = this.baseComponentBuilder("2");
        ComponentModel child21 = this.baseComponentBuilder("21").build();
        child2Builder.addChildComponentModel(child21);
        ComponentModel child22 = this.baseComponentBuilder("22").build();
        child2Builder.addChildComponentModel(child22);
        ComponentModel child2 = child2Builder.build();
        rootBuilder.addChildComponentModel(child2);
        ComponentModel root = rootBuilder.build();
        ArrayList visitedComponents = new ArrayList();
        ((ComponentAst)root).directChildrenStream().forEach(c -> visitedComponents.add(c));
        Assert.assertThat(visitedComponents, (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.sameInstance((Object)child1), Matchers.sameInstance((Object)child2)}));
        Assert.assertThat(visitedComponents, (Matcher)Matchers.hasSize((int)2));
    }

    @Test
    public void twoLevelsDirectOnly2() {
        ComponentModel.Builder rootBuilder = this.baseComponentBuilder("root");
        ComponentModel.Builder child1Builder = this.baseComponentBuilder("1");
        ComponentModel child11 = this.baseComponentBuilder("11").build();
        child1Builder.addChildComponentModel(child11);
        ComponentModel.Builder child12Builder = this.baseComponentBuilder("12");
        child12Builder.addChildComponentModel(this.baseComponentBuilder("121").build());
        ComponentModel child12 = child12Builder.build();
        child1Builder.addChildComponentModel(child12);
        ComponentModel child1 = child1Builder.build();
        rootBuilder.addChildComponentModel(child1);
        ComponentModel.Builder child2Builder = this.baseComponentBuilder("2");
        ComponentModel child21 = this.baseComponentBuilder("21").build();
        child2Builder.addChildComponentModel(child21);
        ComponentModel child22 = this.baseComponentBuilder("22").build();
        child2Builder.addChildComponentModel(child22);
        ComponentModel child2 = child2Builder.build();
        rootBuilder.addChildComponentModel(child2);
        ComponentModel root = rootBuilder.build();
        ArrayList visitedComponents = new ArrayList();
        ((ComponentAst)root).directChildrenStream().forEach(c -> visitedComponents.add(c));
        Assert.assertThat(visitedComponents, (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.sameInstance((Object)child1), Matchers.sameInstance((Object)child2)}));
        Assert.assertThat(visitedComponents, (Matcher)Matchers.hasSize((int)2));
    }

    protected ComponentModel.Builder baseComponentBuilder(String name) {
        return new ComponentModel.Builder().setIdentifier(ComponentIdentifier.builder().namespace("lalala").name(name).build());
    }

    @Test
    public void fiveLevelsFiveChildrenEachDirectOnly() {
        ComponentModel.Builder rootBuilder = this.baseComponentBuilder("root");
        this.addLevel(rootBuilder, 1);
        ComponentModel root = rootBuilder.build();
        ArrayList visitedComponents = new ArrayList();
        ((ComponentAst)root).directChildrenStream().forEach(c -> visitedComponents.add(c));
        Assert.assertThat(visitedComponents, (Matcher)Matchers.hasSize((int)5));
    }

    @Test
    public void fiveLevelsFiveChildrenEachParallel() {
        ComponentModel.Builder rootBuilder = this.baseComponentBuilder("root");
        this.addLevel(rootBuilder, 1);
        ComponentModel root = rootBuilder.build();
        ArrayList visitedComponents = new ArrayList();
        HashSet visitingThreads = new HashSet();
        ((Stream)((ComponentAst)root).recursiveStream().parallel()).forEach(c -> {
            visitedComponents.add(c);
            visitingThreads.add(Thread.currentThread());
        });
        Assert.assertThat(visitedComponents, (Matcher)Matchers.hasSize((int)3906));
    }

    protected void addLevel(ComponentModel.Builder rootBuilder, int level) {
        for (int i = 0; i < 5; ++i) {
            ComponentModel.Builder childBuilder = this.baseComponentBuilder("" + level + "." + i);
            if (level < 5) {
                this.addLevel(childBuilder, level + 1);
            }
            rootBuilder.addChildComponentModel(childBuilder.build());
        }
    }
}

