/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.model.extension.xml;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.custommonkey.xmlunit.DetailedDiff;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.Difference;
import org.custommonkey.xmlunit.XMLUnit;
import org.junit.Test;
import org.mule.runtime.config.internal.ModuleDelegatingEntityResolver;
import org.mule.runtime.config.internal.dsl.model.ComponentModelReader;
import org.mule.runtime.config.internal.dsl.model.config.ConfigurationPropertiesResolver;
import org.mule.runtime.config.internal.dsl.model.extension.xml.ComponentModelReaderHelper;
import org.mule.runtime.config.internal.dsl.xml.XmlNamespaceInfoProviderSupplier;
import org.mule.runtime.config.internal.model.ComponentModel;
import org.mule.runtime.core.api.util.xmlsecurity.XMLSecureFactories;
import org.mule.runtime.dsl.api.xml.parser.ConfigLine;
import org.mule.runtime.dsl.api.xml.parser.XmlConfigurationDocumentLoader;
import org.mule.runtime.dsl.internal.xml.parser.XmlApplicationParser;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;

public class ComponentModelReaderHelperTestCase {
    @Test
    public void testSimpleApp() throws Exception {
        String applicationXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<mule xmlns=\"http://www.mulesoft.org/schema/mule/core\"\n      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n      xsi:schemaLocation=\"\n       http://www.mulesoft.org/schema/mule/core http://www.mulesoft.org/schema/mule/core/current/mule.xsd\">\n\n    <flow name=\"test\">\n        <logger category=\"SOMETHING\" level=\"WARN\" message=\"logging info\"/>\n    </flow>\n\n</mule>";
        this.compareXML(applicationXml, applicationXml);
    }

    @Test
    public void testAppWithCData() throws Exception {
        String applicationXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<mule xmlns=\"http://www.mulesoft.org/schema/mule/core\"\n      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n      xmlns:ee=\"http://www.mulesoft.org/schema/mule/ee/core\"\n      xsi:schemaLocation=\"\n       http://www.mulesoft.org/schema/mule/core http://www.mulesoft.org/schema/mule/core/current/mule.xsd\n       http://www.mulesoft.org/schema/mule/ee/core http://www.mulesoft.org/schema/mule/ee/core/current/mule-ee.xsd\">\n\n    <flow name=\"test\">\n            <ee:transform>\n                <ee:message>\n                    <ee:set-payload><![CDATA[\n                    %dw 2.0\n                    output application/json encoding='UTF-8'\n                    ---\n                    {\n                        'name' : 'Rick',\n                        'lastname' : 'Sanchez'\n                    }\n                    ]]></ee:set-payload>\n                </ee:message>\n            </ee:transform>    </flow>\n\n</mule>";
        this.compareXML(applicationXml, applicationXml);
    }

    @Test
    public void testAppWithPasswordInOperation() throws Exception {
        String format = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<mule xmlns=\"http://www.mulesoft.org/schema/mule/core\"\n      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n      xmlns:echo=\"http://www.mulesoft.org/schema/mule/module-echo\"\n      xsi:schemaLocation=\"\n       http://www.mulesoft.org/schema/mule/core http://www.mulesoft.org/schema/mule/core/current/mule.xsd\n       http://www.mulesoft.org/schema/mule/module-echo http://www.mulesoft.org/schema/mule/module-echo/current/mule-module-echo.xsd\">\n\n    <flow name=\"test\">\n        <echo:data-type value=\"#[payload]\" password=\"%s\" />\n    </flow>\n\n</mule>";
        String applicationXml = String.format(format, "THIS IS THE PASSWORD ATTRIBUTE");
        String expectedXml = String.format(format, "@@credentials@@");
        this.compareXML(applicationXml, expectedXml);
    }

    @Test
    public void testAppWithPasswordInGlobalElement() throws Exception {
        String format = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<mule xmlns=\"http://www.mulesoft.org/schema/mule/core\"\n      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n      xmlns:echo=\"http://www.mulesoft.org/schema/mule/module-echo\"\n      xsi:schemaLocation=\"\n       http://www.mulesoft.org/schema/mule/core http://www.mulesoft.org/schema/mule/core/current/mule.xsd\n       http://www.mulesoft.org/schema/mule/module-echo http://www.mulesoft.org/schema/mule/module-echo/current/mule-module-echo.xsd\">\n\n    <echo:config name=\"echoConfig\" username=\"Rick\" password=\"%s\">\n        <echo:connection anotherUsername=\"Morty\" password=\"%s\"/>\n    </echo:config>\n    <flow name=\"test\">\n        <echo:data-type config-ref=\"echoConfig\" value=\"#[payload]\"/>\n    </flow>\n</mule>";
        String applicationXml = String.format(format, "Sanchez", "Smith");
        String expectedXml = String.format(format, "@@credentials@@", "@@credentials@@");
        this.compareXML(applicationXml, expectedXml);
    }

    private void compareXML(String inputXml, String expectedXml) throws Exception {
        ComponentModel componentModel = this.getComponentModel(inputXml);
        String actualXml = ComponentModelReaderHelper.toXml((ComponentModel)componentModel);
        XMLUnit.setNormalizeWhitespace((boolean)true);
        XMLUnit.setIgnoreWhitespace((boolean)true);
        XMLUnit.setIgnoreComments((boolean)false);
        XMLUnit.setIgnoreAttributeOrder((boolean)false);
        Diff diff = XMLUnit.compareXML((String)expectedXml, (String)actualXml);
        if (!diff.similar() || !diff.identical()) {
            System.out.println(actualXml);
            DetailedDiff detDiff = new DetailedDiff(diff);
            List differences = detDiff.getAllDifferences();
            StringBuilder diffLines = new StringBuilder();
            for (Object object : differences) {
                Difference difference = (Difference)object;
                diffLines.append(difference.toString() + '\n');
            }
            throw new IllegalArgumentException("Actual XML differs from expected: \n" + diffLines.toString());
        }
    }

    private ComponentModel getComponentModel(String applicationXml) {
        String filename = "file-app-config-name.xml";
        InputStream inputStream = IOUtils.toInputStream((String)applicationXml, (Charset)StandardCharsets.UTF_8);
        XmlConfigurationDocumentLoader xmlConfigurationDocumentLoader = XmlConfigurationDocumentLoader.noValidationDocumentLoader();
        Document moduleDocument = xmlConfigurationDocumentLoader.loadDocument(() -> XMLSecureFactories.createDefault().getSAXParserFactory(), (EntityResolver)new ModuleDelegatingEntityResolver(Collections.emptySet()), filename, inputStream);
        XmlApplicationParser xmlApplicationParser = new XmlApplicationParser(XmlNamespaceInfoProviderSupplier.createFromExtensionModels(Collections.emptySet(), Optional.empty()));
        Optional parseModule = xmlApplicationParser.parse(moduleDocument.getDocumentElement());
        if (!parseModule.isPresent()) {
            throw new IllegalArgumentException("There was an issue trying to read the stream of the test");
        }
        ConfigLine configLine = (ConfigLine)parseModule.get();
        ConfigurationPropertiesResolver externalPropertiesResolver = new ConfigurationPropertiesResolver(){

            public Object resolveValue(String value) {
                return value;
            }

            public Object resolvePlaceholderKeyValue(String placeholderKey) {
                return placeholderKey;
            }
        };
        ComponentModelReader componentModelReader = new ComponentModelReader(externalPropertiesResolver);
        return componentModelReader.extractComponentDefinitionModel(configLine, filename);
    }
}

