/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.factories;

import java.util.Collections;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.tx.TransactionType;
import org.mule.runtime.config.internal.factories.TryProcessorFactoryBean;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.runtime.core.internal.lifecycle.LifecycleInterceptor;
import org.mule.runtime.core.internal.lifecycle.MuleLifecycleInterceptor;
import org.mule.runtime.core.internal.processor.TryScope;
import org.mule.runtime.core.internal.registry.SimpleRegistry;
import org.mule.runtime.core.internal.transaction.TransactionFactoryLocator;
import org.mule.runtime.core.privileged.registry.RegistrationException;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.util.MuleContextUtils;

@RunWith(value=MockitoJUnitRunner.class)
public class TryProcessorFactoryBeanTestCase
extends AbstractMuleTestCase {
    private MuleContextWithRegistry muleContextMock = MuleContextUtils.mockContextWithServices();
    private SimpleRegistry registry;

    @Before
    public void setUp() throws RegistrationException {
        this.registry = new SimpleRegistry((MuleContext)this.muleContextMock, (LifecycleInterceptor)new MuleLifecycleInterceptor());
        this.registry.registerObject("txFactory", (Object)new TransactionFactoryLocator());
    }

    @Test
    public void doesNotFailWithNoProcessors() throws Exception {
        TryProcessorFactoryBean tryProcessorFactoryBean = new TryProcessorFactoryBean();
        tryProcessorFactoryBean.setTransactionalAction("INDIFFERENT");
        tryProcessorFactoryBean.setTransactionType(TransactionType.LOCAL);
        tryProcessorFactoryBean.setAnnotations(Collections.singletonMap(AbstractComponent.ROOT_CONTAINER_NAME_KEY, "root"));
        this.registry.inject((Object)tryProcessorFactoryBean);
        TryScope tryMessageProcessor = tryProcessorFactoryBean.getObject();
        LifecycleUtils.initialiseIfNeeded((Object)tryMessageProcessor, (MuleContext)this.muleContextMock);
        tryMessageProcessor.start();
    }
}

