/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.model;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.util.NameUtils;
import org.mule.runtime.config.internal.dsl.model.SpringComponentModel;
import org.mule.runtime.config.internal.model.ComponentModel;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.tck.junit4.AbstractMuleTestCase;

@Feature(value="Mule Artifact AST")
@Story(value="Parameter AST resolution")
public class ComponentAstParametersTestCase
extends AbstractMuleTestCase {
    private static final String PARAMETER_A = "a";
    private static final String PARAMETER_B = "b";
    private static final String PARAMETER_C = "c";
    private final ClassTypeLoader TYPE_LOADER = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    private ParameterModel createParameterModel(String name) {
        ParameterModel parameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)parameterModel.getName()).thenReturn((Object)name);
        Mockito.when((Object)parameterModel.getType()).thenReturn((Object)this.TYPE_LOADER.load(String.class));
        return parameterModel;
    }

    @Test
    public void getParametersShouldFailIfParameterizedModelIsNotPresent() {
        this.expectedException.expectMessage(Matchers.containsString((String)"is not parameterizable"));
        this.expectedException.expect(IllegalStateException.class);
        SpringComponentModel componentModel = (SpringComponentModel)this.baseComponentModelBuilder().build();
        componentModel.getParameters();
    }

    @Test
    @Issue(value="MULE-18513")
    public void paramsInShowDslGroupProperlyProcessedSeparated() {
        this.paramsInShowDslGroupProperlyProcessed("GroupComponent B", "GroupComponent C");
        this.paramsInShowDslGroupProperlyProcessed("groupB", "groupC");
        this.paramsInShowDslGroupProperlyProcessed("Message", "Advanced");
    }

    private void paramsInShowDslGroupProperlyProcessed(String parameterGruupBName, String parameterGroupCName) {
        ComponentModel parameterizedModel = (ComponentModel)Mockito.mock(ComponentModel.class);
        ParameterModel paramA = this.createParameterModel(PARAMETER_A);
        ParameterModel paramB = this.createParameterModel(PARAMETER_B);
        ParameterModel paramC = this.createParameterModel(PARAMETER_C);
        Mockito.when((Object)parameterizedModel.getAllParameterModels()).thenReturn(Arrays.asList(paramA, paramB, paramC));
        ParameterGroupModel paramGroupA = (ParameterGroupModel)Mockito.mock(ParameterGroupModel.class);
        Mockito.when((Object)paramGroupA.getName()).thenReturn((Object)"General");
        Mockito.when((Object)paramGroupA.getParameterModels()).thenReturn(Collections.singletonList(paramA));
        Mockito.when((Object)paramGroupA.isShowInDsl()).thenReturn((Object)false);
        ParameterGroupModel paramGroupB = (ParameterGroupModel)Mockito.mock(ParameterGroupModel.class);
        Mockito.when((Object)paramGroupB.getName()).thenReturn((Object)parameterGruupBName);
        Mockito.when((Object)paramGroupB.getParameterModels()).thenReturn(Collections.singletonList(paramB));
        Mockito.when((Object)paramGroupB.isShowInDsl()).thenReturn((Object)false);
        ParameterGroupModel paramGroupC = (ParameterGroupModel)Mockito.mock(ParameterGroupModel.class);
        Mockito.when((Object)paramGroupC.getName()).thenReturn((Object)parameterGroupCName);
        Mockito.when((Object)paramGroupC.getParameterModels()).thenReturn(Collections.singletonList(paramC));
        Mockito.when((Object)paramGroupC.isShowInDsl()).thenReturn((Object)true);
        Mockito.when((Object)parameterizedModel.getParameterGroupModels()).thenReturn(Arrays.asList(paramGroupA, paramGroupB, paramGroupC));
        SpringComponentModel componentModel = (SpringComponentModel)this.baseComponentModelBuilder().addParameter(PARAMETER_A, PARAMETER_A, false).addParameter(PARAMETER_B, PARAMETER_B, false).addChildComponentModel(this.baseComponentModelBuilder().setIdentifier(ComponentIdentifier.buildFromStringRepresentation((String)("test:" + NameUtils.hyphenize((String)parameterGroupCName)))).addParameter(PARAMETER_C, PARAMETER_C, false).build()).build();
        componentModel.setComponentModel(parameterizedModel);
        Collection parameters = componentModel.getParameters();
        Assert.assertThat((Object)parameters, (Matcher)IsCollectionWithSize.hasSize((int)3));
        Assert.assertThat(parameters.stream().map(p -> p.getValue().getRight()).collect(Collectors.toSet()), (Matcher)Matchers.is(new HashSet<String>(Arrays.asList(PARAMETER_A, PARAMETER_B, PARAMETER_C))));
    }

    private ComponentModel.Builder baseComponentModelBuilder() {
        return new ComponentModel.Builder().setIdentifier((ComponentIdentifier)Mockito.mock(ComponentIdentifier.class));
    }
}

