/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.util.Calendar;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.time.TimeSupplier;
import org.mule.runtime.config.internal.SpringXmlConfigurationBuilder;
import org.mule.runtime.core.api.config.ConfigurationBuilder;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.config.builders.SimpleConfigurationBuilder;
import org.mule.runtime.core.api.context.DefaultMuleContextFactory;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.internal.config.ImmutableExpirationPolicy;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.runtime.extension.api.runtime.ExpirationPolicy;
import org.mule.tck.config.TestServicesConfigurationBuilder;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.MockExtensionManagerConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Feature(value="Configuration properties")
@Story(value="Component configuration properties story")
public class MuleConfigurationConfiguratorTestCase
extends AbstractMuleTestCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(MuleConfigurationConfiguratorTestCase.class);
    @Rule
    public TestServicesConfigurationBuilder testServicesConfigurationBuilder = new TestServicesConfigurationBuilder();
    private TimeSupplier timeSupplier = (TimeSupplier)Mockito.mock(TimeSupplier.class);
    private MuleContextWithRegistry muleContext;

    @Before
    public void before() throws Exception {
        this.muleContext = (MuleContextWithRegistry)new DefaultMuleContextFactory().createMuleContext(new ConfigurationBuilder[]{this.testServicesConfigurationBuilder, new SimpleConfigurationBuilder(Collections.singletonMap("_muleTimeSupplier", this.timeSupplier)), new MockExtensionManagerConfigurationBuilder(), new SpringXmlConfigurationBuilder(new String[0], Collections.emptyMap())});
        this.muleContext.start();
        this.muleContext.getRegistry().lookupByType(Calendar.class);
    }

    @After
    public void after() {
        if (this.muleContext != null) {
            LifecycleUtils.disposeIfNeeded((Object)this.muleContext, (Logger)LOGGER);
        }
    }

    @Test
    @Issue(value="MULE-19006")
    public void configuratorExpirationPolicyUsesManagedTimeSupplier() throws Exception {
        MuleConfiguration configuration = (MuleConfiguration)this.muleContext.getRegistry().lookupObject("_muleConfiguration");
        ExpirationPolicy policy = configuration.getDynamicConfigExpiration().getExpirationPolicy();
        Assert.assertThat((Object)policy, (Matcher)Matchers.instanceOf(ImmutableExpirationPolicy.class));
        configuration.getDynamicConfigExpiration().getExpirationPolicy().isExpired(0L, TimeUnit.DAYS);
        ((TimeSupplier)Mockito.verify((Object)this.timeSupplier)).getAsLong();
    }
}

