/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.dsl.processor;

import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.config.internal.dsl.processor.ObjectTypeVisitor;
import org.mule.runtime.config.internal.model.ComponentModel;
import org.mule.runtime.core.internal.processor.AbstractProcessor;
import org.mule.runtime.core.internal.processor.ReferenceProcessor;
import org.mule.runtime.dsl.api.component.TypeDefinition;
import org.mule.runtime.dsl.api.component.TypeDefinitionVisitor;

public class ObjectTypeVisitorTestCase {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @BeforeClass
    public static void loadClassLoader() throws ClassNotFoundException {
        Thread.currentThread().getContextClassLoader().loadClass("org.mule.runtime.core.internal.processor.ReferenceProcessor");
    }

    @Test
    public void typeIsInstanceOfGivenClass() {
        ObjectTypeVisitor visitor = new ObjectTypeVisitor(this.baseComponentModelBuilder().build());
        TypeDefinition typeDefinition = TypeDefinition.fromType(String.class);
        typeDefinition.visit((TypeDefinitionVisitor)visitor);
        Assert.assertTrue((boolean)String.class.isAssignableFrom(visitor.getType()));
    }

    @Test
    public void typeIsInstanceOfGivenClassFromAttribute() throws ClassNotFoundException {
        ObjectTypeVisitor visitor = new ObjectTypeVisitor(this.baseComponentModelBuilder().addParameter("type", "org.mule.runtime.core.internal.processor.ReferenceProcessor", false).build());
        TypeDefinition typeDefinition = TypeDefinition.fromConfigurationAttribute((String)"type");
        typeDefinition.visit((TypeDefinitionVisitor)visitor);
        Assert.assertTrue((boolean)ReferenceProcessor.class.isAssignableFrom(visitor.getType()));
    }

    @Test
    public void typeIsInstanceOfCheckedClassFromAttribute() throws ClassNotFoundException {
        ObjectTypeVisitor visitor = new ObjectTypeVisitor(this.baseComponentModelBuilder().addParameter("type", "org.mule.runtime.core.internal.processor.ReferenceProcessor", false).build());
        TypeDefinition typeDefinition = TypeDefinition.fromConfigurationAttribute((String)"type").checkingThatIsClassOrInheritsFrom(ReferenceProcessor.class);
        typeDefinition.visit((TypeDefinitionVisitor)visitor);
        Assert.assertTrue((boolean)ReferenceProcessor.class.isAssignableFrom(visitor.getType()));
    }

    @Test
    public void typeIsInstanceOfClassInheritedFromCheckedClassFromAttribute() throws ClassNotFoundException {
        ObjectTypeVisitor visitor = new ObjectTypeVisitor(this.baseComponentModelBuilder().addParameter("type", "org.mule.runtime.core.internal.processor.ReferenceProcessor", false).build());
        TypeDefinition typeDefinition = TypeDefinition.fromConfigurationAttribute((String)"type").checkingThatIsClassOrInheritsFrom(AbstractProcessor.class);
        typeDefinition.visit((TypeDefinitionVisitor)visitor);
        Assert.assertTrue((boolean)AbstractProcessor.class.isAssignableFrom(visitor.getType()));
    }

    @Test
    public void testFailsIfTypeIsNotOfCheckedClass() throws ClassNotFoundException {
        this.exception.expect(MuleRuntimeException.class);
        this.exception.expectMessage("is not the same nor inherits from");
        ObjectTypeVisitor visitor = new ObjectTypeVisitor(this.baseComponentModelBuilder().addParameter("type", this.getClass().getName(), false).build());
        TypeDefinition typeDefinition = TypeDefinition.fromConfigurationAttribute((String)"type").checkingThatIsClassOrInheritsFrom(ReferenceProcessor.class);
        typeDefinition.visit((TypeDefinitionVisitor)visitor);
    }

    private ComponentModel.Builder baseComponentModelBuilder() {
        return new ComponentModel.Builder().setIdentifier((ComponentIdentifier)Mockito.mock(ComponentIdentifier.class));
    }
}

