/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.model.config;

import com.google.common.collect.ImmutableMap;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.config.api.dsl.model.properties.ConfigurationProperty;
import org.mule.runtime.config.internal.dsl.model.config.EnvironmentPropertiesConfigurationProvider;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class EnvironmentPropertiesConfigurationProviderTestCase
extends AbstractMuleTestCase {
    @Test
    public void environmentVariables() {
        String variableKey = "varA";
        String variableValue = "varAValue";
        EnvironmentPropertiesConfigurationProvider environmentPropertiesConfigurationProvider = new EnvironmentPropertiesConfigurationProvider(() -> ImmutableMap.builder().put((Object)variableKey, (Object)variableValue).build());
        Assert.assertThat((Object)((ConfigurationProperty)environmentPropertiesConfigurationProvider.getConfigurationProperty(variableKey).get()).getRawValue(), (Matcher)Is.is((Object)variableValue));
    }

    @Test
    public void systemProperty() throws Exception {
        String propertyKey = "propertyA";
        String propertyValue = "propertyAValue";
        MuleTestUtils.testWithSystemProperty((String)propertyKey, (String)propertyValue, () -> {
            EnvironmentPropertiesConfigurationProvider environmentPropertiesConfigurationProvider = new EnvironmentPropertiesConfigurationProvider();
            Assert.assertThat((Object)((ConfigurationProperty)environmentPropertiesConfigurationProvider.getConfigurationProperty(propertyKey).get()).getRawValue(), (Matcher)Is.is((Object)propertyValue));
        });
    }

    @Test
    public void systemPropertyPrecedenceOverEnvVariable() throws Exception {
        String key = "varA";
        String keyPropertyValue = "varPropertyValue";
        String keyVariableValue = "varEnvironmentValue";
        MuleTestUtils.testWithSystemProperty((String)key, (String)keyPropertyValue, () -> {
            EnvironmentPropertiesConfigurationProvider environmentPropertiesConfigurationProvider = new EnvironmentPropertiesConfigurationProvider(() -> ImmutableMap.builder().put((Object)key, (Object)keyVariableValue).build());
            Assert.assertThat((Object)((ConfigurationProperty)environmentPropertiesConfigurationProvider.getConfigurationProperty(key).get()).getRawValue(), (Matcher)Is.is((Object)keyPropertyValue));
        });
    }
}

