/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.builder;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.config.internal.model.DefaultComponentParameterAst;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.tck.junit4.AbstractMuleTestCase;

@Feature(value="Mule Artifact AST")
@Story(value="Parameter AST resolution")
public class ComponentAstParameterTestCase
extends AbstractMuleTestCase {
    private final ClassTypeLoader TYPE_LOADER = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();

    @Test
    @Issue(value="MULE-19871")
    public void primitiveToNumberWithDefaultValue() {
        this.assertPrimitiveWithDefaultValue(Long.toString(Long.MAX_VALUE), Long.MAX_VALUE, Number.class);
    }

    @Test
    @Issue(value="MULE-19871")
    public void primitiveToSmallNumberWithDefaultValue() {
        this.assertPrimitiveWithDefaultValue(Integer.toString(Integer.MAX_VALUE), Integer.MAX_VALUE, Number.class);
    }

    @Test
    @Issue(value="MULE-19871")
    public void primitiveToDecimalNumberWithDefaultValue() {
        this.assertPrimitiveWithDefaultValue("2.53", 2.53, Number.class);
    }

    private void assertPrimitiveWithDefaultValue(String value, Number expected, Class<? extends Number> type) {
        ParameterModel model = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)model.getExpressionSupport()).thenReturn((Object)ExpressionSupport.NOT_SUPPORTED);
        Mockito.when((Object)model.getDefaultValue()).thenReturn((Object)value);
        Mockito.when((Object)model.getType()).thenReturn((Object)this.TYPE_LOADER.load(type));
        DefaultComponentParameterAst parameterAst = new DefaultComponentParameterAst(value, () -> model, null);
        MatcherAssert.assertThat((Object)parameterAst.getValue().isRight(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)parameterAst.getValue().getRight(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected)));
    }

    public static enum TestEnum {
        VALUE_A,
        VALUE_B;

    }
}

