/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.dsl.model.internal.config;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.config.api.dsl.model.ResourceProvider;
import org.mule.runtime.config.api.dsl.model.properties.ConfigurationPropertiesProvider;
import org.mule.runtime.config.internal.dsl.model.ClassLoaderResourceProvider;
import org.mule.runtime.config.internal.dsl.model.config.DefaultConfigurationPropertiesResolver;
import org.mule.runtime.config.internal.dsl.model.config.FileConfigurationPropertiesProvider;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.matcher.IsEqualIgnoringLineBreaks;

@Feature(value="Configuration properties")
@Story(value="Component configuration properties resolver story")
public class FileConfigurationPropertiesProviderTestCase
extends AbstractMuleTestCase {
    private DefaultConfigurationPropertiesResolver resolver;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void createResolver() {
        ClassLoaderResourceProvider externalResourceProvider = new ClassLoaderResourceProvider(Thread.currentThread().getContextClassLoader());
        this.resolver = new DefaultConfigurationPropertiesResolver(Optional.empty(), (ConfigurationPropertiesProvider)new FileConfigurationPropertiesProvider((ResourceProvider)externalResourceProvider, "External provider"));
    }

    @Test
    public void fileIsResolved() {
        Assert.assertThat((Object)((String)this.resolver.resolveValue("${file::dummy.xml}")), (Matcher)Is.is((Matcher)IsEqualIgnoringLineBreaks.equalToIgnoringLineBreaks((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<foo/>\n")));
    }

    @Test
    public void fileDoesNotExist() {
        this.expectedException.expectMessage(Is.is((Object)"Couldn't find configuration property value for key ${file::non-existing-file} from properties provider External provider"));
        this.resolver.resolveValue("${file::non-existing-file}");
    }
}

