/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.config.internal.AutoDiscoveredDependencyResolver;
import org.mule.runtime.config.internal.BeanDependencyResolver;
import org.mule.runtime.config.internal.BeanWrapper;
import org.mule.runtime.config.internal.ConfigurationDependencyResolver;
import org.mule.runtime.config.internal.DeclaredDependencyResolver;
import org.mule.runtime.config.internal.DependencyNode;
import org.mule.runtime.config.internal.SpringRegistry;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public class DependencyGraphBeanDependencyResolver
implements BeanDependencyResolver {
    private final SpringRegistry springRegistry;
    private final ConfigurationDependencyResolver configurationDependencyResolver;
    private final DeclaredDependencyResolver declaredDependencyResolver;
    private final AutoDiscoveredDependencyResolver autoDiscoveredDependencyResolver;
    private Map<Integer, Set<BeanWrapper>> visitedComponentsForBuckets;
    private Map<BeanWrapper, List<BeanWrapper>> visitedComponents;

    public DependencyGraphBeanDependencyResolver(ConfigurationDependencyResolver configurationDependencyResolver, DeclaredDependencyResolver declaredDependencyResolver, AutoDiscoveredDependencyResolver autoDiscoveredDependencyResolver, SpringRegistry springRegistry) {
        this.configurationDependencyResolver = configurationDependencyResolver;
        this.declaredDependencyResolver = declaredDependencyResolver;
        this.autoDiscoveredDependencyResolver = autoDiscoveredDependencyResolver;
        this.springRegistry = springRegistry;
        this.visitedComponentsForBuckets = new HashMap<Integer, Set<BeanWrapper>>();
        this.visitedComponents = new HashMap<BeanWrapper, List<BeanWrapper>>();
    }

    @Override
    public List<Object> resolveBeanDependencies(String beanName) {
        Object currentObject = this.springRegistry.get(beanName);
        DependencyNode currentNode = new DependencyNode(currentObject);
        this.addDirectDependency(beanName, currentObject, currentNode, new HashSet<DependencyNode>());
        return currentNode.getChildren().stream().map(DependencyNode::getObject).collect(Collectors.toList());
    }

    public List<BeanWrapper> getDirectBeanDependencies(BeanWrapper currentObject, int bucketIndex) {
        this.visitedComponentsForBuckets.putIfAbsent(bucketIndex, new HashSet());
        if (this.visitedComponentsForBuckets.get(bucketIndex).contains(currentObject)) {
            return Collections.emptyList();
        }
        this.visitedComponentsForBuckets.get(bucketIndex).add(currentObject);
        if (this.visitedComponents.containsKey(currentObject)) {
            return this.visitedComponents.get(currentObject);
        }
        DependencyNode currentNode = new DependencyNode(currentObject.getName(), currentObject.getWrappedObject());
        this.addDirectDependency(currentObject.getName(), currentObject.getWrappedObject(), currentNode, new HashSet<DependencyNode>());
        List<BeanWrapper> directDependencies = currentNode.getChildren().stream().map(DependencyNode::getNameAndObject).collect(Collectors.toList());
        this.visitedComponents.put(currentObject, directDependencies);
        return directDependencies;
    }

    public Map<BeanWrapper, List<BeanWrapper>> getTransitiveDependencies(String beanName, int bucketIndex) {
        LinkedHashMap<BeanWrapper, List<BeanWrapper>> transitiveDependencies = new LinkedHashMap<BeanWrapper, List<BeanWrapper>>();
        HashSet<BeanWrapper> processedComponents = new HashSet<BeanWrapper>();
        ArrayDeque<BeanWrapper> queue = new ArrayDeque<BeanWrapper>();
        queue.add(new BeanWrapper(beanName, this.springRegistry.get(beanName)));
        while (!queue.isEmpty()) {
            BeanWrapper current = (BeanWrapper)queue.remove();
            if (!processedComponents.add(current)) continue;
            List<BeanWrapper> dependencies = this.getDirectBeanDependencies(current, bucketIndex);
            queue.addAll(dependencies);
            transitiveDependencies.put(current, dependencies);
        }
        return transitiveDependencies;
    }

    private void addDirectDependency(String beanName, Object object, DependencyNode node, Set<DependencyNode> processedKeys) {
        this.addDirectAutoDiscoveredDependencies(beanName, processedKeys, node);
        this.addDirectConfigurationDependencies(beanName, node, processedKeys);
        this.addDirectDeclaredDependencies(object, processedKeys, node);
    }

    private void addDirectDeclaredDependencies(Object object, Set<DependencyNode> processedKeys, DependencyNode node) {
        this.declaredDependencyResolver.getDeclaredDependencies(object).forEach(v -> this.addDirectChild(v.getName(), v.getWrappedObject(), node, processedKeys));
    }

    private void addDirectConfigurationDependencies(String beanName, DependencyNode node, Set<DependencyNode> processedKeys) {
        if (this.configurationDependencyResolver == null) {
            return;
        }
        for (String name : this.configurationDependencyResolver.getDirectComponentDependencies(beanName)) {
            try {
                if (!this.springRegistry.isSingleton(name)) continue;
                this.addDirectChild(name, this.springRegistry.get(name), node, processedKeys);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {}
        }
    }

    private void addDirectAutoDiscoveredDependencies(String beanName, Set<DependencyNode> processedKeys, DependencyNode node) {
        this.autoDiscoveredDependencyResolver.getAutoDiscoveredDependencies(beanName).stream().filter(v -> !v.getWrappedObject().equals(node.getObject())).forEach(v -> this.addDirectChild(v.getName(), v.getWrappedObject(), node, processedKeys));
    }

    private void addDirectChild(String key, Object childObject, DependencyNode parent, Set<DependencyNode> processedKeys) {
        if (!processedKeys.add(new DependencyNode(key, childObject))) {
            return;
        }
        parent.addChild(new DependencyNode(key, childObject));
    }
}

