/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.dsl.model;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsNot;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Answers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.meta.model.parameter.ValueProviderModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.util.ExtensionModelTestUtils;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.app.declaration.api.ComponentElementDeclaration;
import org.mule.runtime.app.declaration.api.ConfigurationElementDeclaration;
import org.mule.runtime.app.declaration.api.ConnectionElementDeclaration;
import org.mule.runtime.app.declaration.api.GlobalElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterGroupElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterizedElementDeclaration;
import org.mule.runtime.app.declaration.api.component.location.Location;
import org.mule.runtime.app.declaration.api.fluent.ConfigurationElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ConnectionElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ConstructElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.OperationElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ParameterSimpleValue;
import org.mule.runtime.app.declaration.api.fluent.SourceElementDeclarer;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.config.api.dsl.model.DslElementModel;
import org.mule.runtime.config.api.dsl.model.DslElementModelFactory;
import org.mule.runtime.config.api.dsl.model.metadata.DslElementBasedValueProviderCacheIdGenerator;
import org.mule.runtime.config.api.dsl.processor.ArtifactConfig;
import org.mule.runtime.config.internal.model.ApplicationModel;
import org.mule.runtime.config.internal.model.ComponentModel;
import org.mule.runtime.core.api.extension.MuleExtensionModelProvider;
import org.mule.runtime.core.internal.locator.ComponentLocator;
import org.mule.runtime.core.internal.value.cache.ValueProviderCacheId;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.property.RequiredForMetadataModelProperty;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DslModelValueProviderCacheIdGeneratorTestCase
extends AbstractMuleTestCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(DslModelValueProviderCacheIdGeneratorTestCase.class);
    protected static final String NAMESPACE = "vp-mockns";
    protected static final String NAMESPACE_URI = "http://www.mulesoft.org/schema/mule/vp-mockns";
    protected static final String SCHEMA_LOCATION = "http://www.mulesoft.org/schema/mule/vp-mockns/current/vp-mule-mockns.xsd";
    protected static final String PARAMETER_IN_GROUP_NAME = "parameterInGroup";
    protected static final String PARAMETER_IN_GROUP_DEFAULT_VALUE = "parameterInGroup";
    protected static final String CUSTOM_PARAMETER_GROUP_NAME = "customParameterGroupName";
    protected static final String ACTING_PARAMETER_NAME = "actingParameter";
    protected static final String ACTING_PARAMETER_DEFAULT_VALUE = "actingParameter";
    protected static final String PARAMETER_REQUIRED_FOR_METADATA_NAME = "requiredForMetadata";
    protected static final String PARAMETER_REQUIRED_FOR_METADATA_DEFAULT_VALUE = "requiredForMetadata";
    protected static final String PROVIDED_PARAMETER_NAME = "providedParameter";
    protected static final String PROVIDED_PARAMETER_DEFAULT_VALUE = "providedParameter";
    protected static final String EXTENSION_NAME = "extension";
    protected static final String OPERATION_NAME = "mockOperation";
    protected static final String SOURCE_NAME = "source";
    protected static final String CONFIGURATION_NAME = "configuration";
    protected static final String OTHER_CONFIGURATION_NAME = "otherConfiguration";
    protected static final String CONNECTION_PROVIDER_NAME = "connection";
    protected static final String VALUE_PROVIDER_NAME = "valueProvider";
    private static final String MY_FLOW = "myFlow";
    private static final String MY_CONFIG = "myConfig";
    private static final String MY_CONNECTION = "myConfig/connection";
    private static final String SOURCE_LOCATION = "myFlow/source";
    private static final String OPERATION_LOCATION = "myFlow/processors/0";
    @Mock(lenient=true)
    protected ExtensionModel mockExtension;
    @Mock(lenient=true)
    protected ConfigurationModel configuration;
    @Mock(lenient=true)
    protected ConfigurationModel otherConfiguration;
    @Mock(lenient=true)
    protected OperationModel operation;
    @Mock(lenient=true)
    protected ConnectionProviderModel connectionProvider;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS, lenient=true)
    protected SourceModel source;
    @Mock(lenient=true)
    protected ParameterModel parameterInGroup;
    @Mock(lenient=true)
    protected ParameterGroupModel actingParametersGroup;
    @Mock(lenient=true)
    protected ParameterModel nameParameter;
    @Mock(lenient=true)
    protected ParameterModel actingParameter;
    @Mock(lenient=true)
    protected ParameterModel providedParameter;
    @Mock(lenient=true)
    protected ParameterGroupModel parameterGroup;
    @Mock(lenient=true)
    protected ParameterModel parameterRequiredForMetadata;
    @Mock(lenient=true)
    protected DslResolvingContext dslContext;
    @Mock(lenient=true)
    protected ValueProviderModel valueProviderModel;
    protected ClassTypeLoader TYPE_LOADER = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
    protected List<ParameterModel> customParameterGroupModels;
    protected List<ParameterModel> defaultGroupParameterModels;
    private Set<ExtensionModel> extensions;
    private ElementDeclarer declarer;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)((Object)this));
        this.initializeExtensionMock(this.mockExtension);
        Mockito.when((Object)this.nameParameter.getName()).thenReturn((Object)"name");
        Mockito.when((Object)this.nameParameter.getExpressionSupport()).thenReturn((Object)ExpressionSupport.NOT_SUPPORTED);
        Mockito.when((Object)this.nameParameter.getModelProperty((Class)ArgumentMatchers.any())).thenReturn(Optional.empty());
        Mockito.when((Object)this.nameParameter.getDslConfiguration()).thenReturn((Object)ParameterDslConfiguration.getDefaultInstance());
        Mockito.when((Object)this.nameParameter.getLayoutModel()).thenReturn(Optional.empty());
        Mockito.when((Object)this.nameParameter.getRole()).thenReturn((Object)ParameterRole.BEHAVIOUR);
        Mockito.when((Object)this.nameParameter.getType()).thenReturn((Object)this.TYPE_LOADER.load(String.class));
        Mockito.when((Object)this.nameParameter.isComponentId()).thenReturn((Object)true);
        Mockito.when((Object)this.valueProviderModel.getPartOrder()).thenReturn((Object)0);
        Mockito.when((Object)this.valueProviderModel.getProviderName()).thenReturn((Object)VALUE_PROVIDER_NAME);
        Mockito.when((Object)this.valueProviderModel.getActingParameters()).thenReturn(Arrays.asList("actingParameter", "parameterInGroup"));
        Mockito.when((Object)this.valueProviderModel.requiresConfiguration()).thenReturn((Object)false);
        Mockito.when((Object)this.valueProviderModel.requiresConnection()).thenReturn((Object)false);
        Mockito.when((Object)this.parameterInGroup.getName()).thenReturn((Object)"parameterInGroup");
        Mockito.when((Object)this.parameterInGroup.getExpressionSupport()).thenReturn((Object)ExpressionSupport.NOT_SUPPORTED);
        Mockito.when((Object)this.parameterInGroup.getModelProperty((Class)ArgumentMatchers.any())).thenReturn(Optional.empty());
        Mockito.when((Object)this.parameterInGroup.getDslConfiguration()).thenReturn((Object)ParameterDslConfiguration.getDefaultInstance());
        Mockito.when((Object)this.parameterInGroup.getLayoutModel()).thenReturn(Optional.empty());
        Mockito.when((Object)this.parameterInGroup.getRole()).thenReturn((Object)ParameterRole.BEHAVIOUR);
        Mockito.when((Object)this.parameterInGroup.getType()).thenReturn((Object)this.TYPE_LOADER.load(String.class));
        Mockito.when((Object)this.actingParameter.getName()).thenReturn((Object)"actingParameter");
        Mockito.when((Object)this.actingParameter.getExpressionSupport()).thenReturn((Object)ExpressionSupport.NOT_SUPPORTED);
        Mockito.when((Object)this.actingParameter.getModelProperty((Class)ArgumentMatchers.any())).thenReturn(Optional.empty());
        Mockito.when((Object)this.actingParameter.getDslConfiguration()).thenReturn((Object)ParameterDslConfiguration.getDefaultInstance());
        Mockito.when((Object)this.actingParameter.getLayoutModel()).thenReturn(Optional.empty());
        Mockito.when((Object)this.actingParameter.getRole()).thenReturn((Object)ParameterRole.BEHAVIOUR);
        Mockito.when((Object)this.actingParameter.getType()).thenReturn((Object)this.TYPE_LOADER.load(String.class));
        Mockito.when((Object)this.providedParameter.getName()).thenReturn((Object)"providedParameter");
        Mockito.when((Object)this.providedParameter.getExpressionSupport()).thenReturn((Object)ExpressionSupport.NOT_SUPPORTED);
        Mockito.when((Object)this.providedParameter.getModelProperty((Class)ArgumentMatchers.any())).thenReturn(Optional.empty());
        Mockito.when((Object)this.providedParameter.getDslConfiguration()).thenReturn((Object)ParameterDslConfiguration.getDefaultInstance());
        Mockito.when((Object)this.providedParameter.getLayoutModel()).thenReturn(Optional.empty());
        Mockito.when((Object)this.providedParameter.getRole()).thenReturn((Object)ParameterRole.BEHAVIOUR);
        Mockito.when((Object)this.providedParameter.getType()).thenReturn((Object)this.TYPE_LOADER.load(String.class));
        Mockito.when((Object)this.providedParameter.getValueProviderModel()).thenReturn(Optional.of(this.valueProviderModel));
        Mockito.when((Object)this.parameterRequiredForMetadata.getName()).thenReturn((Object)"requiredForMetadata");
        Mockito.when((Object)this.parameterRequiredForMetadata.getExpressionSupport()).thenReturn((Object)ExpressionSupport.NOT_SUPPORTED);
        Mockito.when((Object)this.parameterRequiredForMetadata.getModelProperty((Class)ArgumentMatchers.any())).thenReturn(Optional.empty());
        Mockito.when((Object)this.parameterRequiredForMetadata.getDslConfiguration()).thenReturn((Object)ParameterDslConfiguration.getDefaultInstance());
        Mockito.when((Object)this.parameterRequiredForMetadata.getLayoutModel()).thenReturn(Optional.empty());
        Mockito.when((Object)this.parameterRequiredForMetadata.getRole()).thenReturn((Object)ParameterRole.BEHAVIOUR);
        Mockito.when((Object)this.parameterRequiredForMetadata.getType()).thenReturn((Object)this.TYPE_LOADER.load(String.class));
        this.customParameterGroupModels = Arrays.asList(this.parameterInGroup);
        Mockito.when((Object)this.actingParametersGroup.getName()).thenReturn((Object)CUSTOM_PARAMETER_GROUP_NAME);
        Mockito.when((Object)this.actingParametersGroup.isShowInDsl()).thenReturn((Object)false);
        Mockito.when((Object)this.actingParametersGroup.getParameterModels()).thenReturn(this.customParameterGroupModels);
        Mockito.when((Object)this.actingParametersGroup.getParameter(ArgumentMatchers.anyString())).then(invocation -> {
            String paramName = (String)invocation.getArgument(0);
            if ("parameterInGroup".equals(paramName)) {
                return Optional.of(this.parameterInGroup);
            }
            return Optional.empty();
        });
        this.defaultGroupParameterModels = Arrays.asList(this.nameParameter, this.actingParameter, this.providedParameter, this.parameterRequiredForMetadata);
        Mockito.when((Object)this.parameterGroup.getName()).thenReturn((Object)"General");
        Mockito.when((Object)this.parameterGroup.isShowInDsl()).thenReturn((Object)false);
        Mockito.when((Object)this.parameterGroup.getParameterModels()).thenReturn(this.defaultGroupParameterModels);
        Mockito.when((Object)this.parameterGroup.getParameter(ArgumentMatchers.anyString())).then(invocation -> {
            String paramName;
            switch (paramName = (String)invocation.getArgument(0)) {
                case "actingParameter": {
                    return Optional.of(this.actingParameter);
                }
                case "providedParameter": {
                    return Optional.of(this.providedParameter);
                }
                case "requiredForMetadata": {
                    return Optional.of(this.parameterRequiredForMetadata);
                }
            }
            return Optional.empty();
        });
        RequiredForMetadataModelProperty requiredForMetadataModelProperty = new RequiredForMetadataModelProperty(Arrays.asList("requiredForMetadata"));
        Mockito.when((Object)this.connectionProvider.getName()).thenReturn((Object)CONNECTION_PROVIDER_NAME);
        Mockito.when((Object)this.connectionProvider.getParameterGroupModels()).thenReturn(Arrays.asList(this.parameterGroup, this.actingParametersGroup));
        Mockito.when((Object)this.connectionProvider.getModelProperty(RequiredForMetadataModelProperty.class)).thenReturn(Optional.of(requiredForMetadataModelProperty));
        Mockito.when((Object)this.configuration.getName()).thenReturn((Object)CONFIGURATION_NAME);
        Mockito.when((Object)this.configuration.getParameterGroupModels()).thenReturn(Arrays.asList(this.parameterGroup, this.actingParametersGroup));
        Mockito.when((Object)this.configuration.getOperationModels()).thenReturn(Arrays.asList(this.operation));
        Mockito.when((Object)this.configuration.getSourceModels()).thenReturn(Arrays.asList(this.source));
        Mockito.when((Object)this.configuration.getConnectionProviders()).thenReturn(Arrays.asList(this.connectionProvider));
        Mockito.when((Object)this.configuration.getModelProperty(RequiredForMetadataModelProperty.class)).thenReturn(Optional.of(requiredForMetadataModelProperty));
        Mockito.when((Object)this.otherConfiguration.getName()).thenReturn((Object)OTHER_CONFIGURATION_NAME);
        Mockito.when((Object)this.otherConfiguration.getParameterGroupModels()).thenReturn(Arrays.asList(this.parameterGroup, this.actingParametersGroup));
        Mockito.when((Object)this.otherConfiguration.getOperationModels()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.otherConfiguration.getSourceModels()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.otherConfiguration.getConnectionProviders()).thenReturn(Arrays.asList(this.connectionProvider));
        Mockito.when((Object)this.otherConfiguration.getModelProperty(RequiredForMetadataModelProperty.class)).thenReturn(Optional.of(requiredForMetadataModelProperty));
        Mockito.when((Object)this.source.getName()).thenReturn((Object)SOURCE_NAME);
        Mockito.when((Object)this.source.getParameterGroupModels()).thenReturn(Arrays.asList(this.parameterGroup, this.actingParametersGroup));
        Mockito.when((Object)this.source.getSuccessCallback()).thenReturn(Optional.empty());
        Mockito.when((Object)this.source.getErrorCallback()).thenReturn(Optional.empty());
        Mockito.when((Object)this.operation.getName()).thenReturn((Object)OPERATION_NAME);
        Mockito.when((Object)this.operation.getParameterGroupModels()).thenReturn(Arrays.asList(this.parameterGroup, this.actingParametersGroup));
        ExtensionModelTestUtils.visitableMock((org.mule.runtime.api.meta.model.ComponentModel[])new org.mule.runtime.api.meta.model.ComponentModel[]{this.operation, this.source});
        Mockito.when((Object)this.dslContext.getExtension((String)ArgumentMatchers.any())).thenReturn(Optional.of(this.mockExtension));
        Mockito.when((Object)this.dslContext.getExtensions()).thenReturn(Collections.singleton(this.mockExtension));
        ArrayList<ParameterModel> allParameterModels = new ArrayList<ParameterModel>();
        allParameterModels.addAll(this.defaultGroupParameterModels);
        allParameterModels.addAll(this.customParameterGroupModels);
        Stream.of(this.configuration, this.otherConfiguration, this.operation, this.connectionProvider, this.source).forEach(model -> Mockito.when((Object)model.getAllParameterModels()).thenReturn((Object)allParameterModels));
        this.extensions = ImmutableSet.builder().add((Object)MuleExtensionModelProvider.getExtensionModel()).add((Object)this.mockExtension).build();
        this.declarer = ElementDeclarer.forExtension((String)EXTENSION_NAME);
    }

    protected void initializeExtensionMock(ExtensionModel extension) {
        Mockito.when((Object)extension.getName()).thenReturn((Object)EXTENSION_NAME);
        Mockito.when((Object)extension.getXmlDslModel()).thenReturn((Object)XmlDslModel.builder().setXsdFileName("mule-mockns.xsd").setPrefix(NAMESPACE).setNamespace(NAMESPACE_URI).setSchemaLocation(SCHEMA_LOCATION).setSchemaVersion("4.0").build());
        Mockito.when((Object)extension.getSubTypes()).thenReturn(Collections.emptySet());
        Mockito.when((Object)extension.getImportedTypes()).thenReturn(Collections.emptySet());
        Mockito.when((Object)extension.getXmlDslModel()).thenReturn((Object)XmlDslModel.builder().setXsdFileName("").setPrefix(NAMESPACE).setNamespace(NAMESPACE_URI).setSchemaLocation(SCHEMA_LOCATION).setSchemaVersion("").build());
        Mockito.when((Object)extension.getConfigurationModels()).thenReturn(Arrays.asList(this.configuration, this.otherConfiguration));
        Mockito.when((Object)extension.getConfigurationModel(ArgumentMatchers.anyString())).then(invocation -> {
            if (this.configuration.getName().equals(invocation.getArgument(0))) {
                return Optional.of(this.configuration);
            }
            if (this.otherConfiguration.getName().equals(invocation.getArgument(0))) {
                return Optional.of(this.otherConfiguration);
            }
            return Optional.empty();
        });
        Mockito.when((Object)extension.getOperationModels()).thenReturn(Arrays.asList(this.operation));
        Mockito.when((Object)extension.getOperationModel(ArgumentMatchers.anyString())).thenReturn(Optional.of(this.operation));
        Mockito.when((Object)extension.getSourceModels()).thenReturn(Arrays.asList(this.source));
        Mockito.when((Object)extension.getSourceModel(ArgumentMatchers.anyString())).thenReturn(Optional.of(this.source));
        Mockito.when((Object)extension.getConnectionProviders()).thenReturn(Arrays.asList(this.connectionProvider));
        Mockito.when((Object)extension.getConnectionProviderModel(ArgumentMatchers.anyString())).thenReturn(Optional.of(this.connectionProvider));
    }

    private ConfigurationElementDeclaration declareConfig(ConnectionElementDeclaration connectionDeclaration, String name, String parameterRequiredForMetadata, String actingParameter, String providedParameter, String parameterInGroup) {
        return (ConfigurationElementDeclaration)((ConfigurationElementDeclarer)((ConfigurationElementDeclarer)this.declarer.newConfiguration(CONFIGURATION_NAME).withRefName(name).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("requiredForMetadata", parameterRequiredForMetadata).withParameter("actingParameter", actingParameter).withParameter("providedParameter", providedParameter).getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)CUSTOM_PARAMETER_GROUP_NAME).withParameter("parameterInGroup", parameterInGroup).getDeclaration())).withConnection(connectionDeclaration).getDeclaration();
    }

    private ConfigurationElementDeclaration declareOtherConfig(ConnectionElementDeclaration connectionDeclaration, String name, String parameterRequiredForMetadata, String actingParameter, String providedParameter, String parameterInGroup) {
        return (ConfigurationElementDeclaration)((ConfigurationElementDeclarer)((ConfigurationElementDeclarer)this.declarer.newConfiguration(OTHER_CONFIGURATION_NAME).withRefName(name).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("requiredForMetadata", parameterRequiredForMetadata).withParameter("actingParameter", actingParameter).withParameter("providedParameter", providedParameter).getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)CUSTOM_PARAMETER_GROUP_NAME).withParameter("parameterInGroup", parameterInGroup).getDeclaration())).withConnection(connectionDeclaration).getDeclaration();
    }

    private ConnectionElementDeclaration declareConnection(String parameterRequiredForMetadata, String actingParameter, String providedParameter, String parameterInGroup) {
        return (ConnectionElementDeclaration)((ConnectionElementDeclarer)((ConnectionElementDeclarer)this.declarer.newConnection(CONNECTION_PROVIDER_NAME).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("requiredForMetadata", parameterRequiredForMetadata).withParameter("actingParameter", actingParameter).withParameter("providedParameter", providedParameter).getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)CUSTOM_PARAMETER_GROUP_NAME).withParameter("parameterInGroup", parameterInGroup).getDeclaration())).getDeclaration();
    }

    private ArtifactDeclaration getBaseApp() {
        return (ArtifactDeclaration)ElementDeclarer.newArtifact().withGlobalElement((GlobalElementDeclaration)this.declareConfig(this.declareConnection("requiredForMetadata", "actingParameter", "providedParameter", "parameterInGroup"), MY_CONFIG, "requiredForMetadata", "actingParameter", "providedParameter", "parameterInGroup")).withGlobalElement((GlobalElementDeclaration)((ConstructElementDeclarer)((ConstructElementDeclarer)ElementDeclarer.forExtension((String)"mule").newConstruct("flow").withRefName(MY_FLOW).withComponent((ComponentElementDeclaration)((SourceElementDeclarer)((SourceElementDeclarer)((SourceElementDeclarer)this.declarer.newSource(SOURCE_NAME).withConfig(MY_CONFIG)).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("actingParameter", "actingParameter").withParameter("providedParameter", "providedParameter").getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)CUSTOM_PARAMETER_GROUP_NAME).withParameter("parameterInGroup", "parameterInGroup").getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)((OperationElementDeclarer)this.declarer.newOperation(OPERATION_NAME).withConfig(MY_CONFIG)).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("actingParameter", "actingParameter").withParameter("providedParameter", "providedParameter").getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)CUSTOM_PARAMETER_GROUP_NAME).withParameter("parameterInGroup", "parameterInGroup").getDeclaration())).getDeclaration())).getDeclaration()).getDeclaration();
    }

    private ComponentAst getComponentAst(ApplicationModel app, String location) {
        Reference componentAst = new Reference();
        app.getRootComponentModel().executedOnEveryInnerComponent(c -> {
            if (c.getComponentLocation().getLocation().equals(location)) {
                componentAst.set((Object)((ComponentAst)c));
            }
        });
        return (ComponentAst)componentAst.get();
    }

    protected ApplicationModel loadApplicationModel(ArtifactDeclaration declaration) throws Exception {
        return new ApplicationModel(new ArtifactConfig.Builder().build(), declaration, this.extensions, Collections.emptyMap(), Optional.empty(), Optional.empty(), uri -> ((Object)((Object)this)).getClass().getResourceAsStream(uri));
    }

    private Optional<ValueProviderCacheId> computeIdFor(ArtifactDeclaration appDeclaration, String location, String parameterName) throws Exception {
        ApplicationModel app = this.loadApplicationModel(appDeclaration);
        DslElementModelFactory dslFactory = DslElementModelFactory.getDefault((DslResolvingContext)this.dslContext);
        Locator locator = new Locator(app);
        ComponentLocator dslLocator = l -> locator.get(l).map(c -> dslFactory.create(c).orElse(null));
        DslElementBasedValueProviderCacheIdGenerator cacheIdGenerator = new DslElementBasedValueProviderCacheIdGenerator(dslLocator);
        ComponentAst component = this.getComponentAst(app, location);
        DslElementModel element = (DslElementModel)DslElementModelFactory.getDefault((DslResolvingContext)this.dslContext).create(component).get();
        return cacheIdGenerator.getIdForResolvedValues((Object)element, parameterName);
    }

    private String collectLog(ValueProviderCacheId valueProviderCacheId, int level) {
        StringBuilder logId = new StringBuilder();
        if (level == 0) {
            logId.append(System.lineSeparator());
        }
        logId.append(valueProviderCacheId.toString());
        if (!valueProviderCacheId.getParts().isEmpty()) {
            int newLevel = level + 1;
            valueProviderCacheId.getParts().forEach(p -> {
                logId.append(System.lineSeparator());
                IntStream.range(0, newLevel).forEach(i -> logId.append(" "));
                logId.append("+-").append(this.collectLog((ValueProviderCacheId)p, newLevel));
            });
        }
        return logId.toString();
    }

    private void checkIdsAreEqual(Optional<ValueProviderCacheId> id1, Optional<ValueProviderCacheId> id2) {
        LOGGER.debug("ID1: " + id1.map(i -> this.collectLog((ValueProviderCacheId)i, 0)).orElse("empty"));
        LOGGER.debug("ID2: " + id2.map(i -> this.collectLog((ValueProviderCacheId)i, 0)).orElse("empty"));
        MatcherAssert.assertThat(id1, (Matcher)Matchers.equalTo(id2));
    }

    private void checkIdsAreDifferent(Optional<ValueProviderCacheId> id1, Optional<ValueProviderCacheId> id2) {
        LOGGER.debug("ID1: " + id1.map(i -> this.collectLog((ValueProviderCacheId)i, 0)).orElse("empty"));
        LOGGER.debug("ID2: " + id2.map(i -> this.collectLog((ValueProviderCacheId)i, 0)).orElse("empty"));
        MatcherAssert.assertThat(id1, (Matcher)IsNot.not((Matcher)Matchers.equalTo(id2)));
    }

    private Optional<ParameterizedElementDeclaration> getParameterElementDeclaration(ArtifactDeclaration artifactDeclaration, String location) {
        AtomicBoolean isConnection = new AtomicBoolean(false);
        if (location.endsWith("/connection")) {
            isConnection.set(true);
            location = location.split("/connection")[0];
        }
        return artifactDeclaration.findElement(Location.builderFromStringRepresentation((String)location).build()).map(d -> isConnection.get() ? (ParameterizedElementDeclaration)((ConfigurationElementDeclaration)d).getConnection().orElse(null) : d);
    }

    private void modifyParameter(ArtifactDeclaration artifactDeclaration, String ownerLocation, String parameterName, Consumer<ParameterElementDeclaration> parameterConsumer) {
        this.getParameterElementDeclaration(artifactDeclaration, ownerLocation).map(owner -> owner.getParameterGroups().stream().flatMap(pg -> pg.getParameters().stream()).filter(p -> p.getName().equals(parameterName)).findAny().map(fp -> {
            parameterConsumer.accept((ParameterElementDeclaration)fp);
            return "";
        }).orElseThrow(() -> new RuntimeException("Could not find parameter to modify"))).orElseThrow(() -> new RuntimeException("Location not found"));
    }

    @Test
    public void idForParameterWithNoProviderInConfig() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        MatcherAssert.assertThat((Object)this.computeIdFor(app, MY_CONFIG, "actingParameter").isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void idForParameterWithNoProviderInSource() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        MatcherAssert.assertThat((Object)this.computeIdFor(app, SOURCE_LOCATION, "actingParameter").isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void idForParameterWithNoProviderInOperation() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        MatcherAssert.assertThat((Object)this.computeIdFor(app, OPERATION_LOCATION, "actingParameter").isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void idForConfigNoChanges() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Optional<ValueProviderCacheId> configId = this.computeIdFor(app, MY_CONFIG, "providedParameter");
        MatcherAssert.assertThat((Object)configId.isPresent(), (Matcher)Matchers.is((Object)true));
        this.checkIdsAreEqual(configId, this.computeIdFor(app, MY_CONFIG, "providedParameter"));
    }

    @Test
    public void idForConfigChangingNotActingParameters() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Optional<ValueProviderCacheId> configId = this.computeIdFor(app, MY_CONFIG, "providedParameter");
        MatcherAssert.assertThat((Object)configId.isPresent(), (Matcher)Matchers.is((Object)true));
        this.modifyParameter(app, MY_CONFIG, "requiredForMetadata", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.checkIdsAreEqual(configId, this.computeIdFor(app, MY_CONFIG, "providedParameter"));
    }

    @Test
    public void idForConfigChangingActingParameter() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Optional<ValueProviderCacheId> configId = this.computeIdFor(app, MY_CONFIG, "providedParameter");
        MatcherAssert.assertThat((Object)configId.isPresent(), (Matcher)Matchers.is((Object)true));
        this.modifyParameter(app, MY_CONFIG, "actingParameter", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.checkIdsAreDifferent(configId, this.computeIdFor(app, MY_CONFIG, "providedParameter"));
    }

    @Test
    public void idForConfigChangingActingParameterInGroup() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Optional<ValueProviderCacheId> configId = this.computeIdFor(app, MY_CONFIG, "providedParameter");
        MatcherAssert.assertThat((Object)configId.isPresent(), (Matcher)Matchers.is((Object)true));
        this.modifyParameter(app, MY_CONFIG, "parameterInGroup", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.checkIdsAreDifferent(configId, this.computeIdFor(app, MY_CONFIG, "providedParameter"));
    }

    @Test
    public void idForConfiglessAndConnectionlessOperationNoChanges() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Optional<ValueProviderCacheId> opId = this.computeIdFor(app, OPERATION_LOCATION, "providedParameter");
        MatcherAssert.assertThat((Object)opId.isPresent(), (Matcher)Matchers.is((Object)true));
        this.checkIdsAreEqual(opId, this.computeIdFor(app, OPERATION_LOCATION, "providedParameter"));
    }

    @Test
    public void idForConfiglessAndConnectionlessOperationChangingActingParameter() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Optional<ValueProviderCacheId> opId = this.computeIdFor(app, OPERATION_LOCATION, "providedParameter");
        MatcherAssert.assertThat((Object)opId.isPresent(), (Matcher)Matchers.is((Object)true));
        this.modifyParameter(app, OPERATION_LOCATION, "actingParameter", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.checkIdsAreDifferent(opId, this.computeIdFor(app, OPERATION_LOCATION, "providedParameter"));
    }

    @Test
    public void idForConfiglessAndConnectionlessOperationChangingActingParameterInGroup() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Optional<ValueProviderCacheId> opId = this.computeIdFor(app, OPERATION_LOCATION, "providedParameter");
        MatcherAssert.assertThat((Object)opId.isPresent(), (Matcher)Matchers.is((Object)true));
        this.modifyParameter(app, OPERATION_LOCATION, "parameterInGroup", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.checkIdsAreDifferent(opId, this.computeIdFor(app, OPERATION_LOCATION, "providedParameter"));
    }

    @Test
    public void idForConfiglessAndConnectionlessOperationChangesInConfig() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Optional<ValueProviderCacheId> opId = this.computeIdFor(app, OPERATION_LOCATION, "providedParameter");
        MatcherAssert.assertThat((Object)opId.isPresent(), (Matcher)Matchers.is((Object)true));
        this.modifyParameter(app, MY_CONFIG, "requiredForMetadata", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.modifyParameter(app, MY_CONFIG, "actingParameter", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.checkIdsAreEqual(opId, this.computeIdFor(app, OPERATION_LOCATION, "providedParameter"));
    }

    @Test
    public void idForConfiglessAndConnectionlessOperationChangesInConnection() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Optional<ValueProviderCacheId> opId = this.computeIdFor(app, OPERATION_LOCATION, "providedParameter");
        MatcherAssert.assertThat((Object)opId.isPresent(), (Matcher)Matchers.is((Object)true));
        this.modifyParameter(app, MY_CONNECTION, "requiredForMetadata", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.modifyParameter(app, MY_CONNECTION, "actingParameter", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.checkIdsAreEqual(opId, this.computeIdFor(app, OPERATION_LOCATION, "providedParameter"));
    }

    @Test
    public void idForConfiglessAndConnectionlessSourceNoChanges() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Optional<ValueProviderCacheId> sourceId = this.computeIdFor(app, SOURCE_LOCATION, "providedParameter");
        MatcherAssert.assertThat((Object)sourceId.isPresent(), (Matcher)Matchers.is((Object)true));
        this.checkIdsAreEqual(sourceId, this.computeIdFor(app, SOURCE_LOCATION, "providedParameter"));
    }

    @Test
    public void idForConfiglessAndConnectionlessSourceChangingActingParameter() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Optional<ValueProviderCacheId> sourceId = this.computeIdFor(app, SOURCE_LOCATION, "providedParameter");
        MatcherAssert.assertThat((Object)sourceId.isPresent(), (Matcher)Matchers.is((Object)true));
        this.modifyParameter(app, SOURCE_LOCATION, "actingParameter", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.checkIdsAreDifferent(sourceId, this.computeIdFor(app, SOURCE_LOCATION, "providedParameter"));
    }

    @Test
    public void idForConfiglessAndConnectionlessSourceChangingActingParameterInGroup() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Optional<ValueProviderCacheId> sourceId = this.computeIdFor(app, SOURCE_LOCATION, "providedParameter");
        MatcherAssert.assertThat((Object)sourceId.isPresent(), (Matcher)Matchers.is((Object)true));
        this.modifyParameter(app, SOURCE_LOCATION, "parameterInGroup", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.checkIdsAreDifferent(sourceId, this.computeIdFor(app, SOURCE_LOCATION, "providedParameter"));
    }

    @Test
    public void idForConfiglessAndConnectionlessSourceChangesInConfig() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Optional<ValueProviderCacheId> sourceId = this.computeIdFor(app, SOURCE_LOCATION, "providedParameter");
        MatcherAssert.assertThat((Object)sourceId.isPresent(), (Matcher)Matchers.is((Object)true));
        this.modifyParameter(app, MY_CONFIG, "requiredForMetadata", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.modifyParameter(app, MY_CONFIG, "actingParameter", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.checkIdsAreEqual(sourceId, this.computeIdFor(app, SOURCE_LOCATION, "providedParameter"));
    }

    @Test
    public void idForConfiglessAndConnectionlessSourceChangesInConnection() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Optional<ValueProviderCacheId> sourceId = this.computeIdFor(app, SOURCE_LOCATION, "providedParameter");
        MatcherAssert.assertThat((Object)sourceId.isPresent(), (Matcher)Matchers.is((Object)true));
        this.modifyParameter(app, MY_CONNECTION, "requiredForMetadata", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.modifyParameter(app, MY_CONNECTION, "actingParameter", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.checkIdsAreEqual(sourceId, this.computeIdFor(app, SOURCE_LOCATION, "providedParameter"));
    }

    @Test
    public void idForConfigAwareOperationChangesInConfigNotRequiredForMetadata() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Mockito.when((Object)this.valueProviderModel.requiresConfiguration()).thenReturn((Object)true);
        Optional<ValueProviderCacheId> opId = this.computeIdFor(app, OPERATION_LOCATION, "providedParameter");
        MatcherAssert.assertThat((Object)opId.isPresent(), (Matcher)Matchers.is((Object)true));
        this.modifyParameter(app, MY_CONFIG, "actingParameter", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.checkIdsAreEqual(opId, this.computeIdFor(app, OPERATION_LOCATION, "providedParameter"));
    }

    @Test
    public void idForConfigAwareOperationChangesInConfigRequiredForMetadata() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Mockito.when((Object)this.valueProviderModel.requiresConfiguration()).thenReturn((Object)true);
        Optional<ValueProviderCacheId> opId = this.computeIdFor(app, OPERATION_LOCATION, "providedParameter");
        MatcherAssert.assertThat((Object)opId.isPresent(), (Matcher)Matchers.is((Object)true));
        this.modifyParameter(app, MY_CONFIG, "requiredForMetadata", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.checkIdsAreDifferent(opId, this.computeIdFor(app, OPERATION_LOCATION, "providedParameter"));
    }

    @Test
    public void idForConnectionAwareOperationChangesInConnectionNotRequiredForMetadata() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Mockito.when((Object)this.valueProviderModel.requiresConnection()).thenReturn((Object)true);
        Optional<ValueProviderCacheId> opId = this.computeIdFor(app, OPERATION_LOCATION, "providedParameter");
        MatcherAssert.assertThat((Object)opId.isPresent(), (Matcher)Matchers.is((Object)true));
        this.modifyParameter(app, MY_CONNECTION, "actingParameter", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.checkIdsAreEqual(opId, this.computeIdFor(app, OPERATION_LOCATION, "providedParameter"));
    }

    @Test
    public void idForConnectionAwareOperationChangesInConnectionRequiredForMetadata() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Mockito.when((Object)this.valueProviderModel.requiresConnection()).thenReturn((Object)true);
        Optional<ValueProviderCacheId> opId = this.computeIdFor(app, OPERATION_LOCATION, "providedParameter");
        MatcherAssert.assertThat((Object)opId.isPresent(), (Matcher)Matchers.is((Object)true));
        this.modifyParameter(app, MY_CONNECTION, "requiredForMetadata", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.checkIdsAreDifferent(opId, this.computeIdFor(app, OPERATION_LOCATION, "providedParameter"));
    }

    @Test
    public void idForConfigAwareSourceChangesInConfigNotRequiredForMetadata() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Mockito.when((Object)this.valueProviderModel.requiresConfiguration()).thenReturn((Object)true);
        Optional<ValueProviderCacheId> sourceId = this.computeIdFor(app, SOURCE_LOCATION, "providedParameter");
        MatcherAssert.assertThat((Object)sourceId.isPresent(), (Matcher)Matchers.is((Object)true));
        this.modifyParameter(app, MY_CONFIG, "actingParameter", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.checkIdsAreEqual(sourceId, this.computeIdFor(app, SOURCE_LOCATION, "providedParameter"));
    }

    @Test
    public void idForConfigAwareSourceChangesInConfigRequiredForMetadata() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Mockito.when((Object)this.valueProviderModel.requiresConfiguration()).thenReturn((Object)true);
        Optional<ValueProviderCacheId> sourceId = this.computeIdFor(app, SOURCE_LOCATION, "providedParameter");
        MatcherAssert.assertThat((Object)sourceId.isPresent(), (Matcher)Matchers.is((Object)true));
        this.modifyParameter(app, MY_CONFIG, "requiredForMetadata", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.checkIdsAreDifferent(sourceId, this.computeIdFor(app, SOURCE_LOCATION, "providedParameter"));
    }

    @Test
    public void idForConnectionAwareSourceChangesInConnectionNotRequiredForMetadata() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Mockito.when((Object)this.valueProviderModel.requiresConnection()).thenReturn((Object)true);
        Optional<ValueProviderCacheId> sourceId = this.computeIdFor(app, SOURCE_LOCATION, "providedParameter");
        MatcherAssert.assertThat((Object)sourceId.isPresent(), (Matcher)Matchers.is((Object)true));
        this.modifyParameter(app, MY_CONNECTION, "actingParameter", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.checkIdsAreEqual(sourceId, this.computeIdFor(app, SOURCE_LOCATION, "providedParameter"));
    }

    @Test
    public void idForConnectionAwareSourceChangesInConnectionRequiredForMetadata() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Mockito.when((Object)this.valueProviderModel.requiresConnection()).thenReturn((Object)true);
        Optional<ValueProviderCacheId> sourceId = this.computeIdFor(app, SOURCE_LOCATION, "providedParameter");
        MatcherAssert.assertThat((Object)sourceId.isPresent(), (Matcher)Matchers.is((Object)true));
        this.modifyParameter(app, MY_CONNECTION, "requiredForMetadata", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.checkIdsAreDifferent(sourceId, this.computeIdFor(app, SOURCE_LOCATION, "providedParameter"));
    }

    @Test
    public void equalConfigsWithDifferentNameGetSameHash() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        ConfigurationElementDeclaration config = (ConfigurationElementDeclaration)app.getGlobalElements().get(0);
        app.addGlobalElement((GlobalElementDeclaration)this.declareConfig((ConnectionElementDeclaration)config.getConnection().get(), "newName", "requiredForMetadata", "actingParameter", "providedParameter", "parameterInGroup"));
        Optional<ValueProviderCacheId> config1Id = this.computeIdFor(app, MY_CONFIG, "providedParameter");
        Optional<ValueProviderCacheId> config2Id = this.computeIdFor(app, "newName", "providedParameter");
        this.checkIdsAreEqual(config1Id, config2Id);
    }

    @Test
    public void differentConfigsWithSameParametersGetDifferentHashs() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        ConfigurationElementDeclaration config = (ConfigurationElementDeclaration)app.getGlobalElements().get(0);
        app.addGlobalElement((GlobalElementDeclaration)this.declareOtherConfig((ConnectionElementDeclaration)config.getConnection().get(), "newName", "requiredForMetadata", "actingParameter", "providedParameter", "parameterInGroup"));
        Optional<ValueProviderCacheId> config1Id = this.computeIdFor(app, MY_CONFIG, "providedParameter");
        Optional<ValueProviderCacheId> config2Id = this.computeIdFor(app, "newName", "providedParameter");
        this.checkIdsAreDifferent(config1Id, config2Id);
    }

    @Test
    public void differentValueProviderNameGetsDifferentHash() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Mockito.when((Object)this.valueProviderModel.requiresConnection()).thenReturn((Object)true);
        Mockito.when((Object)this.valueProviderModel.requiresConfiguration()).thenReturn((Object)true);
        Optional<ValueProviderCacheId> opId1 = this.computeIdFor(app, OPERATION_LOCATION, "providedParameter");
        Mockito.when((Object)this.valueProviderModel.getProviderName()).thenReturn((Object)"newValueProviderName");
        Optional<ValueProviderCacheId> opId2 = this.computeIdFor(app, OPERATION_LOCATION, "providedParameter");
        this.checkIdsAreDifferent(opId1, opId2);
    }

    private static class Locator
    implements ComponentLocator<ComponentAst> {
        private final Map<org.mule.runtime.api.component.location.Location, ComponentModel> components = new HashMap<org.mule.runtime.api.component.location.Location, ComponentModel>();

        Locator(ApplicationModel app) {
            app.getRootComponentModel().getInnerComponents().forEach(this::addComponent);
        }

        public Optional<ComponentAst> get(org.mule.runtime.api.component.location.Location location) {
            return Optional.ofNullable(this.components.get(location)).map(cm -> (ComponentAst)cm);
        }

        private org.mule.runtime.api.component.location.Location getLocation(ComponentModel component) {
            return org.mule.runtime.api.component.location.Location.builderFromStringRepresentation((String)component.getComponentLocation().getLocation()).build();
        }

        private void addComponent(ComponentModel component) {
            this.components.put(this.getLocation(component), component);
            component.getInnerComponents().forEach(this::addComponent);
        }
    }
}

