/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.dsl.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.internal.creation.MockSettingsImpl;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.metadata.resolving.AttributesTypeResolver;
import org.mule.runtime.api.metadata.resolving.InputTypeResolver;
import org.mule.runtime.api.metadata.resolving.OutputTypeResolver;
import org.mule.runtime.api.metadata.resolving.PartialTypeKeysResolver;
import org.mule.runtime.api.metadata.resolving.QueryEntityResolver;
import org.mule.runtime.api.metadata.resolving.TypeKeysResolver;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.app.declaration.api.ComponentElementDeclaration;
import org.mule.runtime.app.declaration.api.ConfigurationElementDeclaration;
import org.mule.runtime.app.declaration.api.ConnectionElementDeclaration;
import org.mule.runtime.app.declaration.api.ConstructElementDeclaration;
import org.mule.runtime.app.declaration.api.GlobalElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterGroupElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterValue;
import org.mule.runtime.app.declaration.api.fluent.ConfigurationElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ConnectionElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ConstructElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.OperationElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ParameterListValue;
import org.mule.runtime.app.declaration.api.fluent.ParameterObjectValue;
import org.mule.runtime.app.declaration.api.fluent.ParameterSimpleValue;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.config.api.dsl.model.metadata.ModelBasedMetadataCacheIdGeneratorFactory;
import org.mule.runtime.config.api.dsl.processor.ArtifactConfig;
import org.mule.runtime.config.dsl.model.AbstractDslModelTestCase;
import org.mule.runtime.config.internal.model.ApplicationModel;
import org.mule.runtime.config.internal.model.ComponentModel;
import org.mule.runtime.core.api.extension.MuleExtensionModelProvider;
import org.mule.runtime.core.internal.metadata.NullMetadataResolverFactory;
import org.mule.runtime.core.internal.metadata.cache.MetadataCacheId;
import org.mule.runtime.core.internal.metadata.cache.MetadataCacheIdGenerator;
import org.mule.runtime.core.internal.metadata.cache.MetadataCacheIdGeneratorFactory;
import org.mule.runtime.extension.api.metadata.MetadataResolverFactory;
import org.mule.runtime.extension.api.property.MetadataKeyIdModelProperty;
import org.mule.runtime.extension.api.property.MetadataKeyPartModelProperty;
import org.mule.runtime.extension.api.property.RequiredForMetadataModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.MetadataResolverFactoryModelProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=MockitoJUnitRunner.class)
public class ModelBasedMetadataCacheKeyGeneratorTestCase
extends AbstractDslModelTestCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelBasedMetadataCacheKeyGeneratorTestCase.class);
    private static final String MY_FLOW = "myFlow";
    private static final String MY_CONFIG = "myConfig";
    private static final String METADATA_KEY_PART_1 = "partOne";
    private static final String METADATA_KEY_PART_2 = "partTwo";
    private static final String METADATA_KEY_PART_3 = "partThree";
    private static final String METADATA_KEY_GROUP = "Key Group";
    private static final String CATEGORY_NAME = "category";
    private static final String OPERATION_LOCATION = "myFlow/processors/0";
    private static final String ANOTHER_OPERATION_LOCATION = "myFlow/processors/1";
    public static final String MY_GLOBAL_TEMPLATE = "myGlobalTemplate";
    private Set<ExtensionModel> extensions;
    private DslResolvingContext dslResolvingContext;
    private ElementDeclarer declarer;

    @Before
    public void setUp() throws Exception {
        this.extensions = ImmutableSet.builder().add((Object)MuleExtensionModelProvider.getExtensionModel()).add((Object)this.mockExtension).build();
        this.dslResolvingContext = DslResolvingContext.getDefault(this.extensions);
        this.declarer = ElementDeclarer.forExtension((String)"extension");
        this.mockSimpleMetadataKeyId(this.operation);
        this.mockSimpleMetadataKeyId(this.anotherOperation);
    }

    @Test
    public void idempotentHashCalculation() throws Exception {
        ApplicationModel applicationModel = this.loadApplicationModel(this.getBaseApp());
        HashMap hashByLocation = new HashMap();
        MetadataCacheIdGenerator<ComponentAst> generator = this.createGenerator(applicationModel);
        applicationModel.getRootComponentModel().getInnerComponents().forEach(component -> {
            MetadataCacheId cfr_ignored_0 = (MetadataCacheId)hashByLocation.put(component.getComponentLocation().getLocation(), generator.getIdForComponentMetadata((Object)((ComponentAst)component)).get());
        });
        LOGGER.debug(((Object)hashByLocation).toString());
        ApplicationModel reload = this.loadApplicationModel(this.getBaseApp());
        MetadataCacheIdGenerator<ComponentAst> otherGenerator = this.createGenerator(reload);
        reload.getRootComponentModel().getInnerComponents().forEach(component -> {
            String location = component.getComponentLocation().getLocation();
            MetadataCacheId previousHash = (MetadataCacheId)hashByLocation.get(location);
            MatcherAssert.assertThat((Object)previousHash, (Matcher)Matchers.is(otherGenerator.getIdForComponentMetadata((Object)((ComponentAst)component)).get()));
        });
    }

    @Test
    public void configurationParameterModifiesHash() throws Exception {
        ArtifactDeclaration declaration = this.getBaseApp();
        MetadataCacheId cacheId = this.getIdForComponent(declaration);
        LOGGER.debug(cacheId.toString());
        ((ParameterElementDeclaration)((ParameterGroupElementDeclaration)((ConfigurationElementDeclaration)declaration.getGlobalElements().get(0)).getParameterGroups().get(0)).getParameter("otherName").get()).setValue(ParameterSimpleValue.of((String)"otherText"));
        MetadataCacheId otherKeyParts = this.getIdForComponent(declaration);
        LOGGER.debug(otherKeyParts.toString());
        MatcherAssert.assertThat((Object)cacheId, (Matcher)Matchers.not((Object)otherKeyParts));
    }

    @Test
    public void configurationParameterModifiesGlobalHash() throws Exception {
        ArtifactDeclaration declaration = this.getBaseApp();
        MetadataCacheId cacheId = this.getGlobalId(declaration);
        LOGGER.debug(cacheId.toString());
        ((ParameterElementDeclaration)((ParameterGroupElementDeclaration)((ConfigurationElementDeclaration)declaration.getGlobalElements().get(0)).getParameterGroups().get(0)).getParameter("otherName").get()).setValue(ParameterSimpleValue.of((String)"otherText"));
        MetadataCacheId otherKeyParts = this.getGlobalId(declaration);
        LOGGER.debug(otherKeyParts.toString());
        MatcherAssert.assertThat((Object)cacheId, (Matcher)Matchers.not((Object)otherKeyParts));
    }

    @Test
    public void operationParameterDoesNotModifyHash() throws Exception {
        ArtifactDeclaration declaration = this.getBaseApp();
        MetadataCacheId keyParts = this.getIdForComponent(declaration);
        LOGGER.debug(keyParts.toString());
        ComponentElementDeclaration operationDeclaration = (ComponentElementDeclaration)((ConstructElementDeclaration)declaration.getGlobalElements().get(1)).getComponents().get(0);
        ((ParameterElementDeclaration)((ParameterGroupElementDeclaration)operationDeclaration.getParameterGroups().get(0)).getParameter("myCamelCaseName").get()).setValue(ParameterSimpleValue.of((String)"otherValue"));
        ((ParameterGroupElementDeclaration)operationDeclaration.getParameterGroups().get(0)).addParameter(this.newParam("otherName", "notKey"));
        MetadataCacheId otherKeyParts = this.getIdForComponent(declaration);
        LOGGER.debug(otherKeyParts.toString());
        MatcherAssert.assertThat((Object)keyParts, (Matcher)Matchers.is((Object)otherKeyParts));
    }

    @Test
    public void operationParameterDoesNotModifyGlobal() throws Exception {
        ArtifactDeclaration declaration = this.getBaseApp();
        MetadataCacheId keyParts = this.getGlobalId(declaration);
        LOGGER.debug(keyParts.toString());
        ComponentElementDeclaration operationDeclaration = (ComponentElementDeclaration)((ConstructElementDeclaration)declaration.getGlobalElements().get(1)).getComponents().get(0);
        ((ParameterElementDeclaration)((ParameterGroupElementDeclaration)operationDeclaration.getParameterGroups().get(0)).getParameter("myCamelCaseName").get()).setValue(ParameterSimpleValue.of((String)"otherValue"));
        ((ParameterGroupElementDeclaration)operationDeclaration.getParameterGroups().get(0)).addParameter(this.newParam("otherName", "notKey"));
        MetadataCacheId otherKeyParts = this.getGlobalId(declaration);
        LOGGER.debug(otherKeyParts.toString());
        MatcherAssert.assertThat((Object)keyParts, (Matcher)Matchers.is((Object)otherKeyParts));
    }

    @Test
    public void metadataKeyModifiesHash() throws Exception {
        MetadataCacheId keyParts = this.getIdForComponent(this.getBaseApp());
        LOGGER.debug(keyParts.toString());
        ArtifactDeclaration declaration = this.getBaseApp();
        ComponentElementDeclaration operationDeclaration = (ComponentElementDeclaration)((ConstructElementDeclaration)declaration.getGlobalElements().get(1)).getComponents().get(0);
        ParameterElementDeclaration metadataKeyPartParam = this.newParam(METADATA_KEY_PART_1, "User");
        ((ParameterGroupElementDeclaration)operationDeclaration.getParameterGroups().get(0)).addParameter(metadataKeyPartParam);
        MetadataCacheId otherKeyParts = this.getIdForComponent(declaration);
        LOGGER.debug(otherKeyParts.toString());
        metadataKeyPartParam.setValue(ParameterSimpleValue.of((String)"Document"));
        MetadataCacheId finalKeyParts = this.getIdForComponent(declaration);
        LOGGER.debug(finalKeyParts.toString());
        MatcherAssert.assertThat((Object)otherKeyParts, (Matcher)Matchers.not((Object)keyParts));
        MatcherAssert.assertThat((Object)finalKeyParts, (Matcher)Matchers.not((Object)keyParts));
        MatcherAssert.assertThat((Object)finalKeyParts, (Matcher)Matchers.not((Object)otherKeyParts));
    }

    @Test
    public void metadataCategoryModifiesGlobalHash() throws Exception {
        ArtifactDeclaration declaration = this.getBaseApp();
        ComponentElementDeclaration operationDeclaration = (ComponentElementDeclaration)((ConstructElementDeclaration)declaration.getGlobalElements().get(1)).getComponents().get(0);
        ParameterElementDeclaration metadataKeyPartParam = this.newParam(METADATA_KEY_PART_1, "User");
        ((ParameterGroupElementDeclaration)operationDeclaration.getParameterGroups().get(0)).addParameter(metadataKeyPartParam);
        MetadataCacheId id = this.getGlobalId(declaration);
        LOGGER.debug(id.toString());
        Mockito.when((Object)this.operation.getModelProperty(MetadataKeyIdModelProperty.class)).thenReturn(Optional.of(new MetadataKeyIdModelProperty(this.TYPE_LOADER.load(String.class), METADATA_KEY_PART_1, "OTHER_CATEGORY")));
        MetadataCacheId otherId = this.getGlobalId(declaration);
        LOGGER.debug(id.toString());
        MatcherAssert.assertThat((Object)id, (Matcher)Matchers.not((Object)otherId));
    }

    @Test
    public void configurationParametersAsRequireForMetadataModifiesHash() throws Exception {
        this.mockRequiredForMetadataModelProperty((EnrichableModel)this.configuration, null);
        this.mockRequiredForMetadataModelProperty((EnrichableModel)this.connectionProvider, null);
        MetadataCacheId keyParts = this.getIdForComponent(this.getBaseApp());
        LOGGER.debug(keyParts.toString());
        this.mockRequiredForMetadataModelProperty((EnrichableModel)this.configuration, Arrays.asList(this.behaviourParameter.getName()));
        this.mockRequiredForMetadataModelProperty((EnrichableModel)this.connectionProvider, null);
        MetadataCacheId otherKeyParts = this.getIdForComponent(this.getBaseApp());
        LOGGER.debug(otherKeyParts.toString());
        MatcherAssert.assertThat((Object)keyParts, (Matcher)Matchers.not((Object)otherKeyParts));
    }

    @Test
    public void connectionParametersAsRequireForMetadataModifiesHash() throws Exception {
        this.mockRequiredForMetadataModelProperty((EnrichableModel)this.configuration, null);
        this.mockRequiredForMetadataModelProperty((EnrichableModel)this.connectionProvider, null);
        MetadataCacheId keyParts = this.getIdForComponent(this.getBaseApp());
        LOGGER.debug(keyParts.toString());
        this.mockRequiredForMetadataModelProperty((EnrichableModel)this.configuration, null);
        this.mockRequiredForMetadataModelProperty((EnrichableModel)this.connectionProvider, Arrays.asList(this.behaviourParameter.getName()));
        MetadataCacheId otherKeyParts = this.getIdForComponent(this.getBaseApp());
        LOGGER.debug(otherKeyParts.toString());
        MatcherAssert.assertThat((Object)keyParts, (Matcher)Matchers.not((Object)otherKeyParts));
    }

    @Test
    public void differencesInRequiredParametersForMetadataYieldsDifferentHashes() throws Exception {
        this.mockRequiredForMetadataModelProperty((EnrichableModel)this.configuration, null);
        this.mockRequiredForMetadataModelProperty((EnrichableModel)this.connectionProvider, Arrays.asList(this.contentParameter.getName()));
        MetadataCacheId keyParts = this.getIdForComponent(this.getBaseApp());
        LOGGER.debug(keyParts.toString());
        this.mockRequiredForMetadataModelProperty((EnrichableModel)this.configuration, null);
        this.mockRequiredForMetadataModelProperty((EnrichableModel)this.connectionProvider, Arrays.asList(this.behaviourParameter.getName()));
        MetadataCacheId otherKeyParts = this.getIdForComponent(this.getBaseApp());
        LOGGER.debug(otherKeyParts.toString());
        MatcherAssert.assertThat((Object)keyParts, (Matcher)Matchers.not((Object)otherKeyParts));
    }

    @Test
    public void metadataKeyCacheIdForConfigModelShouldIncludeConnectionParameters() throws Exception {
        MetadataCacheId keyParts = this.getKeyHash(this.getBaseApp(), MY_CONFIG);
        LOGGER.debug(keyParts.toString());
        ArtifactDeclaration declaration = this.getBaseApp();
        ConnectionElementDeclaration connectionElementDeclaration = (ConnectionElementDeclaration)((ConfigurationElementDeclaration)declaration.getGlobalElements().get(0)).getConnection().get();
        ((ParameterElementDeclaration)((ParameterGroupElementDeclaration)connectionElementDeclaration.getParameterGroups().get(0)).getParameter("otherName").get()).setValue(ParameterSimpleValue.plain((String)"changed"));
        MetadataCacheId otherKeyParts = this.getKeyHash(declaration, MY_CONFIG);
        LOGGER.debug(otherKeyParts.toString());
        MatcherAssert.assertThat((Object)otherKeyParts, (Matcher)Matchers.not((Matcher)Matchers.is((Object)keyParts)));
    }

    @Test
    public void metadataKeyDoesNotModifyKeyHash() throws Exception {
        MetadataCacheId keyParts = this.getKeyHash(this.getBaseApp(), OPERATION_LOCATION);
        LOGGER.debug(keyParts.toString());
        ArtifactDeclaration declaration = this.getBaseApp();
        ComponentElementDeclaration operationDeclaration = (ComponentElementDeclaration)((ConstructElementDeclaration)declaration.getGlobalElements().get(1)).getComponents().get(0);
        ParameterElementDeclaration metadataKeyPartParam = this.newParam(METADATA_KEY_PART_1, "User");
        ((ParameterGroupElementDeclaration)operationDeclaration.getParameterGroups().get(0)).addParameter(metadataKeyPartParam);
        MetadataCacheId otherKeyParts = this.getKeyHash(declaration, OPERATION_LOCATION);
        LOGGER.debug(otherKeyParts.toString());
        metadataKeyPartParam.setValue(ParameterSimpleValue.of((String)"Document"));
        MetadataCacheId finalKeyParts = this.getKeyHash(declaration, OPERATION_LOCATION);
        LOGGER.debug(finalKeyParts.toString());
        MatcherAssert.assertThat((Object)otherKeyParts, (Matcher)Matchers.is((Object)keyParts));
        MatcherAssert.assertThat((Object)finalKeyParts, (Matcher)Matchers.is((Object)keyParts));
        MatcherAssert.assertThat((Object)finalKeyParts, (Matcher)Matchers.is((Object)otherKeyParts));
    }

    @Test
    public void multiLevelMetadataKeyModifiesHash() throws Exception {
        this.mockMultiLevelMetadataKeyId(this.operation);
        ArtifactDeclaration declaration = this.getBaseApp();
        ComponentElementDeclaration operationDeclaration = (ComponentElementDeclaration)((ConstructElementDeclaration)declaration.getGlobalElements().get(1)).getComponents().get(0);
        ParameterGroupElementDeclaration keyGroup = new ParameterGroupElementDeclaration(METADATA_KEY_GROUP);
        operationDeclaration.addParameterGroup(keyGroup);
        keyGroup.addParameter(this.newParam(METADATA_KEY_PART_1, "localhost"));
        keyGroup.addParameter(this.newParam(METADATA_KEY_PART_2, "8080"));
        MetadataCacheId twoLevelParts = this.getIdForComponent(declaration);
        LOGGER.debug(twoLevelParts.toString());
        keyGroup.addParameter(this.newParam(METADATA_KEY_PART_3, "/api"));
        MetadataCacheId otherKeyParts = this.getIdForComponent(declaration);
        LOGGER.debug(otherKeyParts.toString());
        MatcherAssert.assertThat((Object)otherKeyParts, (Matcher)Matchers.not((Object)twoLevelParts));
    }

    @Test
    public void multiLevelPartValueModifiesHash() throws Exception {
        this.mockMultiLevelMetadataKeyId(this.operation);
        ArtifactDeclaration declaration = this.getBaseApp();
        ComponentElementDeclaration operationDeclaration = (ComponentElementDeclaration)((ConstructElementDeclaration)declaration.getGlobalElements().get(1)).getComponents().get(0);
        ParameterGroupElementDeclaration keyGroup = new ParameterGroupElementDeclaration(METADATA_KEY_GROUP);
        operationDeclaration.addParameterGroup(keyGroup);
        keyGroup.addParameter(this.newParam(METADATA_KEY_PART_1, "localhost"));
        ParameterElementDeclaration partTwo = this.newParam(METADATA_KEY_PART_2, "8080");
        keyGroup.addParameter(partTwo);
        keyGroup.addParameter(this.newParam(METADATA_KEY_PART_3, "/api"));
        MetadataCacheId original = this.getIdForComponent(declaration);
        LOGGER.debug(original.toString());
        partTwo.setValue(ParameterSimpleValue.of((String)"6666"));
        MetadataCacheId newHash = this.getIdForComponent(declaration);
        LOGGER.debug(newHash.toString());
        LOGGER.debug(newHash.toString());
        MatcherAssert.assertThat((Object)original, (Matcher)Matchers.not((Object)newHash));
    }

    @Test
    public void multiLevelPartValueDoesNotModifyHashForKeys() throws Exception {
        this.mockMultiLevelMetadataKeyId(this.operation);
        ArtifactDeclaration declaration = this.getBaseApp();
        ComponentElementDeclaration operationDeclaration = (ComponentElementDeclaration)((ConstructElementDeclaration)declaration.getGlobalElements().get(1)).getComponents().get(0);
        ParameterGroupElementDeclaration keyGroup = new ParameterGroupElementDeclaration(METADATA_KEY_GROUP);
        operationDeclaration.addParameterGroup(keyGroup);
        keyGroup.addParameter(this.newParam(METADATA_KEY_PART_1, "localhost"));
        ParameterElementDeclaration partTwo = this.newParam(METADATA_KEY_PART_2, "8080");
        keyGroup.addParameter(partTwo);
        keyGroup.addParameter(this.newParam(METADATA_KEY_PART_3, "/api"));
        MetadataCacheId original = this.getKeyHash(declaration, OPERATION_LOCATION);
        LOGGER.debug(original.toString());
        partTwo.setValue(ParameterSimpleValue.of((String)"6666"));
        MetadataCacheId newHash = this.getKeyHash(declaration, OPERATION_LOCATION);
        LOGGER.debug(newHash.toString());
        MatcherAssert.assertThat((Object)original, (Matcher)Matchers.is((Object)newHash));
    }

    @Test
    public void multiLevelPartValueDoesNotModifyGlobalId() throws Exception {
        this.mockMultiLevelMetadataKeyId(this.operation);
        ArtifactDeclaration declaration = this.getBaseApp();
        ComponentElementDeclaration operationDeclaration = (ComponentElementDeclaration)((ConstructElementDeclaration)declaration.getGlobalElements().get(1)).getComponents().get(0);
        ParameterGroupElementDeclaration keyGroup = new ParameterGroupElementDeclaration(METADATA_KEY_GROUP);
        operationDeclaration.addParameterGroup(keyGroup);
        keyGroup.addParameter(this.newParam(METADATA_KEY_PART_1, "localhost"));
        ParameterElementDeclaration partTwo = this.newParam(METADATA_KEY_PART_2, "8080");
        keyGroup.addParameter(partTwo);
        keyGroup.addParameter(this.newParam(METADATA_KEY_PART_3, "/api"));
        MetadataCacheId original = this.getGlobalId(declaration);
        LOGGER.debug(original.toString());
        partTwo.setValue(ParameterSimpleValue.of((String)"6666"));
        MetadataCacheId newHash = this.getGlobalId(declaration);
        LOGGER.debug(newHash.toString());
        MatcherAssert.assertThat((Object)original, (Matcher)Matchers.is((Object)newHash));
    }

    @Test
    public void partialFetchingMultiLevelPartValueModifiesHashForKeys() throws Exception {
        this.mockMultiLevelMetadataKeyId(this.operation);
        this.setPartialFetchingMock(this.operation);
        this.mockTypeResolversInformationModelProperty((EnrichableModel)this.operation, CATEGORY_NAME, "outputResolver", "attributesResolver", Collections.emptyMap(), "keysResolver");
        ArtifactDeclaration declaration = this.getBaseApp();
        ComponentElementDeclaration operationDeclaration = (ComponentElementDeclaration)((ConstructElementDeclaration)declaration.getGlobalElements().get(1)).getComponents().get(0);
        ParameterGroupElementDeclaration keyGroup = new ParameterGroupElementDeclaration(METADATA_KEY_GROUP);
        operationDeclaration.addParameterGroup(keyGroup);
        keyGroup.addParameter(this.newParam(METADATA_KEY_PART_1, "localhost"));
        ParameterElementDeclaration partTwo = this.newParam(METADATA_KEY_PART_2, "8080");
        keyGroup.addParameter(partTwo);
        keyGroup.addParameter(this.newParam(METADATA_KEY_PART_3, "/api"));
        MetadataCacheId original = this.getKeyHash(declaration, OPERATION_LOCATION);
        LOGGER.debug(original.toString());
        partTwo.setValue(ParameterSimpleValue.of((String)"6666"));
        MetadataCacheId newHash = this.getKeyHash(declaration, OPERATION_LOCATION);
        LOGGER.debug(newHash.toString());
        MatcherAssert.assertThat((Object)original, (Matcher)Matchers.not((Object)newHash));
    }

    @Test
    public void sameSimpleMetadataKeyWithSameResolverOnDifferentOperationsGeneratesSameHashForKeys() throws Exception {
        this.mockTypeResolversInformationModelProperty((EnrichableModel)this.operation, CATEGORY_NAME, "outputResolver", "attributesResolver", Collections.emptyMap(), "keysResolver");
        this.mockTypeResolversInformationModelProperty((EnrichableModel)this.anotherOperation, CATEGORY_NAME, "outputResolver", "attributesResolver", Collections.emptyMap(), "keysResolver");
        ArtifactDeclaration declaration = this.getBaseApp();
        ComponentElementDeclaration operationDeclaration = (ComponentElementDeclaration)((ConstructElementDeclaration)declaration.getGlobalElements().get(1)).getComponents().get(0);
        ParameterElementDeclaration metadataKeyPartParam = this.newParam(METADATA_KEY_PART_1, "User");
        ((ParameterGroupElementDeclaration)operationDeclaration.getParameterGroups().get(0)).addParameter(metadataKeyPartParam);
        ComponentElementDeclaration anotherOperationDeclaration = (ComponentElementDeclaration)((ConstructElementDeclaration)declaration.getGlobalElements().get(1)).getComponents().get(1);
        ParameterElementDeclaration anotherOperationMetadataKeyPartParam = this.newParam(METADATA_KEY_PART_1, "User");
        ((ParameterGroupElementDeclaration)anotherOperationDeclaration.getParameterGroups().get(0)).addParameter(anotherOperationMetadataKeyPartParam);
        MetadataCacheId operationKeysParts = this.getKeyHash(declaration, OPERATION_LOCATION);
        LOGGER.debug(operationKeysParts.toString());
        MetadataCacheId anotherOperationKeysParts = this.getKeyHash(declaration, ANOTHER_OPERATION_LOCATION);
        LOGGER.debug(anotherOperationKeysParts.toString());
        MatcherAssert.assertThat((Object)anotherOperationKeysParts, (Matcher)Matchers.is((Object)operationKeysParts));
    }

    @Test
    public void multilevelPartsWithSameValuesOnDifferentOperationsGeneratesSameHashForKeys() throws Exception {
        this.mockMultiLevelMetadataKeyId(this.operation);
        this.mockMultiLevelMetadataKeyId(this.anotherOperation);
        this.mockTypeResolversInformationModelProperty((EnrichableModel)this.operation, CATEGORY_NAME, "outputResolver", "attributesResolver", Collections.emptyMap(), "keysResolver");
        this.mockTypeResolversInformationModelProperty((EnrichableModel)this.anotherOperation, CATEGORY_NAME, "outputResolver", "attributesResolver", Collections.emptyMap(), "keysResolver");
        ArtifactDeclaration declaration = this.getBaseApp();
        ComponentElementDeclaration operationDeclaration = (ComponentElementDeclaration)((ConstructElementDeclaration)declaration.getGlobalElements().get(1)).getComponents().get(0);
        ComponentElementDeclaration anotherOperationDeclaration = (ComponentElementDeclaration)((ConstructElementDeclaration)declaration.getGlobalElements().get(1)).getComponents().get(1);
        ParameterGroupElementDeclaration keyGroup = new ParameterGroupElementDeclaration(METADATA_KEY_GROUP);
        operationDeclaration.addParameterGroup(keyGroup);
        anotherOperationDeclaration.addParameterGroup(keyGroup);
        keyGroup.addParameter(this.newParam(METADATA_KEY_PART_1, "localhost"));
        ParameterElementDeclaration partTwo = this.newParam(METADATA_KEY_PART_2, "8080");
        keyGroup.addParameter(partTwo);
        keyGroup.addParameter(this.newParam(METADATA_KEY_PART_3, "/api"));
        MetadataCacheId operationHash = this.getKeyHash(declaration, OPERATION_LOCATION);
        MetadataCacheId anotherOperationHash = this.getKeyHash(declaration, ANOTHER_OPERATION_LOCATION);
        LOGGER.debug(operationHash.toString());
        LOGGER.debug(anotherOperationHash.toString());
        MatcherAssert.assertThat((Object)operationHash, (Matcher)Matchers.is((Object)anotherOperationHash));
    }

    @Test
    public void multilevelPartsWithDifferentValuesOnDifferentOperationsGeneratesSameHashForKeys() throws Exception {
        this.mockMultiLevelMetadataKeyId(this.operation);
        this.mockMultiLevelMetadataKeyId(this.anotherOperation);
        this.mockTypeResolversInformationModelProperty((EnrichableModel)this.operation, CATEGORY_NAME, "outputResolver", "attributesResolver", Collections.emptyMap(), "keysResolver");
        this.mockTypeResolversInformationModelProperty((EnrichableModel)this.anotherOperation, CATEGORY_NAME, "outputResolver", "attributesResolver", Collections.emptyMap(), "keysResolver");
        ArtifactDeclaration declaration = this.getBaseApp();
        ComponentElementDeclaration operationDeclaration = (ComponentElementDeclaration)((ConstructElementDeclaration)declaration.getGlobalElements().get(1)).getComponents().get(0);
        ComponentElementDeclaration anotherOperationDeclaration = (ComponentElementDeclaration)((ConstructElementDeclaration)declaration.getGlobalElements().get(1)).getComponents().get(1);
        ParameterGroupElementDeclaration keyGroup = new ParameterGroupElementDeclaration(METADATA_KEY_GROUP);
        ParameterGroupElementDeclaration anotherKeyGroup = new ParameterGroupElementDeclaration(METADATA_KEY_GROUP);
        operationDeclaration.addParameterGroup(keyGroup);
        anotherOperationDeclaration.addParameterGroup(anotherKeyGroup);
        String keyPart1Value = "localhost";
        keyGroup.addParameter(this.newParam(METADATA_KEY_PART_1, "localhost"));
        anotherKeyGroup.addParameter(this.newParam(METADATA_KEY_PART_1, "localhost"));
        keyGroup.addParameter(this.newParam(METADATA_KEY_PART_2, "8080"));
        anotherKeyGroup.addParameter(this.newParam(METADATA_KEY_PART_2, "6666"));
        String keyPart3Value = "/api";
        keyGroup.addParameter(this.newParam(METADATA_KEY_PART_3, "/api"));
        anotherKeyGroup.addParameter(this.newParam(METADATA_KEY_PART_3, "/api"));
        MetadataCacheId operationHash = this.getKeyHash(declaration, OPERATION_LOCATION);
        MetadataCacheId anotherOperationHash = this.getKeyHash(declaration, ANOTHER_OPERATION_LOCATION);
        LOGGER.debug(operationHash.toString());
        LOGGER.debug(anotherOperationHash.toString());
        MatcherAssert.assertThat((Object)operationHash, (Matcher)Matchers.is((Object)anotherOperationHash));
    }

    @Test
    public void partialFetchingWithSameValuesOnDifferentOperationsGeneratesSameHashForKeys() throws Exception {
        this.mockMultiLevelMetadataKeyId(this.operation);
        this.mockMultiLevelMetadataKeyId(this.anotherOperation);
        this.setPartialFetchingMock(this.operation);
        this.setPartialFetchingMock(this.anotherOperation);
        this.mockTypeResolversInformationModelProperty((EnrichableModel)this.operation, CATEGORY_NAME, "outputResolver", "attributesResolver", Collections.emptyMap(), "keysResolver");
        this.mockTypeResolversInformationModelProperty((EnrichableModel)this.anotherOperation, CATEGORY_NAME, "outputResolver", "attributesResolver", Collections.emptyMap(), "keysResolver");
        ArtifactDeclaration declaration = this.getBaseApp();
        ComponentElementDeclaration operationDeclaration = (ComponentElementDeclaration)((ConstructElementDeclaration)declaration.getGlobalElements().get(1)).getComponents().get(0);
        ComponentElementDeclaration anotherOperationDeclaration = (ComponentElementDeclaration)((ConstructElementDeclaration)declaration.getGlobalElements().get(1)).getComponents().get(1);
        ParameterGroupElementDeclaration keyGroup = new ParameterGroupElementDeclaration(METADATA_KEY_GROUP);
        ParameterGroupElementDeclaration anotherKeyGroup = new ParameterGroupElementDeclaration(METADATA_KEY_GROUP);
        operationDeclaration.addParameterGroup(keyGroup);
        anotherOperationDeclaration.addParameterGroup(anotherKeyGroup);
        String keyPart1Value = "localhost";
        keyGroup.addParameter(this.newParam(METADATA_KEY_PART_1, "localhost"));
        anotherKeyGroup.addParameter(this.newParam(METADATA_KEY_PART_1, "localhost"));
        String keyPart2Value = "8080";
        keyGroup.addParameter(this.newParam(METADATA_KEY_PART_2, "8080"));
        anotherKeyGroup.addParameter(this.newParam(METADATA_KEY_PART_2, "8080"));
        String keyPart3Value = "/api";
        keyGroup.addParameter(this.newParam(METADATA_KEY_PART_3, "/api"));
        anotherKeyGroup.addParameter(this.newParam(METADATA_KEY_PART_3, "/api"));
        MetadataCacheId operationHash = this.getKeyHash(declaration, OPERATION_LOCATION);
        MetadataCacheId anotherOperationHash = this.getKeyHash(declaration, ANOTHER_OPERATION_LOCATION);
        LOGGER.debug(operationHash.toString());
        LOGGER.debug(anotherOperationHash.toString());
        MatcherAssert.assertThat((Object)operationHash, (Matcher)Matchers.is((Object)anotherOperationHash));
    }

    @Test
    public void partialFetchingWithDifferentValuesOnDifferentOperationsGeneratesSameHashForKeys() throws Exception {
        this.mockMultiLevelMetadataKeyId(this.operation);
        this.mockMultiLevelMetadataKeyId(this.anotherOperation);
        this.setPartialFetchingMock(this.operation);
        this.setPartialFetchingMock(this.anotherOperation);
        ArtifactDeclaration declaration = this.getBaseApp();
        ComponentElementDeclaration operationDeclaration = (ComponentElementDeclaration)((ConstructElementDeclaration)declaration.getGlobalElements().get(1)).getComponents().get(0);
        ComponentElementDeclaration anotherOperationDeclaration = (ComponentElementDeclaration)((ConstructElementDeclaration)declaration.getGlobalElements().get(1)).getComponents().get(1);
        ParameterGroupElementDeclaration keyGroup = new ParameterGroupElementDeclaration(METADATA_KEY_GROUP);
        ParameterGroupElementDeclaration anotherKeyGroup = new ParameterGroupElementDeclaration(METADATA_KEY_GROUP);
        operationDeclaration.addParameterGroup(keyGroup);
        anotherOperationDeclaration.addParameterGroup(anotherKeyGroup);
        String keyPart1Value = "localhost";
        keyGroup.addParameter(this.newParam(METADATA_KEY_PART_1, "localhost"));
        anotherKeyGroup.addParameter(this.newParam(METADATA_KEY_PART_1, "localhost"));
        keyGroup.addParameter(this.newParam(METADATA_KEY_PART_2, "8080"));
        anotherKeyGroup.addParameter(this.newParam(METADATA_KEY_PART_2, "6666"));
        String keyPart3Value = "/api";
        keyGroup.addParameter(this.newParam(METADATA_KEY_PART_3, "/api"));
        anotherKeyGroup.addParameter(this.newParam(METADATA_KEY_PART_3, "/api"));
        MetadataCacheId operationHash = this.getKeyHash(declaration, OPERATION_LOCATION);
        MetadataCacheId anotherOperationHash = this.getKeyHash(declaration, ANOTHER_OPERATION_LOCATION);
        LOGGER.debug(operationHash.toString());
        LOGGER.debug(anotherOperationHash.toString());
        MatcherAssert.assertThat((Object)operationHash, (Matcher)Matchers.is((Matcher)Matchers.not((Object)anotherOperationHash)));
    }

    private void mockRequiredForMetadataModelProperty(EnrichableModel model, List<String> parameterNames) {
        if (parameterNames == null) {
            List allParameterNames = this.parameterGroupModel.getParameterModels().stream().map(parameterModel -> parameterModel.getName()).collect(Collectors.toList());
            Mockito.when((Object)model.getModelProperty(RequiredForMetadataModelProperty.class)).thenReturn(Optional.of(new RequiredForMetadataModelProperty(allParameterNames)));
        } else {
            RequiredForMetadataModelProperty requiredForMetadataModelProperty = new RequiredForMetadataModelProperty(parameterNames);
            Mockito.when((Object)model.getModelProperty(RequiredForMetadataModelProperty.class)).thenReturn(Optional.of(requiredForMetadataModelProperty));
        }
    }

    private void setPartialFetchingMock(OperationModel operation) {
        Mockito.when((Object)operation.getModelProperty(MetadataResolverFactoryModelProperty.class)).thenReturn(Optional.of(new MetadataResolverFactoryModelProperty(() -> new MetadataResolverFactory(){

            public TypeKeysResolver getKeyResolver() {
                return (TypeKeysResolver)Mockito.mock(PartialTypeKeysResolver.class);
            }

            public <T> InputTypeResolver<T> getInputResolver(String parameterName) {
                return (InputTypeResolver)Mockito.mock(InputTypeResolver.class);
            }

            public Collection<InputTypeResolver> getInputResolvers() {
                return Collections.emptyList();
            }

            public <T> OutputTypeResolver<T> getOutputResolver() {
                return (OutputTypeResolver)Mockito.mock(OutputTypeResolver.class);
            }

            public <T> AttributesTypeResolver<T> getOutputAttributesResolver() {
                return (AttributesTypeResolver)Mockito.mock(AttributesTypeResolver.class);
            }

            public QueryEntityResolver getQueryEntityResolver() {
                return (QueryEntityResolver)Mockito.mock(QueryEntityResolver.class);
            }
        })));
    }

    private MetadataCacheId getIdForComponent(ArtifactDeclaration declaration) throws Exception {
        ApplicationModel app = this.loadApplicationModel(declaration);
        ComponentAst component = new Locator(app).get(Location.builderFromStringRepresentation((String)OPERATION_LOCATION).build()).get();
        return (MetadataCacheId)this.createGenerator(app).getIdForComponentMetadata((Object)component).get();
    }

    private MetadataCacheId getKeyHash(ArtifactDeclaration declaration, String location) throws Exception {
        ApplicationModel app = this.loadApplicationModel(declaration);
        ComponentAst component = new Locator(app).get(Location.builderFromStringRepresentation((String)location).build()).get();
        return (MetadataCacheId)this.createGenerator(app).getIdForMetadataKeys((Object)component).get();
    }

    private MetadataCacheId getGlobalId(ArtifactDeclaration declaration) throws Exception {
        ApplicationModel app = this.loadApplicationModel(declaration);
        ComponentAst component = new Locator(app).get(Location.builderFromStringRepresentation((String)OPERATION_LOCATION).build()).get();
        return (MetadataCacheId)this.createGenerator(app).getIdForGlobalMetadata((Object)component).get();
    }

    private ParameterElementDeclaration newParam(String name, String value) {
        ParameterElementDeclaration param = new ParameterElementDeclaration(name);
        param.setValue(ParameterSimpleValue.of((String)value));
        return param;
    }

    private ArtifactDeclaration getBaseApp() {
        return (ArtifactDeclaration)ElementDeclarer.newArtifact().withGlobalElement((GlobalElementDeclaration)((ConfigurationElementDeclarer)this.declarer.newConfiguration("configuration").withRefName(MY_CONFIG).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("myCamelCaseName", "#[{field: value}]").withParameter("otherName", "additional").withParameter("listName", (ParameterValue)ElementDeclarer.newListValue().withValue("itemValue").build()).getDeclaration())).withConnection((ConnectionElementDeclaration)((ConnectionElementDeclarer)this.declarer.newConnection("connection").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("myCamelCaseName", "#[{field: value}]").withParameter("otherName", "additional").withParameter("listName", (ParameterValue)ElementDeclarer.newListValue().withValue("itemValue").build()).getDeclaration())).getDeclaration()).getDeclaration()).withGlobalElement((GlobalElementDeclaration)((ConstructElementDeclarer)((ConstructElementDeclarer)ElementDeclarer.forExtension((String)"mule").newConstruct("flow").withRefName(MY_FLOW).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)this.declarer.newOperation("mockOperation").withConfig(MY_CONFIG)).withParameterGroup(g -> g.withParameter("myCamelCaseName", "nonKey"))).getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)this.declarer.newOperation("anotherMockOperation").withConfig(MY_CONFIG)).withParameterGroup(g -> g.withParameter("myCamelCaseName", "nonKey"))).getDeclaration())).getDeclaration()).withGlobalElement((GlobalElementDeclaration)this.declarer.newGlobalParameter("complexType").withRefName(MY_GLOBAL_TEMPLATE).withValue(ParameterObjectValue.builder().withParameter("otherName", "simpleParam").withParameter("myCamelCaseName", "someContent").withParameter("numbers", (ParameterValue)ParameterListValue.builder().withValue("10").withValue("20").build()).build()).getDeclaration()).getDeclaration();
    }

    protected ApplicationModel loadApplicationModel(ArtifactDeclaration declaration) throws Exception {
        return new ApplicationModel(new ArtifactConfig.Builder().build(), declaration, this.extensions, Collections.emptyMap(), Optional.empty(), Optional.empty(), uri -> ((Object)((Object)this)).getClass().getResourceAsStream(uri));
    }

    private void mockSimpleMetadataKeyId(OperationModel model) {
        ParameterModel metadataKeyId = this.mockKeyPart(METADATA_KEY_PART_1, 1);
        ArrayList<ParameterModel> parameterModels = new ArrayList<ParameterModel>(model.getAllParameterModels());
        parameterModels.add(metadataKeyId);
        Mockito.when((Object)((ParameterGroupModel)model.getParameterGroupModels().get(0)).getParameterModels()).thenReturn(parameterModels);
        Mockito.when((Object)((ParameterGroupModel)model.getParameterGroupModels().get(0)).getParameter(ArgumentMatchers.anyString())).then(invocation -> {
            String paramName;
            switch (paramName = (String)invocation.getArgument(0)) {
                case "myCamelCaseName": {
                    return Optional.of(this.contentParameter);
                }
                case "listName": {
                    return Optional.of(this.listParameter);
                }
                case "otherName": {
                    return Optional.of(this.behaviourParameter);
                }
                case "partOne": {
                    return Optional.of(metadataKeyId);
                }
            }
            return Optional.empty();
        });
        Mockito.when((Object)model.getModelProperty(MetadataKeyIdModelProperty.class)).thenReturn(Optional.of(new MetadataKeyIdModelProperty(this.TYPE_LOADER.load(String.class), METADATA_KEY_PART_1, CATEGORY_NAME)));
        Mockito.when((Object)model.getModelProperty(MetadataResolverFactoryModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)model.getAllParameterModels()).thenReturn(parameterModels);
    }

    private void mockMultiLevelMetadataKeyId(OperationModel operationModel) {
        ParameterModel partOne = this.mockKeyPart(METADATA_KEY_PART_1, 1);
        ParameterModel partTwo = this.mockKeyPart(METADATA_KEY_PART_2, 2);
        ParameterModel partThree = this.mockKeyPart(METADATA_KEY_PART_3, 3);
        List<ParameterModel> partParameterModels = Arrays.asList(partOne, partTwo, partThree);
        ParameterGroupModel metadataKeyIdGroup = (ParameterGroupModel)Mockito.mock(ParameterGroupModel.class, (MockSettings)new MockSettingsImpl().lenient().defaultAnswer(Mockito.RETURNS_DEFAULTS));
        Mockito.when((Object)metadataKeyIdGroup.getName()).thenReturn((Object)METADATA_KEY_GROUP);
        Mockito.when((Object)metadataKeyIdGroup.isShowInDsl()).thenReturn((Object)false);
        Mockito.when((Object)metadataKeyIdGroup.getParameterModels()).thenReturn(partParameterModels);
        Mockito.when((Object)metadataKeyIdGroup.getParameter(ArgumentMatchers.anyString())).then(invocation -> {
            String paramName;
            switch (paramName = (String)invocation.getArgument(0)) {
                case "partOne": {
                    return Optional.of(partOne);
                }
                case "partTwo": {
                    return Optional.of(partTwo);
                }
                case "partThree": {
                    return Optional.of(partThree);
                }
            }
            return Optional.empty();
        });
        ObjectTypeBuilder groupType = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType();
        groupType.addField().key(METADATA_KEY_PART_1).value(this.TYPE_LOADER.load(String.class));
        groupType.addField().key(METADATA_KEY_PART_2).value(this.TYPE_LOADER.load(String.class));
        groupType.addField().key(METADATA_KEY_PART_3).value(this.TYPE_LOADER.load(String.class));
        Mockito.when((Object)operationModel.getModelProperty(MetadataKeyIdModelProperty.class)).thenReturn(Optional.of(new MetadataKeyIdModelProperty((MetadataType)groupType.build(), METADATA_KEY_GROUP, CATEGORY_NAME)));
        Mockito.when((Object)operationModel.getModelProperty(MetadataResolverFactoryModelProperty.class)).thenReturn(Optional.of(new MetadataResolverFactoryModelProperty(NullMetadataResolverFactory::new)));
        Mockito.when((Object)operationModel.getParameterGroupModels()).thenReturn(Arrays.asList(this.parameterGroupModel, metadataKeyIdGroup));
        Mockito.when((Object)operationModel.getAllParameterModels()).thenReturn((Object)ImmutableList.builder().addAll((Iterable)this.defaultGroupParameterModels).addAll(partParameterModels).build());
    }

    private ParameterModel mockKeyPart(String name, int order) {
        ParameterModel metadataKeyId = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)metadataKeyId.getName()).thenReturn((Object)name);
        Mockito.when((Object)metadataKeyId.getExpressionSupport()).thenReturn((Object)ExpressionSupport.NOT_SUPPORTED);
        Mockito.when((Object)metadataKeyId.getModelProperty((Class)ArgumentMatchers.any())).then(invocation -> {
            if (invocation.getArguments()[0].equals(MetadataKeyPartModelProperty.class)) {
                return Optional.of(new MetadataKeyPartModelProperty(order));
            }
            return Optional.empty();
        });
        Mockito.when((Object)metadataKeyId.getDslConfiguration()).thenReturn((Object)ParameterDslConfiguration.getDefaultInstance());
        Mockito.when((Object)metadataKeyId.getLayoutModel()).thenReturn(Optional.empty());
        Mockito.when((Object)metadataKeyId.getRole()).thenReturn((Object)ParameterRole.BEHAVIOUR);
        Mockito.when((Object)metadataKeyId.getType()).thenReturn((Object)this.TYPE_LOADER.load(String.class));
        return metadataKeyId;
    }

    private MetadataCacheIdGenerator<ComponentAst> createGenerator(ApplicationModel app) {
        return new ModelBasedMetadataCacheIdGeneratorFactory().create(this.dslResolvingContext, (MetadataCacheIdGeneratorFactory.ComponentLocator)new Locator(app));
    }

    private static class Locator
    implements MetadataCacheIdGeneratorFactory.ComponentLocator<ComponentAst> {
        private final Map<Location, ComponentModel> components = new HashMap<Location, ComponentModel>();

        Locator(ApplicationModel app) {
            app.getRootComponentModel().getInnerComponents().forEach(this::addComponent);
        }

        public Optional<ComponentAst> get(Location location) {
            return Optional.ofNullable(this.components.get(location)).map(cm -> (ComponentAst)cm);
        }

        private Location getLocation(ComponentModel component) {
            return Location.builderFromStringRepresentation((String)component.getComponentLocation().getLocation()).build();
        }

        private void addComponent(ComponentModel component) {
            this.components.put(this.getLocation(component), component);
            component.getInnerComponents().forEach(this::addComponent);
        }
    }
}

