/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.dsl.model;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.app.declaration.api.ComponentElementDeclaration;
import org.mule.runtime.app.declaration.api.ConnectionElementDeclaration;
import org.mule.runtime.app.declaration.api.GlobalElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterGroupElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterValue;
import org.mule.runtime.app.declaration.api.fluent.ConfigurationElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ConnectionElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ConstructElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.OperationElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ParameterListValue;
import org.mule.runtime.app.declaration.api.fluent.ParameterObjectValue;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.config.api.dsl.model.metadata.ModelBasedMetadataCacheIdGeneratorFactory;
import org.mule.runtime.config.api.dsl.processor.ArtifactConfig;
import org.mule.runtime.config.dsl.model.AbstractDslModelTestCase;
import org.mule.runtime.config.dsl.model.ModelBasedMetadataCacheKeyGeneratorTestCase;
import org.mule.runtime.config.internal.model.ApplicationModel;
import org.mule.runtime.config.internal.model.ComponentModel;
import org.mule.runtime.core.api.extension.MuleExtensionModelProvider;
import org.mule.runtime.core.internal.metadata.cache.MetadataCacheId;
import org.mule.runtime.core.internal.metadata.cache.MetadataCacheIdGenerator;
import org.mule.runtime.core.internal.metadata.cache.MetadataCacheIdGeneratorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=MockitoJUnitRunner.class)
public class ModelBasedTypeMetadataCacheKeyGeneratorTestCase
extends AbstractDslModelTestCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelBasedMetadataCacheKeyGeneratorTestCase.class);
    private static final String MY_FLOW = "myFlow";
    private static final String MY_CONFIG = "myConfig";
    private static final String OPERATION_LOCATION = "myFlow/processors/0";
    public static final String MY_GLOBAL_TEMPLATE = "myGlobalTemplate";
    private static final String MY_OTHER_FLOW = "myOtherFlow";
    private static final String ANOTHER_OPERATION_LOCATION = "myOtherFlow/processors/0";
    private Set<ExtensionModel> extensions;
    private DslResolvingContext dslResolvingContext;
    private ElementDeclarer declarer;

    @Before
    public void setUp() throws Exception {
        this.extensions = ImmutableSet.builder().add((Object)MuleExtensionModelProvider.getExtensionModel()).add((Object)this.mockExtension).build();
        this.dslResolvingContext = DslResolvingContext.getDefault(this.extensions);
        this.declarer = ElementDeclarer.forExtension((String)"extension");
    }

    @Test
    public void operationsWithSameOutputType() throws Exception {
        MetadataCacheId keyParts = this.getIdForComponentOutputMetadata(this.getBaseApp(), OPERATION_LOCATION);
        LOGGER.debug(keyParts.toString());
        MetadataCacheId otherKeyParts = this.getIdForComponentOutputMetadata(this.getBaseApp(), ANOTHER_OPERATION_LOCATION);
        LOGGER.debug(otherKeyParts.toString());
        MatcherAssert.assertThat((Object)keyParts, (Matcher)Matchers.is((Object)otherKeyParts));
    }

    @Test
    public void operationsWithDifferentOutputTypeResolvers() throws Exception {
        this.mockTypeResolversInformationModelPropertyWithOutputType((EnrichableModel)this.operation, "category", "resolverName");
        MetadataCacheId keyParts = this.getIdForComponentOutputMetadata(this.getBaseApp(), OPERATION_LOCATION);
        LOGGER.debug(keyParts.toString());
        this.mockTypeResolversInformationModelPropertyWithOutputType((EnrichableModel)this.anotherOperation, "category", "anotherResolverName");
        MetadataCacheId otherKeyParts = this.getIdForComponentOutputMetadata(this.getBaseApp(), ANOTHER_OPERATION_LOCATION);
        LOGGER.debug(otherKeyParts.toString());
        MatcherAssert.assertThat((Object)keyParts, (Matcher)Matchers.not((Object)otherKeyParts));
    }

    @Test
    public void operationsWithOutputStaticTypeAgainstDynamicType() throws Exception {
        this.mockTypeResolversInformationModelPropertyWithOutputType((EnrichableModel)this.operation, "category", "resolverName");
        MetadataCacheId keyParts = this.getIdForComponentOutputMetadata(this.getBaseApp(), OPERATION_LOCATION);
        LOGGER.debug(keyParts.toString());
        this.removeTypeResolversInformationModelPropertyfromMock((EnrichableModel)this.anotherOperation);
        MetadataCacheId otherKeyParts = this.getIdForComponentOutputMetadata(this.getBaseApp(), ANOTHER_OPERATION_LOCATION);
        LOGGER.debug(otherKeyParts.toString());
        MatcherAssert.assertThat((Object)keyParts, (Matcher)Matchers.not((Object)otherKeyParts));
    }

    @Test
    public void operationsWithDifferentOutputResolversCategory() throws Exception {
        this.mockTypeResolversInformationModelPropertyWithOutputType((EnrichableModel)this.operation, "category", "resolverName");
        MetadataCacheId keyParts = this.getIdForComponentOutputMetadata(this.getBaseApp(), OPERATION_LOCATION);
        LOGGER.debug(keyParts.toString());
        this.mockTypeResolversInformationModelPropertyWithOutputType((EnrichableModel)this.anotherOperation, "anotherCategory", "resolverName");
        MetadataCacheId otherKeyParts = this.getIdForComponentOutputMetadata(this.getBaseApp(), ANOTHER_OPERATION_LOCATION);
        LOGGER.debug(otherKeyParts.toString());
        MatcherAssert.assertThat((Object)keyParts, (Matcher)Matchers.not((Object)otherKeyParts));
    }

    @Test
    public void operationsWithSameAttributesType() throws Exception {
        MetadataCacheId keyParts = this.getIdForComponentAttributesMetadata(this.getBaseApp(), OPERATION_LOCATION);
        LOGGER.debug(keyParts.toString());
        MetadataCacheId otherKeyParts = this.getIdForComponentAttributesMetadata(this.getBaseApp(), ANOTHER_OPERATION_LOCATION);
        LOGGER.debug(otherKeyParts.toString());
        MatcherAssert.assertThat((Object)keyParts, (Matcher)Matchers.is((Object)otherKeyParts));
    }

    @Test
    public void operationsWithDifferentAttributesTypeResolvers() throws Exception {
        this.mockTypeResolversInformationModelPropertyWithAttributeType((EnrichableModel)this.operation, "category", "resolverName");
        MetadataCacheId keyParts = this.getIdForComponentAttributesMetadata(this.getBaseApp(), OPERATION_LOCATION);
        LOGGER.debug(keyParts.toString());
        this.mockTypeResolversInformationModelPropertyWithAttributeType((EnrichableModel)this.anotherOperation, "category", "anotherResolverName");
        MetadataCacheId otherKeyParts = this.getIdForComponentAttributesMetadata(this.getBaseApp(), ANOTHER_OPERATION_LOCATION);
        LOGGER.debug(otherKeyParts.toString());
        MatcherAssert.assertThat((Object)keyParts, (Matcher)Matchers.not((Object)otherKeyParts));
    }

    @Test
    public void operationsWithAttributeStaticTypeAgainstDynamicType() throws Exception {
        this.removeTypeResolversInformationModelPropertyfromMock((EnrichableModel)this.operation);
        MetadataCacheId keyParts = this.getIdForComponentAttributesMetadata(this.getBaseApp(), OPERATION_LOCATION);
        LOGGER.debug(keyParts.toString());
        this.mockTypeResolversInformationModelPropertyWithAttributeType((EnrichableModel)this.anotherOperation, "category", "anotherResolverName");
        MetadataCacheId otherKeyParts = this.getIdForComponentAttributesMetadata(this.getBaseApp(), ANOTHER_OPERATION_LOCATION);
        LOGGER.debug(otherKeyParts.toString());
        MatcherAssert.assertThat((Object)keyParts, (Matcher)Matchers.not((Object)otherKeyParts));
    }

    @Test
    public void operationsWithDifferentAttributesResolversCategory() throws Exception {
        this.mockTypeResolversInformationModelPropertyWithAttributeType((EnrichableModel)this.operation, "category", "resolverName");
        MetadataCacheId keyParts = this.getIdForComponentAttributesMetadata(this.getBaseApp(), OPERATION_LOCATION);
        LOGGER.debug(keyParts.toString());
        this.mockTypeResolversInformationModelPropertyWithAttributeType((EnrichableModel)this.anotherOperation, "anotherCategory", "resolverName");
        MetadataCacheId otherKeyParts = this.getIdForComponentAttributesMetadata(this.getBaseApp(), ANOTHER_OPERATION_LOCATION);
        LOGGER.debug(otherKeyParts.toString());
        MatcherAssert.assertThat((Object)keyParts, (Matcher)Matchers.not((Object)otherKeyParts));
    }

    @Test
    public void operationsWithSameInputType() throws Exception {
        HashMap<String, String> parameterResolversNames = new HashMap<String, String>();
        parameterResolversNames.put("listName", "listName");
        parameterResolversNames.put("myCamelCaseName", "myCamelCaseName");
        this.mockTypeResolversInformationModelPropertyWithInputTypes((EnrichableModel)this.operation, "category", parameterResolversNames);
        MetadataCacheId keyParts = this.getIdForComponentInputMetadata(this.getBaseApp(), OPERATION_LOCATION, "listName");
        LOGGER.debug(keyParts.toString());
        HashMap<String, String> anotherParameterResolversNames = new HashMap<String, String>();
        anotherParameterResolversNames.put("listName", "listName");
        anotherParameterResolversNames.put("anotherMyCamelCaseName", "myCamelCaseName");
        this.mockTypeResolversInformationModelPropertyWithInputTypes((EnrichableModel)this.anotherOperation, "category", anotherParameterResolversNames);
        MetadataCacheId otherKeyParts = this.getIdForComponentInputMetadata(this.getBaseApp(), ANOTHER_OPERATION_LOCATION, "listName");
        LOGGER.debug(otherKeyParts.toString());
        MatcherAssert.assertThat((Object)keyParts, (Matcher)Matchers.is((Object)otherKeyParts));
    }

    @Test
    public void operationsWithDifferentInputTypeResolvers() throws Exception {
        HashMap<String, String> parameterResolversNames = new HashMap<String, String>();
        parameterResolversNames.put("listName", "listName");
        parameterResolversNames.put("myCamelCaseName", "myCamelCaseName");
        this.mockTypeResolversInformationModelPropertyWithInputTypes((EnrichableModel)this.operation, "category", parameterResolversNames);
        MetadataCacheId keyParts = this.getIdForComponentInputMetadata(this.getBaseApp(), OPERATION_LOCATION, "myCamelCaseName");
        LOGGER.debug(keyParts.toString());
        HashMap<String, String> anotherParameterResolversNames = new HashMap<String, String>();
        parameterResolversNames.put("listName", "listName");
        parameterResolversNames.put("anotherMyCamelCaseName", "changed");
        this.mockTypeResolversInformationModelPropertyWithInputTypes((EnrichableModel)this.anotherOperation, "category", anotherParameterResolversNames);
        MetadataCacheId otherKeyParts = this.getIdForComponentInputMetadata(this.getBaseApp(), ANOTHER_OPERATION_LOCATION, "anotherMyCamelCaseName");
        LOGGER.debug(otherKeyParts.toString());
        MatcherAssert.assertThat((Object)keyParts, (Matcher)Matchers.not((Object)otherKeyParts));
    }

    @Test
    public void operationsWithInputTypeStaticTypeAgainstDynamicType() throws Exception {
        HashMap<String, String> parameterResolversNames = new HashMap<String, String>();
        parameterResolversNames.put("listName", "listName");
        parameterResolversNames.put("myCamelCaseName", "myCamelCaseName");
        this.mockTypeResolversInformationModelPropertyWithInputTypes((EnrichableModel)this.operation, "category", parameterResolversNames);
        MetadataCacheId keyParts = this.getIdForComponentInputMetadata(this.getBaseApp(), OPERATION_LOCATION, "myCamelCaseName");
        LOGGER.debug(keyParts.toString());
        this.removeTypeResolversInformationModelPropertyfromMock((EnrichableModel)this.anotherOperation);
        MetadataCacheId otherKeyParts = this.getIdForComponentInputMetadata(this.getBaseApp(), ANOTHER_OPERATION_LOCATION, "anotherMyCamelCaseName");
        LOGGER.debug(otherKeyParts.toString());
        MatcherAssert.assertThat((Object)keyParts, (Matcher)Matchers.not((Object)otherKeyParts));
    }

    @Test
    public void operationsWithDifferentInputResolversCategory() throws Exception {
        HashMap<String, String> parameterResolversNames = new HashMap<String, String>();
        parameterResolversNames.put("listName", "listName");
        parameterResolversNames.put("myCamelCaseName", "myCamelCaseName");
        this.mockTypeResolversInformationModelPropertyWithInputTypes((EnrichableModel)this.operation, "category", parameterResolversNames);
        MetadataCacheId keyParts = this.getIdForComponentInputMetadata(this.getBaseApp(), OPERATION_LOCATION, "listName");
        LOGGER.debug(keyParts.toString());
        this.mockTypeResolversInformationModelPropertyWithInputTypes((EnrichableModel)this.anotherOperation, "anotherCategory", parameterResolversNames);
        MetadataCacheId otherKeyParts = this.getIdForComponentInputMetadata(this.getBaseApp(), ANOTHER_OPERATION_LOCATION, "listName");
        LOGGER.debug(otherKeyParts.toString());
        MatcherAssert.assertThat((Object)keyParts, (Matcher)Matchers.not((Object)otherKeyParts));
    }

    @Test
    public void operationsWithDifferentStaticOutputTypes() throws Exception {
        this.removeTypeResolversInformationModelPropertyfromMock((EnrichableModel)this.operation);
        MetadataCacheId keyParts = this.getIdForComponentOutputMetadata(this.getBaseApp(), OPERATION_LOCATION);
        LOGGER.debug(keyParts.toString());
        this.removeTypeResolversInformationModelPropertyfromMock((EnrichableModel)this.anotherOperation);
        MetadataCacheId otherKeyParts = this.getIdForComponentOutputMetadata(this.getBaseApp(), ANOTHER_OPERATION_LOCATION);
        LOGGER.debug(otherKeyParts.toString());
        MatcherAssert.assertThat((Object)keyParts, (Matcher)Matchers.not((Object)otherKeyParts));
    }

    @Test
    public void operationsWithDifferentStaticAttributeTypes() throws Exception {
        this.removeTypeResolversInformationModelPropertyfromMock((EnrichableModel)this.operation);
        MetadataCacheId keyParts = this.getIdForComponentAttributesMetadata(this.getBaseApp(), OPERATION_LOCATION);
        LOGGER.debug(keyParts.toString());
        this.removeTypeResolversInformationModelPropertyfromMock((EnrichableModel)this.anotherOperation);
        MetadataCacheId otherKeyParts = this.getIdForComponentAttributesMetadata(this.getBaseApp(), ANOTHER_OPERATION_LOCATION);
        LOGGER.debug(otherKeyParts.toString());
        MatcherAssert.assertThat((Object)keyParts, (Matcher)Matchers.not((Object)otherKeyParts));
    }

    @Test
    public void operationsWithDifferentStaticInputTypes() throws Exception {
        this.removeTypeResolversInformationModelPropertyfromMock((EnrichableModel)this.operation);
        MetadataCacheId keyParts = this.getIdForComponentInputMetadata(this.getBaseApp(), OPERATION_LOCATION, "listName");
        LOGGER.debug(keyParts.toString());
        this.removeTypeResolversInformationModelPropertyfromMock((EnrichableModel)this.anotherOperation);
        MetadataCacheId otherKeyParts = this.getIdForComponentInputMetadata(this.getBaseApp(), ANOTHER_OPERATION_LOCATION, "listName");
        LOGGER.debug(otherKeyParts.toString());
        MatcherAssert.assertThat((Object)keyParts, (Matcher)Matchers.not((Object)otherKeyParts));
    }

    @Test
    public void operationWithStaticOutputAndInputTypes() throws Exception {
        this.removeTypeResolversInformationModelPropertyfromMock((EnrichableModel)this.operation);
        MetadataCacheId keyParts = this.getIdForComponentOutputMetadata(this.getBaseApp(), OPERATION_LOCATION);
        LOGGER.debug(keyParts.toString());
        MetadataCacheId otherKeyParts = this.getIdForComponentAttributesMetadata(this.getBaseApp(), ANOTHER_OPERATION_LOCATION);
        LOGGER.debug(otherKeyParts.toString());
        MatcherAssert.assertThat((Object)keyParts, (Matcher)Matchers.not((Object)otherKeyParts));
    }

    @Test
    public void operationWithStaticInputTypes() throws Exception {
        this.removeTypeResolversInformationModelPropertyfromMock((EnrichableModel)this.operation);
        MetadataCacheId keyParts = this.getIdForComponentInputMetadata(this.getBaseApp(), OPERATION_LOCATION, "listName");
        LOGGER.debug(keyParts.toString());
        MetadataCacheId otherKeyParts = this.getIdForComponentInputMetadata(this.getBaseApp(), OPERATION_LOCATION, "myCamelCaseName");
        LOGGER.debug(otherKeyParts.toString());
        MatcherAssert.assertThat((Object)keyParts, (Matcher)Matchers.not((Object)otherKeyParts));
    }

    @Test
    public void operationWithParametersOfSameInputType() throws Exception {
        HashMap<String, String> parameterResolversNames = new HashMap<String, String>();
        parameterResolversNames.put("listName", "listName");
        parameterResolversNames.put("myCamelCaseName", "listName");
        this.mockTypeResolversInformationModelPropertyWithInputTypes((EnrichableModel)this.operation, "category", parameterResolversNames);
        MetadataCacheId keyParts = this.getIdForComponentInputMetadata(this.getBaseApp(), OPERATION_LOCATION, "listName");
        LOGGER.debug(keyParts.toString());
        MetadataCacheId otherKeyParts = this.getIdForComponentInputMetadata(this.getBaseApp(), OPERATION_LOCATION, "myCamelCaseName");
        LOGGER.debug(otherKeyParts.toString());
        MatcherAssert.assertThat((Object)keyParts, (Matcher)Matchers.is((Object)otherKeyParts));
    }

    @Test
    public void operationWithParametersOfDifferentInputType() throws Exception {
        HashMap<String, String> parameterResolversNames = new HashMap<String, String>();
        parameterResolversNames.put("listName", "listName");
        parameterResolversNames.put("myCamelCaseName", "myCamelCaseName");
        this.mockTypeResolversInformationModelPropertyWithInputTypes((EnrichableModel)this.operation, "category", parameterResolversNames);
        MetadataCacheId keyParts = this.getIdForComponentInputMetadata(this.getBaseApp(), OPERATION_LOCATION, "listName");
        LOGGER.debug(keyParts.toString());
        MetadataCacheId otherKeyParts = this.getIdForComponentInputMetadata(this.getBaseApp(), OPERATION_LOCATION, "myCamelCaseName");
        LOGGER.debug(otherKeyParts.toString());
        MatcherAssert.assertThat((Object)keyParts, (Matcher)Matchers.not((Object)otherKeyParts));
    }

    @Test
    public void sameComponentsOnDifferentExtensionsGenerateDifferentHash() throws Exception {
        String newExtensionModelName = "newMockedExtension";
        String newNamespace = "new-mockns";
        String newNamespaceUri = "http://www.mulesoft.org/schema/mule/new-mockns";
        String newSchemaLocation = "http://www.mulesoft.org/schema/mule/new-mockns/current/mule-new-mockns.xsd";
        ExtensionModel newExtensionModel = (ExtensionModel)Mockito.mock(ExtensionModel.class);
        this.initializeExtensionMock(newExtensionModel);
        Mockito.when((Object)newExtensionModel.getName()).thenReturn((Object)"newMockedExtension");
        Mockito.when((Object)newExtensionModel.getXmlDslModel()).thenReturn((Object)XmlDslModel.builder().setXsdFileName("new-mule-mockns.xsd").setPrefix("new-mockns").setNamespace("http://www.mulesoft.org/schema/mule/new-mockns").setSchemaLocation("http://www.mulesoft.org/schema/mule/new-mockns/current/mule-new-mockns.xsd").setSchemaVersion("4.0").build());
        Mockito.when((Object)newExtensionModel.getSubTypes()).thenReturn(Collections.emptySet());
        Mockito.when((Object)newExtensionModel.getImportedTypes()).thenReturn(Collections.emptySet());
        Mockito.when((Object)newExtensionModel.getXmlDslModel()).thenReturn((Object)XmlDslModel.builder().setXsdFileName("").setPrefix("new-mockns").setNamespace("http://www.mulesoft.org/schema/mule/new-mockns").setSchemaLocation("http://www.mulesoft.org/schema/mule/new-mockns/current/mule-new-mockns.xsd").setSchemaVersion("").build());
        this.extensions = ImmutableSet.builder().add((Object)MuleExtensionModelProvider.getExtensionModel()).add((Object)this.mockExtension).add((Object)newExtensionModel).build();
        this.dslResolvingContext = DslResolvingContext.getDefault(this.extensions);
        ElementDeclarer newElementDeclarer = ElementDeclarer.forExtension((String)"newMockedExtension");
        String newFlowName = "myNewFlow";
        String newConfigName = "myNewConfig";
        ArtifactDeclaration baseApp = this.getBaseApp();
        ArtifactDeclaration app = (ArtifactDeclaration)ElementDeclarer.newArtifact().withGlobalElement((GlobalElementDeclaration)baseApp.getGlobalElements().get(0)).withGlobalElement((GlobalElementDeclaration)baseApp.getGlobalElements().get(1)).withGlobalElement((GlobalElementDeclaration)((ConfigurationElementDeclarer)newElementDeclarer.newConfiguration("configuration").withRefName("myNewConfig").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("myCamelCaseName", "#[{field: value}]").withParameter("otherName", "additional").withParameter("listName", (ParameterValue)ElementDeclarer.newListValue().withValue("itemValue").build()).getDeclaration())).withConnection((ConnectionElementDeclaration)((ConnectionElementDeclarer)newElementDeclarer.newConnection("connection").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("myCamelCaseName", "#[{field: value}]").withParameter("otherName", "additional").withParameter("listName", (ParameterValue)ElementDeclarer.newListValue().withValue("itemValue").build()).getDeclaration())).getDeclaration()).getDeclaration()).withGlobalElement((GlobalElementDeclaration)((ConstructElementDeclarer)ElementDeclarer.forExtension((String)"mule").newConstruct("flow").withRefName("myNewFlow").withComponent((ComponentElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)newElementDeclarer.newOperation("mockOperation").withConfig("myNewConfig")).withParameterGroup(g -> g.withParameter("myCamelCaseName", "nonKey"))).getDeclaration())).getDeclaration()).getDeclaration();
        String extensionOperationLocation = OPERATION_LOCATION;
        String newExtensionOperationLocation = "myNewFlow/processors/0";
        MetadataCacheId oldHash = this.getIdForComponentOutputMetadata(app, OPERATION_LOCATION);
        MetadataCacheId newHash = this.getIdForComponentOutputMetadata(app, "myNewFlow/processors/0");
        MatcherAssert.assertThat((Object)oldHash, (Matcher)Matchers.is((Matcher)Matchers.not((Object)newHash)));
    }

    @Test
    public void sameTypesOnDifferentOperationsWithDifferentKeyResolverGeneratesSameHash() throws Exception {
        String category = "category";
        String outputResolverName = "outputResolver";
        HashMap<String, String> parameterResolversNames = new HashMap<String, String>();
        parameterResolversNames.put("listName", "listName");
        String attributesResolverName = "attributesResolver";
        this.mockTypeResolversInformationModelProperty((EnrichableModel)this.operation, "category", "outputResolver", "attributesResolver", parameterResolversNames, "operationKeysResolver");
        this.mockTypeResolversInformationModelProperty((EnrichableModel)this.anotherOperation, "category", "outputResolver", "attributesResolver", parameterResolversNames, "anotherOperationKeysResolver");
        ArtifactDeclaration baseApp = this.getBaseApp();
        MetadataCacheId operationOutputMetadataCacheId = this.getIdForComponentOutputMetadata(baseApp, OPERATION_LOCATION);
        LOGGER.debug(operationOutputMetadataCacheId.toString());
        MetadataCacheId operationListInputMetadataCacheId = this.getIdForComponentInputMetadata(baseApp, OPERATION_LOCATION, "listName");
        LOGGER.debug(operationListInputMetadataCacheId.toString());
        MetadataCacheId operationAttributesMetadataCacheId = this.getIdForComponentAttributesMetadata(baseApp, OPERATION_LOCATION);
        LOGGER.debug(operationAttributesMetadataCacheId.toString());
        MetadataCacheId anotherOperationOutputMetadataCacheId = this.getIdForComponentOutputMetadata(baseApp, ANOTHER_OPERATION_LOCATION);
        LOGGER.debug(anotherOperationOutputMetadataCacheId.toString());
        MetadataCacheId anotherOperationListInputMetadataCacheId = this.getIdForComponentInputMetadata(baseApp, ANOTHER_OPERATION_LOCATION, "listName");
        LOGGER.debug(anotherOperationListInputMetadataCacheId.toString());
        MetadataCacheId anotherOperationAttributesMetadataCacheId = this.getIdForComponentAttributesMetadata(baseApp, ANOTHER_OPERATION_LOCATION);
        LOGGER.debug(anotherOperationAttributesMetadataCacheId.toString());
        MatcherAssert.assertThat((Object)operationOutputMetadataCacheId, (Matcher)Matchers.is((Object)anotherOperationOutputMetadataCacheId));
        MatcherAssert.assertThat((Object)operationListInputMetadataCacheId, (Matcher)Matchers.is((Object)anotherOperationListInputMetadataCacheId));
        MatcherAssert.assertThat((Object)operationAttributesMetadataCacheId, (Matcher)Matchers.is((Object)anotherOperationAttributesMetadataCacheId));
    }

    protected MetadataCacheId getIdForComponentOutputMetadata(ArtifactDeclaration declaration, String location) throws Exception {
        ApplicationModel app = this.loadApplicationModel(declaration);
        ComponentAst component = new Locator(app).get(Location.builderFromStringRepresentation((String)location).build()).get();
        return (MetadataCacheId)this.createGenerator(app).getIdForComponentOutputMetadata((Object)component).get();
    }

    protected MetadataCacheId getIdForComponentAttributesMetadata(ArtifactDeclaration declaration, String location) throws Exception {
        ApplicationModel app = this.loadApplicationModel(declaration);
        ComponentAst component = new Locator(app).get(Location.builderFromStringRepresentation((String)location).build()).get();
        return (MetadataCacheId)this.createGenerator(app).getIdForComponentAttributesMetadata((Object)component).get();
    }

    protected MetadataCacheId getIdForComponentInputMetadata(ArtifactDeclaration declaration, String location, String parameterName) throws Exception {
        ApplicationModel app = this.loadApplicationModel(declaration);
        ComponentAst component = new Locator(app).get(Location.builderFromStringRepresentation((String)location).build()).get();
        return (MetadataCacheId)this.createGenerator(app).getIdForComponentInputMetadata((Object)component, parameterName).get();
    }

    private ArtifactDeclaration getBaseApp() {
        return (ArtifactDeclaration)ElementDeclarer.newArtifact().withGlobalElement((GlobalElementDeclaration)((ConfigurationElementDeclarer)this.declarer.newConfiguration("configuration").withRefName(MY_CONFIG).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("myCamelCaseName", "#[{field: value}]").withParameter("otherName", "additional").withParameter("listName", (ParameterValue)ElementDeclarer.newListValue().withValue("itemValue").build()).getDeclaration())).withConnection((ConnectionElementDeclaration)((ConnectionElementDeclarer)this.declarer.newConnection("connection").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("myCamelCaseName", "#[{field: value}]").withParameter("otherName", "additional").withParameter("listName", (ParameterValue)ElementDeclarer.newListValue().withValue("itemValue").build()).getDeclaration())).getDeclaration()).getDeclaration()).withGlobalElement((GlobalElementDeclaration)((ConstructElementDeclarer)ElementDeclarer.forExtension((String)"mule").newConstruct("flow").withRefName(MY_FLOW).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)this.declarer.newOperation("mockOperation").withConfig(MY_CONFIG)).withParameterGroup(g -> g.withParameter("myCamelCaseName", "nonKey"))).getDeclaration())).getDeclaration()).withGlobalElement((GlobalElementDeclaration)((ConstructElementDeclarer)ElementDeclarer.forExtension((String)"mule").newConstruct("flow").withRefName(MY_OTHER_FLOW).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)this.declarer.newOperation("anotherMockOperation").withConfig(MY_CONFIG)).withParameterGroup(g -> g.withParameter("anotherMyCamelCaseName", "anotherNonKey"))).getDeclaration())).getDeclaration()).withGlobalElement((GlobalElementDeclaration)this.declarer.newGlobalParameter("complexType").withRefName(MY_GLOBAL_TEMPLATE).withValue(ParameterObjectValue.builder().withParameter("otherName", "simpleParam").withParameter("myCamelCaseName", "someContent").withParameter("numbers", (ParameterValue)ParameterListValue.builder().withValue("10").withValue("20").build()).build()).getDeclaration()).getDeclaration();
    }

    protected ApplicationModel loadApplicationModel(ArtifactDeclaration declaration) throws Exception {
        return new ApplicationModel(new ArtifactConfig.Builder().build(), declaration, this.extensions, Collections.emptyMap(), Optional.empty(), Optional.empty(), uri -> ((Object)((Object)this)).getClass().getResourceAsStream(uri));
    }

    private MetadataCacheIdGenerator<ComponentAst> createGenerator(ApplicationModel app) {
        return new ModelBasedMetadataCacheIdGeneratorFactory().create(this.dslResolvingContext, (MetadataCacheIdGeneratorFactory.ComponentLocator)new Locator(app));
    }

    private static class Locator
    implements MetadataCacheIdGeneratorFactory.ComponentLocator<ComponentAst> {
        private final Map<Location, ComponentModel> components = new HashMap<Location, ComponentModel>();

        Locator(ApplicationModel app) {
            app.getRootComponentModel().getInnerComponents().forEach(this::addComponent);
        }

        public Optional<ComponentAst> get(Location location) {
            return Optional.ofNullable(this.components.get(location)).map(cm -> (ComponentAst)cm);
        }

        private Location getLocation(ComponentModel component) {
            return Location.builderFromStringRepresentation((String)component.getComponentLocation().getLocation()).build();
        }

        private void addComponent(ComponentModel component) {
            this.components.put(this.getLocation(component), component);
            component.getInnerComponents().forEach(this::addComponent);
        }
    }
}

