/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.dsl.spring;

import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.runtime.config.internal.dsl.spring.ObjectFactoryClassRepository;
import org.mule.runtime.dsl.api.component.AbstractComponentFactory;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.runtime.dsl.api.component.ObjectFactory;
import org.springframework.beans.factory.SmartFactoryBean;

@RunWith(value=MockitoJUnitRunner.class)
public class ObjectFactoryClassRepositoryTestCase {
    @Mock
    private ComponentBuildingDefinition componentBuildingDefinition;

    @Test
    public void cacheEnableForCGLib() throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        Class<ObjectFactory> objectFactoryClass = this.getObjectFactoryClass();
        ObjectFactory objectFactory = objectFactoryClass.newInstance();
        Assert.assertThat((Object)((SmartFactoryBean)objectFactory).isSingleton(), (Matcher)Is.is((Object)true));
        Class<?> firstProxyGenerated = objectFactory.getClass();
        objectFactoryClass = this.getObjectFactoryClass();
        objectFactory = objectFactoryClass.newInstance();
        Assert.assertThat((Object)((SmartFactoryBean)objectFactory).isSingleton(), (Matcher)Is.is((Object)true));
        Assert.assertThat(firstProxyGenerated, (Matcher)CoreMatchers.sameInstance(objectFactory.getClass()));
    }

    public Class<ObjectFactory> getObjectFactoryClass() {
        ObjectFactoryClassRepository objectFactoryClassRepository = new ObjectFactoryClassRepository();
        return objectFactoryClassRepository.getObjectFactoryClass(this.componentBuildingDefinition, FakeObjectConnectionProviderObjectFactory.class, FakeObject.class, () -> false, Optional.empty());
    }

    public static class FakeObject {
    }

    public static class FakeObjectConnectionProviderObjectFactory
    extends AbstractComponentFactory {
        public Object doGetObject() throws Exception {
            return new FakeObject();
        }
    }
}

