/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.factories;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.inject.Inject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentMatchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.BindingContextUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.config.internal.factories.FlowRefFactoryBean;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleState;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.internal.processor.chain.SubflowMessageProcessorChainBuilder;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.core.privileged.routing.RoutePathNotFoundException;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.tck.util.MuleContextUtils;
import org.reactivestreams.Publisher;
import org.springframework.context.ApplicationContext;
import reactor.core.publisher.Mono;

@SmallTest
public class FlowRefFactoryBeanTestCase
extends AbstractMuleTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private static final MockSettings INITIALIZABLE_MESSAGE_PROCESSOR = Mockito.withSettings().extraInterfaces(new Class[]{Component.class, Processor.class, Initialisable.class, Disposable.class, Startable.class, Stoppable.class});
    private static final String STATIC_REFERENCED_FLOW = "staticReferencedFlow";
    private static final String DYNAMIC_REFERENCED_FLOW = "dynamicReferencedFlow";
    private static final String PARSED_DYNAMIC_REFERENCED_FLOW = "parsedDynamicReferencedFlow";
    private static final String DYNAMIC_NON_EXISTANT = "#['nonExistant']";
    private CoreEvent result;
    private final ProcessingStrategy callerFlowProcessingStrategy = (ProcessingStrategy)Mockito.mock(ProcessingStrategy.class);
    private final Flow callerFlow = (Flow)Mockito.mock(Flow.class, (MockSettings)INITIALIZABLE_MESSAGE_PROCESSOR);
    private final Flow targetFlow = (Flow)Mockito.mock(Flow.class, (MockSettings)INITIALIZABLE_MESSAGE_PROCESSOR);
    private final LifecycleState flowLifeCycleState = (LifecycleState)Mockito.mock(LifecycleState.class);
    private final MessageProcessorChain targetSubFlow = (MessageProcessorChain)Mockito.mock(MessageProcessorChain.class, (MockSettings)INITIALIZABLE_MESSAGE_PROCESSOR);
    private final Processor targetSubFlowChild = (Processor)Mockito.mock(Object.class, (MockSettings)INITIALIZABLE_MESSAGE_PROCESSOR);
    private final SubflowMessageProcessorChainBuilder targetSubFlowChainBuilder = (SubflowMessageProcessorChainBuilder)Mockito.spy((Object)new SubflowMessageProcessorChainBuilder());
    private final ApplicationContext applicationContext = (ApplicationContext)Mockito.mock(ApplicationContext.class);
    private ExtendedExpressionManager expressionManager;
    private MuleContext mockMuleContext;
    @Inject
    private ConfigurationComponentLocator locator;

    @Before
    public void setup() throws MuleException {
        this.result = this.testEvent();
        this.mockMuleContext = MuleContextUtils.mockContextWithServices();
        this.expressionManager = this.mockMuleContext.getExpressionManager();
        ((ExtendedExpressionManager)Mockito.doReturn((Object)true).when((Object)this.expressionManager)).isExpression(ArgumentMatchers.anyString());
        Mockito.when((Object)this.targetFlow.apply((Publisher)ArgumentMatchers.any(Publisher.class))).thenReturn((Object)Mono.just((Object)this.result));
        Mockito.when((Object)this.targetFlow.referenced()).thenReturn((Object)this.targetFlow);
        Mockito.when((Object)this.flowLifeCycleState.isStarted()).thenReturn((Object)true);
        Mockito.when((Object)this.targetFlow.getLifecycleState()).thenReturn((Object)this.flowLifeCycleState);
        List<Processor> targetSubFlowProcessors = Collections.singletonList(this.targetSubFlowChild);
        Mockito.when((Object)this.targetSubFlow.getMessageProcessors()).thenReturn(targetSubFlowProcessors);
        this.targetSubFlowChainBuilder.chain(targetSubFlowProcessors);
        Mockito.when((Object)this.targetSubFlowChild.apply((Publisher)ArgumentMatchers.any(Publisher.class))).thenReturn((Object)Mono.just((Object)this.result));
        Mockito.when((Object)this.targetSubFlow.apply((Publisher)ArgumentMatchers.any(Publisher.class))).thenReturn((Object)Mono.just((Object)this.result));
        this.mockMuleContext.getInjector().inject((Object)this);
        Mockito.when((Object)this.locator.find((Location)ArgumentMatchers.any(Location.class))).thenReturn(Optional.of(Mockito.mock(Flow.class)));
        Mockito.when((Object)this.locator.find(Location.builder().globalName("flow").build())).thenReturn(Optional.of(this.callerFlow));
        Mockito.when((Object)this.callerFlow.getProcessingStrategy()).thenReturn((Object)this.callerFlowProcessingStrategy);
        Mockito.when((Object)this.callerFlowProcessingStrategy.onProcessor((ReactiveProcessor)ArgumentMatchers.any())).thenAnswer(invocationOnMock -> invocationOnMock.getArguments()[0]);
    }

    @Test
    public void staticFlowRefFlow() throws Exception {
        FlowRefFactoryBean flowRefFactoryBean = this.createStaticFlowRefFactoryBean((Processor)this.targetFlow, null);
        Assert.assertNotSame((Object)this.targetFlow, (Object)this.getFlowRefProcessor(flowRefFactoryBean));
        Assert.assertNotSame((Object)this.targetFlow, (Object)this.getFlowRefProcessor(flowRefFactoryBean));
        this.verifyProcess(flowRefFactoryBean, (Processor)this.targetFlow);
        this.verifyLifecycle((Processor)this.targetFlow, 0);
    }

    @Test
    public void dynamicFlowRefFlow() throws Exception {
        FlowRefFactoryBean flowRefFactoryBean = this.createDynamicFlowRefFactoryBean((Processor)this.targetFlow, null);
        Assert.assertNotSame((Object)this.targetFlow, (Object)this.getFlowRefProcessor(flowRefFactoryBean));
        Assert.assertNotSame((Object)this.targetFlow, (Object)this.getFlowRefProcessor(flowRefFactoryBean));
        this.verifyProcess(flowRefFactoryBean, (Processor)this.targetFlow);
        this.verifyLifecycle((Processor)this.targetFlow, 0);
    }

    @Test
    public void staticFlowRefSubFlow() throws Exception {
        FlowRefFactoryBean flowRefFactoryBean = this.createStaticFlowRefFactoryBean((Processor)this.targetSubFlow, this.targetSubFlowChainBuilder);
        Assert.assertThat((Object)this.targetSubFlow, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)this.getFlowRefProcessor(flowRefFactoryBean))));
        Assert.assertThat((Object)this.targetSubFlow, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)this.getFlowRefProcessor(flowRefFactoryBean))));
        this.verifyProcess(flowRefFactoryBean, this.targetSubFlowChild);
        ((SubflowMessageProcessorChainBuilder)Mockito.verify((Object)this.targetSubFlowChainBuilder)).setProcessingStrategy((ProcessingStrategy)ArgumentMatchers.argThat(ps -> {
            ReactiveProcessor pipeline = (ReactiveProcessor)Mockito.mock(ReactiveProcessor.class);
            ReactiveProcessor processor = (ReactiveProcessor)Mockito.mock(ReactiveProcessor.class);
            ps.onProcessor(processor);
            ((ProcessingStrategy)Mockito.verify((Object)this.callerFlowProcessingStrategy)).onProcessor(processor);
            Assert.assertThat((Object)ps.onPipeline(pipeline), (Matcher)CoreMatchers.sameInstance((Object)pipeline));
            return true;
        }));
    }

    @Test
    public void dynamicFlowRefSubFlow() throws Exception {
        FlowRefFactoryBean flowRefFactoryBean = this.createDynamicFlowRefFactoryBean((Processor)this.targetSubFlow, this.targetSubFlowChainBuilder);
        Assert.assertNotSame((Object)this.targetSubFlow, (Object)this.getFlowRefProcessor(flowRefFactoryBean));
        Assert.assertNotSame((Object)this.targetSubFlow, (Object)this.getFlowRefProcessor(flowRefFactoryBean));
        this.verifyProcess(flowRefFactoryBean, this.targetSubFlowChild);
        ((SubflowMessageProcessorChainBuilder)Mockito.verify((Object)this.targetSubFlowChainBuilder)).setProcessingStrategy((ProcessingStrategy)ArgumentMatchers.argThat(ps -> {
            ReactiveProcessor pipeline = (ReactiveProcessor)Mockito.mock(ReactiveProcessor.class);
            ReactiveProcessor processor = (ReactiveProcessor)Mockito.mock(ReactiveProcessor.class);
            ps.onProcessor(processor);
            ((ProcessingStrategy)Mockito.verify((Object)this.callerFlowProcessingStrategy)).onProcessor(processor);
            Assert.assertThat((Object)ps.onPipeline(pipeline), (Matcher)CoreMatchers.sameInstance((Object)pipeline));
            return true;
        }));
    }

    @Test
    public void dynamicFlowRefSubContextAware() throws Exception {
        CoreEvent event = this.testEvent();
        MuleContextAware targetMuleContextAware = (MuleContextAware)Mockito.mock(MuleContextAware.class, (MockSettings)INITIALIZABLE_MESSAGE_PROCESSOR);
        Mockito.when((Object)((Processor)targetMuleContextAware).apply((Publisher)ArgumentMatchers.any(Publisher.class))).thenReturn((Object)Mono.just((Object)this.result));
        FlowRefFactoryBean flowRefFactoryBean = this.createDynamicFlowRefFactoryBean((Processor)targetMuleContextAware, null);
        Assert.assertSame((Object)this.result.getMessage(), (Object)this.getFlowRefProcessor(flowRefFactoryBean).process(event).getMessage());
        ((MuleContextAware)Mockito.verify((Object)targetMuleContextAware)).setMuleContext(this.mockMuleContext);
    }

    @Test
    public void dynamicFlowRefSubFlowMessageProcessorChain() throws Exception {
        CoreEvent event = this.testEvent();
        Processor targetSubFlowConstructAware = (Processor)Mockito.mock(Object.class, (MockSettings)INITIALIZABLE_MESSAGE_PROCESSOR);
        Mockito.when((Object)targetSubFlowConstructAware.apply((Publisher)ArgumentMatchers.any(Publisher.class))).thenReturn((Object)Mono.just((Object)this.result));
        Processor targetMuleContextAwareAware = (Processor)Mockito.mock(MuleContextAware.class, (MockSettings)INITIALIZABLE_MESSAGE_PROCESSOR);
        Mockito.when((Object)targetMuleContextAwareAware.apply((Publisher)ArgumentMatchers.any(Publisher.class))).thenAnswer(invocationOnMock -> invocationOnMock.getArguments()[0]);
        MessageProcessorChain targetSubFlowChain = (MessageProcessorChain)Mockito.mock(MessageProcessorChain.class, (MockSettings)INITIALIZABLE_MESSAGE_PROCESSOR);
        Mockito.when((Object)targetSubFlowChain.apply((Publisher)ArgumentMatchers.any(Publisher.class))).thenReturn((Object)Mono.just((Object)this.result));
        List<Processor> targetSubFlowProcessors = Arrays.asList(targetSubFlowConstructAware, targetMuleContextAwareAware);
        Mockito.when((Object)targetSubFlowChain.getMessageProcessors()).thenReturn(targetSubFlowProcessors);
        SubflowMessageProcessorChainBuilder chainBuilder = new SubflowMessageProcessorChainBuilder();
        chainBuilder.chain(targetSubFlowProcessors);
        FlowRefFactoryBean flowRefFactoryBean = this.createDynamicFlowRefFactoryBean((Processor)targetSubFlowChain, chainBuilder);
        Processor flowRefProcessor = this.getFlowRefProcessor(flowRefFactoryBean);
        Mono.just((Object)event).transform((Function)flowRefProcessor).block();
        ((MuleContextAware)Mockito.verify((Object)((MuleContextAware)targetMuleContextAwareAware), (VerificationMode)Mockito.atLeastOnce())).setMuleContext(this.mockMuleContext);
    }

    private Processor getFlowRefProcessor(FlowRefFactoryBean factoryBean) throws Exception {
        Processor processor = (Processor)factoryBean.getObject();
        LifecycleUtils.setMuleContextIfNeeded((Object)processor, (MuleContext)this.mockMuleContext);
        return processor;
    }

    @Test
    public void dynamicFlowRefDoesNotExist() throws Exception {
        ((ExtendedExpressionManager)Mockito.doReturn((Object)true).when((Object)this.expressionManager)).isExpression(ArgumentMatchers.anyString());
        ((ExtendedExpressionManager)Mockito.doReturn((Object)new TypedValue((Object)"other", DataType.STRING)).when((Object)this.expressionManager)).evaluate((String)ArgumentMatchers.eq((Object)DYNAMIC_NON_EXISTANT), (DataType)ArgumentMatchers.eq((Object)DataType.STRING), (BindingContext)ArgumentMatchers.eq((Object)BindingContextUtils.NULL_BINDING_CONTEXT), (CoreEvent)ArgumentMatchers.any(CoreEvent.class), (ComponentLocation)ArgumentMatchers.any(ComponentLocation.class), ArgumentMatchers.eq((boolean)true));
        this.expectedException.expect(CoreMatchers.instanceOf(RoutePathNotFoundException.class));
        this.getFlowRefProcessor(this.createFlowRefFactoryBean(DYNAMIC_NON_EXISTANT)).process(this.testEvent());
    }

    private FlowRefFactoryBean createFlowRefFactoryBean(String name) throws Exception {
        FlowRefFactoryBean flowRefFactoryBean = new FlowRefFactoryBean();
        flowRefFactoryBean.setName(name);
        flowRefFactoryBean.setAnnotations(Collections.singletonMap(AbstractComponent.LOCATION_KEY, DefaultComponentLocation.fromSingleComponent((String)"flow")));
        flowRefFactoryBean.setApplicationContext(this.applicationContext);
        this.mockMuleContext.getInjector().inject((Object)flowRefFactoryBean);
        return flowRefFactoryBean;
    }

    private FlowRefFactoryBean createStaticFlowRefFactoryBean(Processor target, Object targetBuilder) throws Exception {
        ((ExtendedExpressionManager)Mockito.doReturn((Object)false).when((Object)this.expressionManager)).isExpression(ArgumentMatchers.anyString());
        if (targetBuilder != null) {
            Mockito.when((Object)this.applicationContext.getBean((String)ArgumentMatchers.eq((Object)STATIC_REFERENCED_FLOW))).thenReturn(targetBuilder);
        } else {
            Mockito.when((Object)this.applicationContext.getBean((String)ArgumentMatchers.eq((Object)STATIC_REFERENCED_FLOW))).thenReturn((Object)target);
        }
        if (target instanceof MessageProcessorChain) {
            Processor processor = (Processor)((MessageProcessorChain)target).getMessageProcessors().get(0);
            Mockito.when((Object)processor.apply((Publisher)ArgumentMatchers.any())).thenAnswer(this.successAnswer());
        } else {
            Mockito.when((Object)target.apply((Publisher)ArgumentMatchers.any())).thenAnswer(this.successAnswer());
        }
        return this.createFlowRefFactoryBean(STATIC_REFERENCED_FLOW);
    }

    private FlowRefFactoryBean createDynamicFlowRefFactoryBean(Processor target, Object targetBuilder) throws Exception {
        ((ExtendedExpressionManager)Mockito.doReturn((Object)true).when((Object)this.expressionManager)).isExpression(ArgumentMatchers.anyString());
        ((ExtendedExpressionManager)Mockito.doReturn((Object)new TypedValue((Object)PARSED_DYNAMIC_REFERENCED_FLOW, DataType.STRING)).when((Object)this.expressionManager)).evaluate((String)ArgumentMatchers.eq((Object)DYNAMIC_REFERENCED_FLOW), (DataType)ArgumentMatchers.eq((Object)DataType.STRING), (BindingContext)ArgumentMatchers.eq((Object)BindingContextUtils.NULL_BINDING_CONTEXT), (CoreEvent)ArgumentMatchers.any(CoreEvent.class), (ComponentLocation)ArgumentMatchers.any(ComponentLocation.class), ArgumentMatchers.eq((boolean)true));
        if (targetBuilder != null) {
            Mockito.when((Object)this.applicationContext.getBean((String)ArgumentMatchers.eq((Object)PARSED_DYNAMIC_REFERENCED_FLOW))).thenReturn(targetBuilder);
        } else {
            Mockito.when((Object)this.applicationContext.getBean((String)ArgumentMatchers.eq((Object)PARSED_DYNAMIC_REFERENCED_FLOW))).thenReturn((Object)target);
        }
        if (target instanceof MessageProcessorChain) {
            Processor processor = (Processor)((MessageProcessorChain)target).getMessageProcessors().get(0);
            Mockito.when((Object)processor.apply((Publisher)ArgumentMatchers.any())).thenAnswer(this.successAnswer());
        } else {
            Mockito.when((Object)target.apply((Publisher)ArgumentMatchers.any())).thenAnswer(this.successAnswer());
        }
        return this.createFlowRefFactoryBean(DYNAMIC_REFERENCED_FLOW);
    }

    private Answer<?> successAnswer() {
        return invocation -> Mono.from((Publisher)((Publisher)invocation.getArgument(0))).cast(CoreEvent.class).doOnNext(event -> ((BaseEventContext)event.getContext()).success(CoreEvent.builder((CoreEvent)event).message(this.result.getMessage()).variables(this.result.getVariables()).build())).map(event -> CoreEvent.builder((CoreEvent)event).message(this.result.getMessage()).variables(this.result.getVariables()).build());
    }

    private void verifyProcess(FlowRefFactoryBean flowRefFactoryBean, Processor target) throws Exception {
        Processor flowRefProcessor = this.getFlowRefProcessor(flowRefFactoryBean);
        LifecycleUtils.initialiseIfNeeded((Object)flowRefProcessor);
        LifecycleUtils.startIfNeeded((Object)flowRefProcessor);
        Assert.assertSame((Object)this.result.getMessage(), (Object)((CoreEvent)Mono.just((Object)this.newEvent()).cast(CoreEvent.class).transform((Function)flowRefProcessor).block()).getMessage());
        Assert.assertSame((Object)this.result.getMessage(), (Object)((CoreEvent)Mono.just((Object)this.newEvent()).cast(CoreEvent.class).transform((Function)flowRefProcessor).block()).getMessage());
        ((ApplicationContext)Mockito.verify((Object)this.applicationContext)).getBean(ArgumentMatchers.anyString());
        ((Processor)Mockito.verify((Object)target, (VerificationMode)Mockito.times((int)2))).apply((Publisher)ArgumentMatchers.any(Publisher.class));
        LifecycleUtils.stopIfNeeded((Object)flowRefProcessor);
        LifecycleUtils.disposeIfNeeded((Object)flowRefProcessor, null);
    }

    private void verifyLifecycle(Processor target, int lifecycleRounds) throws Exception {
        ((Initialisable)Mockito.verify((Object)((Initialisable)target), (VerificationMode)Mockito.times((int)lifecycleRounds))).initialise();
        ((MessageProcessorChain)Mockito.verify((Object)this.targetSubFlow, (VerificationMode)Mockito.times((int)lifecycleRounds))).initialise();
        ((MessageProcessorChain)Mockito.verify((Object)this.targetSubFlow, (VerificationMode)Mockito.times((int)lifecycleRounds))).start();
        ((MessageProcessorChain)Mockito.verify((Object)this.targetSubFlow, (VerificationMode)Mockito.times((int)lifecycleRounds))).stop();
        ((MessageProcessorChain)Mockito.verify((Object)this.targetSubFlow, (VerificationMode)Mockito.times((int)lifecycleRounds))).dispose();
    }

    @Test
    public void referencedSubFlowIsStartedWhenCallerFlowIsStartedAfterStop() throws Exception {
        FlowRefFactoryBean flowRefFactoryBean = this.createStaticFlowRefFactoryBean((Processor)this.targetSubFlow, null);
        Processor flowRefProcessor = flowRefFactoryBean.doGetObject();
        flowRefProcessor.process(this.testEvent());
        ((MessageProcessorChain)Mockito.verify((Object)this.targetSubFlow, (VerificationMode)Mockito.times((int)1))).initialise();
        ((MessageProcessorChain)Mockito.verify((Object)this.targetSubFlow, (VerificationMode)Mockito.times((int)1))).start();
        ((MessageProcessorChain)Mockito.verify((Object)this.targetSubFlow, (VerificationMode)Mockito.times((int)0))).stop();
        ((MessageProcessorChain)Mockito.verify((Object)this.targetSubFlow, (VerificationMode)Mockito.times((int)0))).dispose();
        LifecycleUtils.stopIfNeeded((Object)flowRefProcessor);
        ((MessageProcessorChain)Mockito.verify((Object)this.targetSubFlow, (VerificationMode)Mockito.times((int)1))).initialise();
        ((MessageProcessorChain)Mockito.verify((Object)this.targetSubFlow, (VerificationMode)Mockito.times((int)1))).start();
        ((MessageProcessorChain)Mockito.verify((Object)this.targetSubFlow, (VerificationMode)Mockito.times((int)1))).stop();
        ((MessageProcessorChain)Mockito.verify((Object)this.targetSubFlow, (VerificationMode)Mockito.times((int)0))).dispose();
        LifecycleUtils.startIfNeeded((Object)flowRefProcessor);
        ((MessageProcessorChain)Mockito.verify((Object)this.targetSubFlow, (VerificationMode)Mockito.times((int)1))).initialise();
        ((MessageProcessorChain)Mockito.verify((Object)this.targetSubFlow, (VerificationMode)Mockito.times((int)2))).start();
        ((MessageProcessorChain)Mockito.verify((Object)this.targetSubFlow, (VerificationMode)Mockito.times((int)1))).stop();
        ((MessageProcessorChain)Mockito.verify((Object)this.targetSubFlow, (VerificationMode)Mockito.times((int)0))).dispose();
    }
}

