/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.spring;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceConfigurationError;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.ClassUtils;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.ast.api.ComponentMetadataAst;
import org.mule.runtime.config.internal.dsl.model.SpringComponentModel;
import org.mule.runtime.config.internal.dsl.processor.ObjectTypeVisitor;
import org.mule.runtime.config.internal.dsl.spring.BeanDefinitionBuilderHelper;
import org.mule.runtime.config.internal.dsl.spring.BeanDefinitionCreator;
import org.mule.runtime.config.internal.dsl.spring.ComponentConfigurationBuilder;
import org.mule.runtime.config.internal.dsl.spring.CreateBeanDefinitionRequest;
import org.mule.runtime.config.internal.dsl.spring.ObjectFactoryClassRepository;
import org.mule.runtime.config.internal.dsl.spring.PropertyComponentUtils;
import org.mule.runtime.config.internal.dsl.spring.SpringPostProcessorIocHelper;
import org.mule.runtime.config.internal.model.ApplicationModel;
import org.mule.runtime.config.internal.model.ComponentModel;
import org.mule.runtime.config.privileged.dsl.BeanDefinitionPostProcessor;
import org.mule.runtime.core.api.registry.SpiServiceRegistry;
import org.mule.runtime.core.api.security.SecurityFilter;
import org.mule.runtime.core.privileged.execution.LocationExecutionContextProvider;
import org.mule.runtime.core.privileged.processor.SecurityFilterMessageProcessor;
import org.mule.runtime.deployment.model.internal.application.MuleApplicationClassLoader;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.runtime.dsl.api.component.TypeDefinitionVisitor;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.RootBeanDefinition;

public class CommonBeanDefinitionCreator
extends BeanDefinitionCreator {
    private static Set<ComponentIdentifier> genericPropertiesCustomProcessingIdentifiers = ImmutableSet.builder().add((Object)ApplicationModel.CUSTOM_TRANSFORMER_IDENTIFIER).build();
    private final ObjectFactoryClassRepository objectFactoryClassRepository;
    private final BeanDefinitionPostProcessor beanDefinitionPostProcessor;
    private final boolean enableByteBuddy;

    public CommonBeanDefinitionCreator(ObjectFactoryClassRepository objectFactoryClassRepository, boolean enableByteBuddy) {
        this.objectFactoryClassRepository = objectFactoryClassRepository;
        this.beanDefinitionPostProcessor = this.resolvePostProcessor();
        this.enableByteBuddy = enableByteBuddy;
    }

    private BeanDefinitionPostProcessor resolvePostProcessor() {
        for (ClassLoader classLoader : MuleApplicationClassLoader.resolveContextArtifactPluginClassLoaders()) {
            try {
                BeanDefinitionPostProcessor foundProvider = (BeanDefinitionPostProcessor)new SpiServiceRegistry().lookupProvider(BeanDefinitionPostProcessor.class, classLoader);
                if (foundProvider == null) continue;
                return foundProvider;
            }
            catch (Exception | ServiceConfigurationError throwable) {
            }
        }
        return (componentModel, helper) -> {};
    }

    @Override
    public boolean handleRequest(CreateBeanDefinitionRequest request) {
        SpringComponentModel componentModel = request.getComponentModel();
        ComponentBuildingDefinition buildingDefinition = request.getComponentBuildingDefinition();
        componentModel.setType(this.retrieveComponentType(componentModel, buildingDefinition));
        BeanDefinitionBuilder beanDefinitionBuilder = this.createBeanDefinitionBuilder(componentModel, buildingDefinition);
        this.processAnnotations(componentModel, beanDefinitionBuilder);
        this.processComponentDefinitionModel(componentModel, buildingDefinition, beanDefinitionBuilder);
        return true;
    }

    private BeanDefinitionBuilder createBeanDefinitionBuilder(SpringComponentModel componentModel, ComponentBuildingDefinition buildingDefinition) {
        BeanDefinitionBuilder beanDefinitionBuilder = buildingDefinition.getObjectFactoryType() != null ? this.createBeanDefinitionBuilderFromObjectFactory(componentModel, buildingDefinition) : BeanDefinitionBuilder.genericBeanDefinition(componentModel.getType());
        return beanDefinitionBuilder;
    }

    private void processNestedAnnotations(ComponentModel componentModel, Map<QName, Object> previousAnnotations) {
        componentModel.getInnerComponents().stream().filter(cdm -> cdm.getIdentifier().equals(ApplicationModel.ANNOTATIONS_ELEMENT_IDENTIFIER)).findFirst().ifPresent(annotationsCdm -> annotationsCdm.getInnerComponents().forEach(annotationCdm -> previousAnnotations.put(new QName(annotationCdm.getIdentifier().getNamespaceUri(), annotationCdm.getIdentifier().getName()), annotationCdm.getTextContent())));
    }

    private void processAnnotations(ComponentModel componentModel, BeanDefinitionBuilder beanDefinitionBuilder) {
        if (Component.class.isAssignableFrom(componentModel.getType()) || ValueResolver.class.isAssignableFrom(componentModel.getType())) {
            Map<QName, Object> annotations = this.processMetadataAnnotationsHelper(beanDefinitionBuilder, componentModel);
            this.processNestedAnnotations(componentModel, annotations);
            if (!annotations.isEmpty()) {
                beanDefinitionBuilder.addPropertyValue("annotations", annotations);
            }
        }
    }

    private Map<QName, Object> processMetadataAnnotationsHelper(BeanDefinitionBuilder builder, ComponentModel componentModel) {
        HashMap<QName, Object> annotations = new HashMap<QName, Object>();
        if (componentModel == null) {
            return annotations;
        }
        if (Component.class.isAssignableFrom(builder.getBeanDefinition().getBeanClass())) {
            CommonBeanDefinitionCreator.addMetadataAnnotationsFromDocAttributes(annotations, componentModel.getMetadata());
            builder.getBeanDefinition().getPropertyValues().addPropertyValue("annotations", annotations);
        }
        return annotations;
    }

    public static void addMetadataAnnotationsFromDocAttributes(Map<QName, Object> beanAnnotations, ComponentMetadataAst metadata) {
        String sourceCode = metadata.getSourceCode().orElse(null);
        if (sourceCode != null) {
            beanAnnotations.put(Component.Annotations.SOURCE_ELEMENT_ANNOTATION_KEY, LocationExecutionContextProvider.maskPasswords((String)sourceCode));
        }
        beanAnnotations.putAll(metadata.getDocAttributes().entrySet().stream().collect(Collectors.toMap(e -> QName.valueOf((String)e.getKey()), e -> (String)e.getValue())));
    }

    private Class<?> retrieveComponentType(ComponentModel componentModel, ComponentBuildingDefinition componentBuildingDefinition) {
        ObjectTypeVisitor objectTypeVisitor = new ObjectTypeVisitor(componentModel);
        componentBuildingDefinition.getTypeDefinition().visit((TypeDefinitionVisitor)objectTypeVisitor);
        return objectTypeVisitor.getType();
    }

    private BeanDefinitionBuilder createBeanDefinitionBuilderFromObjectFactory(SpringComponentModel componentModel, ComponentBuildingDefinition componentBuildingDefinition) {
        ObjectTypeVisitor objectTypeVisitor = new ObjectTypeVisitor(componentModel);
        componentBuildingDefinition.getTypeDefinition().visit((TypeDefinitionVisitor)objectTypeVisitor);
        Class objectFactoryType = componentBuildingDefinition.getObjectFactoryType();
        Map<String, Object> customProperties = this.getTransformerCustomProperties(componentModel);
        Optional<Object> instanceCustomizationFunctionOptional = customProperties.isEmpty() ? Optional.empty() : Optional.of(object -> this.injectSpringProperties(customProperties, object));
        if (!this.enableByteBuddy) {
            return BeanDefinitionBuilder.rootBeanDefinition(this.objectFactoryClassRepository.getObjectFactoryDynamicClass(componentBuildingDefinition, objectFactoryType, componentModel.getType(), (Supplier<Boolean>)new LazyValue(() -> componentModel.getBeanDefinition().isLazyInit()), instanceCustomizationFunctionOptional));
        }
        return BeanDefinitionBuilder.rootBeanDefinition(this.objectFactoryClassRepository.getObjectFactoryClass(objectFactoryType, instanceCustomizationFunctionOptional.isPresent(), componentModel.getType())).addPropertyValue("isSingleton", (Object)(!componentBuildingDefinition.isPrototype() ? 1 : 0)).addPropertyValue("isPrototype", (Object)componentBuildingDefinition.isPrototype()).addPropertyValue("isEagerInit", (Object)new LazyValue(() -> !componentModel.getBeanDefinition().isLazyInit())).addPropertyValue("instanceCustomizationFunctionOptional", instanceCustomizationFunctionOptional);
    }

    private void injectSpringProperties(Map<String, Object> customProperties, Object createdInstance) {
        try {
            for (String propertyName : customProperties.keySet()) {
                BeanUtils.copyProperty((Object)createdInstance, (String)propertyName, (Object)customProperties.get(propertyName));
            }
        }
        catch (Exception e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private Map<String, Object> getTransformerCustomProperties(ComponentModel componentModel) {
        ComponentIdentifier identifier = componentModel.getIdentifier();
        if (!identifier.equals(ApplicationModel.CUSTOM_TRANSFORMER_IDENTIFIER)) {
            return Collections.emptyMap();
        }
        return componentModel.getInnerComponents().stream().filter(innerComponent -> innerComponent.getIdentifier().equals(ApplicationModel.MULE_PROPERTY_IDENTIFIER)).map(springComponent -> PropertyComponentUtils.getPropertyValueFromPropertyComponent(springComponent)).collect(Collectors.toMap(propValue -> (String)propValue.getFirst(), propValue -> propValue.getSecond()));
    }

    private void processComponentDefinitionModel(SpringComponentModel componentModel, ComponentBuildingDefinition componentBuildingDefinition, BeanDefinitionBuilder beanDefinitionBuilder) {
        AbstractBeanDefinition wrappedBeanDefinition;
        AbstractBeanDefinition originalBeanDefinition;
        this.processObjectConstructionParameters(componentModel, componentBuildingDefinition, new BeanDefinitionBuilderHelper(beanDefinitionBuilder));
        CommonBeanDefinitionCreator.processMuleProperties(componentModel, beanDefinitionBuilder, this.beanDefinitionPostProcessor);
        if (componentBuildingDefinition.isPrototype()) {
            beanDefinitionBuilder.setScope("prototype");
        }
        if ((originalBeanDefinition = beanDefinitionBuilder.getBeanDefinition()) != (wrappedBeanDefinition = this.adaptBeanDefinition(originalBeanDefinition))) {
            componentModel.setType(wrappedBeanDefinition.getBeanClass());
        }
        SpringPostProcessorIocHelper iocHelper = new SpringPostProcessorIocHelper(this.objectFactoryClassRepository, wrappedBeanDefinition, this.enableByteBuddy);
        componentModel.setBeanDefinition((BeanDefinition)iocHelper.getBeanDefinition());
    }

    static void processMuleProperties(ComponentModel componentModel, BeanDefinitionBuilder beanDefinitionBuilder, BeanDefinitionPostProcessor beanDefinitionPostProcessor) {
        if (genericPropertiesCustomProcessingIdentifiers.contains(componentModel.getIdentifier()) || beanDefinitionPostProcessor != null && beanDefinitionPostProcessor.getGenericPropertiesCustomProcessingIdentifiers().contains(componentModel.getIdentifier())) {
            return;
        }
        componentModel.getInnerComponents().stream().filter(innerComponent -> {
            ComponentIdentifier identifier = innerComponent.getIdentifier();
            return identifier.equals(ApplicationModel.MULE_PROPERTY_IDENTIFIER) || identifier.equals(ApplicationModel.MULE_PROPERTIES_IDENTIFIER);
        }).forEach(propertyComponentModel -> {
            Pair<String, Object> propertyValue = PropertyComponentUtils.getPropertyValueFromPropertyComponent(propertyComponentModel);
            beanDefinitionBuilder.addPropertyValue((String)propertyValue.getFirst(), propertyValue.getSecond());
        });
    }

    public static List<Pair<String, Object>> getPropertyValueFromPropertiesComponent(ComponentModel propertyComponentModel) {
        ArrayList<Pair<String, Object>> propertyValues = new ArrayList<Pair<String, Object>>();
        propertyComponentModel.getInnerComponents().stream().forEach(entryComponentModel -> propertyValues.add(new Pair((Object)entryComponentModel.getRawParameters().get("key"), (Object)entryComponentModel.getRawParameters().get("value"))));
        return propertyValues;
    }

    private void processObjectConstructionParameters(ComponentModel componentModel, ComponentBuildingDefinition componentBuildingDefinition, BeanDefinitionBuilderHelper beanDefinitionBuilderHelper) {
        new ComponentConfigurationBuilder(componentModel, componentBuildingDefinition, beanDefinitionBuilderHelper).processConfiguration();
    }

    private AbstractBeanDefinition adaptBeanDefinition(AbstractBeanDefinition originalBeanDefinition) {
        Class beanClass;
        if (originalBeanDefinition instanceof RootBeanDefinition) {
            beanClass = ((RootBeanDefinition)originalBeanDefinition).getBeanClass();
        } else {
            try {
                beanClass = originalBeanDefinition.getBeanClass();
            }
            catch (IllegalStateException e) {
                try {
                    beanClass = ClassUtils.getClass((String)originalBeanDefinition.getBeanClassName());
                }
                catch (ClassNotFoundException e2) {
                    throw new RuntimeException(e2);
                }
            }
        }
        if (CommonBeanDefinitionCreator.areMatchingTypes(SecurityFilter.class, beanClass)) {
            AbstractBeanDefinition newBeanDefinition = BeanDefinitionBuilder.rootBeanDefinition(SecurityFilterMessageProcessor.class).addConstructorArgValue((Object)originalBeanDefinition).getBeanDefinition();
            return newBeanDefinition;
        }
        SpringPostProcessorIocHelper iocHelper = new SpringPostProcessorIocHelper(this.objectFactoryClassRepository, originalBeanDefinition, this.enableByteBuddy);
        return iocHelper.getBeanDefinition();
    }

    public static boolean areMatchingTypes(Class<?> superType, Class<?> childType) {
        return superType.isAssignableFrom(childType);
    }
}

