/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.config.internal.DeclaredDependencyResolver;
import org.mule.runtime.config.internal.SpringRegistry;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.internal.lifecycle.InjectedDependenciesProvider;
import org.springframework.context.ApplicationContext;

@Issue(value="MULE-19984")
@Feature(value="Lifecycle and Dependency Injection")
@Story(value="Lifecycle Phase")
public class DeclaredDependencyResolverTestCase {
    private DeclaredDependencyResolver declaredDependencyResolver;
    private SpringRegistry springRegistry;
    private InjectedDependenciesProvider object;

    @Before
    public void setUp() throws Exception {
        this.springRegistry = (SpringRegistry)Mockito.mock(SpringRegistry.class);
        this.object = (InjectedDependenciesProvider)Mockito.mock(InjectedDependenciesProvider.class);
        this.declaredDependencyResolver = new DeclaredDependencyResolver(this.springRegistry);
    }

    @Test
    @Description(value="check if getDeclaredDirectDependencies properly interacts with InjectedDependencyProvider")
    public void getDeclaredDirectDependenciesInteractionTest() {
        this.declaredDependencyResolver.getDeclaredDependencies((Object)this.object);
        ((InjectedDependenciesProvider)Mockito.verify((Object)this.object, (VerificationMode)Mockito.atLeastOnce())).getInjectedDependencies();
    }

    @Test
    @Description(value="check if the method returns declared dependencies correctly")
    public void getDeclaredDirectDependenciesTest() {
        Class<MuleContext> type = MuleContext.class;
        String beanName = "muleContext";
        Object ob = new Object();
        Mockito.when((Object)this.object.getInjectedDependencies()).thenReturn(Arrays.asList(Either.left(type)));
        Mockito.when((Object)this.springRegistry.get(beanName)).thenReturn(ob);
        String[] beanNames = new String[]{beanName};
        ApplicationContext context = (ApplicationContext)Mockito.mock(ApplicationContext.class);
        Mockito.when((Object)this.springRegistry.getApplicationContext()).thenReturn((Object)context);
        Mockito.when((Object)context.getBeanNamesForType(type)).thenReturn((Object)beanNames);
        Assert.assertThat((Object)this.declaredDependencyResolver.getDeclaredDependencies((Object)this.object).size(), (Matcher)Matchers.is((Object)1));
    }
}

