/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.config.internal.InjectParamsFromContextServiceMethodInvoker;
import org.mule.runtime.config.utils.Utils;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.registry.IllegalDependencyInjectionException;
import org.mule.runtime.core.privileged.registry.LegacyRegistryUtils;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class InjectParamsFromContextServiceMethodInvokerTestCase
extends AbstractMuleContextTestCase {
    @Rule
    public ExpectedException expected = ExpectedException.none();
    @Inject
    private Registry registry;
    private InjectParamsFromContextServiceMethodInvoker injectParamsFromContextServiceMethodInvoker;
    private Method method;

    protected boolean doTestClassInjection() {
        return true;
    }

    @Before
    public void setUp() throws NoSuchMethodException {
        this.injectParamsFromContextServiceMethodInvoker = new InjectParamsFromContextServiceMethodInvoker(this.registry);
        this.method = Utils.BaseService.class.getMethod("augmented", new Class[0]);
    }

    @Test
    public void notAugmentedInvocation() throws Throwable {
        Utils.BasicService service = new Utils.BasicService();
        this.injectParamsFromContextServiceMethodInvoker.invoke((Object)service, this.method, null);
        Assert.assertThat((Object)Utils.augmentedParam, (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void augmentedInvocation() throws Throwable {
        Utils.AugmentedMethodService service = new Utils.AugmentedMethodService();
        this.injectParamsFromContextServiceMethodInvoker.invoke((Object)service, this.method, null);
        Assert.assertThat((Object)Utils.augmentedParam, (Matcher)Matchers.sameInstance((Object)muleContext));
    }

    @Test
    public void augmentedSubclassInvocation() throws Throwable {
        Utils.AugmentedSubclassMethodService service = new Utils.AugmentedSubclassMethodService();
        this.injectParamsFromContextServiceMethodInvoker.invoke((Object)service, this.method, null);
        Assert.assertThat((Object)Utils.augmentedParam, (Matcher)Matchers.sameInstance((Object)muleContext));
    }

    @Test
    public void augmentedSubclassOverridesInvocation() throws Throwable {
        Utils.AugmentedSubclassOverridesMethodService service = new Utils.AugmentedSubclassOverridesMethodService();
        this.injectParamsFromContextServiceMethodInvoker.invoke((Object)service, this.method, null);
        Assert.assertThat((Object)Utils.augmentedParam, (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void augmentedWithPreferredInvocation() throws Throwable {
        LegacyRegistryUtils.registerObject((MuleContext)muleContext, (String)"myBean", (Object)new Utils.MyBean());
        Utils.MyPreferredBean preferredBean = new Utils.MyPreferredBean();
        LegacyRegistryUtils.registerObject((MuleContext)muleContext, (String)"myPreferredBean", (Object)preferredBean);
        Utils.AugmentedWithPreferredMethodService service = new Utils.AugmentedWithPreferredMethodService();
        this.injectParamsFromContextServiceMethodInvoker.invoke((Object)service, this.method, null);
        Assert.assertThat((Object)Utils.augmentedParam, (Matcher)Matchers.sameInstance((Object)preferredBean));
    }

    @Test
    public void namedAugmentedInvocation() throws Throwable {
        Utils.NamedAugmentedMethodService service = new Utils.NamedAugmentedMethodService();
        this.injectParamsFromContextServiceMethodInvoker.invoke((Object)service, this.method, null);
        Assert.assertThat((Object)Utils.augmentedParam, (Matcher)Matchers.sameInstance((Object)muleContext));
    }

    @Test
    public void invalidNamedAugmentedInvocation() throws Throwable {
        Utils.InvalidNamedAugmentedMethodService service = new Utils.InvalidNamedAugmentedMethodService();
        this.expected.expect(IllegalDependencyInjectionException.class);
        this.expected.expectMessage(String.format("No object found in the registry for parameter '%s' of method '%s' in service '%s'", "param", this.method.getName(), service.toString()));
        this.injectParamsFromContextServiceMethodInvoker.invoke((Object)service, this.method, null);
    }

    @Test
    public void hiddenAugmentedInvocation() throws Throwable {
        Utils.HiddenAugmentedMethodService service = new Utils.HiddenAugmentedMethodService();
        this.injectParamsFromContextServiceMethodInvoker.invoke((Object)service, this.method, null);
        Assert.assertThat((Object)Utils.augmentedParam, (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void overloadedAugmentedInvocation() throws Throwable {
        Utils.OverloadedAugmentedMethodService service = new Utils.OverloadedAugmentedMethodService();
        this.injectParamsFromContextServiceMethodInvoker.invoke((Object)service, this.method, null);
        Assert.assertThat((Object)Utils.augmentedParam, (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void overloadedAugmentedInvocation2() throws Throwable {
        Utils.OverloadedAugmentedMethodService service = new Utils.OverloadedAugmentedMethodService();
        List<Method> methods = Arrays.asList(Utils.OverloadedAugmentedMethodService.class.getMethods());
        Optional<Method> method = methods.stream().filter(m -> m.getName().equals("augmented") && m.getParameterCount() == 1 && !m.getParameters()[0].getName().contains("context")).findFirst();
        this.injectParamsFromContextServiceMethodInvoker.invoke((Object)service, method.get(), new Object[]{1});
        Assert.assertThat((Object)Utils.augmentedParam, (Matcher)Matchers.sameInstance((Object)muleContext));
    }

    @Test
    public void ambiguousAugmentedInvocation() throws Throwable {
        Utils.AmbiguousAugmentedMethodService service = new Utils.AmbiguousAugmentedMethodService();
        this.expected.expectMessage(String.format("More than one invocation candidate for method '%s' in service '%s'", this.method.getName(), service.toString()));
        this.expected.expect(IllegalDependencyInjectionException.class);
        this.injectParamsFromContextServiceMethodInvoker.invoke((Object)service, this.method, null);
        Assert.assertThat((Object)Utils.augmentedParam, (Matcher)Matchers.nullValue());
    }

    @Test
    public void invalidAugmentedInvocation() throws Throwable {
        Utils.InvalidAugmentedMethodService service = new Utils.InvalidAugmentedMethodService();
        this.injectParamsFromContextServiceMethodInvoker.invoke((Object)service, this.method, null);
        Assert.assertThat((Object)Utils.augmentedParam, (Matcher)Matchers.is((Object)true));
    }
}

