/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal;

import io.qameta.allure.Issue;
import java.util.HashMap;
import javax.inject.Inject;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mule.runtime.api.config.Feature;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.config.internal.SpringXmlConfigurationBuilder;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.runtime.extension.api.dsl.syntax.resources.spi.ExtensionSchemaGenerator;
import org.mule.tck.util.MuleContextUtils;

public class SpringXmlConfigurationBuilderTestCase {
    public static final String SCHEMA_VALIDATION_ERROR = "Can't resolve http://www.mulesoft.org/schema/mule/invalid-namespace/current/invalid-schema.xsd, A dependency or plugin might be missing";
    @Inject
    private FeatureFlaggingService featureFlaggingService;
    private SpringXmlConfigurationBuilder configurationBuilderWithUsedInvalidSchema;
    private SpringXmlConfigurationBuilder configurationBuilderWitUnusedInvalidSchema;
    private MuleContextWithRegistry muleContext;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setUp() throws Exception {
        this.muleContext = MuleContextUtils.mockContextWithServices();
        this.muleContext.getInjector().inject((Object)this);
        this.configurationBuilderWithUsedInvalidSchema = new SpringXmlConfigurationBuilder(new String[]{"invalid-schema.xml"}, new HashMap(), ArtifactType.APP, false, false);
        this.configurationBuilderWitUnusedInvalidSchema = new SpringXmlConfigurationBuilder(new String[]{"invalid-schema-not-used.xml"}, new HashMap(), ArtifactType.APP, false, false);
    }

    @Test
    @Issue(value="MULE-19534")
    public void configureWithFailOnFirstError() throws ConfigurationException {
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)SCHEMA_VALIDATION_ERROR));
        Mockito.when((Object)this.featureFlaggingService.isEnabled((Feature)MuleRuntimeFeature.ENTITY_RESOLVER_FAIL_ON_FIRST_ERROR)).thenReturn((Object)true);
        this.configurationBuilderWithUsedInvalidSchema.configure((MuleContext)this.muleContext);
    }

    @Test
    @Issue(value="MULE-19534")
    public void configureWithFailAfterTenErrors() throws ConfigurationException {
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)SCHEMA_VALIDATION_ERROR));
        Mockito.when((Object)this.featureFlaggingService.isEnabled((Feature)MuleRuntimeFeature.ENTITY_RESOLVER_FAIL_ON_FIRST_ERROR)).thenReturn((Object)false);
        this.configurationBuilderWithUsedInvalidSchema.configure((MuleContext)this.muleContext);
    }

    @Test
    @Issue(value="MULE-19534")
    public void configureWithFailAfterTenErrorsWillSucceedIfSchemaNotUsed() throws ConfigurationException {
        Mockito.when((Object)this.featureFlaggingService.isEnabled((Feature)MuleRuntimeFeature.ENTITY_RESOLVER_FAIL_ON_FIRST_ERROR)).thenReturn((Object)false);
        this.configurationBuilderWitUnusedInvalidSchema.configure((MuleContext)this.muleContext);
    }

    public static final class TestExtensionSchemagenerator
    implements ExtensionSchemaGenerator {
        public String generate(ExtensionModel extensionModel, DslResolvingContext context) {
            return "";
        }
    }
}

