/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.spring;

import java.util.Map;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentGenerationInformation;
import org.mule.runtime.ast.api.ComponentMetadataAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.config.internal.dsl.model.SpringComponentModel;
import org.mule.runtime.config.internal.dsl.spring.CreateBeanDefinitionRequest;
import org.mule.runtime.config.internal.dsl.spring.CreateComponentBeanDefinitionRequest;
import org.mule.runtime.config.internal.dsl.spring.SimpleTypeBeanComponentDefinitionCreator;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.runtime.dsl.api.component.TypeConverter;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.springframework.beans.factory.config.BeanDefinition;

public class SimpleTypeBeanDefinitionCreatorTestCase
extends AbstractMuleTestCase {
    public static final String TEST_STRING_RAW_VALUE = "Test Raw Value";
    private SimpleTypeBeanComponentDefinitionCreator simpleTypeBeanDefinitionCreator;
    private Map<ComponentAst, SpringComponentModel> springComponentModels;
    private CreateComponentBeanDefinitionRequest createBeanDefinitionRequest;

    @Before
    public void setUp() {
        this.simpleTypeBeanDefinitionCreator = new SimpleTypeBeanComponentDefinitionCreator();
        this.createBeanDefinitionRequest = (CreateComponentBeanDefinitionRequest)Mockito.mock(CreateComponentBeanDefinitionRequest.class);
        SpringComponentModel springComponentModel = new SpringComponentModel();
        Mockito.when((Object)this.createBeanDefinitionRequest.getSpringComponentModel()).thenReturn((Object)springComponentModel);
    }

    @Test
    public void testHandleRequestReturnsFalse_WhenCreateBeanDefinitionRequestTypeIsNotSimpleType() {
        SpringComponentModel springComponentModel = this.createBeanDefinitionRequest.getSpringComponentModel();
        springComponentModel.setType(SimpleTypeBeanDefinitionCreatorTestCase.class);
        boolean result = this.simpleTypeBeanDefinitionCreator.handleRequest(this.springComponentModels, (CreateBeanDefinitionRequest)this.createBeanDefinitionRequest);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testHandleRequestReturnsTrue_WhenCreateBeanDefinitionRequestTypeIsSimpleTypeAndParamFoundInOwnerComponent() {
        SpringComponentModel springComponentModel = this.createBeanDefinitionRequest.getSpringComponentModel();
        springComponentModel.setType(String.class);
        MyComponentParameterAst paramInOwnerComponent = new MyComponentParameterAst();
        ComponentAst componentModel = (ComponentAst)Mockito.mock(ComponentAst.class);
        Mockito.when((Object)componentModel.getParameter("General", "value")).thenReturn((Object)paramInOwnerComponent);
        Mockito.when((Object)this.createBeanDefinitionRequest.getComponent()).thenReturn((Object)componentModel);
        this.mockComponentBuildingDefinition((CreateBeanDefinitionRequest)this.createBeanDefinitionRequest, Optional.empty());
        boolean result = this.simpleTypeBeanDefinitionCreator.handleRequest(this.springComponentModels, (CreateBeanDefinitionRequest)this.createBeanDefinitionRequest);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testHandleRequestCallsSetBeanDefinitionWithResultGetConvertibleBeanDefinition_WhenCreateBeanDefinitionRequestTypeIsSimpleTypeAndParamFoundInOwnerComponentAndNoTypeConverter() {
        SpringComponentModel springComponentModel = (SpringComponentModel)Mockito.mock(SpringComponentModel.class);
        Mockito.when((Object)springComponentModel.getType()).then(inv -> String.class);
        Mockito.when((Object)this.createBeanDefinitionRequest.getSpringComponentModel()).thenReturn((Object)springComponentModel);
        MyComponentParameterAst paramInOwnerComponent = new MyComponentParameterAst();
        ComponentAst componentModel = (ComponentAst)Mockito.mock(ComponentAst.class);
        Mockito.when((Object)componentModel.getParameter("General", "value")).thenReturn((Object)paramInOwnerComponent);
        Mockito.when((Object)this.createBeanDefinitionRequest.getComponent()).thenReturn((Object)componentModel);
        this.mockComponentBuildingDefinition((CreateBeanDefinitionRequest)this.createBeanDefinitionRequest, Optional.empty());
        this.simpleTypeBeanDefinitionCreator.handleRequest(this.springComponentModels, (CreateBeanDefinitionRequest)this.createBeanDefinitionRequest);
        ArgumentCaptor beanDefinitionArgumentCaptor = ArgumentCaptor.forClass(BeanDefinition.class);
        ((SpringComponentModel)Mockito.verify((Object)springComponentModel, (VerificationMode)Mockito.times((int)1))).setBeanDefinition((BeanDefinition)beanDefinitionArgumentCaptor.capture());
        BeanDefinition value = (BeanDefinition)beanDefinitionArgumentCaptor.getValue();
        MatcherAssert.assertThat((Object)value.getBeanClassName(), (Matcher)Matchers.is((Object)String.class.getName()));
        MatcherAssert.assertThat((Object)value.getConstructorArgumentValues().getArgumentValue(0, String.class).getValue(), (Matcher)Matchers.is((Object)TEST_STRING_RAW_VALUE));
    }

    @Test
    public void testHandleRequestCallsSetBeanDefinitionWithResultGetConvertibleBeanDefinition_WhenCreateBeanDefinitionRequestTypeIsSimpleTypeAndParamFoundInOwnerComponentAndTypeConverter() {
        SpringComponentModel springComponentModel = (SpringComponentModel)Mockito.mock(SpringComponentModel.class);
        Mockito.when((Object)springComponentModel.getType()).then(inv -> String.class);
        Mockito.when((Object)this.createBeanDefinitionRequest.getSpringComponentModel()).thenReturn((Object)springComponentModel);
        MyComponentParameterAst paramInOwnerComponent = new MyComponentParameterAst();
        ComponentAst componentModel = (ComponentAst)Mockito.mock(ComponentAst.class);
        Mockito.when((Object)componentModel.getParameter("General", "value")).thenReturn((Object)paramInOwnerComponent);
        Mockito.when((Object)this.createBeanDefinitionRequest.getComponent()).thenReturn((Object)componentModel);
        this.mockComponentBuildingDefinition((CreateBeanDefinitionRequest)this.createBeanDefinitionRequest, Optional.of(o -> TEST_STRING_RAW_VALUE));
        this.simpleTypeBeanDefinitionCreator.handleRequest(this.springComponentModels, (CreateBeanDefinitionRequest)this.createBeanDefinitionRequest);
        ArgumentCaptor beanDefinitionArgumentCaptor = ArgumentCaptor.forClass(BeanDefinition.class);
        ((SpringComponentModel)Mockito.verify((Object)springComponentModel, (VerificationMode)Mockito.times((int)1))).setBeanDefinition((BeanDefinition)beanDefinitionArgumentCaptor.capture());
        BeanDefinition value = (BeanDefinition)beanDefinitionArgumentCaptor.getValue();
        MatcherAssert.assertThat((Object)value.getBeanClassName(), (Matcher)Matchers.is((Object)"org.mule.runtime.config.internal.factories.ConstantFactoryBean"));
        MatcherAssert.assertThat((Object)value.getConstructorArgumentValues().getArgumentValue(0, String.class).getValue(), (Matcher)Matchers.is((Object)TEST_STRING_RAW_VALUE));
    }

    @Test
    public void testHandleRequestReturnsTrue_WhenCreateBeanDefinitionRequestTypeIsSimpleTypeAndParamNotFoundInOwnerComponentButFoundInComponentModel() {
        SpringComponentModel springComponentModel = this.createBeanDefinitionRequest.getSpringComponentModel();
        springComponentModel.setType(String.class);
        ComponentAst componentModel = (ComponentAst)Mockito.mock(ComponentAst.class);
        ComponentParameterAst componentParameterAst = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        Mockito.when((Object)componentParameterAst.getResolvedRawValue()).thenReturn((Object)TEST_STRING_RAW_VALUE);
        Mockito.when((Object)componentModel.getParameter("General", "value")).thenReturn((Object)componentParameterAst);
        Mockito.when((Object)this.createBeanDefinitionRequest.getComponent()).thenReturn((Object)componentModel);
        this.mockComponentBuildingDefinition((CreateBeanDefinitionRequest)this.createBeanDefinitionRequest, Optional.empty());
        boolean result = this.simpleTypeBeanDefinitionCreator.handleRequest(this.springComponentModels, (CreateBeanDefinitionRequest)this.createBeanDefinitionRequest);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testHandleRequestCallsSetBeanDefinitionWithResultGetConvertibleBeanDefinition_WhenCreateBeanDefinitionRequestTypeIsSimpleTypeAndParamNotFoundInOwnerComponentButFoundInComponentModelAndNoTypeConverter() {
        SpringComponentModel springComponentModel = (SpringComponentModel)Mockito.mock(SpringComponentModel.class);
        Mockito.when((Object)springComponentModel.getType()).then(inv -> String.class);
        Mockito.when((Object)this.createBeanDefinitionRequest.getSpringComponentModel()).thenReturn((Object)springComponentModel);
        ComponentAst componentModel = (ComponentAst)Mockito.mock(ComponentAst.class);
        ComponentParameterAst componentParameterAst = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        Mockito.when((Object)componentParameterAst.getResolvedRawValue()).thenReturn((Object)TEST_STRING_RAW_VALUE);
        Mockito.when((Object)componentModel.getParameter("General", "value")).thenReturn((Object)componentParameterAst);
        Mockito.when((Object)this.createBeanDefinitionRequest.getComponent()).thenReturn((Object)componentModel);
        this.mockComponentBuildingDefinition((CreateBeanDefinitionRequest)this.createBeanDefinitionRequest, Optional.empty());
        this.simpleTypeBeanDefinitionCreator.handleRequest(this.springComponentModels, (CreateBeanDefinitionRequest)this.createBeanDefinitionRequest);
        ArgumentCaptor beanDefinitionArgumentCaptor = ArgumentCaptor.forClass(BeanDefinition.class);
        ((SpringComponentModel)Mockito.verify((Object)springComponentModel, (VerificationMode)Mockito.times((int)1))).setBeanDefinition((BeanDefinition)beanDefinitionArgumentCaptor.capture());
        BeanDefinition value = (BeanDefinition)beanDefinitionArgumentCaptor.getValue();
        MatcherAssert.assertThat((Object)value.getBeanClassName(), (Matcher)Matchers.is((Object)String.class.getName()));
        MatcherAssert.assertThat((Object)value.getConstructorArgumentValues().getArgumentValue(0, String.class).getValue(), (Matcher)Matchers.is((Object)TEST_STRING_RAW_VALUE));
    }

    @Test
    public void testHandleRequestCallsSetBeanDefinitionWithResultGetConvertibleBeanDefinition_WhenCreateBeanDefinitionRequestTypeIsSimpleTypeAndParamNotFoundInOwnerComponentButFoundInComponentModelAndTypeConverter() {
        SpringComponentModel springComponentModel = (SpringComponentModel)Mockito.mock(SpringComponentModel.class);
        Mockito.when((Object)springComponentModel.getType()).then(inv -> String.class);
        Mockito.when((Object)this.createBeanDefinitionRequest.getSpringComponentModel()).thenReturn((Object)springComponentModel);
        ComponentAst componentModel = (ComponentAst)Mockito.mock(ComponentAst.class);
        ComponentParameterAst componentParameterAst = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        Mockito.when((Object)componentParameterAst.getResolvedRawValue()).thenReturn((Object)TEST_STRING_RAW_VALUE);
        Mockito.when((Object)componentModel.getParameter("General", "value")).thenReturn((Object)componentParameterAst);
        Mockito.when((Object)this.createBeanDefinitionRequest.getComponent()).thenReturn((Object)componentModel);
        this.mockComponentBuildingDefinition((CreateBeanDefinitionRequest)this.createBeanDefinitionRequest, Optional.of(o -> TEST_STRING_RAW_VALUE));
        this.simpleTypeBeanDefinitionCreator.handleRequest(this.springComponentModels, (CreateBeanDefinitionRequest)this.createBeanDefinitionRequest);
        ArgumentCaptor beanDefinitionArgumentCaptor = ArgumentCaptor.forClass(BeanDefinition.class);
        ((SpringComponentModel)Mockito.verify((Object)springComponentModel, (VerificationMode)Mockito.times((int)1))).setBeanDefinition((BeanDefinition)beanDefinitionArgumentCaptor.capture());
        BeanDefinition value = (BeanDefinition)beanDefinitionArgumentCaptor.getValue();
        MatcherAssert.assertThat((Object)value.getBeanClassName(), (Matcher)Matchers.is((Object)"org.mule.runtime.config.internal.factories.ConstantFactoryBean"));
        MatcherAssert.assertThat((Object)value.getConstructorArgumentValues().getArgumentValue(0, String.class).getValue(), (Matcher)Matchers.is((Object)TEST_STRING_RAW_VALUE));
    }

    private void mockComponentBuildingDefinition(CreateBeanDefinitionRequest createBeanDefinitionRequest, Optional<TypeConverter> typeConverterOptional) {
        ComponentBuildingDefinition componentBuildingDefinition = (ComponentBuildingDefinition)Mockito.mock(ComponentBuildingDefinition.class);
        Mockito.when((Object)componentBuildingDefinition.getTypeConverter()).thenReturn(typeConverterOptional);
        Mockito.when((Object)createBeanDefinitionRequest.getComponentBuildingDefinition()).thenReturn((Object)componentBuildingDefinition);
    }

    private static class MyComponentParameterAst
    implements ComponentParameterAst {
        private MyComponentParameterAst() {
        }

        public ParameterModel getModel() {
            return null;
        }

        public ParameterGroupModel getGroupModel() {
            return null;
        }

        public <T> Either<String, T> getValue() {
            return null;
        }

        public String getRawValue() {
            return null;
        }

        public String getResolvedRawValue() {
            return SimpleTypeBeanDefinitionCreatorTestCase.TEST_STRING_RAW_VALUE;
        }

        public Optional<ComponentMetadataAst> getMetadata() {
            return Optional.empty();
        }

        public ComponentGenerationInformation getGenerationInformation() {
            return null;
        }

        public boolean isDefaultValue() {
            return false;
        }
    }
}

