/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsEqual;
import org.junit.Test;
import org.mule.runtime.core.internal.config.CustomService;
import org.mule.runtime.core.internal.config.DefaultCustomizationService;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class DefaultCustomizationServiceTestCase
extends AbstractMuleTestCase {
    public static final String SERVICE_ID = "foo";
    private DefaultCustomizationService customizationService = new DefaultCustomizationService();

    @Test
    public void overridesDefaultServiceClass() throws Exception {
        Class<String> serviceClass = String.class;
        this.customizationService.overrideDefaultServiceClass(SERVICE_ID, serviceClass);
        CustomService customService = (CustomService)this.customizationService.getOverriddenService(SERVICE_ID).get();
        this.assertServiceClass(customService, serviceClass);
    }

    @Test
    public void overridesDefaultService() throws Exception {
        Object service = new Object();
        this.customizationService.overrideDefaultServiceImpl(SERVICE_ID, service);
        CustomService customService = (CustomService)this.customizationService.getOverriddenService(SERVICE_ID).get();
        this.assertServiceInstance(customService, service);
    }

    @Test
    public void registersCustomServiceClass() throws Exception {
        Class<String> serviceClass = String.class;
        this.customizationService.registerCustomServiceClass(SERVICE_ID, serviceClass);
        MatcherAssert.assertThat((Object)this.customizationService.getCustomServices().size(), (Matcher)IsEqual.equalTo((Object)1));
        CustomService customService = (CustomService)this.customizationService.getCustomServices().get(SERVICE_ID);
        this.assertServiceClass(customService, serviceClass);
    }

    @Test
    public void registersCustomService() throws Exception {
        Object service = new Object();
        this.customizationService.registerCustomServiceImpl(SERVICE_ID, service);
        MatcherAssert.assertThat((Object)this.customizationService.getCustomServices().size(), (Matcher)IsEqual.equalTo((Object)1));
        CustomService customService = (CustomService)this.customizationService.getCustomServices().get(SERVICE_ID);
        this.assertServiceInstance(customService, service);
    }

    private void assertServiceInstance(CustomService customService, Object service) {
        MatcherAssert.assertThat(customService.getServiceImpl().get(), (Matcher)IsEqual.equalTo((Object)service));
        MatcherAssert.assertThat((Object)customService.getServiceClass().isPresent(), (Matcher)Is.is((Object)false));
    }

    private void assertServiceClass(CustomService customService, Class<String> serviceClass) {
        MatcherAssert.assertThat(customService.getServiceClass().get(), (Matcher)IsEqual.equalTo(serviceClass));
        MatcherAssert.assertThat((Object)customService.getServiceImpl().isPresent(), (Matcher)Is.is((Object)false));
    }
}

