/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.runtime.config.internal.BeanWrapper;
import org.mule.runtime.config.internal.DependencyGraphBeanDependencyResolver;
import org.mule.runtime.config.internal.DependencyGraphLifecycleObjectSorter;
import org.mule.runtime.core.api.config.Config;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.security.SecurityManager;
import org.mule.runtime.core.api.streaming.DefaultStreamingManager;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.api.util.queue.QueueManager;
import org.mule.runtime.core.internal.el.mvel.ExpressionLanguageExtension;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;

@Issue(value="MULE-19984")
@Feature(value="Lifecycle and Dependency Injection")
@Story(value="Lifecycle Phase")
public class DependencyGraphLifecycleObjectSorterTestCase {
    private DependencyGraphLifecycleObjectSorter sorter;
    private DependencyGraphBeanDependencyResolver resolver;
    private DefaultStreamingManager objectA;
    private DefaultStreamingManager objectB;
    private DefaultStreamingManager objectC;
    private List<String> lookupObjects;

    @Before
    public void setUp() throws Exception {
        this.resolver = (DependencyGraphBeanDependencyResolver)Mockito.mock(DependencyGraphBeanDependencyResolver.class);
        this.sorter = new DependencyGraphLifecycleObjectSorter(this.resolver, new Class[]{LockFactory.class, ObjectStoreManager.class, ExpressionLanguageExtension.class, ExpressionLanguage.class, QueueManager.class, StreamingManager.class, ConfigurationProvider.class, Config.class, SecurityManager.class, FlowConstruct.class, MuleConfiguration.class, Initialisable.class});
        this.lookupObjects = new ArrayList<String>();
        this.objectA = new DefaultStreamingManager();
        this.objectB = new DefaultStreamingManager();
        this.objectC = new DefaultStreamingManager();
        this.lookupObjects.add("objectA");
        this.lookupObjects.add("objectB");
        this.lookupObjects.add("objectC");
        this.sorter.setLifeCycleObjectNameOrder(this.lookupObjects);
    }

    @Test
    @Description(value="When one of the 12 lifecycle type objects is added, the object should be on the final list.")
    public void addOneLifecycleTypeObjectTest() {
        DefaultStreamingManager lifecycleObject = new DefaultStreamingManager();
        this.sorter.addObject("lifecycleObject", (Object)lifecycleObject);
        MatcherAssert.assertThat((Object)this.sorter.getSortedObjects(), (Matcher)Matchers.contains((Object[])new Object[]{lifecycleObject}));
    }

    @Test
    @Description(value="When an object that isn't on the ignored types list is added, it shouldn't be on the final list.")
    public void addIgnoredObjectTest() {
        String ignoredObject = "string";
        this.sorter.addObject("ignoredObject", (Object)ignoredObject);
        MatcherAssert.assertThat((Object)this.sorter.getSortedObjects(), (Matcher)Matchers.empty());
    }

    @Test
    @Description(value="Sort components without adding any components.")
    public void emptyListTest() {
        MatcherAssert.assertThat((Object)this.sorter.getSortedObjects(), (Matcher)Matchers.empty());
    }

    @Test
    @Description(value="Sort components after adding duplicate components.")
    public void detectDuplicateComponentsTest() {
        DefaultStreamingManager sameComponent = new DefaultStreamingManager();
        this.sorter.addObject("sameComponent", (Object)sameComponent);
        this.sorter.addObject("sameComponent", (Object)sameComponent);
        this.sorter.addObject("sameComponent", (Object)sameComponent);
        this.sorter.addObject("sameComponent", (Object)sameComponent);
        MatcherAssert.assertThat((Object)this.sorter.getSortedObjects().size(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    @Description(value="Sort components for a graph with multiple levels (When A -> C means A depends on C, A->C and C->B should return a list B - C - A.")
    public void sortComponentsTest() {
        BeanWrapper componentA = new BeanWrapper("objectA", (Object)this.objectA);
        BeanWrapper componentB = new BeanWrapper("objectB", (Object)this.objectB);
        BeanWrapper componentC = new BeanWrapper("objectC", (Object)this.objectC);
        List<BeanWrapper> directDependenciesOfA = Arrays.asList(componentC);
        List<BeanWrapper> directDependenciesOfC = Arrays.asList(componentB);
        LinkedHashMap<BeanWrapper, List<BeanWrapper>> transitiveDependenciesOfA = new LinkedHashMap<BeanWrapper, List<BeanWrapper>>();
        transitiveDependenciesOfA.put(componentA, directDependenciesOfA);
        transitiveDependenciesOfA.put(componentC, directDependenciesOfC);
        LinkedHashMap transitiveDependenciesOfB = new LinkedHashMap();
        transitiveDependenciesOfB.put(componentB, Collections.emptyList());
        LinkedHashMap transitiveDependenciesOfC = new LinkedHashMap();
        transitiveDependenciesOfC.put(componentC, Collections.emptyList());
        Mockito.when((Object)this.resolver.getTransitiveDependencies("objectA", 5)).thenReturn(transitiveDependenciesOfA);
        Mockito.when((Object)this.resolver.getTransitiveDependencies("objectB", 5)).thenReturn(transitiveDependenciesOfB);
        Mockito.when((Object)this.resolver.getTransitiveDependencies("objectC", 5)).thenReturn(transitiveDependenciesOfC);
        this.sorter.addObject("objectA", (Object)this.objectA);
        this.sorter.addObject("objectB", (Object)this.objectB);
        this.sorter.addObject("objectC", (Object)this.objectC);
        MatcherAssert.assertThat((Object)this.sorter.getSortedObjects(), (Matcher)Matchers.containsInRelativeOrder((Object[])new Object[]{this.objectB, this.objectC, this.objectA}));
    }

    @Test
    @Description(value="Sort components when two components are sharing the same prerequisite. A -> C, B -> C: C should be initialized before A and B.")
    public void sortComponentsWithSharedChildTest() {
        BeanWrapper componentA = new BeanWrapper("objectA", (Object)this.objectA);
        BeanWrapper componentB = new BeanWrapper("objectB", (Object)this.objectB);
        BeanWrapper componentC = new BeanWrapper("objectC", (Object)this.objectC);
        List<BeanWrapper> dependenciesOfA = Arrays.asList(componentC);
        List<BeanWrapper> dependenciesOfB = Arrays.asList(componentC);
        HashMap<BeanWrapper, List<Object>> transitiveDependenciesOfA = new HashMap<BeanWrapper, List<Object>>();
        transitiveDependenciesOfA.put(componentA, dependenciesOfA);
        transitiveDependenciesOfA.put(componentC, Collections.emptyList());
        HashMap<BeanWrapper, List<Object>> transitiveDependenciesOfB = new HashMap<BeanWrapper, List<Object>>();
        transitiveDependenciesOfB.put(componentB, dependenciesOfB);
        transitiveDependenciesOfB.put(componentC, Collections.emptyList());
        Mockito.when((Object)this.resolver.getTransitiveDependencies("objectA", 5)).thenReturn(transitiveDependenciesOfA);
        Mockito.when((Object)this.resolver.getTransitiveDependencies("objectB", 5)).thenReturn(transitiveDependenciesOfB);
        Mockito.when((Object)this.resolver.getTransitiveDependencies("objectC", 5)).thenReturn(Collections.emptyMap());
        this.sorter.setLifeCycleObjectNameOrder(this.lookupObjects);
        this.sorter.addObject("objectA", (Object)this.objectA);
        this.sorter.addObject("objectB", (Object)this.objectB);
        this.sorter.addObject("objectC", (Object)this.objectC);
        MatcherAssert.assertThat((Object)this.sorter.getSortedObjects(), (Matcher)Matchers.anyOf((Matcher)Matchers.containsInRelativeOrder((Object[])new Object[]{this.objectC, this.objectA}), (Matcher)Matchers.containsInRelativeOrder((Object[])new Object[]{this.objectC, this.objectB})));
    }

    @Test(expected=NullPointerException.class)
    @Description(value="If a null component is added to the graph, it will throw NullPointerException.")
    public void handleNullObjectTest() {
        this.sorter.addObject("objectA", null);
    }

    @Test
    @Description(value="Duplicate components should be ignored if added again")
    public void sortComponentsWhenAddingDuplicatesTest() {
        BeanWrapper componentA = new BeanWrapper("objectA", (Object)this.objectA);
        BeanWrapper componentB = new BeanWrapper("objectB", (Object)this.objectB);
        Mockito.when((Object)this.resolver.getDirectBeanDependencies(componentA, 5)).thenReturn(Arrays.asList(componentB));
        Mockito.when((Object)this.resolver.getDirectBeanDependencies(componentB, 5)).thenReturn(Arrays.asList(new BeanWrapper[0]));
        this.sorter.addObject("objectA", (Object)this.objectA);
        this.sorter.addObject("objectB", (Object)this.objectB);
        this.sorter.addObject("objectA", (Object)this.objectA);
        this.sorter.addObject("objectA", (Object)this.objectA);
        MatcherAssert.assertThat((Object)this.sorter.getSortedObjects().size(), (Matcher)Matchers.is((Object)2));
    }

    @Test
    @Description(value="Detect cycles and remove the latest edge added to the graph to use top sort. (When A -> B, B -> C, C -> A, the last edge that creates a cycle will be removed.")
    public void detectIndirectCycleTest() {
        BeanWrapper componentA = new BeanWrapper("objectA", (Object)this.objectA);
        BeanWrapper componentB = new BeanWrapper("objectB", (Object)this.objectB);
        BeanWrapper componentC = new BeanWrapper("objectC", (Object)this.objectC);
        List<BeanWrapper> dependenciesOfA = Arrays.asList(componentB);
        List<BeanWrapper> dependenciesOfB = Arrays.asList(componentC);
        List<BeanWrapper> dependenciesOfC = Arrays.asList(componentA);
        LinkedHashMap<BeanWrapper, List<BeanWrapper>> transitiveDependenciesOfA = new LinkedHashMap<BeanWrapper, List<BeanWrapper>>();
        transitiveDependenciesOfA.put(componentA, dependenciesOfA);
        transitiveDependenciesOfA.put(componentB, dependenciesOfB);
        transitiveDependenciesOfA.put(componentC, dependenciesOfC);
        LinkedHashMap transitiveDependenciesOfB = new LinkedHashMap();
        transitiveDependenciesOfB.put(componentB, Collections.emptyList());
        LinkedHashMap transitiveDependenciesOfC = new LinkedHashMap();
        transitiveDependenciesOfC.put(componentC, Collections.emptyList());
        Mockito.when((Object)this.resolver.getDirectBeanDependencies(componentA, 5)).thenReturn(dependenciesOfA);
        Mockito.when((Object)this.resolver.getDirectBeanDependencies(componentB, 5)).thenReturn(dependenciesOfB);
        Mockito.when((Object)this.resolver.getDirectBeanDependencies(componentC, 5)).thenReturn(dependenciesOfC);
        Mockito.when((Object)this.resolver.getTransitiveDependencies("objectA", 5)).thenReturn(transitiveDependenciesOfA);
        Mockito.when((Object)this.resolver.getTransitiveDependencies("objectB", 5)).thenReturn(transitiveDependenciesOfB);
        Mockito.when((Object)this.resolver.getTransitiveDependencies("objectC", 5)).thenReturn(transitiveDependenciesOfC);
        this.sorter.setLifeCycleObjectNameOrder(this.lookupObjects);
        this.sorter.addObject("objectA", (Object)this.objectA);
        this.sorter.addObject("objectB", (Object)this.objectB);
        this.sorter.addObject("objectC", (Object)this.objectC);
        MatcherAssert.assertThat((Object)this.sorter.getSortedObjects(), (Matcher)Matchers.containsInRelativeOrder((Object[])new Object[]{this.objectC, this.objectA}));
    }

    @Test
    @Description(value="When adding C -> (non initializable) D -> A-> B, the order of initialisables should be BAC.")
    public void transitiveDependenciesTest() {
        String objectD = "objectD";
        BeanWrapper componentA = new BeanWrapper("objectA", (Object)this.objectA);
        BeanWrapper componentB = new BeanWrapper("objectB", (Object)this.objectB);
        BeanWrapper componentC = new BeanWrapper("objectC", (Object)this.objectC);
        BeanWrapper componentD = new BeanWrapper("objectD", (Object)objectD);
        List<BeanWrapper> dependenciesOfA = Arrays.asList(componentB);
        List<BeanWrapper> dependenciesOfC = Arrays.asList(componentD);
        List<BeanWrapper> dependenciesOfD = Arrays.asList(componentA);
        LinkedHashMap<BeanWrapper, List<Object>> transitiveDependenciesOfA = new LinkedHashMap<BeanWrapper, List<Object>>();
        transitiveDependenciesOfA.put(componentA, dependenciesOfA);
        transitiveDependenciesOfA.put(componentB, Collections.emptyList());
        LinkedHashMap transitiveDependenciesOfB = new LinkedHashMap();
        transitiveDependenciesOfB.put(componentB, Collections.emptyList());
        LinkedHashMap<BeanWrapper, List<Object>> transitiveDependenciesOfC = new LinkedHashMap<BeanWrapper, List<Object>>();
        transitiveDependenciesOfC.put(componentC, dependenciesOfC);
        transitiveDependenciesOfC.put(componentD, dependenciesOfD);
        transitiveDependenciesOfC.put(componentA, Collections.emptyList());
        transitiveDependenciesOfC.put(componentB, Collections.emptyList());
        Mockito.when((Object)this.resolver.getDirectBeanDependencies(componentA, 5)).thenReturn(dependenciesOfA);
        Mockito.when((Object)this.resolver.getDirectBeanDependencies(componentB, 5)).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.resolver.getDirectBeanDependencies(componentC, 5)).thenReturn(dependenciesOfC);
        Mockito.when((Object)this.resolver.getDirectBeanDependencies(componentD, 5)).thenReturn(dependenciesOfD);
        Mockito.when((Object)this.resolver.getTransitiveDependencies("objectA", 5)).thenReturn(transitiveDependenciesOfA);
        Mockito.when((Object)this.resolver.getTransitiveDependencies("objectB", 5)).thenReturn(transitiveDependenciesOfB);
        Mockito.when((Object)this.resolver.getTransitiveDependencies("objectC", 5)).thenReturn(transitiveDependenciesOfC);
        this.sorter.setLifeCycleObjectNameOrder(this.lookupObjects);
        this.sorter.addObject("objectA", (Object)this.objectA);
        this.sorter.addObject("objectB", (Object)this.objectB);
        this.sorter.addObject("objectC", (Object)this.objectC);
        MatcherAssert.assertThat((Object)this.sorter.getSortedObjects(), (Matcher)Matchers.containsInRelativeOrder((Object[])new Object[]{this.objectB, this.objectA, this.objectC}));
    }
}

