/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config;

import java.util.Collection;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.config.internal.DefaultOptionalObjectsController;
import org.mule.runtime.config.internal.OptionalObjectsController;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class DefaultOptionalObjectsControllerTestCase
extends AbstractMuleTestCase {
    private static final String OPTIONAL_KEY = "optional";
    private static final String DISCARDED_KEY = "discarded";
    private OptionalObjectsController optionalObjectsController;

    @Before
    public void before() {
        this.optionalObjectsController = new DefaultOptionalObjectsController();
        this.optionalObjectsController.registerOptionalKey(OPTIONAL_KEY);
        this.optionalObjectsController.discardOptionalObject(DISCARDED_KEY);
    }

    @Test
    public void isOptional() {
        Assert.assertThat((Object)this.optionalObjectsController.isOptional(OPTIONAL_KEY), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.optionalObjectsController.isOptional(DISCARDED_KEY), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void isDiscarded() {
        Assert.assertThat((Object)this.optionalObjectsController.isDiscarded(OPTIONAL_KEY), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.optionalObjectsController.isDiscarded(DISCARDED_KEY), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void getAllDiscardedKeys() {
        Collection allKeys = this.optionalObjectsController.getAllOptionalKeys();
        Assert.assertThat((Object)allKeys, (Matcher)Matchers.contains((Object[])new String[]{OPTIONAL_KEY}));
    }

    @Test
    public void getDiscardedObjectPlaceholder() {
        Assert.assertThat((Object)this.optionalObjectsController.getDiscardedObjectPlaceholder(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
    }
}

