/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config;

import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.config.internal.SpringXmlConfigurationBuilder;
import org.mule.runtime.core.api.config.ConfigurationBuilder;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class LocalStoreAliasConfigTestCase
extends AbstractMuleContextTestCase {
    protected ConfigurationBuilder getBuilder() throws Exception {
        return new SpringXmlConfigurationBuilder(new String[0], Collections.emptyMap());
    }

    @Test
    public void inMemoryObjectStore() throws Exception {
        this.testSame("_defaultInMemoryObjectStore", "_localInMemoryObjectStore");
    }

    @Test
    public void persistentObjectStore() throws Exception {
        this.testSame("_defaultPersistentObjectStore", "_localPersistentObjectStore");
    }

    @Test
    public void queueManager() throws Exception {
        this.testSame("_muleQueueManager", "_localQueueManager");
        Assert.assertSame((Object)muleContext.getQueueManager(), (Object)((MuleContextWithRegistry)muleContext).getRegistry().lookupObject("_localQueueManager"));
    }

    @Test
    public void objectStoreManager() throws Exception {
        this.testSame("_muleObjectStoreManager", "_muleLocalObjectStoreManager");
        Assert.assertSame((Object)muleContext.getObjectStoreManager(), (Object)((MuleContextWithRegistry)muleContext).getRegistry().lookupObject("_muleLocalObjectStoreManager"));
    }

    private void testSame(String key1, String key2) {
        Object obj1 = ((MuleContextWithRegistry)muleContext).getRegistry().lookupObject(key1);
        Object obj2 = ((MuleContextWithRegistry)muleContext).getRegistry().lookupObject(key2);
        Assert.assertSame((Object)obj1, (Object)obj2);
    }
}

