/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.model;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mule.runtime.config.internal.dsl.model.CoreComponentBuildingDefinitionProvider;
import org.mule.runtime.core.privileged.exception.TemplateOnErrorHandler;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@Issue(value="W-11117613")
@Feature(value="Error Handling")
@Story(value="Global Error Handler")
@RunWith(value=Parameterized.class)
public class CoreComponentBuildingDefinitionProviderTestCase
extends AbstractMuleTestCase {
    @Rule
    public MockitoRule mockitoRule = MockitoJUnit.rule();
    private CoreComponentBuildingDefinitionProvider provider;

    public CoreComponentBuildingDefinitionProviderTestCase(String reuseGlobalErrorHandler) {
        TemplateOnErrorHandler.reuseGlobalErrorHandler = Boolean.parseBoolean(reuseGlobalErrorHandler);
    }

    @Parameterized.Parameters(name="enable system property: {0}")
    public static Collection params() {
        return Arrays.asList("true", "false");
    }

    @Before
    public void setUp() throws Exception {
        this.provider = new CoreComponentBuildingDefinitionProvider();
    }

    @After
    public void tearDown() throws Exception {
        TemplateOnErrorHandler.reuseGlobalErrorHandler = null;
    }

    @Test
    public void isPrototype() {
        ComponentBuildingDefinition buildingDefinition = this.provider.getErrorHandlerBuilder().build();
        MatcherAssert.assertThat((Object)buildingDefinition.isPrototype(), (Matcher)Matchers.is((Matcher)Matchers.not((Object)TemplateOnErrorHandler.reuseGlobalErrorHandler)));
    }
}

