/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.config.internal.AutoDiscoveredDependencyResolver;
import org.mule.runtime.config.internal.SpringRegistry;

@Issue(value="MULE-19984")
@Feature(value="Lifecycle and Dependency Injection")
@Story(value="Lifecycle Phase")
public class AutoDiscoveredDependencyResolverTestCase {
    private AutoDiscoveredDependencyResolver autoDiscoveredDependencyResolver;
    private SpringRegistry springRegistry;

    @Before
    public void setUp() throws Exception {
        this.springRegistry = (SpringRegistry)Mockito.mock(SpringRegistry.class);
        this.autoDiscoveredDependencyResolver = new AutoDiscoveredDependencyResolver(this.springRegistry);
    }

    @Test
    @Description(value="check if getAutoDiscoveredDependency properly interacts with springRegistry")
    public void getAutoDiscoveredDependenciesTest() {
        String beanName = "component";
        this.autoDiscoveredDependencyResolver.getAutoDiscoveredDependencies(beanName);
        ((SpringRegistry)Mockito.verify((Object)this.springRegistry, (VerificationMode)Mockito.times((int)1))).getDependencies(beanName);
    }
}

