/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.lazy;

import com.google.common.collect.ImmutableSet;
import io.qameta.allure.Feature;
import io.qameta.allure.Features;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.memory.management.MemoryManagementService;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.app.declaration.api.GlobalElementDeclaration;
import org.mule.runtime.app.declaration.api.fluent.ElementDeclarer;
import org.mule.runtime.config.api.LazyComponentInitializer;
import org.mule.runtime.config.api.dsl.ArtifactDeclarationUtils;
import org.mule.runtime.config.dsl.model.AbstractDslModelTestCase;
import org.mule.runtime.config.internal.DefaultComponentBuildingDefinitionRegistryFactory;
import org.mule.runtime.config.internal.LazyMuleArtifactContext;
import org.mule.runtime.config.internal.ObjectProviderAwareBeanFactory;
import org.mule.runtime.config.internal.OptionalObjectsController;
import org.mule.runtime.config.internal.context.BaseConfigurationComponentLocator;
import org.mule.runtime.config.internal.model.ComponentBuildingDefinitionRegistryFactory;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.extension.MuleExtensionModelProvider;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.internal.config.CustomServiceRegistry;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.runtime.core.internal.exception.ContributedErrorTypeLocator;
import org.mule.runtime.core.internal.exception.ContributedErrorTypeRepository;
import org.mule.runtime.core.internal.registry.DefaultRegistry;
import org.mule.runtime.core.internal.registry.MuleRegistry;
import org.mule.runtime.core.privileged.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.runtime.extension.api.model.ImmutableExtensionModel;
import org.mule.tck.util.MuleContextUtils;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

@Features(value={@Feature(value="Lazy Initialization"), @Feature(value="Configuration component locator")})
@Story(value="Component life cycle")
public class LazyComponentInitializerAdapterTestCase
extends AbstractDslModelTestCase {
    private LazyMuleArtifactContext lazyMuleArtifactContext;
    private static final String MY_FLOW = "myFlow";
    @Mock
    private ObjectProviderAwareBeanFactory beanFactory;
    @Mock
    private ExtensionManager extensionManager;
    @Mock
    private CustomServiceRegistry customizationService;
    @Mock
    private OptionalObjectsController optionalObjectsController;
    @Mock
    private LockFactory lockFactory;
    @Mock(extraInterfaces={Initialisable.class, Disposable.class, Startable.class, Stoppable.class})
    private Processor targetProcessor;
    private MuleContextWithRegistry muleContext;
    private AtomicInteger initializations;

    @Before
    public void setup() throws Exception {
        this.initializations = new AtomicInteger(0);
        this.muleContext = MuleContextUtils.mockContextWithServices();
        ImmutableSet extensions = ImmutableSet.builder().add((Object)MuleExtensionModelProvider.getExtensionModel()).add((Object)this.mockExtension).build();
        DefaultMessageProcessorChainBuilder messageProcessorChainBuilder = new DefaultMessageProcessorChainBuilder().chain(new Processor[]{this.targetProcessor});
        MuleRegistry mockedRegistry = this.muleContext.getRegistry();
        Mockito.when((Object)this.extensionManager.getExtensions()).thenReturn((Object)extensions);
        Mockito.when((Object)this.muleContext.getExecutionClassLoader()).thenReturn((Object)Thread.currentThread().getContextClassLoader());
        Mockito.when((Object)this.muleContext.getExtensionManager()).thenReturn((Object)this.extensionManager);
        Mockito.when((Object)this.muleContext.getCustomizationService()).thenReturn((Object)this.customizationService);
        Mockito.when((Object)mockedRegistry.lookupObject(MY_FLOW)).thenReturn((Object)messageProcessorChainBuilder);
        Mockito.when((Object)mockedRegistry.get("_muleRegistry")).thenReturn((Object)new DefaultRegistry((MuleContext)this.muleContext));
        Mockito.when((Object)this.beanFactory.getSingletonMutex()).thenReturn((Object)"mutex");
        ((ObjectProviderAwareBeanFactory)Mockito.doReturn((Object)new String[0]).when((Object)this.beanFactory)).getBeanNamesForType((Class)ArgumentMatchers.any(Class.class), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean());
        ((ObjectProviderAwareBeanFactory)Mockito.doNothing().when((Object)this.beanFactory)).setSerializationId((String)ArgumentMatchers.any(String.class));
        this.lazyMuleArtifactContext = this.createLazyMuleArtifactContextStub(this.beanFactory);
        ((Initialisable)Mockito.doAnswer(a -> {
            this.initializations.incrementAndGet();
            return null;
        }).when((Object)((Initialisable)this.targetProcessor))).initialise();
    }

    @Test
    @Issue(value="MULE-17400")
    public void shouldNotCreateBeansForSameLocationRequest() {
        Location location = Location.builderFromStringRepresentation((String)MY_FLOW).build();
        this.lazyMuleArtifactContext.initializeComponent(location);
        this.lazyMuleArtifactContext.initializeComponent(location);
        MatcherAssert.assertThat((Object)this.initializations.get(), (Matcher)Is.is((Object)1));
    }

    @Test
    @Issue(value="MULE-17400")
    public void shouldCreateBeansForSameLocationRequestIfDifferentPhaseApplied() {
        Location location = Location.builderFromStringRepresentation((String)MY_FLOW).build();
        this.lazyMuleArtifactContext.initializeComponent(location, false);
        this.lazyMuleArtifactContext.initializeComponent(location);
        MatcherAssert.assertThat((Object)this.initializations.get(), (Matcher)Is.is((Object)2));
    }

    @Test
    @Issue(value="MULE-17400")
    public void shouldNotCreateBeansForSameLocationFilterRequest() {
        LazyComponentInitializer.ComponentLocationFilter filter = loc -> loc.getLocation().equals(MY_FLOW);
        this.lazyMuleArtifactContext.initializeComponents(filter);
        this.lazyMuleArtifactContext.initializeComponents(filter);
        MatcherAssert.assertThat((Object)this.initializations.get(), (Matcher)Is.is((Object)1));
    }

    @Test
    @Issue(value="MULE-17400")
    public void shouldCreateBeansForSameLocationFilterRequestIfDifferentPhaseApplied() {
        LazyComponentInitializer.ComponentLocationFilter filter = loc -> loc.getLocation().equals(MY_FLOW);
        this.lazyMuleArtifactContext.initializeComponents(filter, false);
        this.lazyMuleArtifactContext.initializeComponents(filter);
        MatcherAssert.assertThat((Object)this.initializations.get(), (Matcher)Is.is((Object)2));
    }

    @Override
    protected ExtensionModel createExtension(String name, XmlDslModel xmlDslModel, List<ConfigurationModel> configs, List<ConnectionProviderModel> connectionProviders) {
        return new ImmutableExtensionModel("extension", "", "1.0", "Mulesoft", Category.COMMUNITY, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null, xmlDslModel, Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
    }

    private ArtifactDeclaration getSimpleApp() {
        return (ArtifactDeclaration)ElementDeclarer.newArtifact().withGlobalElement((GlobalElementDeclaration)ElementDeclarer.forExtension((String)"mule").newConstruct("flow").withRefName(MY_FLOW).getDeclaration()).getDeclaration();
    }

    private LazyMuleArtifactContext createLazyMuleArtifactContextStub(final ObjectProviderAwareBeanFactory beanFactory) {
        LazyMuleArtifactContext muleArtifactContext = new LazyMuleArtifactContext((MuleContext)this.muleContext, ArtifactDeclarationUtils.toArtifactast((ArtifactDeclaration)this.getSimpleApp(), this.getExtensions(this.muleContext.getExtensionManager())), this.optionalObjectsController, Optional.empty(), new BaseConfigurationComponentLocator(), new ContributedErrorTypeRepository(), new ContributedErrorTypeLocator(), Collections.emptyMap(), ArtifactType.APP, Optional.empty(), this.lockFactory, (ComponentBuildingDefinitionRegistryFactory)new DefaultComponentBuildingDefinitionRegistryFactory(), (MemoryManagementService)Mockito.mock(MemoryManagementService.class), (FeatureFlaggingService)Mockito.mock(FeatureFlaggingService.class)){

            protected DefaultListableBeanFactory createBeanFactory() {
                return beanFactory;
            }
        };
        muleArtifactContext.refresh();
        return muleArtifactContext;
    }

    private Set<ExtensionModel> getExtensions(ExtensionManager extensionManager) {
        return extensionManager == null ? Collections.emptySet() : extensionManager.getExtensions();
    }
}

