/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.registry;

import com.google.common.graph.Traverser;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.config.internal.dsl.model.ConfigurationDependencyResolver;
import org.mule.runtime.config.internal.registry.BeanDependencyResolver;
import org.mule.runtime.config.internal.registry.SpringContextRegistry;
import org.mule.runtime.core.internal.lifecycle.InjectedDependenciesProvider;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public class DefaultBeanDependencyResolver
implements BeanDependencyResolver {
    private final SpringContextRegistry springRegistry;
    private final ConfigurationDependencyResolver configurationDependencyResolver;

    public DefaultBeanDependencyResolver(ConfigurationDependencyResolver configurationDependencyResolver, SpringContextRegistry springRegistry) {
        this.configurationDependencyResolver = configurationDependencyResolver;
        this.springRegistry = springRegistry;
    }

    @Override
    public List<Object> resolveBeanDependencies(String beanName) {
        DependencyNode root = new DependencyNode(null);
        this.addDependency(root, beanName, this.springRegistry.get(beanName));
        return StreamSupport.stream(Traverser.forTree(DependencyNode::getChildren).depthFirstPostOrder((Object)root).spliterator(), false).filter(node -> node != root).map(DependencyNode::getValue).collect(Collectors.toList());
    }

    private void addDependency(DependencyNode parent, String key, Object object) {
        this.addDependency(parent, key, object, new HashSet<String>());
    }

    private void addDependency(DependencyNode parent, String key, Object object, Set<String> processedKeys) {
        DependencyNode node = new DependencyNode(object);
        parent.addChild(node);
        if (!processedKeys.add(key)) {
            return;
        }
        this.addAutoDiscoveredDependencies(key, processedKeys, node);
        this.addConfigurationDependencies(key, processedKeys, node);
        this.addDeclaredDependencies(object, processedKeys, node);
    }

    private void addDeclaredDependencies(Object object, Set<String> processedKeys, DependencyNode node) {
        if (object instanceof InjectedDependenciesProvider) {
            ((InjectedDependenciesProvider)object).getInjectedDependencies().forEach(dependency -> ((List)dependency.reduce(type -> Stream.of(this.springRegistry.getBeanNamesForType((Class)dependency.getLeft())).map(name -> new Pair(name, this.springRegistry.get((String)name))).collect(Collectors.toList()), name -> Arrays.asList(new Pair(name, this.springRegistry.get((String)name))))).forEach(pair -> this.addDependency(node, (String)pair.getFirst(), pair.getSecond(), processedKeys)));
        }
    }

    private void addConfigurationDependencies(String key, Set<String> processedKeys, DependencyNode node) {
        if (this.configurationDependencyResolver == null) {
            return;
        }
        for (String dependency : this.configurationDependencyResolver.resolveComponentDependencies(key)) {
            try {
                if (!this.springRegistry.isSingleton(dependency)) continue;
                this.addDependency(node, dependency, this.springRegistry.get(dependency), processedKeys);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {}
        }
    }

    private void addAutoDiscoveredDependencies(String key, Set<String> processedKeys, DependencyNode node) {
        for (Map.Entry<String, Object> dependency : this.springRegistry.getDependencies(key).entrySet()) {
            this.addDependency(node, dependency.getKey(), dependency.getValue(), processedKeys);
        }
    }

    private class DependencyNode {
        private final Object value;
        private final List<DependencyNode> children = new LinkedList<DependencyNode>();

        private DependencyNode(Object value) {
            this.value = value;
        }

        public DependencyNode addChild(DependencyNode child) {
            this.children.add(child);
            return this;
        }

        public List<DependencyNode> getChildren() {
            return this.children;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

