/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.dsl.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.app.declaration.api.ConfigurationElementDeclaration;
import org.mule.runtime.app.declaration.api.ConnectionElementDeclaration;
import org.mule.runtime.app.declaration.api.ElementDeclaration;
import org.mule.runtime.app.declaration.api.OperationElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterGroupElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterValue;
import org.mule.runtime.app.declaration.api.SourceElementDeclaration;
import org.mule.runtime.app.declaration.api.TopLevelParameterDeclaration;
import org.mule.runtime.app.declaration.api.fluent.ConfigurationElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ConnectionElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.OperationElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ParameterObjectValue;
import org.mule.runtime.app.declaration.api.fluent.SourceElementDeclarer;
import org.mule.runtime.config.api.dsl.model.DslElementModel;
import org.mule.runtime.config.api.dsl.model.DslElementModelFactory;
import org.mule.runtime.config.dsl.model.AbstractDslModelTestCase;
import org.mule.runtime.dsl.api.component.config.ComponentConfiguration;
import org.mule.runtime.extension.api.model.ImmutableExtensionModel;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;

public class DeclarationElementModelFactoryTestCase
extends AbstractDslModelTestCase {
    @Test
    public void testConfigDeclarationToElement() {
        ElementDeclarer ext = ElementDeclarer.forExtension((String)"extension");
        ConfigurationElementDeclaration declaration = (ConfigurationElementDeclaration)((ConfigurationElementDeclarer)ext.newConfiguration("configuration").withRefName("sample").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("myCamelCaseName", "#[{field: value}]").withParameter("otherName", "additional").withParameter("listName", (ParameterValue)ElementDeclarer.newListValue().withValue("itemValue").build()).getDeclaration())).withConnection((ConnectionElementDeclaration)((ConnectionElementDeclarer)ext.newConnection("connection").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("myCamelCaseName", "#[{field: value}]").withParameter("otherName", "additional").withParameter("listName", (ParameterValue)ElementDeclarer.newListValue().withValue("itemValue").build()).getDeclaration())).getDeclaration()).getDeclaration();
        DslElementModel configElement = this.create((ElementDeclaration)declaration);
        MatcherAssert.assertThat((Object)configElement.getModel(), (Matcher)Is.is((Object)this.configuration));
        MatcherAssert.assertThat((Object)configElement.getContainedElements().size(), (Matcher)Is.is((Object)4));
        MatcherAssert.assertThat((Object)configElement.findElement("otherName").isPresent(), (Matcher)Is.is((Object)true));
        this.assertBehaviourParameter(configElement);
        MatcherAssert.assertThat((Object)configElement.findElement("myCamelCaseName").isPresent(), (Matcher)Is.is((Object)true));
        this.assertContentParameter((DslElementModel)configElement.getContainedElements().get(1));
        MatcherAssert.assertThat((Object)configElement.findElement("listName").isPresent(), (Matcher)Is.is((Object)true));
        this.assertListParameter((DslElementModel)configElement.getContainedElements().get(3));
        MatcherAssert.assertThat((Object)configElement.findElement("connection").isPresent(), (Matcher)Is.is((Object)true));
        DslElementModel connectionElement = (DslElementModel)configElement.getContainedElements().get(0);
        MatcherAssert.assertThat((Object)connectionElement.getContainedElements().size(), (Matcher)Is.is((Object)3));
        this.assertBehaviourParameter(connectionElement);
        this.assertContentParameter((DslElementModel)connectionElement.findElement("myCamelCaseName").get());
        this.assertListParameter((DslElementModel)connectionElement.findElement("listName").get());
    }

    private void assertContentParameter(DslElementModel<?> contentModel) {
        MatcherAssert.assertThat(((ComponentConfiguration)contentModel.getConfiguration().get()).getValue().get(), (Matcher)Is.is((Object)"#[{field: value}]"));
    }

    private void assertBehaviourParameter(DslElementModel<?> elementModel) {
        MatcherAssert.assertThat(((ComponentConfiguration)elementModel.getConfiguration().get()).getParameters().get("otherName"), (Matcher)Is.is((Object)"additional"));
    }

    private void assertListParameter(DslElementModel<?> listModel) {
        MatcherAssert.assertThat((Object)listModel.getContainedElements().size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)((DslElementModel)listModel.getContainedElements().get(0)).getDsl().getElementName(), (Matcher)Is.is((Object)"list-name-item"));
        DslElementModel itemModel = (DslElementModel)listModel.getContainedElements().get(0);
        MatcherAssert.assertThat((Object)((DslElementModel)itemModel.getContainedElements().get(0)).getDsl().getAttributeName(), (Matcher)Is.is((Object)"value"));
        MatcherAssert.assertThat(((DslElementModel)itemModel.getContainedElements().get(0)).getValue().get(), (Matcher)Is.is((Object)"itemValue"));
    }

    @Test
    public void testOperationDeclarationToElement() {
        ElementDeclarer ext = ElementDeclarer.forExtension((String)"extension");
        OperationElementDeclaration declaration = (OperationElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)ext.newOperation("mockOperation").withConfig("configuration")).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("myCamelCaseName", "#[{field: value}]").withParameter("otherName", "additional").getDeclaration())).getDeclaration();
        DslElementModel element = this.create((ElementDeclaration)declaration);
        MatcherAssert.assertThat((Object)element.getModel(), (Matcher)Is.is((Object)this.operation));
        MatcherAssert.assertThat((Object)element.getContainedElements().size(), (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)element.findElement("otherName").isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat(((ComponentConfiguration)((DslElementModel)element.findElement("myCamelCaseName").get()).getConfiguration().get()).getValue().get(), (Matcher)Is.is((Object)"#[{field: value}]"));
        MatcherAssert.assertThat(((ComponentConfiguration)element.getConfiguration().get()).getParameters().get("otherName"), (Matcher)Is.is((Object)"additional"));
    }

    @Test
    public void testSourceDeclarationToElement() {
        ElementDeclarer ext = ElementDeclarer.forExtension((String)"extension");
        SourceElementDeclaration declaration = (SourceElementDeclaration)((SourceElementDeclarer)((SourceElementDeclarer)ext.newSource("source").withConfig("configuration")).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("otherName", "additional").withParameter("myCamelCaseName", "#[{field: value}]").getDeclaration())).getDeclaration();
        DslElementModel element = this.create((ElementDeclaration)declaration);
        MatcherAssert.assertThat((Object)element.getModel(), (Matcher)Is.is((Object)this.source));
        MatcherAssert.assertThat((Object)element.getContainedElements().size(), (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)element.findElement("otherName").isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat(((ComponentConfiguration)((DslElementModel)element.findElement("myCamelCaseName").get()).getConfiguration().get()).getValue().get(), (Matcher)Is.is((Object)"#[{field: value}]"));
        MatcherAssert.assertThat(((ComponentConfiguration)element.getConfiguration().get()).getParameters().get("otherName"), (Matcher)Is.is((Object)"additional"));
    }

    @Test
    public void testGlobalParameterDeclarationToElement() {
        ElementDeclarer ext = ElementDeclarer.forExtension((String)"extension");
        ParameterObjectValue.Builder value = ElementDeclarer.newObjectValue().withParameter("otherName", "additional").withParameter("myCamelCaseName", "#[{field: value}]");
        ExtensionMetadataTypeUtils.getId((MetadataType)this.complexType).ifPresent(arg_0 -> ((ParameterObjectValue.Builder)value).ofType(arg_0));
        TopLevelParameterDeclaration declaration = (TopLevelParameterDeclaration)ext.newGlobalParameter("source").withRefName("globalParameter").withValue(value.build()).getDeclaration();
        DslElementModel element = this.create((ElementDeclaration)declaration);
        MatcherAssert.assertThat((Object)element.getModel(), (Matcher)Is.is((Object)this.complexType));
        MatcherAssert.assertThat((Object)element.getContainedElements().size(), (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)element.findElement("otherName").isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat(((DslElementModel)element.findElement("myCamelCaseName").get()).getValue().get(), (Matcher)Is.is((Object)"#[{field: value}]"));
        MatcherAssert.assertThat(((ComponentConfiguration)element.getConfiguration().get()).getParameters().get("otherName"), (Matcher)Is.is((Object)"additional"));
    }

    @Test
    public void testConfigNoConnectionNoParams() {
        ConfigurationModel emptyConfig = (ConfigurationModel)Mockito.mock(ConfigurationModel.class, (MockSettings)Mockito.withSettings().lenient());
        Mockito.when((Object)emptyConfig.getName()).thenReturn((Object)"configuration");
        Mockito.when((Object)emptyConfig.getParameterGroupModels()).thenReturn(Collections.emptyList());
        Mockito.when((Object)emptyConfig.getOperationModels()).thenReturn(Collections.emptyList());
        Mockito.when((Object)emptyConfig.getSourceModels()).thenReturn(Collections.emptyList());
        Mockito.when((Object)emptyConfig.getConnectionProviders()).thenReturn(Collections.emptyList());
        this.mockExtension = this.createExtension("extension", XmlDslModel.builder().setXsdFileName("mule-mockns.xsd").setPrefix("mockns").setNamespace("http://www.mulesoft.org/schema/mule/mockns").setSchemaLocation("http://www.mulesoft.org/schema/mule/mockns/current/mule-mockns.xsd").setSchemaVersion("4.0").build(), Arrays.asList(emptyConfig), Arrays.asList(this.connectionProvider));
        ConfigurationElementDeclaration declaration = (ConfigurationElementDeclaration)ElementDeclarer.forExtension((String)"extension").newConfiguration("configuration").withRefName("sample").getDeclaration();
        DslElementModel element = this.create((ElementDeclaration)declaration);
        MatcherAssert.assertThat((Object)element.getModel(), (Matcher)Is.is((Object)this.configuration));
        MatcherAssert.assertThat((Object)element.getContainedElements().isEmpty(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testConnectionNoParams() {
        ConnectionProviderModel emptyConnection = (ConnectionProviderModel)Mockito.mock(ConnectionProviderModel.class, (MockSettings)Mockito.withSettings().lenient());
        Mockito.when((Object)this.connectionProvider.getName()).thenReturn((Object)"connection");
        Mockito.when((Object)this.connectionProvider.getParameterGroupModels()).thenReturn(Collections.emptyList());
        this.mockExtension = this.createExtension("extension", XmlDslModel.builder().setXsdFileName("mule-mockns.xsd").setPrefix("mockns").setNamespace("http://www.mulesoft.org/schema/mule/mockns").setSchemaLocation("http://www.mulesoft.org/schema/mule/mockns/current/mule-mockns.xsd").setSchemaVersion("4.0").build(), Arrays.asList(this.configuration), Arrays.asList(emptyConnection));
        ConnectionElementDeclaration declaration = (ConnectionElementDeclaration)ElementDeclarer.forExtension((String)"extension").newConnection("connection").getDeclaration();
        DslElementModel element = this.create((ElementDeclaration)declaration);
        MatcherAssert.assertThat((Object)element.getModel(), (Matcher)Is.is((Object)this.connectionProvider));
        MatcherAssert.assertThat((Object)element.getContainedElements().isEmpty(), (Matcher)Is.is((Object)true));
    }

    @Override
    protected ExtensionModel createExtension(String name, XmlDslModel xmlDslModel, List<ConfigurationModel> configs, List<ConnectionProviderModel> connectionProviders) {
        return new ImmutableExtensionModel(name, "", "1.0", "Mulesoft", Category.COMMUNITY, configs, Arrays.asList(this.operation, this.anotherOperation), connectionProviders, Arrays.asList(this.source), Collections.emptyList(), Collections.emptyList(), null, xmlDslModel, Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
    }

    @Test
    public void testConfigNoParams() {
        ConfigurationElementDeclaration declaration = (ConfigurationElementDeclaration)ElementDeclarer.forExtension((String)"extension").newConfiguration("configuration").withRefName("sample").getDeclaration();
        DslElementModel element = this.create((ElementDeclaration)declaration);
        MatcherAssert.assertThat((Object)element.getModel(), (Matcher)Is.is((Object)this.configuration));
        MatcherAssert.assertThat((Object)element.getContainedElements().isEmpty(), (Matcher)Is.is((Object)true));
    }

    protected <T> DslElementModel<T> create(ElementDeclaration declaration) {
        Optional elementModel = DslElementModelFactory.getDefault((DslResolvingContext)this.dslContext).create(declaration);
        if (!elementModel.isPresent()) {
            Assert.fail((String)("Could not create element model for declared element: " + declaration.getName()));
        }
        return (DslElementModel)elementModel.get();
    }
}

