/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.memory.management.MemoryManagementService;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.config.internal.ArtifactAstConfigurationBuilder;
import org.mule.runtime.config.internal.context.BaseSpringMuleContextServiceConfigurator;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.runtime.deployment.model.api.artifact.ArtifactContext;
import org.mule.runtime.extension.api.dsl.syntax.resources.spi.ExtensionSchemaGenerator;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.tck.util.MuleContextUtils;

public class ArtifactAstConfigurationBuilderTestCase
extends AbstractMuleTestCase {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();
    public static final String SCHEMA_VALIDATION_ERROR = "Can't resolve http://www.mulesoft.org/schema/mule/invalid-namespace/current/invalid-schema.xsd, A dependency or plugin might be missing";
    private MuleContextWithRegistry muleContext;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Rule
    public SystemProperty disableExpressionsSupport = new SystemProperty(BaseSpringMuleContextServiceConfigurator.DISABLE_TRANSFORMERS_SUPPORT, "true");

    @Before
    public void setUp() throws Exception {
        this.muleContext = MuleContextUtils.mockContextWithServices();
        this.muleContext.getInjector().inject((Object)this);
    }

    @Test
    public void memoryManagementCanBeInjectedInBean() throws MuleException, IOException {
        ArtifactAstConfigurationBuilder configurationBuilder = this.xmlConfigurationBuilderRelativeToPath(this.tempFolder.getRoot(), MuleAstUtils.emptyArtifact());
        configurationBuilder.configure((MuleContext)this.muleContext);
        ArtifactContext artifactContext = configurationBuilder.createArtifactContext();
        MemoryManagementInjected memoryManagementInjected = new MemoryManagementInjected();
        artifactContext.getMuleContext().getInjector().inject((Object)memoryManagementInjected);
        MatcherAssert.assertThat((Object)memoryManagementInjected.getMemoryManagementService(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    private ArtifactAstConfigurationBuilder xmlConfigurationBuilderRelativeToPath(File basePath, ArtifactAst artifactAst) throws IOException {
        return (ArtifactAstConfigurationBuilder)ClassUtils.withContextClassLoader((ClassLoader)new URLClassLoader(new URL[]{basePath.toURI().toURL()}, null), () -> new ArtifactAstConfigurationBuilder(artifactAst, Collections.emptyMap(), ArtifactType.APP, false));
    }

    private static class MemoryManagementInjected {
        @Inject
        private MemoryManagementService memoryManagementService;

        private MemoryManagementInjected() {
        }

        public MemoryManagementService getMemoryManagementService() {
            return this.memoryManagementService;
        }
    }

    public static final class TestExtensionSchemagenerator
    implements ExtensionSchemaGenerator {
        public String generate(ExtensionModel extensionModel, DslResolvingContext context) {
            return "";
        }
    }
}

