/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.factories;

import java.util.List;
import javax.inject.Inject;
import org.mule.runtime.api.config.Feature;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.core.internal.exception.ErrorHandler;
import org.mule.runtime.core.internal.exception.GlobalErrorHandler;
import org.mule.runtime.core.privileged.exception.MessagingExceptionHandlerAcceptor;
import org.mule.runtime.dsl.api.component.AbstractComponentFactory;

public class ErrorHandlerFactoryBean
extends AbstractComponentFactory<ErrorHandler> {
    private GlobalErrorHandler delegate;
    private List<MessagingExceptionHandlerAcceptor> exceptionListeners;
    private String name;
    @Inject
    private FeatureFlaggingService featureFlaggingService;

    public ErrorHandler doGetObject() throws Exception {
        GlobalErrorHandler errorHandler;
        if (this.delegate != null) {
            if (this.featureFlaggingService.isEnabled((Feature)MuleRuntimeFeature.REUSE_GLOBAL_ERROR_HANDLER)) {
                return this.delegate;
            }
            return this.delegate.createLocalErrorHandler(this.getRootContainerLocation());
        }
        if (this.isGlobalErrorHandler()) {
            errorHandler = new GlobalErrorHandler();
            errorHandler.setName(this.name);
        } else {
            errorHandler = new ErrorHandler();
        }
        errorHandler.setExceptionListeners(this.exceptionListeners);
        return errorHandler;
    }

    private boolean isGlobalErrorHandler() {
        return this.getLocation().getParts().size() == 1;
    }

    public void setDelegate(GlobalErrorHandler delegate) {
        this.delegate = delegate;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setExceptionListeners(List<MessagingExceptionHandlerAcceptor> exceptionListeners) {
        this.exceptionListeners = exceptionListeners;
    }
}

