/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.dsl.spring;

import io.qameta.allure.Issue;
import java.util.function.Supplier;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.config.internal.dsl.spring.ObjectFactoryClassRepository;
import org.mule.runtime.dsl.api.component.AbstractComponentFactory;
import org.mule.runtime.dsl.api.component.ObjectTypeProvider;
import org.mule.tck.junit4.rule.SystemProperty;

@Issue(value="W-10672687")
public class ObjectFactoryClassRepositoryTestCase {
    @Rule
    public MockitoRule rule = MockitoJUnit.rule();
    @Rule
    public SystemProperty enableByteBuddy = new SystemProperty("mule.enable.byteBuddy.objectCreation", "true");

    @Test
    public void testSetters() throws InstantiationException, IllegalAccessException {
        ObjectFactoryClassRepository objectFactoryClassRepository = new ObjectFactoryClassRepository();
        ObjectFactoryClassRepository.SmartFactoryBeanInterceptor byteBuddyClass = (ObjectFactoryClassRepository.SmartFactoryBeanInterceptor)objectFactoryClassRepository.getObjectFactoryClass(FakeObjectConnectionProviderObjectFactory.class).newInstance();
        byteBuddyClass.setIsSingleton(Boolean.valueOf(true));
        byteBuddyClass.setObjectTypeClass(String.class);
        byteBuddyClass.setIsPrototype(Boolean.valueOf(true));
        byteBuddyClass.setIsEagerInit((Supplier)new LazyValue(() -> true));
        Assert.assertThat((Object)byteBuddyClass.isSingleton(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)byteBuddyClass.getObjectType(), (Matcher)Is.is(String.class));
        Assert.assertThat((Object)byteBuddyClass.isPrototype(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)byteBuddyClass.isEagerInit(), (Matcher)Is.is((Object)true));
        byteBuddyClass.setIsSingleton(Boolean.valueOf(false));
        byteBuddyClass.setObjectTypeClass(Integer.class);
        byteBuddyClass.setIsPrototype(Boolean.valueOf(false));
        byteBuddyClass.setIsEagerInit((Supplier)new LazyValue(() -> false));
        Assert.assertThat((Object)byteBuddyClass.isSingleton(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)byteBuddyClass.getObjectType(), (Matcher)Is.is(Integer.class));
        Assert.assertThat((Object)byteBuddyClass.isPrototype(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)byteBuddyClass.isEagerInit(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testLoadSameClassHasDifferentInterceptors() throws InstantiationException, IllegalAccessException {
        ObjectFactoryClassRepository objectFactoryClassRepository = new ObjectFactoryClassRepository();
        ObjectFactoryClassRepository.SmartFactoryBeanInterceptor byteBuddyClass = (ObjectFactoryClassRepository.SmartFactoryBeanInterceptor)objectFactoryClassRepository.getObjectFactoryClass(FakeObjectConnectionProviderObjectFactory.class).newInstance();
        byteBuddyClass.setObjectTypeClass(String.class);
        ObjectFactoryClassRepository.SmartFactoryBeanInterceptor otherByteBuddyClass = (ObjectFactoryClassRepository.SmartFactoryBeanInterceptor)objectFactoryClassRepository.getObjectFactoryClass(FakeObjectConnectionProviderObjectFactory.class).newInstance();
        otherByteBuddyClass.setObjectTypeClass(Integer.class);
        Assert.assertThat(byteBuddyClass.getClass(), (Matcher)Is.is(otherByteBuddyClass.getClass()));
        Assert.assertThat((Object)byteBuddyClass.getObjectType(), (Matcher)Is.is(String.class));
        Assert.assertThat((Object)otherByteBuddyClass.getObjectType(), (Matcher)Is.is(Integer.class));
    }

    @Test
    public void testGetObjectTypeReturnsSuperIfImplementsObjectTypeProvider() throws InstantiationException, IllegalAccessException {
        ObjectFactoryClassRepository objectFactoryClassRepository = new ObjectFactoryClassRepository();
        ObjectFactoryClassRepository.SmartFactoryBeanInterceptor byteBuddyClass = (ObjectFactoryClassRepository.SmartFactoryBeanInterceptor)objectFactoryClassRepository.getObjectFactoryClass(OtherFakeObjectConnectionProviderObjectFactory.class).newInstance();
        byteBuddyClass.setObjectTypeClass(String.class);
        Assert.assertThat((Object)byteBuddyClass.getObjectType(), (Matcher)Is.is(Long.class));
    }

    public static class FakeObject {
    }

    public static class OtherFakeObjectConnectionProviderObjectFactory
    extends AbstractComponentFactory
    implements ObjectTypeProvider {
        public Object doGetObject() throws Exception {
            return new FakeObject();
        }

        public Class<?> getObjectType() {
            return Long.class;
        }
    }

    public static class FakeObjectConnectionProviderObjectFactory
    extends AbstractComponentFactory {
        public Object doGetObject() throws Exception {
            return new FakeObject();
        }
    }
}

