/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.context;

import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.util.Collections;
import java.util.Optional;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.config.Feature;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.memory.management.MemoryManagementService;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.ast.api.validation.ArtifactAstValidatorBuilder;
import org.mule.runtime.ast.internal.validation.DefaultValidatorBuilder;
import org.mule.runtime.config.internal.DefaultComponentBuildingDefinitionRegistryFactory;
import org.mule.runtime.config.internal.context.BaseConfigurationComponentLocator;
import org.mule.runtime.config.internal.context.MuleArtifactContext;
import org.mule.runtime.config.internal.context.ObjectProviderAwareBeanFactory;
import org.mule.runtime.config.internal.model.ComponentBuildingDefinitionRegistryFactory;
import org.mule.runtime.config.internal.registry.OptionalObjectsController;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.internal.exception.ContributedErrorTypeLocator;
import org.mule.runtime.core.internal.exception.ContributedErrorTypeRepository;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.util.MuleContextUtils;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={MuleAstUtils.class})
@Issue(value="W-10808757")
@Story(value="Application Deployment")
public class MuleArtifactContextTestCase
extends AbstractMuleTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private MuleContext mockMuleContext;
    private ClassLoader executionClassloader = (ClassLoader)Mockito.mock(ClassLoader.class);
    private ClassLoader parentClassloader = (ClassLoader)Mockito.mock(ClassLoader.class);
    private DefaultListableBeanFactory beanFactory = new ObjectProviderAwareBeanFactory(null);
    private ArtifactAstValidatorBuilder astValidatorBuilder;

    @Before
    public void before() throws MuleException {
        this.astValidatorBuilder = (ArtifactAstValidatorBuilder)Mockito.spy((Object)new DefaultValidatorBuilder());
        PowerMockito.mockStatic(MuleAstUtils.class, (Class[])new Class[0]);
        PowerMockito.when((Object)MuleAstUtils.validatorBuilder()).thenReturn((Object)this.astValidatorBuilder);
        PowerMockito.when((Object)MuleAstUtils.emptyArtifact()).thenCallRealMethod();
        this.mockMuleContext = MuleContextUtils.mockContextWithServices();
        this.mockMuleContext.getInjector().inject((Object)this);
        PowerMockito.when((Object)this.mockMuleContext.getExecutionClassLoader()).thenReturn((Object)this.executionClassloader);
        PowerMockito.when((Object)this.executionClassloader.getParent()).thenReturn((Object)this.parentClassloader);
    }

    @Test
    public void testValidationWithFFEnabled() {
        this.createMuleArtifactContextStub(this.beanFactory, this.mockFF(true));
        ((ArtifactAstValidatorBuilder)Mockito.verify((Object)this.astValidatorBuilder, (VerificationMode)Mockito.times((int)1))).withArtifactRegionClassLoader(this.parentClassloader);
    }

    @Test
    public void testValidationWithFFDisabled() {
        this.createMuleArtifactContextStub(this.beanFactory, this.mockFF(false));
        ((ArtifactAstValidatorBuilder)Mockito.verify((Object)this.astValidatorBuilder, (VerificationMode)Mockito.times((int)1))).withArtifactRegionClassLoader(this.executionClassloader);
    }

    private FeatureFlaggingService mockFF(boolean flag) {
        FeatureFlaggingService featureFlaggingService = (FeatureFlaggingService)Mockito.mock(FeatureFlaggingService.class);
        PowerMockito.when((Object)featureFlaggingService.isEnabled((Feature)MuleRuntimeFeature.VALIDATE_APPLICATION_MODEL_WITH_REGION_CLASSLOADER)).thenReturn((Object)flag);
        return featureFlaggingService;
    }

    private MuleArtifactContext createMuleArtifactContextStub(final DefaultListableBeanFactory mockedBeanFactory, FeatureFlaggingService featureFlaggingService) {
        MuleArtifactContext muleArtifactContext = new MuleArtifactContext(this.mockMuleContext, MuleAstUtils.emptyArtifact(), (OptionalObjectsController)Mockito.mock(OptionalObjectsController.class), Optional.empty(), new BaseConfigurationComponentLocator(), new ContributedErrorTypeRepository(), new ContributedErrorTypeLocator(), Collections.emptyMap(), ArtifactType.APP, (ComponentBuildingDefinitionRegistryFactory)new DefaultComponentBuildingDefinitionRegistryFactory(), (MemoryManagementService)Mockito.mock(MemoryManagementService.class), featureFlaggingService){

            protected DefaultListableBeanFactory createBeanFactory() {
                return mockedBeanFactory;
            }

            protected void customizeBeanFactory(DefaultListableBeanFactory beanFactory) {
            }

            protected void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
            }

            protected void registerBeanPostProcessors(ConfigurableListableBeanFactory beanFactory) {
            }

            protected void invokeBeanFactoryPostProcessors(ConfigurableListableBeanFactory beanFactory) {
            }

            protected void registerListeners() {
            }

            protected void finishBeanFactoryInitialization(ConfigurableListableBeanFactory beanFactory) {
            }

            protected void finishRefresh() {
            }
        };
        muleArtifactContext.refresh();
        return muleArtifactContext;
    }
}

